[indent=2]
init
  if (SDL.init(SDL.InitFlag.VIDEO) >= 0)
     screen : unonwed SDL.Screen

    screen = SDL.Screen.set_video_mode (640, 480, 16,
      SDL.SurfaceFlag.HWSURFACE | SDL.SurfaceFlag.DOUBLEBUF)
    if (screen != null)
      Environment.atexit (SDL.quit)

      var src = new SDL.RWops.from_file ("valide.bmp", "rb")
      var bmp = SDLImage.load_bmp (src)
      if (bmp != null)
        var done = false

        while (!done)
          var event = SDL.Event ()

          while (SDL.Event.poll (event) != 0)
            case event.type
              when SDL.EventType.QUIT
                done = true

              when SDL.EventType.KEYDOWN
                case event.key.keysym.sym
                  when SDL.KeySymbol.ESCAPE
                    done = true

          /* DRAWING STARTS HERE */

          screen.fill (null, screen.format.map_rgb (0, 0, 0))

          var dstrect = SDL.Rect ()
          dstrect.x = (int16)(screen.w - bmp.w) / 2
          dstrect.y = (int16)(screen.h - bmp.h) / 2

          bmp.blit (null, screen, dstrect)

          /* DRAWING ENDS HERE */

          screen.flip ()
      else
        print ("Unable to load bitmap: %s\n", SDL.get_error ())
    else
      print ("Unable to set 640x480 video: %s\n", SDL.get_error ())
  else
    print ("Unable to init SDL: %s\n", SDL.get_error ())

