/* waf-builder.vala
 *
 * Copyright (C) 2008-2010 Nicolas Joseph
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 *   Nicolas Joseph <nicolas.joseph@valaide.org>
 */

using Valide;

/**
 * Builder base on waf: http://code.google.com/p/waf/
 */
public class WafBuilder : Plugin, Builder, Object
{
  /**
   * @see Valide.Builder.project
   */
  public Project project { get; construct set; }

  /**
   * @see Valide.Builder.executables
   */
  public ExecutableManager executables { get; construct set; }

  /**
   * @see Valide.Plugin.path
   */
  public string path { get; construct set; }

  /**
   * @see Valide.Plugin.window
   */
  public Window window { get; construct set; }

  private int run_waf (BuildingStep step)
  {
    WafExecutable waf;
    WafBuilderOptions options;
    ExecutableOptions exec_options;

    options = this.project.builder_options as WafBuilderOptions;

    exec_options = new ExecutableOptions ();
    exec_options.arguments = options.to_string (step);
    exec_options.working_dir = this.project.path;

    waf = new WafExecutable (this.project);
    waf.step = step;
    return executables.run (waf, exec_options);
  }

  public WafBuilder (ExecutableManager executables, Project project)
  {
    Object (project: project, executables: executables);
  }

  construct
  {
    BuilderManager.get_instance ().register_builder (this.get_type (),
                                                     typeof (WafBuilderOptions));
  }

  /**
   * @see Valide.Builder.configure
   */
  public int configure ()
  {
    return this.run_waf (BuildingStep.CONFIGURE);
  }

  /**
   * @see Valide.Builder.build
   */
  public int build ()
  {
    return this.run_waf (BuildingStep.BUILD);
  }

  /**
   * @see Valide.Builder.install
   */
  public int install ()
  {
    return this.run_waf (BuildingStep.INSTALL);
  }

  /**
   * @see Valide.Builder.dist
   */
  public int dist ()
  {
    return this.run_waf (BuildingStep.DIST);
  }

  /**
   * @see Valide.Builder.clean
   */
  public int clean ()
  {
    return this.run_waf (BuildingStep.CLEAN);
  }

  /**
   * @see Valide.Builder.distclean
   */
  public int distclean ()
  {
    return this.run_waf (BuildingStep.DISTCLEAN);
  }

  /**
   * @see Valide.Builder.uninstall
   */
  public int uninstall ()
  {
    return this.run_waf (BuildingStep.UNINSTALL);
  }

  /**
   * @see Valide.Builder.preferences
   */
  public Gtk.Widget preferences ()
  {
    return new WafBuilderPreferences (this.project);
  }
}

public Type register_plugin (TypeModule module)
{
  return typeof (WafBuilder);
}

