/* sample.vala
 *
 * Copyright (C) 2008-2010 Nicolas Joseph
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 * 	Nicolas Joseph <nicolas.joseph@valaide.org>
 */

using Valide;

public class SamplePlugin : Plugin, Object
{
  public string path { get; construct set; }
  public Window window { get; construct set; }

  construct
  {
    print ("Hello world!\n");
  }

  ~SamplePlugin ()
  {
    print ("Good by world!\n");
  }

  public Gtk.Widget create_configure_dialog ()
  {
    return new Gtk.Label ("Sample preferences");
  }
}

/*
 * or
 * public Type register_plugin (TypeModule module, void* target) throw PluginError
 */
public Type register_plugin (TypeModule module)
{
  return typeof (SamplePlugin);
}

public Gtk.Widget create_configure_dialog (SamplePlugin self)
{
  return self.create_configure_dialog ();
}

