/* make-executable.vala
 *
 * Copyright (C) 2008-2011 Nicolas Joseph
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 *	Nicolas Joseph <nicolas.joseph@valaide.org>
 */

using Valide;

/**
 * The vala compiler
 */
public class MakeExecutable : Compiler
{
  private static const string EXECUTABLE_PATH = "make";
  /**
   * @see Valide.Executable.executable
   */
  public override string executable
  {
    get { return EXECUTABLE_PATH; }
    set {}
  }

  /**
   * @see Valide.Executable.get_color_line
   */
  public override void get_color_line (ref string line, out Gdk.Color color)
  {
    base.get_color_line (ref line, out color);
    if (line.index_of (" error:") != -1)
    {
      Gdk.Color.parse (Utils.Color.ERROR, out color);
    }
    else if (line.index_of (" warning:") != -1)
    {
      Gdk.Color.parse (Utils.Color.WARNING, out color);
    }
  }

  public MakeExecutable (Project project)
  {
    Object (project: project);
  }
}

