;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; NSIS installer script for valide ;
;     (http://www.valaide.org)     ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

!define MINGW_DIR "..\..\..\valide-cross"
!define APPNAME "valide"
!define APPVERSION "0.8.0"
!define PKGNAME "${APPNAME}-${APPVERSION}"
!define VALAVERSION "0.8.1"

;;;;;;;;;;;;;;;;;;;;;;;;;
; General configuration ;
;;;;;;;;;;;;;;;;;;;;;;;;;

Name "${PKGNAME}"
OutFile ".\${PKGNAME}.exe"
InstallDir "$PROGRAMFILES\${PKGNAME}"
ShowInstDetails show
ShowUnInstDetails show
!ifdef NSIS_LZMA_COMPRESS_WHOLE
  SetCompressor lzma
!else
  SetCompressor /SOLID lzma
!endif

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; NSIS Modern User Interface configuration ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; MUI 1.66 compatible
  !include "MUI.nsh"
  !include "MUI2.nsh"
  !include "EnvVarUpdate.nsh"
  !include "fileassoc.nsh"

; MUI Settings
  !define MUI_ABORTWARNING

; Installer pages
  ; Welcome page
    !insertmacro MUI_PAGE_WELCOME
  ; License page
    !define MUI_LICENSEPAGE_RADIOBUTTONS
    !insertmacro MUI_PAGE_LICENSE "..\..\COPYING"
  ; Components page
    !insertmacro MUI_PAGE_COMPONENTS
  ; Directory page
    !insertmacro MUI_PAGE_DIRECTORY
  ; Start menu page
    Var StartMenuFolder
    !insertmacro MUI_PAGE_STARTMENU Application $StartMenuFolder
  ; Instfiles page
    !insertmacro MUI_PAGE_INSTFILES
  ; Finish page
    !define MUI_FINISHPAGE_LINK "http://www.valide.org/"
    !define MUI_FINISHPAGE_LINK_LOCATION "http://www.valide.org/"
    !define MUI_FINISHPAGE_RUN
    !define MUI_FINISHPAGE_RUN_NOTCHECKED
    !define MUI_FINISHPAGE_RUN_TEXT $(RUN_Valide)
    !define MUI_FINISHPAGE_RUN_FUNCTION "RunValide"
    !insertmacro MUI_PAGE_FINISH

; Languages
  !insertmacro MUI_LANGUAGE "English"
  !insertmacro MUI_LANGUAGE "French"

; Reserve files for solid compression
  !insertmacro MUI_RESERVEFILE_LANGDLL

;;;;;;;;;;;;;;;;;;;;;;;
; Macro and Functions ;
;;;;;;;;;;;;;;;;;;;;;;;

Function .onInit
  !insertmacro MUI_LANGDLL_DISPLAY
FunctionEnd

Section "Val(a)ide" Valide
  SectionIn RO
  SetOutPath "$INSTDIR\bin"
  File "..\..\_build_\default\src\valide.exe"
  File "..\..\_build_\default\libvalide\valide-0.0-0.dll"
  File "..\..\_build_\default\ctags-vala\ctags-vala.exe"
  File "valide.bat"
  SetOutPath "$INSTDIR\lib\valide\plugins\completion"
  File /oname=libcompletion.dll "..\..\_build_\default\plugins\completion\completion.dll"
  File "..\..\plugins\completion\completion.valide-plugin"
  SetOutPath "$INSTDIR\lib\valide\plugins\todo"
  File /oname=libtodo.dll "..\..\_build_\default\plugins\todo\todo.dll"
  File "..\..\plugins\todo\todo.valide-plugin"
  SetOutPath "$INSTDIR\lib\valide\plugins\symbol"
  File /oname=libsymbol.dll "..\..\_build_\default\plugins\symbol\symbol.dll"
  File "..\..\plugins\symbol\symbol.valide-plugin"
  SetOutPath "$INSTDIR\lib\valide\plugins\file-browser"
  File /oname=libfile-browser.dll "..\..\_build_\default\plugins\file-browser\file-browser.dll"
  File "..\..\plugins\file-browser\file-browser.valide-plugin"
  SetOutPath "$INSTDIR\lib\valide\plugins\opened-documents"
  File /oname=libopened-documents.dll "..\..\_build_\default\plugins\opened-documents\opened-documents.dll"
  File "..\..\plugins\opened-documents\opened-documents.valide-plugin"
  SetOutPath "$INSTDIR\lib\valide\plugins\advanced-search"
  File /oname=libadvanced-search.dll "..\..\_build_\default\plugins\advanced-search\advanced-search.dll"
  File "..\..\plugins\advanced-search\advanced-search.valide-plugin"
  SetOutPath "$INSTDIR\lib\valide\plugins\start-page"
  File /oname=libstart-page.dll "..\..\_build_\default\plugins\start-page\start-page.dll"
  File "..\..\plugins\start-page\start-page.valide-plugin"
  File "..\..\plugins\start-page\logo.png"
  SetOutPath "$INSTDIR\lib\valide\plugins\waf"
  File /oname=libwaf.dll "..\..\_build_\default\plugins\waf\waf.dll"
  File "..\..\plugins\waf\waf.valide-plugin"
  SetOutPath "$INSTDIR\lib\valide\plugins\make"
  File /oname=libmake.dll "..\..\_build_\default\plugins\make\make.dll"
  File "..\..\plugins\make\make.valide-plugin"
  SetOutPath "$INSTDIR\share\valide"
  File "..\..\AUTHORS"
  SetOutPath "$INSTDIR\share\valide\template\cmd"
  File "..\..\data\template\cmd\*"
  SetOutPath "$INSTDIR\share\valide\template\empty"
  File "..\..\data\template\empty\*"
  SetOutPath "$INSTDIR\share\valide\template\gnome"
  File "..\..\data\template\gnome\*"
  SetOutPath "$INSTDIR\share\valide\template\gtk"
  File "..\..\data\template\gtk\*"
  SetOutPath "$INSTDIR\share\valide\template\sdl"
  File "..\..\data\template\sdl\*"
  SetOutPath "$INSTDIR\share\valide\template\opengl"
  File "..\..\data\template\opengl\*"
  SetOutPath "$INSTDIR\share\pixmaps\valide"
  File "..\..\pixmaps\*"
  File "..\..\data\application-x-vide.ico"
  SetOutPath "$INSTDIR\share\pixmaps\valide\symbols"
  File "..\..\pixmaps\symbols\*"
  SetOutPath "$INSTDIR\share\pixmaps\valide\plugins"
  File "..\..\plugins\symbol\symbol-browser.png"
  SetOutPath "$INSTDIR\share\pixmaps\valide\plugins"
  File "..\..\plugins\todo\todo.png"
  SetOutPath "$INSTDIR\share\locale\fr\LC_MESSAGES"
  File /oname=valide.mo "..\..\_build_\default\po\fr.mo"
  SetOutPath "$INSTDIR\share\locale\es\LC_MESSAGES"
  File /oname=valide.mo "..\..\_build_\default\po\es.mo"

  ; gtksourceview-2.0
  SetOutPath "$INSTDIR\bin\"
  File "${MINGW_DIR}\bin\libgtksourceview-2.0-0.dll"
  File "${MINGW_DIR}\bin\libxml2-2.dll"
  SetOutPath "$INSTDIR\share\gtksourceview-2.0\language-specs"
  File "${MINGW_DIR}\share\gtksourceview-2.0\language-specs\*"
  SetOutPath "$INSTDIR\share\gtksourceview-2.0\styles"
  File "${MINGW_DIR}\share\gtksourceview-2.0\styles\*"

  ; GDL
  SetOutPath "$INSTDIR\bin\"
  File "${MINGW_DIR}\bin\libgdl-1-3.dll"
  File /oname=libintl-8.dll "${MINGW_DIR}\bin\intl.dll"

  ${EnvVarUpdate} $0 "PATH" "A" "HKLM" "$INSTDIR\bin"
SectionEnd

Section "Vala compiler" Vala
  StrCpy $2 "$TEMP\vala_Installer.exe"
  NSISdl::download http://valide.googlecode.com/files/vala-${VALAVERSION}.exe $2
  Pop $0
  StrCmp $0 success success
    MessageBox MB_OK "Download failed: $0"
    Abort
  success:
    ExecWait '"$2"'
    Delete $2
SectionEnd

LangString DESC_Valide ${LANG_ENGLISH} "IDE for vala."
LangString DESC_Valide ${LANG_FRENCH} "EDI pour vala."
LangString DESC_Vala ${LANG_ENGLISH} "Vala compiler (${VALAVERSION})."
LangString DESC_Vala ${LANG_FRENCH} "Compilateur pour vala (${VALAVERSION})."
LangString RUN_Valide ${LANG_ENGLISH} "Run Val(a)IDE"
LangString RUN_Valide ${LANG_FRENCH} "Lancer Val(a)IDE"
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${Valide} $(DESC_Valide)
  !insertmacro MUI_DESCRIPTION_TEXT ${Vala} $(DESC_Vala)
!insertmacro MUI_FUNCTION_DESCRIPTION_END

Section -Icons
!insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  SetOutPath "$INSTDIR\bin"
  CreateDirectory "$SMPROGRAMS\$StartMenuFolder"
  CreateShortCut "$SMPROGRAMS\$StartMenuFolder\Val(a)IDE.lnk" "$INSTDIR\bin\valide.exe" "" "$INSTDIR\share\pixmaps\valide\icone.ico"
  CreateShortCut "$SMPROGRAMS\$StartMenuFolder\uninstall.lnk" "$INSTDIR\uninstall.exe"
  CreateDirectory "$DESKTOP"
  CreateShortCut "$DESKTOP\Val(a)IDE.lnk" "$INSTDIR\bin\valide.exe" "" "$INSTDIR\share\pixmaps\valide\icone.ico" "" "" "" ""
!insertmacro MUI_STARTMENU_WRITE_END
SectionEnd

Section -PostInstall
  ; Register file type
  !insertmacro APP_ASSOCIATE "vide" "Valide.Project" "Val(a)IDE Project" \
               "$INSTDIR\share\pixmaps\valide\application-x-vide.ico,0" \
               "" "$INSTDIR\bin\valide.bat $\"$INSTDIR\bin$\" $\"%1$\""
  !insertmacro APP_ASSOCIATE "vala" "Valide.Vala" "Vala Source" \
               "" "" "$INSTDIR\bin\valide.bat $\"$INSTDIR\bin$\" $\"%1$\""
  !insertmacro APP_ASSOCIATE "vapi" "Valide.Vapi" "Vapi File" \
               "" "" "$INSTDIR\bin\valide.bat $\"$INSTDIR\bin$\" $\"%1$\""
  !insertmacro APP_ASSOCIATE "gs" "Valide.Genie" "Genie Source" \
               "" "" "$INSTDIR\bin\valide.bat $\"$INSTDIR\bin$\" $\"%1$\""

  ; uninstall informations
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\valide" "DisplayName" "valide"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\valide" "UninstallString" "$INSTDIR\uninstall.exe"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\valide" "Publisher" "Nicolas Joseph"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\valide" "URLInfoAbout" "http://www.valaide.org/"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\valide" "HelpLink" "http://www.valaide.org/"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\valide" "URLUpdateInfo" "http://www.valaide.org/"
  WriteUninstaller "$INSTDIR\uninstall.exe"
SectionEnd

Function RunValide
  Exec '"$INSTDIR\bin\valide.bat" "$INSTDIR\bin"'
FunctionEnd

#### Uninstaller code ####

Function un.onInit
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove $(^Name) and all of its components?" IDYES +2
  Abort
FunctionEnd

Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) was successfully removed from your computer."
FunctionEnd

Section Uninstall
  ${un.EnvVarUpdate} $0 "PATH" "R" "HKLM" "$INSTDIR\bin"
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\valide"
  !insertmacro APP_UNASSOCIATE "vide" "Valide.Project"
  !insertmacro APP_UNASSOCIATE "vala" "Valide.Vala"
  !insertmacro APP_UNASSOCIATE "vapi" "Valide.Vapi"
  !insertmacro APP_UNASSOCIATE "gs" "Valide.Genie"

  Delete "$INSTDIR\uninstall.exe"
  Delete "$DESKTOP\Val(a)IDE.lnk"
  Delete "$SMPROGRAMS\$StartMenuFolder\*"
  Delete "$INSTDIR\bin\*"
  Delete "$INSTDIR\etc\gtk-2.0\*"
  Delete "$INSTDIR\lib\gtk-2.0\2.10.0\engines\*"
  Delete "$INSTDIR\share\gtksourceview-2.0\styles\*"
  Delete "$INSTDIR\share\gtksourceview-2.0\language-specs\*"
  Delete "$INSTDIR\share\pixmaps\valide\symbols\*"
  Delete "$INSTDIR\share\pixmaps\valide\plugins\*"
  Delete "$INSTDIR\share\pixmaps\valide\*"
  Delete "$INSTDIR\share\valide\template\opengl\*"
  Delete "$INSTDIR\share\valide\template\sdl\*"
  Delete "$INSTDIR\share\valide\template\gtk\*"
  Delete "$INSTDIR\share\valide\template\gnome\*"
  Delete "$INSTDIR\share\valide\template\empty\*"
  Delete "$INSTDIR\share\valide\template\cmd\*"
  Delete "$INSTDIR\share\valide\licenses\*"
  Delete "$INSTDIR\share\locale\fr\LC_MESSAGES\*"
  Delete "$INSTDIR\share\locale\es\LC_MESSAGES\*"
  Delete "$INSTDIR\share\valide\*"
  Delete "$INSTDIR\lib\valide\plugins\opened-documents\*"
  Delete "$INSTDIR\lib\valide\plugins\advanced-search\*"
  Delete "$INSTDIR\lib\valide\plugins\file-browser\*"
  Delete "$INSTDIR\lib\valide\plugins\completion\*"
  Delete "$INSTDIR\lib\valide\plugins\start-page\*"
  Delete "$INSTDIR\lib\valide\plugins\symbol\*"
  Delete "$INSTDIR\lib\valide\plugins\todo\*"
  Delete "$INSTDIR\lib\valide\plugins\make\*"
  Delete "$INSTDIR\lib\valide\plugins\waf\*"

  RMDir "$SMPROGRAMS\$StartMenuFolder"
  RMDir "$INSTDIR\share\gtksourceview-2.0\styles"
  RMDir "$INSTDIR\share\gtksourceview-2.0\language-specs"
  RMDir "$INSTDIR\share\gtksourceview-2.0"
  RMDir "$INSTDIR\share\pixmaps\valide\symbols"
  RMDir "$INSTDIR\share\pixmaps\valide\plugins"
  RMDir "$INSTDIR\share\pixmaps\valide"
  RMDir "$INSTDIR\share\pixmaps"
  RMDir "$INSTDIR\share\valide\template\opengl"
  RMDir "$INSTDIR\share\valide\template\sdl"
  RMDir "$INSTDIR\share\valide\template\gtk"
  RMDir "$INSTDIR\share\valide\template\gnome"
  RMDir "$INSTDIR\share\valide\template\empty"
  RMDir "$INSTDIR\share\valide\template\cmd"
  RMDir "$INSTDIR\share\valide\template"
  RMDir "$INSTDIR\share\valide"
  RMDir "$INSTDIR\share\locale\fr\LC_MESSAGES"
  RMDir "$INSTDIR\share\locale\fr"
  RMDir "$INSTDIR\share\locale\es\LC_MESSAGES"
  RMDir "$INSTDIR\share\locale\es"
  RMDir "$INSTDIR\share\locale"
  RMDir "$INSTDIR\share"
  RMDir "$INSTDIR\etc\gtk-2.0"
  RMDir "$INSTDIR\etc"
  RMDir "$INSTDIR\lib\valide\plugins\opened-documents"
  RMDir "$INSTDIR\lib\valide\plugins\file-browser"
  RMDir "$INSTDIR\lib\valide\plugins\completion"
  RMDir "$INSTDIR\lib\valide\plugins\completion"
  RMDir "$INSTDIR\lib\valide\plugins\symbol"
  RMDir "$INSTDIR\lib\valide\plugins\todo"
  RMDir "$INSTDIR\lib\valide\plugins\make"
  RMDir "$INSTDIR\lib\valide\plugins\waf"
  RMDir "$INSTDIR\lib\valide\plugins"
  RMDir "$INSTDIR\lib\valide"
  RMDir "$INSTDIR\lib\gtk-2.0\2.10.0\engines"
  RMDir "$INSTDIR\lib\gtk-2.0\2.10.0"
  RMDir "$INSTDIR\lib\gtk-2.0"
  RMDir "$INSTDIR\lib"
  RMDir "$INSTDIR\bin"
  RMDir "$INSTDIR"

  SetAutoClose true
SectionEnd


