/* valac.vala
 *
 * Copyright (C) 2008-2011 Nicolas Joseph
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 *   Nicolas Joseph <nicolas.joseph@valaide.org>
 */

/* @fixme Use static properties */
/**
 * Vala compiler informations
 */
public class Valide.Valac
{
  /**
   * The version of the vala compiler
   */
  public static const string version = Config.VALA_VERSION;

  /**
   * The name of the vala compiler
   */
  public static const string compiler_name = "valac";

  private static string _prefix = null;
  /**
   * The path of the vala compiler
   */
  public static string get_prefix()
  {
    if (Valac._prefix == null)
    {
      string bin_path;
      string vala_path;

      vala_path = Environment.find_program_in_path (Valac.compiler_name);
      bin_path = Path.get_dirname (vala_path);
      Valac._prefix = Path.get_dirname (bin_path);
    }
    return Valac._prefix;
  }

  private static string _vapi_dir = null;
  /**
   * The default vapi directory
   */
  public static string get_vapi_dir ()
  {
    if (Valac._vapi_dir == null)
    {
      string dir;

      if (Config.OS == "win32")
      {
        dir = Path.build_filename ("C:", "Documents and Settings", "All Users",
                                   "Application Data");
      }
      else
      {
        dir = Path.build_filename (Valac.get_prefix(), "share");
      }
      Valac._vapi_dir = Path.build_filename (dir, "vala-" + Valac.version, "vapi");
      if (!FileUtils.test (Valac._vapi_dir, FileTest.IS_DIR))
      {
        Valac._vapi_dir = Path.build_filename (dir, "vala", "vapi");
      }
    }
    return Valac._vapi_dir;
  }

  /**
   * Get the list of the available packages
   *
   * @param vapi_dir The additionnal vapi directory
   *
   * @return The package list
   */
  public static List<string> get_package_list (List<string>? vapi_dir = null)
  {
    List<string> vapi_files = null;
    List<string> vapidir = null;

    if (vapi_dir != null)
    {
      foreach (string v in vapi_dir)
      {
        vapidir.append (v);
      }
    }

    vapidir.append (Valac.get_vapi_dir());

    foreach (string d in Environment.get_system_data_dirs ())
    {
      if (FileUtils.test (d, FileTest.IS_DIR))
      {
        vapidir.append (d);
      }
    }

    foreach (string d in vapidir)
    {
      try
      {
        string filename;
        Dir dir = Dir.open (d);

        while ((filename = dir.read_name ()) != null)
        {
          if (filename.has_suffix (".vapi"))
          {
            vapi_files.append (filename.substring (0, filename.length - 5));
          }
        }
      }
      catch (Error e)
      {
        debug (e.message);
      }
    }
    return vapi_files;
  }
}

