/* uimanager.vala
 *
 * Copyright (C) 2008-2010 Nicolas Joseph
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 *   Nicolas Joseph <nicolas.joseph@valaide.org>
 */

/**
 * Class for construct the user interface (menu and toolbar)
 */
public class Valide.UIManager : Gtk.UIManager
{
  private Gtk.ActionGroup action_group;

  construct
  {
    try
    {
      this.add_ui_from_string (this.xmldef, -1);
      this.action_group = new Gtk.ActionGroup ("general");
    }
    catch (Error e)
    {
      critical (e.message);
    }
  }

  /**
   * Populate the graphical user interface with menu and toolbar
   */
  public void populate ()
  {
    /* File menu */
    action_group.add_action (new Gtk.Action ("file", _("_File"), null, null));
    action_group.add_action_with_accel (new Gtk.Action ("document-create", null, _("Create new source file"), Gtk.Stock.NEW), null);
    action_group.add_action_with_accel (new Gtk.Action ("document-open", _("Open..."), _("Open source file"), Gtk.Stock.OPEN), null);
    action_group.add_action_with_accel (new Gtk.Action ("document-save", null, _("Save source file"), Gtk.Stock.SAVE), null);
    action_group.add_action_with_accel (new Gtk.Action ("document-save-as", _("Save As..."), _("Save as source file"), Gtk.Stock.SAVE_AS), "<ctrl><shift>S");
    action_group.add_action_with_accel (new Gtk.Action ("document-rename", _("Rename..."), _("Rename source file"), null), null);
    action_group.add_action_with_accel (new Gtk.Action ("document-close", null, _("Close source file"), Gtk.Stock.CLOSE), null);
    action_group.add_action_with_accel (new Gtk.Action ("window-quit", null, _("Quit application"), Gtk.Stock.QUIT), null);

    /* Edit menu */
    action_group.add_action (new Gtk.Action ("edit", _("_Edit"), null, null));
    action_group.add_action_with_accel (new Gtk.Action ("edit-undo", null, _("Undo last action"), Gtk.Stock.UNDO), "<ctrl>Z");
    action_group.add_action_with_accel (new Gtk.Action ("edit-redo", null, _("Redo last undo action"), Gtk.Stock.REDO), "<ctrl><shift>Z");
    action_group.add_action_with_accel (new Gtk.Action ("edit-copy", null, _("Copy text"), Gtk.Stock.COPY), null);
    action_group.add_action_with_accel (new Gtk.Action ("edit-cut", null, _("Cut text"), Gtk.Stock.CUT), null);
    action_group.add_action_with_accel (new Gtk.Action ("edit-paste", null, _("Paste text"), Gtk.Stock.PASTE), null);
    action_group.add_action_with_accel (new Gtk.Action ("edit-lower", _("Make Lowercase"), _("Make selection lowercase"), null), "<ctrl>L");
    action_group.add_action_with_accel (new Gtk.Action ("edit-upper", _("Make Uppercase"), _("Make selection uppercase"), null), "<ctrl>U");
    action_group.add_action_with_accel (new Gtk.Action ("config-preferences", null, _("Configure IDE"), Gtk.Stock.PREFERENCES), null);

    /* Search menu */
    action_group.add_action (new Gtk.Action ("search", _("_Search"), null, null));
    action_group.add_action_with_accel (new Gtk.Action ("search-find", _("Find..."), _("Find"), Gtk.Stock.FIND), null);
    action_group.add_action_with_accel (new Gtk.Action ("search-find-next", _("Find Next"), _("Find next"), null), "<ctrl>G");
    action_group.add_action_with_accel (new Gtk.Action ("search-find-prev", _("Find Previous"), _("Find previous"), null), "<ctrl><shift>G");
    action_group.add_action_with_accel (new Gtk.Action ("search-replace", null, _("Replace"), Gtk.Stock.FIND_AND_REPLACE), "<ctrl>H");
    action_group.add_action_with_accel (new Gtk.Action ("search-goto-line", _("Go to Line..."), _("Goto line"), Gtk.Stock.JUMP_TO), "<ctrl>I");

    /* View menu */
    action_group.add_action (new Gtk.Action ("view", _("_View"), null, null));
    action_group.add_action_with_accel (new Gtk.ToggleAction ("window-show-toolbar", _("Toolbar"), _("View/hide the toolbar"), null), null);
    action_group.add_action_with_accel (new Gtk.ToggleAction ("window-show-statusbar", _("Statusbar"), _("View/hide the statusbar"), null), null);
    action_group.add_action_with_accel (new Gtk.ToggleAction ("window-fullscreen", _("Full Screen"), _("View/hide the bottom panel"), null), "F11");

    /* Project menu */
    action_group.add_action (new Gtk.Action ("project", _("_Project"), null, null));
    action_group.add_action_with_accel (new Gtk.Action ("project-create", _("New..."), _("Create new project"), Gtk.Stock.NEW), "<ctrl><shift>N");
    action_group.add_action_with_accel (new Gtk.Action ("project-open", _("Open..."), _("Open project"), Gtk.Stock.OPEN), "<ctrl><shift>O");
    action_group.add_action_with_accel (new Gtk.Action ("project-add-file", _("_Add File..."), _("Add file to project"), Gtk.Stock.ADD), null);
    action_group.add_action_with_accel (new Gtk.Action ("project-remove-file", _("_Remove File..."), _("Remove file from project"), Gtk.Stock.REMOVE), null);
    action_group.add_action_with_accel (new Gtk.Action ("project-options", _("O_ptions..."), _("Project options"), Gtk.Stock.PROPERTIES), null);
    action_group.add_action_with_accel (new Gtk.Action ("project-configure", _("_Configure"), _("Configure project"), null), "F5");
    action_group.add_action_with_accel (new Gtk.Action ("project-build", _("_Build"), _("Build project"), Gtk.Stock.CONVERT), "F6");
    action_group.add_action_with_accel (new Gtk.Action ("project-install", _("_Install"), _("Install project"), null), "F7");
    action_group.add_action_with_accel (new Gtk.Action ("project-dist", _("_Dist"), _("Distribute project"), null), null);
    action_group.add_action_with_accel (new Gtk.Action ("project-clean", _("_Clean"), _("Clean project"), Gtk.Stock.CLEAR), null);
    action_group.add_action_with_accel (new Gtk.Action ("project-distclean", _("_Distclean"), _("Clean project for distribution"), null), null);
    action_group.add_action_with_accel (new Gtk.Action ("project-uninstall", _("_Uninstall"), _("Uninstall project"), null), null);
    action_group.add_action_with_accel (new Gtk.Action ("project-execute", null, _("Execute project"), Gtk.Stock.EXECUTE), "F8");
    action_group.add_action_with_accel (new Gtk.Action ("executable-stop", _("Abort"), _("Abort executing"), Gtk.Stock.STOP), "<shift>F8");
    action_group.add_action_with_accel (new Gtk.Action ("project-close", null, _("Close project"), Gtk.Stock.CLOSE), "");

    /* Document menu */
    action_group.add_action (new Gtk.Action ("document", _("_Documents"), null, null));
    action_group.add_action_with_accel (new Gtk.Action ("document-save-all", ("Save All"), _("Save all unsaved source files"), Gtk.Stock.SAVE), "<ctrl><shift>L");
    action_group.add_action_with_accel (new Gtk.Action ("document-close-all", _("C_lose All"), _("Close all source files"), Gtk.Stock.CLOSE), "<ctrl><shift>W");
    action_group.add_action_with_accel (new Gtk.Action ("document-prev-page", _("_Previous Document"), _("Active the previous document"), null), "<ctrl><alt>Page_Up");
    action_group.add_action_with_accel (new Gtk.Action ("document-next-page", _("_Next Document"), _("Active the next document"), null), "<ctrl><alt>Page_Down");
    action_group.add_action_with_accel (new Gtk.ToggleAction ("document-split", _("Split Document"), _("Split the document view"), null), null);

    /* Help menu */
    action_group.add_action (new Gtk.Action ("help", _("_Help"), null, null));
    action_group.add_action (new Gtk.Action ("window-about", null, _("About this application"), Gtk.Stock.ABOUT));

    /* Fullscreen toolbar */
    action_group.add_action_with_accel (new Gtk.Action ("window-leave-fullscreen", _("Leave fullscreen"), _("Leave the fullscreen mode"), Gtk.Stock.LEAVE_FULLSCREEN), null);

    /* Project popup */
    action_group.add_action_with_accel (new Gtk.Action ("project-open-selected-file", _("Open file"), _("Open source file"), Gtk.Stock.OPEN), null);
    action_group.add_action_with_accel (new Gtk.Action ("project-remove-selected-file", _("Remove file"), _("Remove this file from the project"), Gtk.Stock.REMOVE), null);

    this.insert_action_group (this.action_group, 0);
  }

  /**
   * Get a Gtk.Action from name
   *
   * @param name The action name
   *
   * @return The Gtk.Action
   */
  public new Gtk.Action get_action (string name)
  {
    return this.action_group.get_action (name);
  }

  /**
   * Sets the checked state on the toggle action without signal emit
   *
   * @param name The action name
   * @param active Whether the action should be checked or not 
   */
  public void action_set_toggled (string name, bool active)
  {
    Gtk.ToggleAction action;

    action = this.get_action (name) as Gtk.ToggleAction;
    if (action != null)
    {
      this.action_group.remove_action (action);
      action.set_active (active);
      this.action_group.add_action (action);
    }
    else
    {
      debug ("Invalid action name: %s", name);
    }
  }

  private static const string xmldef="""<ui>
  <menubar name="menubar">
    <menu action="file">
      <menuitem action="document-create"/>
      <placeholder name="document-ops-1"/>
      <menuitem action="document-open"/>
      <placeholder name="document-ops-2"/>
      <separator/>
      <menuitem action="document-save"/>
      <menuitem action="document-save-as"/>
      <placeholder name="document-ops-3"/>
      <separator/>
      <menuitem action="document-rename"/>
      <placeholder name="document-ops-4"/>
      <placeholder name="file-recents-placeholder">
        <separator/>
      </placeholder>
      <separator/>
      <menuitem action="document-close"/>
      <menuitem action="window-quit"/>
    </menu>

    <menu action="edit">
      <menuitem action="edit-undo"/>
      <menuitem action="edit-redo"/>
      <separator/>
      <menuitem action="edit-copy"/>
      <menuitem action="edit-cut"/>
      <menuitem action="edit-paste"/>
      <placeholder name="edit-ops-1"/>
      <separator/>
      <menuitem action="edit-lower"/>
      <menuitem action="edit-upper"/>
      <placeholder name="edit-ops-2"/>
      <separator/>
      <menuitem action="config-preferences"/>
    </menu>

    <menu action="search">
      <menuitem action="search-find"/>
      <menuitem action="search-find-next"/>
      <menuitem action="search-find-prev"/>
      <placeholder name="search-ops-1"/>
      <separator/>
      <menuitem action="search-replace"/>
      <placeholder name="search-ops-2"/>
      <separator/>
      <menuitem action="search-goto-line"/>
      <placeholder name="search-ops-3"/>
      <separator/>
    </menu>

    <menu action="view">
      <menuitem action="window-show-toolbar"/>
      <menuitem action="window-show-statusbar"/>
      <separator/>
      <menuitem action="window-fullscreen"/>
      <placeholder name="view-layout-placeholder">
        <separator/>
      </placeholder>
    </menu>

    <menu action="project">
      <menuitem action="project-create"/>
      <menuitem action="project-open"/>
      <menuitem action="project-close"/>
      <placeholder name="project-ops-1"/>
      <separator/>
      <menuitem action="project-add-file" />
      <menuitem action="project-remove-file" />
      <placeholder name="project-ops-2"/>
      <separator/>
      <menuitem action="project-configure"/>
      <menuitem action="project-build"/>
      <menuitem action="project-install"/>
      <menuitem action="project-dist"/>
      <menuitem action="project-clean"/>
      <menuitem action="project-distclean"/>
      <menuitem action="project-uninstall"/>
      <placeholder name="project-ops-3"/>
      <separator/>
      <menuitem action="project-execute"/>
      <menuitem action="executable-stop"/>
      <placeholder name="project-ops-4"/>
      <separator/>
      <menuitem action="project-options"/>
      <placeholder name="project-recents-placeholder">
        <separator/>
      </placeholder>
    </menu>

    <menu action="document">
      <menuitem action="document-save-all"/>
      <menuitem action="document-close-all"/>
      <separator/>
      <menuitem action="document-prev-page"/>
      <menuitem action="document-next-page"/>
      <separator/>
      <menuitem action="document-split"/>
      <placeholder name="document-ops-1">
        <separator/>
      </placeholder>
    </menu>

    <menu action="help">
      <menuitem action="window-about"/>
    </menu>
  </menubar>

  <toolbar name="toolbar">
    <toolitem action="document-create" />
    <toolitem action="document-open" />
    <toolitem action="document-save" />
    <separator/>
    <toolitem action="edit-undo" />
    <toolitem action="edit-redo" />
    <separator/>
    <toolitem action="search-find" />
    <toolitem action="search-replace" />
    <separator/>
    <toolitem action="project-build"/>
    <toolitem action="project-execute"/>
    <toolitem action="executable-stop"/>
  </toolbar>

  <toolbar name="fullscreen-toolbar">
    <toolitem action="document-create" />
    <toolitem action="document-open" />
    <toolitem action="document-save" />
    <separator/>
    <toolitem action="edit-undo" />
    <toolitem action="edit-redo" />
    <separator/>
    <toolitem action="search-find" />
    <toolitem action="search-replace" />
    <separator/>
    <toolitem action="project-build"/>
    <toolitem action="project-execute"/>
    <toolitem action="executable-stop"/>
    <separator expand="true"/>
    <toolitem action="window-leave-fullscreen"/>
  </toolbar>

  <popup name="project-popup">
    <menuitem action="document-create" />
    <menuitem action="project-open-selected-file" />
    <menuitem action="project-add-file" />
    <menuitem action="project-remove-selected-file" />
  </popup>

  <popup name="document-popup">
    <menuitem action="document-rename"/>
    <separator/>
    <menuitem action="document-save"/>
    <menuitem action="document-save-as"/>
    <separator/>
    <menuitem action="document-close"/>
  </popup>
</ui>""";
}
