/* template-manager.vala
 *
 * Copyright (C) 2008-2009  Nicolas Joseph
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 * 	Nicolas Joseph <nicolas.joseph@valaide.org>
 */

/**
 * The template manager
 */
public class Valide.TemplateManager : Object
{
  private static TemplateManager instance = null;

  private TemplateManager ()
  {
  }

  /**
   * Get the uniq instance of Valide.TemplateManager
   *
   * @return The Valide.TemplateManager instance
   */
  public static TemplateManager get_instance ()
  {
    if (TemplateManager.instance == null)
    {
      TemplateManager.instance = new TemplateManager ();
    }
    return TemplateManager.instance;
  }

  /**
   * Get the list of available template
   *
   * @return The template list
   */
  public List<string> get_list ()
  {
    List<string> list;
    string[] template_dir = { Config.TEMPLATES_DIR,
                              Path.build_filename (ConfigManager.get_instance ().get_home_dir(),
                                                   "template")
                            };


    list = new List<string> ();
    foreach (string d in template_dir)
    {
      try
      {
        Dir dir;
        string filename = null;

        dir = Dir.open (d);
        do
        {
          filename = dir.read_name ();
          if (filename != null)
          {
            if (FileUtils.test (Path.build_filename (d, filename), FileTest.IS_DIR))
            {
              string file;

              file = Path.build_filename (d, filename, "template.yml");
              if (FileUtils.test (file, FileTest.EXISTS))
              {
                list.append (file);
              }
            }
          }
        } while (filename != null);

      }
      catch (Error e)
      {
        debug (e.message);
      }
    }
    list.sort (strcmp);
    return list;
  }
}

