/* project-dialog-remove.vala
 *
 * Copyright (C) 2008-2010 Nicolas Joseph
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 *   Nicolas Joseph <nicolas.joseph@valaide.org>
 */

private enum Col
{
  DELETE,
  FILENAME,
  PATH,
  NB
}

/**
 * A dialog box for remove a file from a project
 */
public class Valide.ProjectDialogRemove : AbstractProjectDialogRemove
{
  private Gtk.ListStore list_store;

  /**
   * The attached project
   */
  public Project project
  {
    get;
    construct;
  }

  private List<string> _selected_files;
  /**
   * The list of the selected files
   */
  public List<string> selected_files
  {
    get
    {
      Gtk.TreeIter iter;

      this._selected_files = null;
      /* @FIXME Error if no file */
      this.list_store.get_iter_first (out iter);
      do
      {
        bool enable = false;

        this.list_store.get (iter, Col.DELETE, out enable);
        if (enable)
        {
          string file = "";

          this.list_store.get (iter, Col.PATH, out file);
          this._selected_files.append (file);
        }
      } while (this.list_store.iter_next (ref iter) == true);
      return this._selected_files;
    }
  }

  private void toggled (Gtk.CellRendererToggle sender, string path)
  {
    Gtk.TreeIter iter;
    bool enable = false;

    this.list_store.get_iter_from_string (out iter, path);
    this.list_store.get (iter, Col.DELETE, &enable);
    this.list_store.set (iter, Col.DELETE, !enable);
  }

  /**
   * Create a new Valide.ProjectDialogRemove
   *
   * @param project The attached project
   */
  public ProjectDialogRemove (Project project)
  {
    Object (project: project);
  }

  construct
  {
    this.list_store = new Gtk.ListStore (Col.NB, typeof (bool), typeof (string),
                                                 typeof (string));

    Gtk.TreeView tree_view = this.widgets.tree_view;
    tree_view.model = this.list_store;

    Gtk.CellRendererToggle render1 = new Gtk.CellRendererToggle ();
    Gtk.TreeViewColumn column = new Gtk.TreeViewColumn.with_attributes (_("Remove"), render1, "active", Col.DELETE, null);
    tree_view.append_column (column);
    render1.toggled.connect (this.toggled);

    Gtk.CellRendererText render2 = new Gtk.CellRendererText ();
    column = new Gtk.TreeViewColumn.with_attributes (_("File"), render2, "text", Col.FILENAME, null);
    tree_view.append_column (column);
    tree_view.headers_visible = false;

    this.widgets.label.set_text (_("Select files to remove from %s:").printf (this.project.name));
    foreach (Source file in this.project.files)
    {
      Gtk.TreeIter iter;

      this.list_store.append (out iter);
      this.list_store.set (iter, Col.DELETE, false,
                                 Col.FILENAME, file.path,
                                 Col.PATH, project.get_real_filename (file.path));
    }
  }

  /**
   * @see Gtk.Dialog.run
   */
  public int run ()
  {
    this.widgets.dialog.show_all ();
    return this.widgets.dialog.run ();
  }

  /**
   * @see Gtk.Object.destroy
   */
  public override void destroy ()
  {
    this.widgets.dialog.destroy ();
    this.destroy ();
  }

  /**
   * @see Gtk.Widget.hide
   */
  public new void hide ()
  {
    this.widgets.dialog.hide ();
  }
}

