/* plugin-manager.vala
 *
 * Copyright (C) 2008-2009  Nicolas Joseph
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 * 	Nicolas Joseph <nicolas.joseph@valaide.org>
 */

/**
 * The plugin manager
 */
public class Valide.PluginManager : Object
{
  /**
   * The main window of the application
   */
  public Window window
  {
    get;
    construct;
  }

  /**
   * List of register plugins
   */
  public List<PluginRegistrar> plugins;

  private void register_plugin (string filename)
  {
    PluginRegistrar registrar;

    registrar = new PluginRegistrar (filename, this.window);
    registrar.load ();
    if (ConfigManager.get_instance ().get_boolean ("Plugins", registrar.name))
    {
      registrar.activate ();
    }
    this.plugins.append (registrar);
  }

  /**
   * Create a new plugin manager
   *
   * @param window The main window of the application
   */
  public PluginManager (Window window)
  {
    Object (window: window);
  }

  construct
  {
    string[] plugin_dir = { Config.PLUGINS_DIR,
                            Path.build_filename (ConfigManager.get_instance ().get_home_dir(),
                                                 "plugins"),
                            "../lib/valide/plugins/"
                          };

    foreach (string d in plugin_dir)
    {
      try
      {
        Dir dir = Dir.open (d);

        do
        {
          string filename;

          filename = dir.read_name ();
          if (filename != null)
          {
            string file;

            file = Path.build_filename (d, filename);
            if (FileUtils.test (file, FileTest.IS_DIR))
            {
              file = Path.build_filename (file, filename + "." + PluginRegistrar.FILE_EXT[0]);
            }

            if (file.has_suffix ("." + PluginRegistrar.FILE_EXT[0]))
            {
              this.register_plugin (file);
            }
          }
          else
          {
            break;
          }
        } while (true);
      }
      catch (Error e)
      {
        debug (e.message);
      }
    }
  }

  ~PluginManager()
  {
    foreach (PluginRegistrar pr in this.plugins)
    {
      pr.unload ();
    }
  }

  /**
   * Get the preference widget
   *
   * @return The preference widget
   */
  public Gtk.Widget preferences ()
  {
    return new PluginPreferences (this);
  }
}

