/* goto-dialog.vala
 *
 * Copyright (C) 2008-2011  Nicolas Joseph
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 *	Nicolas Joseph <nicolas.joseph@valaide.org>
 */

/**
 * A goto dialog widget for Valide.SourceView
 */
public class Valide.GotoDialog : Gtk.Window
{
  private Gtk.Entry entry;

  /**
   * The attached source view
   */
  public SourceView source_view
  {
    get;
    construct;
  }

  private void hide_search (bool cancel)
  {
    this.hide ();

    if (cancel)
    {
    }
    this.source_view.grab_focus ();
  }

  private void update_position ()
  {
	  int view_x, view_y;
	  Gdk.Window view_window;

	  view_window = this.source_view.window;
	  this.realize ();

	  view_window.get_origin (out view_x, out view_y);

	  this.move (view_x, view_y);
  }

  private bool key_press_event_cb (Gtk.Widget sender, Gdk.EventKey event)
  {
    bool catched = false;

    switch (event.keyval)
    {
      case Gdk.KeySyms.Return:
      case Gdk.KeySyms.Tab:
        this.hide_search (false);
        catched =  true;
      break;
      case Gdk.KeySyms.Escape:
        /* Cancel */
        this.hide_search (true);
        catched =  true;
      break;
    }
    return catched;
  }

  private void changed_cb ()
  {
    if (this.entry.get_text () != "")
    {
      int line;
      bool moved;
      Gdk.Color color;

      line = int.parse (this.entry.text);
      if (line > 0)
      {
         line--;
      }
      moved = this.source_view.goto_line (line);

      if (!moved)
      {
		Gdk.Color.parse ("#FFBFBF", out color);
      }
      else
      {
		Gdk.Color.parse ("white", out color);
      }
      this.entry.modify_base (Gtk.StateType.NORMAL, color);
    }
  }

  private void insert_text_cb (Gtk.Editable sender, string new_text,
                               int new_text_length, void* position)
  {
    int i = 0;
	  unichar c;

	  while (i < new_text_length)
	  {
		  c = new_text[i];

		  if (!c.isdigit ())
		  {
			  Signal.stop_emission_by_name (sender, "insert_text");
			  break;
		  }
		  i++;
	  }
  }

  /**
   * Create a new Valide.GotoDialog
   *
   * @param source_view The attached source view
   */
  public GotoDialog (SourceView source_view)
  {
    Object (source_view: source_view);
  }

  construct
  {
    Gtk.Frame frame;
    Gtk.VBox vbox;
    Gtk.Window toplevel;

    this.set_decorated (false);
    this.set_skip_taskbar_hint (true);
    this.set_skip_pager_hint (true);
    toplevel = this.source_view.get_toplevel () as Gtk.Window;
    toplevel.group.add_window (this);
    this.set_modal (true);

    frame = new Gtk.Frame (null);
    frame.set_shadow_type (Gtk.ShadowType.ETCHED_IN);
    this.add (frame);
    frame.show ();

    vbox = new Gtk.VBox (false, 0);
    vbox.set_border_width (3);
    frame.add (vbox);
    vbox.show ();

    this.entry = new Gtk.Entry ();
    vbox.add (entry);
    this.entry.show ();
    this.entry.realize ();

    this.entry.activate.connect (() => {
      this.hide_search (false);
    });

    this.delete_event.connect (() => {
      this.hide_search (false);
      return false;
    });

    this.focus_out_event.connect (() => {
      this.hide_search (true);
      return false;
    });

    this.entry.changed.connect (this.changed_cb);
    this.entry.insert_text.connect (this.insert_text_cb);
    this.entry.key_press_event.connect (this.key_press_event_cb);
  }

  /**
   * @see Gtk.Widget.Show
   */
  public override void show ()
  {
    base.show ();
    this.update_position ();
    this.grab_focus ();
  }

  /**
   * @see Gtk.Widget.grab_focus
   */
  public override void grab_focus ()
  {
    this.entry.grab_focus ();
  }
}

