/* frame.vala
 *
 * Copyright (C) 2008-2009  Nicolas Joseph
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 * 	Nicolas Joseph <nicolas.joseph@valaide.org>
 */

/**
 * Frame with the style recommended by GNOME Human Interface Guidelines
 */
public class Valide.Frame : Gtk.Frame
{
  private Gtk.Alignment alignment;

  public Frame (string label)
  {
    Gtk.Label label_widget;
    Pango.AttrList attr_list;

    Object (label: label, shadow_type: Gtk.ShadowType.NONE);
    attr_list = new Pango.AttrList ();
    attr_list.insert (Pango.attr_weight_new (Pango.Weight.BOLD).copy ());
    label_widget = this.label_widget as Gtk.Label;
    label_widget.set_attributes (attr_list);
  }

  construct
  {
    this.alignment = new Gtk.Alignment (0, 0, 0, 0);
    this.alignment.left_padding = 12;
    base.add (this.alignment);
  }

  /**
   * @see Gtk.Container.add
   */
  public override void add (Gtk.Widget widget)
  {
    this.alignment.add (widget);
  }
}

