/* encoding.vala
 *
 * Copyright (C) 2009  Nicolas Joseph
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 * 	Nicolas Joseph <nicolas.joseph@valaide.org>
 */

errordomain Valide.EncodingError
{
  UNKNOW_ENCODING
}

/**
 * A class for manager the file encoding
 */
public class Valide.Encoding : Object
{
  private const string[] charsets = {"UTF-8", "ISO-8859-15"};

  private static string convert (string text, string to_codeset,
                                 string from_codeset) throws Error

  {
    return GLib.convert (text, -1, to_codeset, from_codeset);
  }

  private static bool test (string text, string charset)
  {
    bool valid = false;

    try
    {
      string convert;

      convert = GLib.convert (text, -1, "UTF-8", charset);
      valid = true;
    }
    catch (Error e)
    {
      debug (e.message);
    }
    return valid;
  }

  private static string get_charset (string text)
  {
    string charset = null;

    foreach (string c in charsets)
    {
      if (Encoding.test (text, c))
      {
        charset = c;
        break;
      }
    }
    return charset;
  }

  /**
   * Return the content of a file encoding in UTF8
   *
   * @param path The name of file
   * @param encoding The encoding of the file
   *
   * @return The content of the file in UTF8
   */
  public static string to_utf8 (string path, out string? encoding = null) throws Error
  {
    string text = null;
    string contents = "";

    FileUtils.get_contents (path, out text, null);
    encoding = Encoding.get_charset (text);
    if (encoding != null)
    {
      contents = Encoding.convert (text, "UTF-8", encoding);
    }
    else
    {
      throw new EncodingError.UNKNOW_ENCODING ("unknow encoding");
    }
    return contents;
  }

  /* @bug ?! */
  /**
   * Return the content of a Gtk.TextView encoding in UTF8
   *
   * @param text_buffer A Gtk.TextBuffer
   * @param encoding The encoding of the file
   *
   * @return The content of the Gtk.TextView in UTF8
   */
  public static string from_utf8 (Gtk.TextBuffer text_buffer, out string? encoding = null) throws Error
  {
    string text;
    Gtk.TextIter end;
    Gtk.TextIter start;
    string convert = null;

    text_buffer.get_bounds (out start, out end);
    text = start.get_text (end);
    if (text != null)
    {
      encoding = Encoding.get_charset (text);
      if (encoding != null)
      {
        convert = Encoding.convert (text, encoding, "UTF-8");
      }
    }
    return convert;
  }
}

