/* config-manager.vala
 *
 * Copyright (C) 2008-2011 Nicolas Joseph
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 *   Nicolas Joseph <nicolas.joseph@valaide.org>
 */

/**
 * Class for manage the configuration file
 */
public class Valide.ConfigManager : AbstractConfigManager
{
  private static ConfigManager instance;
  private const string CONFIG_FILE = "config.ini";
  private const string LAYOUT_FILE = "layout.xml";

  /**
   * @see Valide.AbstractConfigManager.config_file
   */
  public override string get_config_file ()
  {
      return this.create_preferences_file (this.CONFIG_FILE, """[General]
full-screen=true
window-width=1024
window-height=768

[GtkSourceView]
auto-indent=true
indent-on-tab=true
tab-width=2
highlight-current-line=true
show-right-margin=true
right-margin-position=80
show-line-numbers=false
insert-spaces-instead-of-tabs=true
auto-indent=true
style-scheme=classic
font=Monospace 12

[Plugins]
Todo=true
Symbol=true
Completion=true
File browser=true
Opened Documents=true
Waf=true
Make=true
Advanced search=true
Start page=true

[SymbolBrowser]
show-language=false
show-source-file=false
show-line-number=false
hierarchic-view=true

[Interface]
switcher-style=both
max-recent-files=5
max-recent-projects=5
""");
  }

  public string get_layout_file ()
  {
      return this.create_preferences_file (this.LAYOUT_FILE, """<?xml version="1.0"?>
<dock-layout>
  <layout name="__default__">
    <dock name="__dock_1" floating="no" width="-1" height="-1" floatx="0" floaty="0">
      <paned orientation="vertical" locked="no" position="326">
        <paned orientation="horizontal" locked="no" position="249">
          <notebook orientation="vertical" locked="no" page="0">
            <item name="projects" orientation="vertical" locked="no" />
            <item name="file-browser-plugin" orientation="vertical" locked="no"/>
            <item name="symbol-browser-plugin" orientation="vertical" locked="no"/>
            <item name="opened-documents-plugin" orientation="vertical" locked="no"/>
            <placeholder name="ph_left" next-placement="left"/>
          </notebook>
          <paned orientation="horizontal" locked="no" position="500">
            <paned orientation="vertical" locked="no" position="200">
              <notebook orientation="vertical" locked="no" page="0">
                <placeholder name="ph_top" next-placement="top"/>
              </notebook>
              <notebook orientation="vertical" locked="no" page="0">
                <item name="start-page-plugin" orientation="vertical" locked="no" />
                <item name="editor" orientation="vertical" locked="no" />
                <placeholder name="ph_center" next-placement="center"/>
              </notebook>
            </paned>
            <notebook orientation="vertical" locked="no" page="0">
              <placeholder name="ph_right" next-placement="right"/>
            </notebook>
          </paned>
        </paned>
        <notebook orientation="vertical" locked="no" page="0">
          <item name="executables" orientation="vertical" locked="no" />
          <item name="todo-plugin" orientation="vertical" locked="no"/>
          <item name="advanced-search-plugin" orientation="vertical" locked="no"/>
          <placeholder name="ph_bottom" next-placement="bottom"/>
        </notebook>
      </paned>
    </dock>
  </layout>
</dock-layout>
""");
  }

  private ConfigManager ()
  {
  }

  /**
   * @see Valide.AbstractConfigManager.first_run
   */
  protected override void first_run ()
  {
    DirUtils.create (Path.build_filename (this.get_home_dir (), "plugins"), 0700);
    DirUtils.create (Path.build_filename (this.get_home_dir (), "template"), 0700);
    DirUtils.create (Path.build_filename (this.get_home_dir (), "licenses"), 0700);
  }

  /**
   * Get the uniq instance of Valide.ConfigManager
   *
   * @return The Valide.ConfigManager instance
   */
  public static ConfigManager get_instance ()
  {
    if (instance == null)
    {
      instance = new ConfigManager ();
    }
    return instance;
  }

  /**
   * @see Valide.AbstractConfigManager.preferences
   */
  public override void preferences (Window window)
  {
    PreferencesDialog dialog;

    dialog = new PreferencesDialog (window);
    dialog.run ();
    dialog.destroy ();
  }
}

