/* builder.vala
 *
 * Copyright (C) 2008-2010 Nicolas Joseph
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 *   Nicolas Joseph <nicolas.joseph@valaide.org>
 */

/**
 * The different building step
 */
public enum Valide.BuildingStep
{
  CONFIGURE,
  BUILD,
  INSTALL,
  DIST,
  CLEAN,
  DISTCLEAN,
  UNINSTALL
}

/**
 * This instance use to create a new builder
 *
 * warning: You should register builder with BuilderManager.register_builder
 * function.
 */
public interface Valide.Builder : Object
{
  public abstract Project project { get; construct set; }
  public abstract ExecutableManager executables { get; construct set; }

  /**
   * Configure the project
   *
   * @return Exit status
   */
  public abstract int configure ();

  /**
   * Compile the project
   *
   * @return Exit status
   */
  public abstract int build ();

  /**
   * Install the project
   *
   * @return Exit status
   */
  public abstract int install ();

  /**
   * Distribute the project
   *
   * @return Exit status
   */
  public abstract int dist ();

  /**
   * Clean the project
   *
   * @return Exit status
   */
  public abstract int clean ();

  /**
   * Clean the project for distribution
   *
   * @return Exit status
   */
  public abstract int distclean ();

  /**
   * Uninstall the project
   *
   * @return Exit status
   */
  public abstract int uninstall ();

  public abstract Gtk.Widget preferences ();
}

public interface Valide.BuilderOptions : Object
{
}

