<xsl:transform version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:glade="http://glade.gnome.org/glade-2.0.dtd"
        xmlns:regexp="http://exslt.org/regular-expressions"
        xmlns:str="http://exslt.org/strings"
        xmlns:sam="http://liddicott.com/sam"
        xmlns:func="http://exslt.org/functions"
        xmlns:valax="http://www.liddicott.com/valax"
        extension-element-prefixes="regexp str func sam valax"
        exclude-result-prefixes="regexp str func sam valax">
  <xsl:output method="xml" indent="no" omit-xml-declaration="yes" standalone="no" />
    <xsl:param name="class"/>
    <xsl:param name="class-prefix"/>
    <xsl:param name="namespace"/>
    <xsl:param name="class-name"/>

<!-- these are more constants than params -->
  <xsl:param name="idchars">abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_</xsl:param>
  <xsl:param name="eol" select="'&#xA;'"/>

  <func:function name="valax:identifier-char">
    <xsl:param name="char"/>
    <func:result select="translate($char,$idchars,'')=''"/>
  </func:function>

  <func:function name="valax:glade-to-vala-identifier">
    <xsl:param name="text"/>
    <xsl:choose>
      <xsl:when test="starts-with($text,'Gtk')">
        <func:result select="concat('Gtk.',valax:vala-identifier(substring-after($text,'Gtk')))"/>

      </xsl:when>
      <xsl:otherwise>
        <func:result select="valax:vala-identifier($text)"/>
      </xsl:otherwise>
    </xsl:choose>
  </func:function>

  <func:function name="valax:C-quote">
    <xsl:param name="text"/>

    <func:result select="str:replace($text,str:tokenize('\,&quot;',','),str:tokenize('\\,\&quot;',','))"/>
  </func:function>

  <func:function name="valax:vala-identifier">
    <xsl:param name="id"/>

      <xsl:variable name="prefix">
      <xsl:if test="substring($id,1,1) &gt;= '0' and substring($id,1,1) &lt;= '9'">
      <xsl:text>_</xsl:text>

      </xsl:if>
    </xsl:variable>

    <func:result select="concat($prefix,valax:_vala-identifier(normalize-space($id)))"/>
  </func:function>

  <func:function name="valax:_vala-identifier">
    <xsl:param name="id"/>
    <xsl:param name="previous"/>

    <xsl:choose>

      <xsl:when test="$id=''">
        <func:result select="''"/>
      </xsl:when>
      <xsl:when test="not(valax:identifier-char(substring($id,1,1)))">

        <xsl:choose>
          <xsl:when test="$previous='_'">
            <func:result select="valax:_vala-identifier(substring($id,2),'_')"/>
          </xsl:when>

          <xsl:otherwise>
            <func:result select="concat('_',valax:_vala-identifier(substring($id,2),'_'))"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <func:result select="concat(substring($id,1,1),valax:_vala-identifier(substring($id,2),''))"/>
      </xsl:otherwise>
    </xsl:choose>
  </func:function>

  <xsl:template match="/">
    <xsl:variable name="class" select="concat($class-prefix,valax:vala-identifier(//object/@id))"/>
    <xsl:variable name="class-count-name" select="concat($class,'_WIDGET_COUNT')" />
    <xsl:variable name="widget-count" select="count(//object[@id])"/>

    <xsl:if test="not($widget-count &gt; 0)">
      <xsl:message terminate="yes">Error: Could not find any gtk objects.</xsl:message>
    </xsl:if>

    <xsl:text>/* Auto generated by gen-vala-gtk-widget-bindings.xslt */
public abstract class </xsl:text>
    <xsl:value-of select="$namespace"/>
    <xsl:text>.</xsl:text>
    <xsl:value-of select="$class-name"/>
    <xsl:text> : Gtk.Object</xsl:text>
    <xsl:text disable-output-escaping="yes">
{</xsl:text>

    <!-- the widgets class -->
    <xsl:text>
  protected class WindowWidgets : Object
  {
</xsl:text>
    <xsl:for-each select="//object[@id]">
      <xsl:text>    public </xsl:text>
      <xsl:value-of select="valax:glade-to-vala-identifier(@class)"/>
      <xsl:text> </xsl:text>
        <xsl:value-of select="valax:vala-identifier(@id)"/>
        <xsl:text> {get; set;} /* </xsl:text>
      <xsl:value-of select="@class"/>
      <xsl:text> </xsl:text>
      <xsl:value-of select="@id"/>
      <xsl:text> */
</xsl:text>
    </xsl:for-each>
    <xsl:text>  }
</xsl:text>

<xsl:text disable-output-escaping="yes">
  private Module module;

  protected Gtk.Builder xml;
  protected string name_space;
  protected WindowWidgets widgets;

  construct
  {
    this.xml = new Gtk.Builder ();

    try
    {
      this.xml.add_from_string (xmldef, -1);
      this.widgets = new WindowWidgets ();
      this.widget_connect ();
    }
    catch (Error e)
    {
      debug (e.message);
    }
  }

  private void widget_connect ()
  {
    SList&lt;unowned Object&gt; objects = this.xml.get_objects ();

    foreach (Object object in objects)
    {
      if (object is Gtk.Buildable)
      {
        this.widgets.set ((object as Gtk.Buildable).get_name (), object);
      }
    }
  }

  [InstanceLast]
  protected void connect_signal (Gtk.Builder builder, Object object, string signal_name, 
                        string handler_name, Object? connect_objectt, ConnectFlags flags)
  {
    void* sym;

    if (!module.symbol (this.name_space + handler_name, out sym)
        &amp;&amp; !module.symbol (handler_name, out sym))
    {
      stdout.printf ("Symbol not found: %s => %s\n", signal_name, handler_name);
    }
    else
    {
      Signal.connect(object, signal_name, (Callback) sym, this);
    }
  }

  protected void connect_signals (string name_space)
  {
    this.name_space = name_space;

    if (null != (this.module = Module.open (null, ModuleFlags.BIND_LAZY)))
    {
      this.xml.connect_signals_full (connect_signal);
    }
  }

</xsl:text>

    <!-- now copy the xml as a constant -->
    <xsl:text>
  private static const string xmldef="""
</xsl:text>

    <xsl:copy><xsl:apply-templates select="node()|@*"/></xsl:copy>

    <xsl:text> """;} </xsl:text>

  </xsl:template>

  <xsl:template match="node()|@*">
    <xsl:copy><xsl:apply-templates select="node()|@*"/></xsl:copy>
  </xsl:template>

  <xsl:template name="widget-info">
    <xsl:param name="id" select="@id"/>
      <xsl:param name="class" select="@class"/>

      <xsl:param name="index" select="position() - 1"/>
      
      <xsl:text>    {</xsl:text>
      <xsl:value-of select="$index"/>
      <xsl:text disable-output-escaping="yes">, &quot;</xsl:text>
      <xsl:value-of select="$class"/>
      <xsl:text disable-output-escaping="yes">&quot;, &quot;</xsl:text>
      <xsl:value-of select="$id"/>

      <xsl:text disable-output-escaping="yes">&quot;},&#xA;</xsl:text>
  </xsl:template>

</xsl:transform>

