[CCode (cheader_filename = "ctags.h", cprefix = "", lower_case_cprefix = "")]
namespace CTags
{
  [CCode (cheader_filename = "options.h", cprefix = "EX_", cname = "exCmd")]
  public enum ExCmd
  {
	  MIX,
	  LINENUM,
	  PATTERN
  }

  [CCode (cheader_filename = "options.h", cprefix = "SO_", cname = "sortType")]
  public enum SortType
  {
	  UNSORTED,
	  SORTED,
	  FOLDSORTED
  }

  [CCode (cheader_filename = "parse.h", cname = "langType")]
  public struct LangType
  {
  }

  [CCode (cheader_filename = "vstring.h", cname = "vString")]
  public struct VString
  {
	  public size_t  length;
	  public size_t  size;
	  public string buffer;
  }

  [CCode (cheader_filename = "strlist.h", cname = "stringList")]
  public struct StringList
  {
	  public uint max;
	  public uint count;
	  public VString[] list;
  }

  [CCode (cheader_filename = "options.h", cname = "sInclude")]
  public struct Include
  {
    [CCode (cname = "fileNames")]
	  public bool file_names;
    [CCode (cname = "qualifiedTags")]
	  public bool qualified_tags;
    [CCode (cname = "fileScope")]
	  public bool file_scope;
  }

  [CCode (cheader_filename = "options.h", cname = "sExtFields")]
  public struct ExtFields
  {
	  public bool access;
    [CCode (cname = "fileScope")]
	  public bool file_scope;
	  public bool implementation;
	  public bool inheritance;
	  public bool kind;
    [CCode (cname = "kindKey")]
	  public bool kind_key;
    [CCode (cname = "kindLong")]
	  public bool kind_long;
	  public bool language;
    [CCode (cname = "lineNumber")]
	  public bool line_number;
	  public bool scope;
	  public bool signature;
    [CCode (cname = "typeRef")]
	  public bool type_ref;
  }

  [CCode (cheader_filename = "options.h")]
  public struct OptionValues
  {
	  public Include include;
    [CCode (cname = "extensionFields")]
	  public ExtFields extension_fields;
	  public StringList ignore;
	  public bool append;
	  public bool backward;
	  public bool etags;
	  public ExCmd locate;
	  public bool recurse;
	  public SortType sorted;
	  public bool verbose;
	  public bool xref;
	  public string fileList;
	  public string tagFileName;
	  public StringList headerExt;
	  public StringList etagsInclude;
	  public uint tagFileFormat;
	  public bool if0;
	  public bool kindLong;
	  public LangType language;
	  public bool followLinks;
	  public bool filter;
	  public string filterTerminator;
	  public bool tagRelative;
	  public bool printTotals;
	  public bool lineDirectives;
  }

  [CCode (cheader_filename = "options.h")]
  public const OptionValues Option;
}

