// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is automatically generated.

#ifndef UI_GFX_GL_GL_BINDINGS_AUTOGEN_GL_H_
#define UI_GFX_GL_GL_BINDINGS_AUTOGEN_GL_H_

namespace gfx {

class GLContext;


typedef void (GL_BINDING_CALL *glActiveTextureProc)(GLenum texture);
typedef void (GL_BINDING_CALL *glAttachShaderProc)(GLuint program, GLuint shader);
typedef void (GL_BINDING_CALL *glBeginQueryProc)(GLenum target, GLuint id);
typedef void (GL_BINDING_CALL *glBeginQueryARBProc)(GLenum target, GLuint id);
typedef void (GL_BINDING_CALL *glBindAttribLocationProc)(GLuint program, GLuint index, const char* name);
typedef void (GL_BINDING_CALL *glBindBufferProc)(GLenum target, GLuint buffer);
typedef void (GL_BINDING_CALL *glBindFragDataLocationProc)(GLuint program, GLuint colorNumber, const char* name);
typedef void (GL_BINDING_CALL *glBindFragDataLocationIndexedProc)(GLuint program, GLuint colorNumber, GLuint index, const char* name);
typedef void (GL_BINDING_CALL *glBindFramebufferEXTProc)(GLenum target, GLuint framebuffer);
typedef void (GL_BINDING_CALL *glBindRenderbufferEXTProc)(GLenum target, GLuint renderbuffer);
typedef void (GL_BINDING_CALL *glBindTextureProc)(GLenum target, GLuint texture);
typedef void (GL_BINDING_CALL *glBlendColorProc)(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
typedef void (GL_BINDING_CALL *glBlendEquationProc)( GLenum mode );
typedef void (GL_BINDING_CALL *glBlendEquationSeparateProc)(GLenum modeRGB, GLenum modeAlpha);
typedef void (GL_BINDING_CALL *glBlendFuncProc)(GLenum sfactor, GLenum dfactor);
typedef void (GL_BINDING_CALL *glBlendFuncSeparateProc)(GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha);
typedef void (GL_BINDING_CALL *glBlitFramebufferProc)(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter);
typedef void (GL_BINDING_CALL *glBlitFramebufferEXTProc)(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter);
typedef void (GL_BINDING_CALL *glBlitFramebufferANGLEProc)(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter);
typedef void (GL_BINDING_CALL *glBufferDataProc)(GLenum target, GLsizeiptr size, const void* data, GLenum usage);
typedef void (GL_BINDING_CALL *glBufferSubDataProc)(GLenum target, GLintptr offset, GLsizeiptr size, const void* data);
typedef GLenum (GL_BINDING_CALL *glCheckFramebufferStatusEXTProc)(GLenum target);
typedef void (GL_BINDING_CALL *glClearProc)(GLbitfield mask);
typedef void (GL_BINDING_CALL *glClearColorProc)(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
typedef void (GL_BINDING_CALL *glClearDepthProc)(GLclampd depth);
typedef void (GL_BINDING_CALL *glClearDepthfProc)(GLclampf depth);
typedef void (GL_BINDING_CALL *glClearStencilProc)(GLint s);
typedef void (GL_BINDING_CALL *glColorMaskProc)(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha);
typedef void (GL_BINDING_CALL *glCompileShaderProc)(GLuint shader);
typedef void (GL_BINDING_CALL *glCompressedTexImage2DProc)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void* data);
typedef void (GL_BINDING_CALL *glCompressedTexSubImage2DProc)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void* data);
typedef void (GL_BINDING_CALL *glCopyTexImage2DProc)(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border);
typedef void (GL_BINDING_CALL *glCopyTexSubImage2DProc)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
typedef GLuint (GL_BINDING_CALL *glCreateProgramProc)(void);
typedef GLuint (GL_BINDING_CALL *glCreateShaderProc)(GLenum type);
typedef void (GL_BINDING_CALL *glCullFaceProc)(GLenum mode);
typedef void (GL_BINDING_CALL *glDeleteBuffersARBProc)(GLsizei n, const GLuint* buffers);
typedef void (GL_BINDING_CALL *glDeleteFramebuffersEXTProc)(GLsizei n, const GLuint* framebuffers);
typedef void (GL_BINDING_CALL *glDeleteProgramProc)(GLuint program);
typedef void (GL_BINDING_CALL *glDeleteQueriesProc)(GLsizei n, const GLuint* ids);
typedef void (GL_BINDING_CALL *glDeleteQueriesARBProc)(GLsizei n, const GLuint* ids);
typedef void (GL_BINDING_CALL *glDeleteRenderbuffersEXTProc)(GLsizei n, const GLuint* renderbuffers);
typedef void (GL_BINDING_CALL *glDeleteShaderProc)(GLuint shader);
typedef void (GL_BINDING_CALL *glDeleteTexturesProc)(GLsizei n, const GLuint* textures);
typedef void (GL_BINDING_CALL *glDepthFuncProc)(GLenum func);
typedef void (GL_BINDING_CALL *glDepthMaskProc)(GLboolean flag);
typedef void (GL_BINDING_CALL *glDepthRangeProc)(GLclampd zNear, GLclampd zFar);
typedef void (GL_BINDING_CALL *glDepthRangefProc)(GLclampf zNear, GLclampf zFar);
typedef void (GL_BINDING_CALL *glDetachShaderProc)(GLuint program, GLuint shader);
typedef void (GL_BINDING_CALL *glDisableProc)(GLenum cap);
typedef void (GL_BINDING_CALL *glDisableVertexAttribArrayProc)(GLuint index);
typedef void (GL_BINDING_CALL *glDrawArraysProc)(GLenum mode, GLint first, GLsizei count);
typedef void (GL_BINDING_CALL *glDrawBufferProc)(GLenum mode);
typedef void (GL_BINDING_CALL *glDrawBuffersARBProc)(GLsizei n, const GLenum* bufs);
typedef void (GL_BINDING_CALL *glDrawElementsProc)(GLenum mode, GLsizei count, GLenum type, const void* indices);
typedef void (GL_BINDING_CALL *glEGLImageTargetTexture2DOESProc)(GLenum target, GLeglImageOES image);
typedef void (GL_BINDING_CALL *glEGLImageTargetRenderbufferStorageOESProc)(GLenum target, GLeglImageOES image);
typedef void (GL_BINDING_CALL *glEnableProc)(GLenum cap);
typedef void (GL_BINDING_CALL *glEnableVertexAttribArrayProc)(GLuint index);
typedef void (GL_BINDING_CALL *glEndQueryProc)(GLenum target);
typedef void (GL_BINDING_CALL *glEndQueryARBProc)(GLenum target);
typedef void (GL_BINDING_CALL *glFinishProc)(void);
typedef void (GL_BINDING_CALL *glFlushProc)(void);
typedef void (GL_BINDING_CALL *glFramebufferRenderbufferEXTProc)(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer);
typedef void (GL_BINDING_CALL *glFramebufferTexture2DEXTProc)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
typedef void (GL_BINDING_CALL *glFramebufferTexture2DMultisampleEXTProc)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLsizei samples);
typedef void (GL_BINDING_CALL *glFramebufferTexture2DMultisampleIMGProc)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLsizei samples);
typedef void (GL_BINDING_CALL *glFrontFaceProc)(GLenum mode);
typedef void (GL_BINDING_CALL *glGenBuffersARBProc)(GLsizei n, GLuint* buffers);
typedef void (GL_BINDING_CALL *glGenQueriesProc)(GLsizei n, GLuint* ids);
typedef void (GL_BINDING_CALL *glGenQueriesARBProc)(GLsizei n, GLuint* ids);
typedef void (GL_BINDING_CALL *glGenerateMipmapEXTProc)(GLenum target);
typedef void (GL_BINDING_CALL *glGenFramebuffersEXTProc)(GLsizei n, GLuint* framebuffers);
typedef void (GL_BINDING_CALL *glGenRenderbuffersEXTProc)(GLsizei n, GLuint* renderbuffers);
typedef void (GL_BINDING_CALL *glGenTexturesProc)(GLsizei n, GLuint* textures);
typedef void (GL_BINDING_CALL *glGetActiveAttribProc)(GLuint program, GLuint index, GLsizei bufsize, GLsizei* length, GLint* size, GLenum* type, char* name);
typedef void (GL_BINDING_CALL *glGetActiveUniformProc)(GLuint program, GLuint index, GLsizei bufsize, GLsizei* length, GLint* size, GLenum* type, char* name);
typedef void (GL_BINDING_CALL *glGetAttachedShadersProc)(GLuint program, GLsizei maxcount, GLsizei* count, GLuint* shaders);
typedef GLint (GL_BINDING_CALL *glGetAttribLocationProc)(GLuint program, const char* name);
typedef void (GL_BINDING_CALL *glGetBooleanvProc)(GLenum pname, GLboolean* params);
typedef void (GL_BINDING_CALL *glGetBufferParameterivProc)(GLenum target, GLenum pname, GLint* params);
typedef GLenum (GL_BINDING_CALL *glGetErrorProc)(void);
typedef void (GL_BINDING_CALL *glGetFloatvProc)(GLenum pname, GLfloat* params);
typedef void (GL_BINDING_CALL *glGetFramebufferAttachmentParameterivEXTProc)(GLenum target, GLenum attachment, GLenum pname, GLint* params);
typedef GLenum (GL_BINDING_CALL *glGetGraphicsResetStatusARBProc)(void);
typedef void (GL_BINDING_CALL *glGetIntegervProc)(GLenum pname, GLint* params);
typedef void (GL_BINDING_CALL *glGetProgramBinaryProc)(GLuint program, GLsizei bufSize, GLsizei* length, GLenum* binaryFormat, GLvoid* binary);
typedef void (GL_BINDING_CALL *glGetProgramivProc)(GLuint program, GLenum pname, GLint* params);
typedef void (GL_BINDING_CALL *glGetProgramInfoLogProc)(GLuint program, GLsizei bufsize, GLsizei* length, char* infolog);
typedef void (GL_BINDING_CALL *glGetQueryivProc)(GLenum target, GLenum pname, GLint* params);
typedef void (GL_BINDING_CALL *glGetQueryivARBProc)(GLenum target, GLenum pname, GLint* params);
typedef void (GL_BINDING_CALL *glGetQueryObjecti64vProc)(GLuint id, GLenum pname, GLint64* params);
typedef void (GL_BINDING_CALL *glGetQueryObjectivProc)(GLuint id, GLenum pname, GLint* params);
typedef void (GL_BINDING_CALL *glGetQueryObjectui64vProc)(GLuint id, GLenum pname, GLuint64* params);
typedef void (GL_BINDING_CALL *glGetQueryObjectuivProc)(GLuint id, GLenum pname, GLuint* params);
typedef void (GL_BINDING_CALL *glGetQueryObjectuivARBProc)(GLuint id, GLenum pname, GLuint* params);
typedef void (GL_BINDING_CALL *glGetRenderbufferParameterivEXTProc)(GLenum target, GLenum pname, GLint* params);
typedef void (GL_BINDING_CALL *glGetShaderivProc)(GLuint shader, GLenum pname, GLint* params);
typedef void (GL_BINDING_CALL *glGetShaderInfoLogProc)(GLuint shader, GLsizei bufsize, GLsizei* length, char* infolog);
typedef void (GL_BINDING_CALL *glGetShaderPrecisionFormatProc)(GLenum shadertype, GLenum precisiontype, GLint* range, GLint* precision);
typedef void (GL_BINDING_CALL *glGetShaderSourceProc)(GLuint shader, GLsizei bufsize, GLsizei* length, char* source);
typedef const GLubyte* (GL_BINDING_CALL *glGetStringProc)(GLenum name);
typedef void (GL_BINDING_CALL *glGetTexLevelParameterfvProc)(GLenum target, GLint level, GLenum pname, GLfloat* params);
typedef void (GL_BINDING_CALL *glGetTexLevelParameterivProc)(GLenum target, GLint level, GLenum pname, GLint* params);
typedef void (GL_BINDING_CALL *glGetTexParameterfvProc)(GLenum target, GLenum pname, GLfloat* params);
typedef void (GL_BINDING_CALL *glGetTexParameterivProc)(GLenum target, GLenum pname, GLint* params);
typedef void (GL_BINDING_CALL *glGetTranslatedShaderSourceANGLEProc)(GLuint shader, GLsizei bufsize, GLsizei* length, char* source);
typedef void (GL_BINDING_CALL *glGetUniformfvProc)(GLuint program, GLint location, GLfloat* params);
typedef void (GL_BINDING_CALL *glGetUniformivProc)(GLuint program, GLint location, GLint* params);
typedef GLint (GL_BINDING_CALL *glGetUniformLocationProc)(GLuint program, const char* name);
typedef void (GL_BINDING_CALL *glGetVertexAttribfvProc)(GLuint index, GLenum pname, GLfloat* params);
typedef void (GL_BINDING_CALL *glGetVertexAttribivProc)(GLuint index, GLenum pname, GLint* params);
typedef void (GL_BINDING_CALL *glGetVertexAttribPointervProc)(GLuint index, GLenum pname, void** pointer);
typedef void (GL_BINDING_CALL *glHintProc)(GLenum target, GLenum mode);
typedef void (GL_BINDING_CALL *glInsertEventMarkerEXTProc)(GLsizei length, const char* marker);
typedef GLboolean (GL_BINDING_CALL *glIsBufferProc)(GLuint buffer);
typedef GLboolean (GL_BINDING_CALL *glIsEnabledProc)(GLenum cap);
typedef GLboolean (GL_BINDING_CALL *glIsFramebufferEXTProc)(GLuint framebuffer);
typedef GLboolean (GL_BINDING_CALL *glIsProgramProc)(GLuint program);
typedef GLboolean (GL_BINDING_CALL *glIsQueryARBProc)(GLuint query);
typedef GLboolean (GL_BINDING_CALL *glIsRenderbufferEXTProc)(GLuint renderbuffer);
typedef GLboolean (GL_BINDING_CALL *glIsShaderProc)(GLuint shader);
typedef GLboolean (GL_BINDING_CALL *glIsTextureProc)(GLuint texture);
typedef void (GL_BINDING_CALL *glLineWidthProc)(GLfloat width);
typedef void (GL_BINDING_CALL *glLinkProgramProc)(GLuint program);
typedef void* (GL_BINDING_CALL *glMapBufferProc)(GLenum target, GLenum access);
typedef void* (GL_BINDING_CALL *glMapBufferRangeProc)(GLenum target, GLintptr offset, GLsizeiptr length, GLenum access);
typedef void (GL_BINDING_CALL *glFlushMappedBufferRangeProc)(GLenum target, GLintptr offset, GLsizeiptr length);
typedef void (GL_BINDING_CALL *glPixelStoreiProc)(GLenum pname, GLint param);
typedef void (GL_BINDING_CALL *glPointParameteriProc)(GLenum pname, GLint param);
typedef void (GL_BINDING_CALL *glPolygonOffsetProc)(GLfloat factor, GLfloat units);
typedef void (GL_BINDING_CALL *glPopGroupMarkerEXTProc)(void);
typedef void (GL_BINDING_CALL *glProgramBinaryProc)(GLuint program, GLenum binaryFormat, const GLvoid* binary, GLsizei length);
typedef void (GL_BINDING_CALL *glProgramParameteriProc)(GLuint program, GLenum pname, GLint value);
typedef void (GL_BINDING_CALL *glPushGroupMarkerEXTProc)(GLsizei length, const char* marker);
typedef void (GL_BINDING_CALL *glQueryCounterProc)(GLuint id, GLenum target);
typedef void (GL_BINDING_CALL *glReadBufferProc)(GLenum src);
typedef void (GL_BINDING_CALL *glReadPixelsProc)(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, void* pixels);
typedef void (GL_BINDING_CALL *glReleaseShaderCompilerProc)(void);
typedef void (GL_BINDING_CALL *glRenderbufferStorageMultisampleProc)(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);
typedef void (GL_BINDING_CALL *glRenderbufferStorageMultisampleEXTProc)(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);
typedef void (GL_BINDING_CALL *glRenderbufferStorageMultisampleANGLEProc)(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);
typedef void (GL_BINDING_CALL *glRenderbufferStorageMultisampleIMGProc)(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);
typedef void (GL_BINDING_CALL *glRenderbufferStorageEXTProc)(GLenum target, GLenum internalformat, GLsizei width, GLsizei height);
typedef void (GL_BINDING_CALL *glSampleCoverageProc)(GLclampf value, GLboolean invert);
typedef void (GL_BINDING_CALL *glScissorProc)(GLint x, GLint y, GLsizei width, GLsizei height);
typedef void (GL_BINDING_CALL *glShaderBinaryProc)(GLsizei n, const GLuint* shaders, GLenum binaryformat, const void* binary, GLsizei length);
typedef void (GL_BINDING_CALL *glShaderSourceProc)(GLuint shader, GLsizei count, const char* const* str, const GLint* length);
typedef void (GL_BINDING_CALL *glStencilFuncProc)(GLenum func, GLint ref, GLuint mask);
typedef void (GL_BINDING_CALL *glStencilFuncSeparateProc)(GLenum face, GLenum func, GLint ref, GLuint mask);
typedef void (GL_BINDING_CALL *glStencilMaskProc)(GLuint mask);
typedef void (GL_BINDING_CALL *glStencilMaskSeparateProc)(GLenum face, GLuint mask);
typedef void (GL_BINDING_CALL *glStencilOpProc)(GLenum fail, GLenum zfail, GLenum zpass);
typedef void (GL_BINDING_CALL *glStencilOpSeparateProc)(GLenum face, GLenum fail, GLenum zfail, GLenum zpass);
typedef void (GL_BINDING_CALL *glTexImage2DProc)(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const void* pixels);
typedef void (GL_BINDING_CALL *glTexParameterfProc)(GLenum target, GLenum pname, GLfloat param);
typedef void (GL_BINDING_CALL *glTexParameterfvProc)(GLenum target, GLenum pname, const GLfloat* params);
typedef void (GL_BINDING_CALL *glTexParameteriProc)(GLenum target, GLenum pname, GLint param);
typedef void (GL_BINDING_CALL *glTexParameterivProc)(GLenum target, GLenum pname, const GLint* params);
typedef void (GL_BINDING_CALL *glTexStorage2DEXTProc)(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height);
typedef void (GL_BINDING_CALL *glTexSubImage2DProc)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void* pixels);
typedef void (GL_BINDING_CALL *glUniform1fProc)(GLint location, GLfloat x);
typedef void (GL_BINDING_CALL *glUniform1fvProc)(GLint location, GLsizei count, const GLfloat* v);
typedef void (GL_BINDING_CALL *glUniform1iProc)(GLint location, GLint x);
typedef void (GL_BINDING_CALL *glUniform1ivProc)(GLint location, GLsizei count, const GLint* v);
typedef void (GL_BINDING_CALL *glUniform2fProc)(GLint location, GLfloat x, GLfloat y);
typedef void (GL_BINDING_CALL *glUniform2fvProc)(GLint location, GLsizei count, const GLfloat* v);
typedef void (GL_BINDING_CALL *glUniform2iProc)(GLint location, GLint x, GLint y);
typedef void (GL_BINDING_CALL *glUniform2ivProc)(GLint location, GLsizei count, const GLint* v);
typedef void (GL_BINDING_CALL *glUniform3fProc)(GLint location, GLfloat x, GLfloat y, GLfloat z);
typedef void (GL_BINDING_CALL *glUniform3fvProc)(GLint location, GLsizei count, const GLfloat* v);
typedef void (GL_BINDING_CALL *glUniform3iProc)(GLint location, GLint x, GLint y, GLint z);
typedef void (GL_BINDING_CALL *glUniform3ivProc)(GLint location, GLsizei count, const GLint* v);
typedef void (GL_BINDING_CALL *glUniform4fProc)(GLint location, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
typedef void (GL_BINDING_CALL *glUniform4fvProc)(GLint location, GLsizei count, const GLfloat* v);
typedef void (GL_BINDING_CALL *glUniform4iProc)(GLint location, GLint x, GLint y, GLint z, GLint w);
typedef void (GL_BINDING_CALL *glUniform4ivProc)(GLint location, GLsizei count, const GLint* v);
typedef void (GL_BINDING_CALL *glUniformMatrix2fvProc)(GLint location, GLsizei count, GLboolean transpose, const GLfloat* value);
typedef void (GL_BINDING_CALL *glUniformMatrix3fvProc)(GLint location, GLsizei count, GLboolean transpose, const GLfloat* value);
typedef void (GL_BINDING_CALL *glUniformMatrix4fvProc)(GLint location, GLsizei count, GLboolean transpose, const GLfloat* value);
typedef GLboolean (GL_BINDING_CALL *glUnmapBufferProc)(GLenum target);
typedef void (GL_BINDING_CALL *glUseProgramProc)(GLuint program);
typedef void (GL_BINDING_CALL *glValidateProgramProc)(GLuint program);
typedef void (GL_BINDING_CALL *glVertexAttrib1fProc)(GLuint indx, GLfloat x);
typedef void (GL_BINDING_CALL *glVertexAttrib1fvProc)(GLuint indx, const GLfloat* values);
typedef void (GL_BINDING_CALL *glVertexAttrib2fProc)(GLuint indx, GLfloat x, GLfloat y);
typedef void (GL_BINDING_CALL *glVertexAttrib2fvProc)(GLuint indx, const GLfloat* values);
typedef void (GL_BINDING_CALL *glVertexAttrib3fProc)(GLuint indx, GLfloat x, GLfloat y, GLfloat z);
typedef void (GL_BINDING_CALL *glVertexAttrib3fvProc)(GLuint indx, const GLfloat* values);
typedef void (GL_BINDING_CALL *glVertexAttrib4fProc)(GLuint indx, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
typedef void (GL_BINDING_CALL *glVertexAttrib4fvProc)(GLuint indx, const GLfloat* values);
typedef void (GL_BINDING_CALL *glVertexAttribPointerProc)(GLuint indx, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const void* ptr);
typedef void (GL_BINDING_CALL *glViewportProc)(GLint x, GLint y, GLsizei width, GLsizei height);
typedef void (GL_BINDING_CALL *glGenFencesNVProc)(GLsizei n, GLuint* fences);
typedef void (GL_BINDING_CALL *glDeleteFencesNVProc)(GLsizei n, const GLuint* fences);
typedef void (GL_BINDING_CALL *glSetFenceNVProc)(GLuint fence, GLenum condition);
typedef GLboolean (GL_BINDING_CALL *glTestFenceNVProc)(GLuint fence);
typedef void (GL_BINDING_CALL *glFinishFenceNVProc)(GLuint fence);
typedef GLboolean (GL_BINDING_CALL *glIsFenceNVProc)(GLuint fence);
typedef void (GL_BINDING_CALL *glGetFenceivNVProc)(GLuint fence, GLenum pname, GLint* params);
typedef GLsync (GL_BINDING_CALL *glFenceSyncProc)(GLenum condition, GLbitfield flags);
typedef void (GL_BINDING_CALL *glDeleteSyncProc)(GLsync sync);
typedef void (GL_BINDING_CALL *glGetSyncivProc)(GLsync sync, GLenum pname, GLsizei bufSize, GLsizei* length,GLint* values);
typedef GLenum (GL_BINDING_CALL *glClientWaitSyncProc)(GLsync sync, GLbitfield flags, GLuint64 timeout);
typedef GLenum (GL_BINDING_CALL *glWaitSyncProc)(GLsync sync, GLbitfield flags, GLuint64 timeout);
typedef void (GL_BINDING_CALL *glDrawArraysInstancedANGLEProc)(GLenum mode, GLint first, GLsizei count, GLsizei primcount);
typedef void (GL_BINDING_CALL *glDrawElementsInstancedANGLEProc)(GLenum mode, GLsizei count, GLenum type, const void* indices, GLsizei primcount);
typedef void (GL_BINDING_CALL *glVertexAttribDivisorANGLEProc)(GLuint index, GLuint divisor);
typedef void (GL_BINDING_CALL *glGenVertexArraysOESProc)(GLsizei n, GLuint* arrays);
typedef void (GL_BINDING_CALL *glDeleteVertexArraysOESProc)(GLsizei n, const GLuint* arrays);
typedef void (GL_BINDING_CALL *glBindVertexArrayOESProc)(GLuint array);
typedef GLboolean (GL_BINDING_CALL *glIsVertexArrayOESProc)(GLuint array);
typedef void (GL_BINDING_CALL *glDiscardFramebufferEXTProc)(GLenum target, GLsizei numAttachments, const GLenum* attachments);

struct ExtensionsGL {
  bool b_GL_ANGLE_framebuffer_blit;
  bool b_GL_ANGLE_framebuffer_multisample;
  bool b_GL_ANGLE_instanced_arrays;
  bool b_GL_ANGLE_translated_shader_source;
  bool b_GL_APPLE_vertex_array_object;
  bool b_GL_ARB_ES2_compatibility;
  bool b_GL_ARB_blend_func_extended;
  bool b_GL_ARB_draw_buffers;
  bool b_GL_ARB_draw_instanced;
  bool b_GL_ARB_framebuffer_object;
  bool b_GL_ARB_get_program_binary;
  bool b_GL_ARB_instanced_arrays;
  bool b_GL_ARB_map_buffer_range;
  bool b_GL_ARB_occlusion_query;
  bool b_GL_ARB_robustness;
  bool b_GL_ARB_sync;
  bool b_GL_ARB_timer_query;
  bool b_GL_ARB_vertex_array_object;
  bool b_GL_ARB_vertex_buffer_object;
  bool b_GL_EXT_debug_marker;
  bool b_GL_EXT_discard_framebuffer;
  bool b_GL_EXT_disjoint_timer_query;
  bool b_GL_EXT_draw_buffers;
  bool b_GL_EXT_framebuffer_blit;
  bool b_GL_EXT_framebuffer_multisample;
  bool b_GL_EXT_framebuffer_object;
  bool b_GL_EXT_multisampled_render_to_texture;
  bool b_GL_EXT_robustness;
  bool b_GL_EXT_texture_storage;
  bool b_GL_IMG_multisampled_render_to_texture;
  bool b_GL_NV_fence;
  bool b_GL_OES_EGL_image;
  bool b_GL_OES_get_program_binary;
  bool b_GL_OES_mapbuffer;
  bool b_GL_OES_vertex_array_object;
};

struct ProcsGL {
  glActiveTextureProc glActiveTextureFn;
  glAttachShaderProc glAttachShaderFn;
  glBeginQueryProc glBeginQueryFn;
  glBeginQueryARBProc glBeginQueryARBFn;
  glBindAttribLocationProc glBindAttribLocationFn;
  glBindBufferProc glBindBufferFn;
  glBindFragDataLocationProc glBindFragDataLocationFn;
  glBindFragDataLocationIndexedProc glBindFragDataLocationIndexedFn;
  glBindFramebufferEXTProc glBindFramebufferEXTFn;
  glBindRenderbufferEXTProc glBindRenderbufferEXTFn;
  glBindTextureProc glBindTextureFn;
  glBlendColorProc glBlendColorFn;
  glBlendEquationProc glBlendEquationFn;
  glBlendEquationSeparateProc glBlendEquationSeparateFn;
  glBlendFuncProc glBlendFuncFn;
  glBlendFuncSeparateProc glBlendFuncSeparateFn;
  glBlitFramebufferProc glBlitFramebufferFn;
  glBlitFramebufferEXTProc glBlitFramebufferEXTFn;
  glBlitFramebufferANGLEProc glBlitFramebufferANGLEFn;
  glBufferDataProc glBufferDataFn;
  glBufferSubDataProc glBufferSubDataFn;
  glCheckFramebufferStatusEXTProc glCheckFramebufferStatusEXTFn;
  glClearProc glClearFn;
  glClearColorProc glClearColorFn;
  glClearDepthProc glClearDepthFn;
  glClearDepthfProc glClearDepthfFn;
  glClearStencilProc glClearStencilFn;
  glColorMaskProc glColorMaskFn;
  glCompileShaderProc glCompileShaderFn;
  glCompressedTexImage2DProc glCompressedTexImage2DFn;
  glCompressedTexSubImage2DProc glCompressedTexSubImage2DFn;
  glCopyTexImage2DProc glCopyTexImage2DFn;
  glCopyTexSubImage2DProc glCopyTexSubImage2DFn;
  glCreateProgramProc glCreateProgramFn;
  glCreateShaderProc glCreateShaderFn;
  glCullFaceProc glCullFaceFn;
  glDeleteBuffersARBProc glDeleteBuffersARBFn;
  glDeleteFramebuffersEXTProc glDeleteFramebuffersEXTFn;
  glDeleteProgramProc glDeleteProgramFn;
  glDeleteQueriesProc glDeleteQueriesFn;
  glDeleteQueriesARBProc glDeleteQueriesARBFn;
  glDeleteRenderbuffersEXTProc glDeleteRenderbuffersEXTFn;
  glDeleteShaderProc glDeleteShaderFn;
  glDeleteTexturesProc glDeleteTexturesFn;
  glDepthFuncProc glDepthFuncFn;
  glDepthMaskProc glDepthMaskFn;
  glDepthRangeProc glDepthRangeFn;
  glDepthRangefProc glDepthRangefFn;
  glDetachShaderProc glDetachShaderFn;
  glDisableProc glDisableFn;
  glDisableVertexAttribArrayProc glDisableVertexAttribArrayFn;
  glDrawArraysProc glDrawArraysFn;
  glDrawBufferProc glDrawBufferFn;
  glDrawBuffersARBProc glDrawBuffersARBFn;
  glDrawElementsProc glDrawElementsFn;
  glEGLImageTargetTexture2DOESProc glEGLImageTargetTexture2DOESFn;
  glEGLImageTargetRenderbufferStorageOESProc glEGLImageTargetRenderbufferStorageOESFn;
  glEnableProc glEnableFn;
  glEnableVertexAttribArrayProc glEnableVertexAttribArrayFn;
  glEndQueryProc glEndQueryFn;
  glEndQueryARBProc glEndQueryARBFn;
  glFinishProc glFinishFn;
  glFlushProc glFlushFn;
  glFramebufferRenderbufferEXTProc glFramebufferRenderbufferEXTFn;
  glFramebufferTexture2DEXTProc glFramebufferTexture2DEXTFn;
  glFramebufferTexture2DMultisampleEXTProc glFramebufferTexture2DMultisampleEXTFn;
  glFramebufferTexture2DMultisampleIMGProc glFramebufferTexture2DMultisampleIMGFn;
  glFrontFaceProc glFrontFaceFn;
  glGenBuffersARBProc glGenBuffersARBFn;
  glGenQueriesProc glGenQueriesFn;
  glGenQueriesARBProc glGenQueriesARBFn;
  glGenerateMipmapEXTProc glGenerateMipmapEXTFn;
  glGenFramebuffersEXTProc glGenFramebuffersEXTFn;
  glGenRenderbuffersEXTProc glGenRenderbuffersEXTFn;
  glGenTexturesProc glGenTexturesFn;
  glGetActiveAttribProc glGetActiveAttribFn;
  glGetActiveUniformProc glGetActiveUniformFn;
  glGetAttachedShadersProc glGetAttachedShadersFn;
  glGetAttribLocationProc glGetAttribLocationFn;
  glGetBooleanvProc glGetBooleanvFn;
  glGetBufferParameterivProc glGetBufferParameterivFn;
  glGetErrorProc glGetErrorFn;
  glGetFloatvProc glGetFloatvFn;
  glGetFramebufferAttachmentParameterivEXTProc glGetFramebufferAttachmentParameterivEXTFn;
  glGetGraphicsResetStatusARBProc glGetGraphicsResetStatusARBFn;
  glGetIntegervProc glGetIntegervFn;
  glGetProgramBinaryProc glGetProgramBinaryFn;
  glGetProgramivProc glGetProgramivFn;
  glGetProgramInfoLogProc glGetProgramInfoLogFn;
  glGetQueryivProc glGetQueryivFn;
  glGetQueryivARBProc glGetQueryivARBFn;
  glGetQueryObjecti64vProc glGetQueryObjecti64vFn;
  glGetQueryObjectivProc glGetQueryObjectivFn;
  glGetQueryObjectui64vProc glGetQueryObjectui64vFn;
  glGetQueryObjectuivProc glGetQueryObjectuivFn;
  glGetQueryObjectuivARBProc glGetQueryObjectuivARBFn;
  glGetRenderbufferParameterivEXTProc glGetRenderbufferParameterivEXTFn;
  glGetShaderivProc glGetShaderivFn;
  glGetShaderInfoLogProc glGetShaderInfoLogFn;
  glGetShaderPrecisionFormatProc glGetShaderPrecisionFormatFn;
  glGetShaderSourceProc glGetShaderSourceFn;
  glGetStringProc glGetStringFn;
  glGetTexLevelParameterfvProc glGetTexLevelParameterfvFn;
  glGetTexLevelParameterivProc glGetTexLevelParameterivFn;
  glGetTexParameterfvProc glGetTexParameterfvFn;
  glGetTexParameterivProc glGetTexParameterivFn;
  glGetTranslatedShaderSourceANGLEProc glGetTranslatedShaderSourceANGLEFn;
  glGetUniformfvProc glGetUniformfvFn;
  glGetUniformivProc glGetUniformivFn;
  glGetUniformLocationProc glGetUniformLocationFn;
  glGetVertexAttribfvProc glGetVertexAttribfvFn;
  glGetVertexAttribivProc glGetVertexAttribivFn;
  glGetVertexAttribPointervProc glGetVertexAttribPointervFn;
  glHintProc glHintFn;
  glInsertEventMarkerEXTProc glInsertEventMarkerEXTFn;
  glIsBufferProc glIsBufferFn;
  glIsEnabledProc glIsEnabledFn;
  glIsFramebufferEXTProc glIsFramebufferEXTFn;
  glIsProgramProc glIsProgramFn;
  glIsQueryARBProc glIsQueryARBFn;
  glIsRenderbufferEXTProc glIsRenderbufferEXTFn;
  glIsShaderProc glIsShaderFn;
  glIsTextureProc glIsTextureFn;
  glLineWidthProc glLineWidthFn;
  glLinkProgramProc glLinkProgramFn;
  glMapBufferProc glMapBufferFn;
  glMapBufferRangeProc glMapBufferRangeFn;
  glFlushMappedBufferRangeProc glFlushMappedBufferRangeFn;
  glPixelStoreiProc glPixelStoreiFn;
  glPointParameteriProc glPointParameteriFn;
  glPolygonOffsetProc glPolygonOffsetFn;
  glPopGroupMarkerEXTProc glPopGroupMarkerEXTFn;
  glProgramBinaryProc glProgramBinaryFn;
  glProgramParameteriProc glProgramParameteriFn;
  glPushGroupMarkerEXTProc glPushGroupMarkerEXTFn;
  glQueryCounterProc glQueryCounterFn;
  glReadBufferProc glReadBufferFn;
  glReadPixelsProc glReadPixelsFn;
  glReleaseShaderCompilerProc glReleaseShaderCompilerFn;
  glRenderbufferStorageMultisampleProc glRenderbufferStorageMultisampleFn;
  glRenderbufferStorageMultisampleEXTProc glRenderbufferStorageMultisampleEXTFn;
  glRenderbufferStorageMultisampleANGLEProc glRenderbufferStorageMultisampleANGLEFn;
  glRenderbufferStorageMultisampleIMGProc glRenderbufferStorageMultisampleIMGFn;
  glRenderbufferStorageEXTProc glRenderbufferStorageEXTFn;
  glSampleCoverageProc glSampleCoverageFn;
  glScissorProc glScissorFn;
  glShaderBinaryProc glShaderBinaryFn;
  glShaderSourceProc glShaderSourceFn;
  glStencilFuncProc glStencilFuncFn;
  glStencilFuncSeparateProc glStencilFuncSeparateFn;
  glStencilMaskProc glStencilMaskFn;
  glStencilMaskSeparateProc glStencilMaskSeparateFn;
  glStencilOpProc glStencilOpFn;
  glStencilOpSeparateProc glStencilOpSeparateFn;
  glTexImage2DProc glTexImage2DFn;
  glTexParameterfProc glTexParameterfFn;
  glTexParameterfvProc glTexParameterfvFn;
  glTexParameteriProc glTexParameteriFn;
  glTexParameterivProc glTexParameterivFn;
  glTexStorage2DEXTProc glTexStorage2DEXTFn;
  glTexSubImage2DProc glTexSubImage2DFn;
  glUniform1fProc glUniform1fFn;
  glUniform1fvProc glUniform1fvFn;
  glUniform1iProc glUniform1iFn;
  glUniform1ivProc glUniform1ivFn;
  glUniform2fProc glUniform2fFn;
  glUniform2fvProc glUniform2fvFn;
  glUniform2iProc glUniform2iFn;
  glUniform2ivProc glUniform2ivFn;
  glUniform3fProc glUniform3fFn;
  glUniform3fvProc glUniform3fvFn;
  glUniform3iProc glUniform3iFn;
  glUniform3ivProc glUniform3ivFn;
  glUniform4fProc glUniform4fFn;
  glUniform4fvProc glUniform4fvFn;
  glUniform4iProc glUniform4iFn;
  glUniform4ivProc glUniform4ivFn;
  glUniformMatrix2fvProc glUniformMatrix2fvFn;
  glUniformMatrix3fvProc glUniformMatrix3fvFn;
  glUniformMatrix4fvProc glUniformMatrix4fvFn;
  glUnmapBufferProc glUnmapBufferFn;
  glUseProgramProc glUseProgramFn;
  glValidateProgramProc glValidateProgramFn;
  glVertexAttrib1fProc glVertexAttrib1fFn;
  glVertexAttrib1fvProc glVertexAttrib1fvFn;
  glVertexAttrib2fProc glVertexAttrib2fFn;
  glVertexAttrib2fvProc glVertexAttrib2fvFn;
  glVertexAttrib3fProc glVertexAttrib3fFn;
  glVertexAttrib3fvProc glVertexAttrib3fvFn;
  glVertexAttrib4fProc glVertexAttrib4fFn;
  glVertexAttrib4fvProc glVertexAttrib4fvFn;
  glVertexAttribPointerProc glVertexAttribPointerFn;
  glViewportProc glViewportFn;
  glGenFencesNVProc glGenFencesNVFn;
  glDeleteFencesNVProc glDeleteFencesNVFn;
  glSetFenceNVProc glSetFenceNVFn;
  glTestFenceNVProc glTestFenceNVFn;
  glFinishFenceNVProc glFinishFenceNVFn;
  glIsFenceNVProc glIsFenceNVFn;
  glGetFenceivNVProc glGetFenceivNVFn;
  glFenceSyncProc glFenceSyncFn;
  glDeleteSyncProc glDeleteSyncFn;
  glGetSyncivProc glGetSyncivFn;
  glClientWaitSyncProc glClientWaitSyncFn;
  glWaitSyncProc glWaitSyncFn;
  glDrawArraysInstancedANGLEProc glDrawArraysInstancedANGLEFn;
  glDrawElementsInstancedANGLEProc glDrawElementsInstancedANGLEFn;
  glVertexAttribDivisorANGLEProc glVertexAttribDivisorANGLEFn;
  glGenVertexArraysOESProc glGenVertexArraysOESFn;
  glDeleteVertexArraysOESProc glDeleteVertexArraysOESFn;
  glBindVertexArrayOESProc glBindVertexArrayOESFn;
  glIsVertexArrayOESProc glIsVertexArrayOESFn;
  glDiscardFramebufferEXTProc glDiscardFramebufferEXTFn;
};

class GL_EXPORT GLApi {
 public:
  GLApi();
  virtual ~GLApi();

  virtual void glActiveTextureFn(GLenum texture) = 0;
  virtual void glAttachShaderFn(GLuint program, GLuint shader) = 0;
  virtual void glBeginQueryFn(GLenum target, GLuint id) = 0;
  virtual void glBeginQueryARBFn(GLenum target, GLuint id) = 0;
  virtual void glBindAttribLocationFn(GLuint program, GLuint index, const char* name) = 0;
  virtual void glBindBufferFn(GLenum target, GLuint buffer) = 0;
  virtual void glBindFragDataLocationFn(GLuint program, GLuint colorNumber, const char* name) = 0;
  virtual void glBindFragDataLocationIndexedFn(GLuint program, GLuint colorNumber, GLuint index, const char* name) = 0;
  virtual void glBindFramebufferEXTFn(GLenum target, GLuint framebuffer) = 0;
  virtual void glBindRenderbufferEXTFn(GLenum target, GLuint renderbuffer) = 0;
  virtual void glBindTextureFn(GLenum target, GLuint texture) = 0;
  virtual void glBlendColorFn(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha) = 0;
  virtual void glBlendEquationFn( GLenum mode ) = 0;
  virtual void glBlendEquationSeparateFn(GLenum modeRGB, GLenum modeAlpha) = 0;
  virtual void glBlendFuncFn(GLenum sfactor, GLenum dfactor) = 0;
  virtual void glBlendFuncSeparateFn(GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha) = 0;
  virtual void glBlitFramebufferFn(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter) = 0;
  virtual void glBlitFramebufferEXTFn(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter) = 0;
  virtual void glBlitFramebufferANGLEFn(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter) = 0;
  virtual void glBufferDataFn(GLenum target, GLsizeiptr size, const void* data, GLenum usage) = 0;
  virtual void glBufferSubDataFn(GLenum target, GLintptr offset, GLsizeiptr size, const void* data) = 0;
  virtual GLenum glCheckFramebufferStatusEXTFn(GLenum target) = 0;
  virtual void glClearFn(GLbitfield mask) = 0;
  virtual void glClearColorFn(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha) = 0;
  virtual void glClearDepthFn(GLclampd depth) = 0;
  virtual void glClearDepthfFn(GLclampf depth) = 0;
  virtual void glClearStencilFn(GLint s) = 0;
  virtual void glColorMaskFn(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha) = 0;
  virtual void glCompileShaderFn(GLuint shader) = 0;
  virtual void glCompressedTexImage2DFn(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void* data) = 0;
  virtual void glCompressedTexSubImage2DFn(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void* data) = 0;
  virtual void glCopyTexImage2DFn(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border) = 0;
  virtual void glCopyTexSubImage2DFn(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height) = 0;
  virtual GLuint glCreateProgramFn(void) = 0;
  virtual GLuint glCreateShaderFn(GLenum type) = 0;
  virtual void glCullFaceFn(GLenum mode) = 0;
  virtual void glDeleteBuffersARBFn(GLsizei n, const GLuint* buffers) = 0;
  virtual void glDeleteFramebuffersEXTFn(GLsizei n, const GLuint* framebuffers) = 0;
  virtual void glDeleteProgramFn(GLuint program) = 0;
  virtual void glDeleteQueriesFn(GLsizei n, const GLuint* ids) = 0;
  virtual void glDeleteQueriesARBFn(GLsizei n, const GLuint* ids) = 0;
  virtual void glDeleteRenderbuffersEXTFn(GLsizei n, const GLuint* renderbuffers) = 0;
  virtual void glDeleteShaderFn(GLuint shader) = 0;
  virtual void glDeleteTexturesFn(GLsizei n, const GLuint* textures) = 0;
  virtual void glDepthFuncFn(GLenum func) = 0;
  virtual void glDepthMaskFn(GLboolean flag) = 0;
  virtual void glDepthRangeFn(GLclampd zNear, GLclampd zFar) = 0;
  virtual void glDepthRangefFn(GLclampf zNear, GLclampf zFar) = 0;
  virtual void glDetachShaderFn(GLuint program, GLuint shader) = 0;
  virtual void glDisableFn(GLenum cap) = 0;
  virtual void glDisableVertexAttribArrayFn(GLuint index) = 0;
  virtual void glDrawArraysFn(GLenum mode, GLint first, GLsizei count) = 0;
  virtual void glDrawBufferFn(GLenum mode) = 0;
  virtual void glDrawBuffersARBFn(GLsizei n, const GLenum* bufs) = 0;
  virtual void glDrawElementsFn(GLenum mode, GLsizei count, GLenum type, const void* indices) = 0;
  virtual void glEGLImageTargetTexture2DOESFn(GLenum target, GLeglImageOES image) = 0;
  virtual void glEGLImageTargetRenderbufferStorageOESFn(GLenum target, GLeglImageOES image) = 0;
  virtual void glEnableFn(GLenum cap) = 0;
  virtual void glEnableVertexAttribArrayFn(GLuint index) = 0;
  virtual void glEndQueryFn(GLenum target) = 0;
  virtual void glEndQueryARBFn(GLenum target) = 0;
  virtual void glFinishFn(void) = 0;
  virtual void glFlushFn(void) = 0;
  virtual void glFramebufferRenderbufferEXTFn(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer) = 0;
  virtual void glFramebufferTexture2DEXTFn(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level) = 0;
  virtual void glFramebufferTexture2DMultisampleEXTFn(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLsizei samples) = 0;
  virtual void glFramebufferTexture2DMultisampleIMGFn(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLsizei samples) = 0;
  virtual void glFrontFaceFn(GLenum mode) = 0;
  virtual void glGenBuffersARBFn(GLsizei n, GLuint* buffers) = 0;
  virtual void glGenQueriesFn(GLsizei n, GLuint* ids) = 0;
  virtual void glGenQueriesARBFn(GLsizei n, GLuint* ids) = 0;
  virtual void glGenerateMipmapEXTFn(GLenum target) = 0;
  virtual void glGenFramebuffersEXTFn(GLsizei n, GLuint* framebuffers) = 0;
  virtual void glGenRenderbuffersEXTFn(GLsizei n, GLuint* renderbuffers) = 0;
  virtual void glGenTexturesFn(GLsizei n, GLuint* textures) = 0;
  virtual void glGetActiveAttribFn(GLuint program, GLuint index, GLsizei bufsize, GLsizei* length, GLint* size, GLenum* type, char* name) = 0;
  virtual void glGetActiveUniformFn(GLuint program, GLuint index, GLsizei bufsize, GLsizei* length, GLint* size, GLenum* type, char* name) = 0;
  virtual void glGetAttachedShadersFn(GLuint program, GLsizei maxcount, GLsizei* count, GLuint* shaders) = 0;
  virtual GLint glGetAttribLocationFn(GLuint program, const char* name) = 0;
  virtual void glGetBooleanvFn(GLenum pname, GLboolean* params) = 0;
  virtual void glGetBufferParameterivFn(GLenum target, GLenum pname, GLint* params) = 0;
  virtual GLenum glGetErrorFn(void) = 0;
  virtual void glGetFloatvFn(GLenum pname, GLfloat* params) = 0;
  virtual void glGetFramebufferAttachmentParameterivEXTFn(GLenum target, GLenum attachment, GLenum pname, GLint* params) = 0;
  virtual GLenum glGetGraphicsResetStatusARBFn(void) = 0;
  virtual void glGetIntegervFn(GLenum pname, GLint* params) = 0;
  virtual void glGetProgramBinaryFn(GLuint program, GLsizei bufSize, GLsizei* length, GLenum* binaryFormat, GLvoid* binary) = 0;
  virtual void glGetProgramivFn(GLuint program, GLenum pname, GLint* params) = 0;
  virtual void glGetProgramInfoLogFn(GLuint program, GLsizei bufsize, GLsizei* length, char* infolog) = 0;
  virtual void glGetQueryivFn(GLenum target, GLenum pname, GLint* params) = 0;
  virtual void glGetQueryivARBFn(GLenum target, GLenum pname, GLint* params) = 0;
  virtual void glGetQueryObjecti64vFn(GLuint id, GLenum pname, GLint64* params) = 0;
  virtual void glGetQueryObjectivFn(GLuint id, GLenum pname, GLint* params) = 0;
  virtual void glGetQueryObjectui64vFn(GLuint id, GLenum pname, GLuint64* params) = 0;
  virtual void glGetQueryObjectuivFn(GLuint id, GLenum pname, GLuint* params) = 0;
  virtual void glGetQueryObjectuivARBFn(GLuint id, GLenum pname, GLuint* params) = 0;
  virtual void glGetRenderbufferParameterivEXTFn(GLenum target, GLenum pname, GLint* params) = 0;
  virtual void glGetShaderivFn(GLuint shader, GLenum pname, GLint* params) = 0;
  virtual void glGetShaderInfoLogFn(GLuint shader, GLsizei bufsize, GLsizei* length, char* infolog) = 0;
  virtual void glGetShaderPrecisionFormatFn(GLenum shadertype, GLenum precisiontype, GLint* range, GLint* precision) = 0;
  virtual void glGetShaderSourceFn(GLuint shader, GLsizei bufsize, GLsizei* length, char* source) = 0;
  virtual const GLubyte* glGetStringFn(GLenum name) = 0;
  virtual void glGetTexLevelParameterfvFn(GLenum target, GLint level, GLenum pname, GLfloat* params) = 0;
  virtual void glGetTexLevelParameterivFn(GLenum target, GLint level, GLenum pname, GLint* params) = 0;
  virtual void glGetTexParameterfvFn(GLenum target, GLenum pname, GLfloat* params) = 0;
  virtual void glGetTexParameterivFn(GLenum target, GLenum pname, GLint* params) = 0;
  virtual void glGetTranslatedShaderSourceANGLEFn(GLuint shader, GLsizei bufsize, GLsizei* length, char* source) = 0;
  virtual void glGetUniformfvFn(GLuint program, GLint location, GLfloat* params) = 0;
  virtual void glGetUniformivFn(GLuint program, GLint location, GLint* params) = 0;
  virtual GLint glGetUniformLocationFn(GLuint program, const char* name) = 0;
  virtual void glGetVertexAttribfvFn(GLuint index, GLenum pname, GLfloat* params) = 0;
  virtual void glGetVertexAttribivFn(GLuint index, GLenum pname, GLint* params) = 0;
  virtual void glGetVertexAttribPointervFn(GLuint index, GLenum pname, void** pointer) = 0;
  virtual void glHintFn(GLenum target, GLenum mode) = 0;
  virtual void glInsertEventMarkerEXTFn(GLsizei length, const char* marker) = 0;
  virtual GLboolean glIsBufferFn(GLuint buffer) = 0;
  virtual GLboolean glIsEnabledFn(GLenum cap) = 0;
  virtual GLboolean glIsFramebufferEXTFn(GLuint framebuffer) = 0;
  virtual GLboolean glIsProgramFn(GLuint program) = 0;
  virtual GLboolean glIsQueryARBFn(GLuint query) = 0;
  virtual GLboolean glIsRenderbufferEXTFn(GLuint renderbuffer) = 0;
  virtual GLboolean glIsShaderFn(GLuint shader) = 0;
  virtual GLboolean glIsTextureFn(GLuint texture) = 0;
  virtual void glLineWidthFn(GLfloat width) = 0;
  virtual void glLinkProgramFn(GLuint program) = 0;
  virtual void* glMapBufferFn(GLenum target, GLenum access) = 0;
  virtual void* glMapBufferRangeFn(GLenum target, GLintptr offset, GLsizeiptr length, GLenum access) = 0;
  virtual void glFlushMappedBufferRangeFn(GLenum target, GLintptr offset, GLsizeiptr length) = 0;
  virtual void glPixelStoreiFn(GLenum pname, GLint param) = 0;
  virtual void glPointParameteriFn(GLenum pname, GLint param) = 0;
  virtual void glPolygonOffsetFn(GLfloat factor, GLfloat units) = 0;
  virtual void glPopGroupMarkerEXTFn(void) = 0;
  virtual void glProgramBinaryFn(GLuint program, GLenum binaryFormat, const GLvoid* binary, GLsizei length) = 0;
  virtual void glProgramParameteriFn(GLuint program, GLenum pname, GLint value) = 0;
  virtual void glPushGroupMarkerEXTFn(GLsizei length, const char* marker) = 0;
  virtual void glQueryCounterFn(GLuint id, GLenum target) = 0;
  virtual void glReadBufferFn(GLenum src) = 0;
  virtual void glReadPixelsFn(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, void* pixels) = 0;
  virtual void glReleaseShaderCompilerFn(void) = 0;
  virtual void glRenderbufferStorageMultisampleFn(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height) = 0;
  virtual void glRenderbufferStorageMultisampleEXTFn(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height) = 0;
  virtual void glRenderbufferStorageMultisampleANGLEFn(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height) = 0;
  virtual void glRenderbufferStorageMultisampleIMGFn(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height) = 0;
  virtual void glRenderbufferStorageEXTFn(GLenum target, GLenum internalformat, GLsizei width, GLsizei height) = 0;
  virtual void glSampleCoverageFn(GLclampf value, GLboolean invert) = 0;
  virtual void glScissorFn(GLint x, GLint y, GLsizei width, GLsizei height) = 0;
  virtual void glShaderBinaryFn(GLsizei n, const GLuint* shaders, GLenum binaryformat, const void* binary, GLsizei length) = 0;
  virtual void glShaderSourceFn(GLuint shader, GLsizei count, const char* const* str, const GLint* length) = 0;
  virtual void glStencilFuncFn(GLenum func, GLint ref, GLuint mask) = 0;
  virtual void glStencilFuncSeparateFn(GLenum face, GLenum func, GLint ref, GLuint mask) = 0;
  virtual void glStencilMaskFn(GLuint mask) = 0;
  virtual void glStencilMaskSeparateFn(GLenum face, GLuint mask) = 0;
  virtual void glStencilOpFn(GLenum fail, GLenum zfail, GLenum zpass) = 0;
  virtual void glStencilOpSeparateFn(GLenum face, GLenum fail, GLenum zfail, GLenum zpass) = 0;
  virtual void glTexImage2DFn(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const void* pixels) = 0;
  virtual void glTexParameterfFn(GLenum target, GLenum pname, GLfloat param) = 0;
  virtual void glTexParameterfvFn(GLenum target, GLenum pname, const GLfloat* params) = 0;
  virtual void glTexParameteriFn(GLenum target, GLenum pname, GLint param) = 0;
  virtual void glTexParameterivFn(GLenum target, GLenum pname, const GLint* params) = 0;
  virtual void glTexStorage2DEXTFn(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height) = 0;
  virtual void glTexSubImage2DFn(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void* pixels) = 0;
  virtual void glUniform1fFn(GLint location, GLfloat x) = 0;
  virtual void glUniform1fvFn(GLint location, GLsizei count, const GLfloat* v) = 0;
  virtual void glUniform1iFn(GLint location, GLint x) = 0;
  virtual void glUniform1ivFn(GLint location, GLsizei count, const GLint* v) = 0;
  virtual void glUniform2fFn(GLint location, GLfloat x, GLfloat y) = 0;
  virtual void glUniform2fvFn(GLint location, GLsizei count, const GLfloat* v) = 0;
  virtual void glUniform2iFn(GLint location, GLint x, GLint y) = 0;
  virtual void glUniform2ivFn(GLint location, GLsizei count, const GLint* v) = 0;
  virtual void glUniform3fFn(GLint location, GLfloat x, GLfloat y, GLfloat z) = 0;
  virtual void glUniform3fvFn(GLint location, GLsizei count, const GLfloat* v) = 0;
  virtual void glUniform3iFn(GLint location, GLint x, GLint y, GLint z) = 0;
  virtual void glUniform3ivFn(GLint location, GLsizei count, const GLint* v) = 0;
  virtual void glUniform4fFn(GLint location, GLfloat x, GLfloat y, GLfloat z, GLfloat w) = 0;
  virtual void glUniform4fvFn(GLint location, GLsizei count, const GLfloat* v) = 0;
  virtual void glUniform4iFn(GLint location, GLint x, GLint y, GLint z, GLint w) = 0;
  virtual void glUniform4ivFn(GLint location, GLsizei count, const GLint* v) = 0;
  virtual void glUniformMatrix2fvFn(GLint location, GLsizei count, GLboolean transpose, const GLfloat* value) = 0;
  virtual void glUniformMatrix3fvFn(GLint location, GLsizei count, GLboolean transpose, const GLfloat* value) = 0;
  virtual void glUniformMatrix4fvFn(GLint location, GLsizei count, GLboolean transpose, const GLfloat* value) = 0;
  virtual GLboolean glUnmapBufferFn(GLenum target) = 0;
  virtual void glUseProgramFn(GLuint program) = 0;
  virtual void glValidateProgramFn(GLuint program) = 0;
  virtual void glVertexAttrib1fFn(GLuint indx, GLfloat x) = 0;
  virtual void glVertexAttrib1fvFn(GLuint indx, const GLfloat* values) = 0;
  virtual void glVertexAttrib2fFn(GLuint indx, GLfloat x, GLfloat y) = 0;
  virtual void glVertexAttrib2fvFn(GLuint indx, const GLfloat* values) = 0;
  virtual void glVertexAttrib3fFn(GLuint indx, GLfloat x, GLfloat y, GLfloat z) = 0;
  virtual void glVertexAttrib3fvFn(GLuint indx, const GLfloat* values) = 0;
  virtual void glVertexAttrib4fFn(GLuint indx, GLfloat x, GLfloat y, GLfloat z, GLfloat w) = 0;
  virtual void glVertexAttrib4fvFn(GLuint indx, const GLfloat* values) = 0;
  virtual void glVertexAttribPointerFn(GLuint indx, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const void* ptr) = 0;
  virtual void glViewportFn(GLint x, GLint y, GLsizei width, GLsizei height) = 0;
  virtual void glGenFencesNVFn(GLsizei n, GLuint* fences) = 0;
  virtual void glDeleteFencesNVFn(GLsizei n, const GLuint* fences) = 0;
  virtual void glSetFenceNVFn(GLuint fence, GLenum condition) = 0;
  virtual GLboolean glTestFenceNVFn(GLuint fence) = 0;
  virtual void glFinishFenceNVFn(GLuint fence) = 0;
  virtual GLboolean glIsFenceNVFn(GLuint fence) = 0;
  virtual void glGetFenceivNVFn(GLuint fence, GLenum pname, GLint* params) = 0;
  virtual GLsync glFenceSyncFn(GLenum condition, GLbitfield flags) = 0;
  virtual void glDeleteSyncFn(GLsync sync) = 0;
  virtual void glGetSyncivFn(GLsync sync, GLenum pname, GLsizei bufSize, GLsizei* length,GLint* values) = 0;
  virtual GLenum glClientWaitSyncFn(GLsync sync, GLbitfield flags, GLuint64 timeout) = 0;
  virtual GLenum glWaitSyncFn(GLsync sync, GLbitfield flags, GLuint64 timeout) = 0;
  virtual void glDrawArraysInstancedANGLEFn(GLenum mode, GLint first, GLsizei count, GLsizei primcount) = 0;
  virtual void glDrawElementsInstancedANGLEFn(GLenum mode, GLsizei count, GLenum type, const void* indices, GLsizei primcount) = 0;
  virtual void glVertexAttribDivisorANGLEFn(GLuint index, GLuint divisor) = 0;
  virtual void glGenVertexArraysOESFn(GLsizei n, GLuint* arrays) = 0;
  virtual void glDeleteVertexArraysOESFn(GLsizei n, const GLuint* arrays) = 0;
  virtual void glBindVertexArrayOESFn(GLuint array) = 0;
  virtual GLboolean glIsVertexArrayOESFn(GLuint array) = 0;
  virtual void glDiscardFramebufferEXTFn(GLenum target, GLsizei numAttachments, const GLenum* attachments) = 0;
};

}  // namespace gfx

#define glActiveTexture ::gfx::g_current_gl_context->glActiveTextureFn
#define glAttachShader ::gfx::g_current_gl_context->glAttachShaderFn
#define glBeginQuery ::gfx::g_current_gl_context->glBeginQueryFn
#define glBeginQueryARB ::gfx::g_current_gl_context->glBeginQueryARBFn
#define glBindAttribLocation ::gfx::g_current_gl_context->glBindAttribLocationFn
#define glBindBuffer ::gfx::g_current_gl_context->glBindBufferFn
#define glBindFragDataLocation ::gfx::g_current_gl_context->glBindFragDataLocationFn
#define glBindFragDataLocationIndexed ::gfx::g_current_gl_context->glBindFragDataLocationIndexedFn
#define glBindFramebufferEXT ::gfx::g_current_gl_context->glBindFramebufferEXTFn
#define glBindRenderbufferEXT ::gfx::g_current_gl_context->glBindRenderbufferEXTFn
#define glBindTexture ::gfx::g_current_gl_context->glBindTextureFn
#define glBlendColor ::gfx::g_current_gl_context->glBlendColorFn
#define glBlendEquation ::gfx::g_current_gl_context->glBlendEquationFn
#define glBlendEquationSeparate ::gfx::g_current_gl_context->glBlendEquationSeparateFn
#define glBlendFunc ::gfx::g_current_gl_context->glBlendFuncFn
#define glBlendFuncSeparate ::gfx::g_current_gl_context->glBlendFuncSeparateFn
#define glBlitFramebuffer ::gfx::g_current_gl_context->glBlitFramebufferFn
#define glBlitFramebufferEXT ::gfx::g_current_gl_context->glBlitFramebufferEXTFn
#define glBlitFramebufferANGLE ::gfx::g_current_gl_context->glBlitFramebufferANGLEFn
#define glBufferData ::gfx::g_current_gl_context->glBufferDataFn
#define glBufferSubData ::gfx::g_current_gl_context->glBufferSubDataFn
#define glCheckFramebufferStatusEXT ::gfx::g_current_gl_context->glCheckFramebufferStatusEXTFn
#define glClear ::gfx::g_current_gl_context->glClearFn
#define glClearColor ::gfx::g_current_gl_context->glClearColorFn
#define glClearDepth ::gfx::g_current_gl_context->glClearDepthFn
#define glClearDepthf ::gfx::g_current_gl_context->glClearDepthfFn
#define glClearStencil ::gfx::g_current_gl_context->glClearStencilFn
#define glColorMask ::gfx::g_current_gl_context->glColorMaskFn
#define glCompileShader ::gfx::g_current_gl_context->glCompileShaderFn
#define glCompressedTexImage2D ::gfx::g_current_gl_context->glCompressedTexImage2DFn
#define glCompressedTexSubImage2D ::gfx::g_current_gl_context->glCompressedTexSubImage2DFn
#define glCopyTexImage2D ::gfx::g_current_gl_context->glCopyTexImage2DFn
#define glCopyTexSubImage2D ::gfx::g_current_gl_context->glCopyTexSubImage2DFn
#define glCreateProgram ::gfx::g_current_gl_context->glCreateProgramFn
#define glCreateShader ::gfx::g_current_gl_context->glCreateShaderFn
#define glCullFace ::gfx::g_current_gl_context->glCullFaceFn
#define glDeleteBuffersARB ::gfx::g_current_gl_context->glDeleteBuffersARBFn
#define glDeleteFramebuffersEXT ::gfx::g_current_gl_context->glDeleteFramebuffersEXTFn
#define glDeleteProgram ::gfx::g_current_gl_context->glDeleteProgramFn
#define glDeleteQueries ::gfx::g_current_gl_context->glDeleteQueriesFn
#define glDeleteQueriesARB ::gfx::g_current_gl_context->glDeleteQueriesARBFn
#define glDeleteRenderbuffersEXT ::gfx::g_current_gl_context->glDeleteRenderbuffersEXTFn
#define glDeleteShader ::gfx::g_current_gl_context->glDeleteShaderFn
#define glDeleteTextures ::gfx::g_current_gl_context->glDeleteTexturesFn
#define glDepthFunc ::gfx::g_current_gl_context->glDepthFuncFn
#define glDepthMask ::gfx::g_current_gl_context->glDepthMaskFn
#define glDepthRange ::gfx::g_current_gl_context->glDepthRangeFn
#define glDepthRangef ::gfx::g_current_gl_context->glDepthRangefFn
#define glDetachShader ::gfx::g_current_gl_context->glDetachShaderFn
#define glDisable ::gfx::g_current_gl_context->glDisableFn
#define glDisableVertexAttribArray ::gfx::g_current_gl_context->glDisableVertexAttribArrayFn
#define glDrawArrays ::gfx::g_current_gl_context->glDrawArraysFn
#define glDrawBuffer ::gfx::g_current_gl_context->glDrawBufferFn
#define glDrawBuffersARB ::gfx::g_current_gl_context->glDrawBuffersARBFn
#define glDrawElements ::gfx::g_current_gl_context->glDrawElementsFn
#define glEGLImageTargetTexture2DOES ::gfx::g_current_gl_context->glEGLImageTargetTexture2DOESFn
#define glEGLImageTargetRenderbufferStorageOES ::gfx::g_current_gl_context->glEGLImageTargetRenderbufferStorageOESFn
#define glEnable ::gfx::g_current_gl_context->glEnableFn
#define glEnableVertexAttribArray ::gfx::g_current_gl_context->glEnableVertexAttribArrayFn
#define glEndQuery ::gfx::g_current_gl_context->glEndQueryFn
#define glEndQueryARB ::gfx::g_current_gl_context->glEndQueryARBFn
#define glFinish ::gfx::g_current_gl_context->glFinishFn
#define glFlush ::gfx::g_current_gl_context->glFlushFn
#define glFramebufferRenderbufferEXT ::gfx::g_current_gl_context->glFramebufferRenderbufferEXTFn
#define glFramebufferTexture2DEXT ::gfx::g_current_gl_context->glFramebufferTexture2DEXTFn
#define glFramebufferTexture2DMultisampleEXT ::gfx::g_current_gl_context->glFramebufferTexture2DMultisampleEXTFn
#define glFramebufferTexture2DMultisampleIMG ::gfx::g_current_gl_context->glFramebufferTexture2DMultisampleIMGFn
#define glFrontFace ::gfx::g_current_gl_context->glFrontFaceFn
#define glGenBuffersARB ::gfx::g_current_gl_context->glGenBuffersARBFn
#define glGenQueries ::gfx::g_current_gl_context->glGenQueriesFn
#define glGenQueriesARB ::gfx::g_current_gl_context->glGenQueriesARBFn
#define glGenerateMipmapEXT ::gfx::g_current_gl_context->glGenerateMipmapEXTFn
#define glGenFramebuffersEXT ::gfx::g_current_gl_context->glGenFramebuffersEXTFn
#define glGenRenderbuffersEXT ::gfx::g_current_gl_context->glGenRenderbuffersEXTFn
#define glGenTextures ::gfx::g_current_gl_context->glGenTexturesFn
#define glGetActiveAttrib ::gfx::g_current_gl_context->glGetActiveAttribFn
#define glGetActiveUniform ::gfx::g_current_gl_context->glGetActiveUniformFn
#define glGetAttachedShaders ::gfx::g_current_gl_context->glGetAttachedShadersFn
#define glGetAttribLocation ::gfx::g_current_gl_context->glGetAttribLocationFn
#define glGetBooleanv ::gfx::g_current_gl_context->glGetBooleanvFn
#define glGetBufferParameteriv ::gfx::g_current_gl_context->glGetBufferParameterivFn
#define glGetError ::gfx::g_current_gl_context->glGetErrorFn
#define glGetFloatv ::gfx::g_current_gl_context->glGetFloatvFn
#define glGetFramebufferAttachmentParameterivEXT ::gfx::g_current_gl_context->glGetFramebufferAttachmentParameterivEXTFn
#define glGetGraphicsResetStatusARB ::gfx::g_current_gl_context->glGetGraphicsResetStatusARBFn
#define glGetIntegerv ::gfx::g_current_gl_context->glGetIntegervFn
#define glGetProgramBinary ::gfx::g_current_gl_context->glGetProgramBinaryFn
#define glGetProgramiv ::gfx::g_current_gl_context->glGetProgramivFn
#define glGetProgramInfoLog ::gfx::g_current_gl_context->glGetProgramInfoLogFn
#define glGetQueryiv ::gfx::g_current_gl_context->glGetQueryivFn
#define glGetQueryivARB ::gfx::g_current_gl_context->glGetQueryivARBFn
#define glGetQueryObjecti64v ::gfx::g_current_gl_context->glGetQueryObjecti64vFn
#define glGetQueryObjectiv ::gfx::g_current_gl_context->glGetQueryObjectivFn
#define glGetQueryObjectui64v ::gfx::g_current_gl_context->glGetQueryObjectui64vFn
#define glGetQueryObjectuiv ::gfx::g_current_gl_context->glGetQueryObjectuivFn
#define glGetQueryObjectuivARB ::gfx::g_current_gl_context->glGetQueryObjectuivARBFn
#define glGetRenderbufferParameterivEXT ::gfx::g_current_gl_context->glGetRenderbufferParameterivEXTFn
#define glGetShaderiv ::gfx::g_current_gl_context->glGetShaderivFn
#define glGetShaderInfoLog ::gfx::g_current_gl_context->glGetShaderInfoLogFn
#define glGetShaderPrecisionFormat ::gfx::g_current_gl_context->glGetShaderPrecisionFormatFn
#define glGetShaderSource ::gfx::g_current_gl_context->glGetShaderSourceFn
#define glGetString ::gfx::g_current_gl_context->glGetStringFn
#define glGetTexLevelParameterfv ::gfx::g_current_gl_context->glGetTexLevelParameterfvFn
#define glGetTexLevelParameteriv ::gfx::g_current_gl_context->glGetTexLevelParameterivFn
#define glGetTexParameterfv ::gfx::g_current_gl_context->glGetTexParameterfvFn
#define glGetTexParameteriv ::gfx::g_current_gl_context->glGetTexParameterivFn
#define glGetTranslatedShaderSourceANGLE ::gfx::g_current_gl_context->glGetTranslatedShaderSourceANGLEFn
#define glGetUniformfv ::gfx::g_current_gl_context->glGetUniformfvFn
#define glGetUniformiv ::gfx::g_current_gl_context->glGetUniformivFn
#define glGetUniformLocation ::gfx::g_current_gl_context->glGetUniformLocationFn
#define glGetVertexAttribfv ::gfx::g_current_gl_context->glGetVertexAttribfvFn
#define glGetVertexAttribiv ::gfx::g_current_gl_context->glGetVertexAttribivFn
#define glGetVertexAttribPointerv ::gfx::g_current_gl_context->glGetVertexAttribPointervFn
#define glHint ::gfx::g_current_gl_context->glHintFn
#define glInsertEventMarkerEXT ::gfx::g_current_gl_context->glInsertEventMarkerEXTFn
#define glIsBuffer ::gfx::g_current_gl_context->glIsBufferFn
#define glIsEnabled ::gfx::g_current_gl_context->glIsEnabledFn
#define glIsFramebufferEXT ::gfx::g_current_gl_context->glIsFramebufferEXTFn
#define glIsProgram ::gfx::g_current_gl_context->glIsProgramFn
#define glIsQueryARB ::gfx::g_current_gl_context->glIsQueryARBFn
#define glIsRenderbufferEXT ::gfx::g_current_gl_context->glIsRenderbufferEXTFn
#define glIsShader ::gfx::g_current_gl_context->glIsShaderFn
#define glIsTexture ::gfx::g_current_gl_context->glIsTextureFn
#define glLineWidth ::gfx::g_current_gl_context->glLineWidthFn
#define glLinkProgram ::gfx::g_current_gl_context->glLinkProgramFn
#define glMapBuffer ::gfx::g_current_gl_context->glMapBufferFn
#define glMapBufferRange ::gfx::g_current_gl_context->glMapBufferRangeFn
#define glFlushMappedBufferRange ::gfx::g_current_gl_context->glFlushMappedBufferRangeFn
#define glPixelStorei ::gfx::g_current_gl_context->glPixelStoreiFn
#define glPointParameteri ::gfx::g_current_gl_context->glPointParameteriFn
#define glPolygonOffset ::gfx::g_current_gl_context->glPolygonOffsetFn
#define glPopGroupMarkerEXT ::gfx::g_current_gl_context->glPopGroupMarkerEXTFn
#define glProgramBinary ::gfx::g_current_gl_context->glProgramBinaryFn
#define glProgramParameteri ::gfx::g_current_gl_context->glProgramParameteriFn
#define glPushGroupMarkerEXT ::gfx::g_current_gl_context->glPushGroupMarkerEXTFn
#define glQueryCounter ::gfx::g_current_gl_context->glQueryCounterFn
#define glReadBuffer ::gfx::g_current_gl_context->glReadBufferFn
#define glReadPixels ::gfx::g_current_gl_context->glReadPixelsFn
#define glReleaseShaderCompiler ::gfx::g_current_gl_context->glReleaseShaderCompilerFn
#define glRenderbufferStorageMultisample ::gfx::g_current_gl_context->glRenderbufferStorageMultisampleFn
#define glRenderbufferStorageMultisampleEXT ::gfx::g_current_gl_context->glRenderbufferStorageMultisampleEXTFn
#define glRenderbufferStorageMultisampleANGLE ::gfx::g_current_gl_context->glRenderbufferStorageMultisampleANGLEFn
#define glRenderbufferStorageMultisampleIMG ::gfx::g_current_gl_context->glRenderbufferStorageMultisampleIMGFn
#define glRenderbufferStorageEXT ::gfx::g_current_gl_context->glRenderbufferStorageEXTFn
#define glSampleCoverage ::gfx::g_current_gl_context->glSampleCoverageFn
#define glScissor ::gfx::g_current_gl_context->glScissorFn
#define glShaderBinary ::gfx::g_current_gl_context->glShaderBinaryFn
#define glShaderSource ::gfx::g_current_gl_context->glShaderSourceFn
#define glStencilFunc ::gfx::g_current_gl_context->glStencilFuncFn
#define glStencilFuncSeparate ::gfx::g_current_gl_context->glStencilFuncSeparateFn
#define glStencilMask ::gfx::g_current_gl_context->glStencilMaskFn
#define glStencilMaskSeparate ::gfx::g_current_gl_context->glStencilMaskSeparateFn
#define glStencilOp ::gfx::g_current_gl_context->glStencilOpFn
#define glStencilOpSeparate ::gfx::g_current_gl_context->glStencilOpSeparateFn
#define glTexImage2D ::gfx::g_current_gl_context->glTexImage2DFn
#define glTexParameterf ::gfx::g_current_gl_context->glTexParameterfFn
#define glTexParameterfv ::gfx::g_current_gl_context->glTexParameterfvFn
#define glTexParameteri ::gfx::g_current_gl_context->glTexParameteriFn
#define glTexParameteriv ::gfx::g_current_gl_context->glTexParameterivFn
#define glTexStorage2DEXT ::gfx::g_current_gl_context->glTexStorage2DEXTFn
#define glTexSubImage2D ::gfx::g_current_gl_context->glTexSubImage2DFn
#define glUniform1f ::gfx::g_current_gl_context->glUniform1fFn
#define glUniform1fv ::gfx::g_current_gl_context->glUniform1fvFn
#define glUniform1i ::gfx::g_current_gl_context->glUniform1iFn
#define glUniform1iv ::gfx::g_current_gl_context->glUniform1ivFn
#define glUniform2f ::gfx::g_current_gl_context->glUniform2fFn
#define glUniform2fv ::gfx::g_current_gl_context->glUniform2fvFn
#define glUniform2i ::gfx::g_current_gl_context->glUniform2iFn
#define glUniform2iv ::gfx::g_current_gl_context->glUniform2ivFn
#define glUniform3f ::gfx::g_current_gl_context->glUniform3fFn
#define glUniform3fv ::gfx::g_current_gl_context->glUniform3fvFn
#define glUniform3i ::gfx::g_current_gl_context->glUniform3iFn
#define glUniform3iv ::gfx::g_current_gl_context->glUniform3ivFn
#define glUniform4f ::gfx::g_current_gl_context->glUniform4fFn
#define glUniform4fv ::gfx::g_current_gl_context->glUniform4fvFn
#define glUniform4i ::gfx::g_current_gl_context->glUniform4iFn
#define glUniform4iv ::gfx::g_current_gl_context->glUniform4ivFn
#define glUniformMatrix2fv ::gfx::g_current_gl_context->glUniformMatrix2fvFn
#define glUniformMatrix3fv ::gfx::g_current_gl_context->glUniformMatrix3fvFn
#define glUniformMatrix4fv ::gfx::g_current_gl_context->glUniformMatrix4fvFn
#define glUnmapBuffer ::gfx::g_current_gl_context->glUnmapBufferFn
#define glUseProgram ::gfx::g_current_gl_context->glUseProgramFn
#define glValidateProgram ::gfx::g_current_gl_context->glValidateProgramFn
#define glVertexAttrib1f ::gfx::g_current_gl_context->glVertexAttrib1fFn
#define glVertexAttrib1fv ::gfx::g_current_gl_context->glVertexAttrib1fvFn
#define glVertexAttrib2f ::gfx::g_current_gl_context->glVertexAttrib2fFn
#define glVertexAttrib2fv ::gfx::g_current_gl_context->glVertexAttrib2fvFn
#define glVertexAttrib3f ::gfx::g_current_gl_context->glVertexAttrib3fFn
#define glVertexAttrib3fv ::gfx::g_current_gl_context->glVertexAttrib3fvFn
#define glVertexAttrib4f ::gfx::g_current_gl_context->glVertexAttrib4fFn
#define glVertexAttrib4fv ::gfx::g_current_gl_context->glVertexAttrib4fvFn
#define glVertexAttribPointer ::gfx::g_current_gl_context->glVertexAttribPointerFn
#define glViewport ::gfx::g_current_gl_context->glViewportFn
#define glGenFencesNV ::gfx::g_current_gl_context->glGenFencesNVFn
#define glDeleteFencesNV ::gfx::g_current_gl_context->glDeleteFencesNVFn
#define glSetFenceNV ::gfx::g_current_gl_context->glSetFenceNVFn
#define glTestFenceNV ::gfx::g_current_gl_context->glTestFenceNVFn
#define glFinishFenceNV ::gfx::g_current_gl_context->glFinishFenceNVFn
#define glIsFenceNV ::gfx::g_current_gl_context->glIsFenceNVFn
#define glGetFenceivNV ::gfx::g_current_gl_context->glGetFenceivNVFn
#define glFenceSync ::gfx::g_current_gl_context->glFenceSyncFn
#define glDeleteSync ::gfx::g_current_gl_context->glDeleteSyncFn
#define glGetSynciv ::gfx::g_current_gl_context->glGetSyncivFn
#define glClientWaitSync ::gfx::g_current_gl_context->glClientWaitSyncFn
#define glWaitSync ::gfx::g_current_gl_context->glWaitSyncFn
#define glDrawArraysInstancedANGLE ::gfx::g_current_gl_context->glDrawArraysInstancedANGLEFn
#define glDrawElementsInstancedANGLE ::gfx::g_current_gl_context->glDrawElementsInstancedANGLEFn
#define glVertexAttribDivisorANGLE ::gfx::g_current_gl_context->glVertexAttribDivisorANGLEFn
#define glGenVertexArraysOES ::gfx::g_current_gl_context->glGenVertexArraysOESFn
#define glDeleteVertexArraysOES ::gfx::g_current_gl_context->glDeleteVertexArraysOESFn
#define glBindVertexArrayOES ::gfx::g_current_gl_context->glBindVertexArrayOESFn
#define glIsVertexArrayOES ::gfx::g_current_gl_context->glIsVertexArrayOESFn
#define glDiscardFramebufferEXT ::gfx::g_current_gl_context->glDiscardFramebufferEXTFn

#endif  //  UI_GFX_GL_GL_BINDINGS_AUTOGEN_GL_H_
