// File is generated by Source/core/inspector/CodeGeneratorInspector.py

// Copyright (c) 2011 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
#ifndef InspectorBackendDispatcher_h
#define InspectorBackendDispatcher_h

#include "InspectorTypeBuilder.h"

#include "wtf/PassRefPtr.h"
#include "wtf/RefCounted.h"
#include "wtf/text/WTFString.h"

namespace WebCore {

class JSONObject;
class JSONArray;
class InspectorFrontendChannel;

typedef String ErrorString;

class InspectorBackendDispatcherImpl;

class InspectorBackendDispatcher: public RefCounted<InspectorBackendDispatcher> {
public:
    static PassRefPtr<InspectorBackendDispatcher> create(InspectorFrontendChannel* inspectorFrontendChannel);
    virtual ~InspectorBackendDispatcher() { }

    class CallbackBase: public RefCounted<CallbackBase> {
    public:
        CallbackBase(PassRefPtr<InspectorBackendDispatcherImpl> backendImpl, int id);
        virtual ~CallbackBase();
        void sendFailure(const ErrorString&);
        bool isActive();

    protected:
        void sendIfActive(PassRefPtr<JSONObject> partialMessage, const ErrorString& invocationError, PassRefPtr<JSONValue> errorData);

    private:
        void disable() { m_alreadySent = true; }

        RefPtr<InspectorBackendDispatcherImpl> m_backendImpl;
        int m_id;
        bool m_alreadySent;

        friend class InspectorBackendDispatcherImpl;
    };

    class InspectorCommandHandler {
    public:
        virtual void enable(ErrorString*) = 0;
        virtual void disable(ErrorString*) = 0;
        virtual void reset(ErrorString*) = 0;

    protected:
        virtual ~InspectorCommandHandler() { }
    };

    class MemoryCommandHandler {
    public:
        virtual void getDOMCounters(ErrorString*, int* out_documents, int* out_nodes, int* out_jsEventListeners) = 0;

    protected:
        virtual ~MemoryCommandHandler() { }
    };

    class PageCommandHandler {
    public:
        virtual void enable(ErrorString*) = 0;
        virtual void disable(ErrorString*) = 0;
        virtual void addScriptToEvaluateOnLoad(ErrorString*, const String& in_scriptSource, TypeBuilder::Page::ScriptIdentifier* out_identifier) = 0;
        virtual void removeScriptToEvaluateOnLoad(ErrorString*, const String& in_identifier) = 0;
        virtual void reload(ErrorString*, const bool* in_ignoreCache, const String* in_scriptToEvaluateOnLoad, const String* in_scriptPreprocessor) = 0;
        virtual void navigate(ErrorString*, const String& in_url) = 0;
        virtual void getCookies(ErrorString*, RefPtr<TypeBuilder::Array<TypeBuilder::Page::Cookie> >& out_cookies) = 0;
        virtual void deleteCookie(ErrorString*, const String& in_cookieName, const String& in_url) = 0;
        virtual void getResourceTree(ErrorString*, RefPtr<TypeBuilder::Page::FrameResourceTree>& out_frameTree) = 0;
        class GetResourceContentCallback : public CallbackBase {
        public:
            GetResourceContentCallback(PassRefPtr<InspectorBackendDispatcherImpl>, int id);
            void sendSuccess(const String& content, bool base64Encoded);
        };
        virtual void getResourceContent(ErrorString*, const String& in_frameId, const String& in_url, PassRefPtr<GetResourceContentCallback> callback) = 0;
        virtual void searchInResource(ErrorString*, const String& in_frameId, const String& in_url, const String& in_query, const bool* in_caseSensitive, const bool* in_isRegex, RefPtr<TypeBuilder::Array<TypeBuilder::Page::SearchMatch> >& out_result) = 0;
        virtual void setDocumentContent(ErrorString*, const String& in_frameId, const String& in_html) = 0;
        virtual void setDeviceMetricsOverride(ErrorString*, int in_width, int in_height, double in_deviceScaleFactor, bool in_emulateViewport, bool in_fitWindow, const double* in_scale, const double* in_offsetX, const double* in_offsetY, const bool* in_textAutosizing, const double* in_fontScaleFactor) = 0;
        virtual void clearDeviceMetricsOverride(ErrorString*) = 0;
        virtual void setShowPaintRects(ErrorString*, bool in_result) = 0;
        virtual void setShowDebugBorders(ErrorString*, bool in_show) = 0;
        virtual void setShowFPSCounter(ErrorString*, bool in_show) = 0;
        virtual void setContinuousPaintingEnabled(ErrorString*, bool in_enabled) = 0;
        virtual void setShowScrollBottleneckRects(ErrorString*, bool in_show) = 0;
        // Named after parameter 'result' while generating command/event getScriptExecutionStatus.
        struct Result {
            enum Enum {
                Allowed = 82,
                Disabled = 83,
                Forbidden = 84,
            };
        }; // struct Result

        virtual void getScriptExecutionStatus(ErrorString*, PageCommandHandler::Result::Enum* out_result) = 0;
        virtual void setScriptExecutionDisabled(ErrorString*, bool in_value) = 0;
        virtual void hasTouchInputs(ErrorString*, bool* out_result) = 0;
        virtual void setTouchEmulationEnabled(ErrorString*, bool in_enabled) = 0;
        virtual void setEmulatedMedia(ErrorString*, const String& in_media) = 0;
        virtual void setShowViewportSizeOnResize(ErrorString*, bool in_show, const bool* in_showGrid) = 0;

    protected:
        virtual ~PageCommandHandler() { }
    };

    class RuntimeCommandHandler {
    public:
        virtual void evaluate(ErrorString*, const String& in_expression, const String* in_objectGroup, const bool* in_includeCommandLineAPI, const bool* in_doNotPauseOnExceptionsAndMuteConsole, const int* in_contextId, const bool* in_returnByValue, const bool* in_generatePreview, RefPtr<TypeBuilder::Runtime::RemoteObject>& out_result, TypeBuilder::OptOutput<bool>* opt_out_wasThrown) = 0;
        virtual void callFunctionOn(ErrorString*, const String& in_objectId, const String& in_functionDeclaration, const RefPtr<JSONArray>* in_arguments, const bool* in_doNotPauseOnExceptionsAndMuteConsole, const bool* in_returnByValue, const bool* in_generatePreview, RefPtr<TypeBuilder::Runtime::RemoteObject>& out_result, TypeBuilder::OptOutput<bool>* opt_out_wasThrown) = 0;
        virtual void getProperties(ErrorString*, const String& in_objectId, const bool* in_ownProperties, const bool* in_accessorPropertiesOnly, RefPtr<TypeBuilder::Array<TypeBuilder::Runtime::PropertyDescriptor> >& out_result, RefPtr<TypeBuilder::Array<TypeBuilder::Runtime::InternalPropertyDescriptor> >& opt_out_internalProperties) = 0;
        virtual void releaseObject(ErrorString*, const String& in_objectId) = 0;
        virtual void releaseObjectGroup(ErrorString*, const String& in_objectGroup) = 0;
        virtual void run(ErrorString*) = 0;
        virtual void enable(ErrorString*) = 0;
        virtual void disable(ErrorString*) = 0;
        virtual void isRunRequired(ErrorString*, bool* out_result) = 0;

    protected:
        virtual ~RuntimeCommandHandler() { }
    };

    class ConsoleCommandHandler {
    public:
        virtual void enable(ErrorString*) = 0;
        virtual void disable(ErrorString*) = 0;
        virtual void clearMessages(ErrorString*) = 0;
        virtual void setMonitoringXHREnabled(ErrorString*, bool in_enabled) = 0;
        virtual void addInspectedNode(ErrorString*, int in_nodeId) = 0;
        virtual void addInspectedHeapObject(ErrorString*, int in_heapObjectId) = 0;

    protected:
        virtual ~ConsoleCommandHandler() { }
    };

    class NetworkCommandHandler {
    public:
        virtual void enable(ErrorString*) = 0;
        virtual void disable(ErrorString*) = 0;
        virtual void setUserAgentOverride(ErrorString*, const String& in_userAgent) = 0;
        virtual void setExtraHTTPHeaders(ErrorString*, const RefPtr<JSONObject>& in_headers) = 0;
        virtual void getResponseBody(ErrorString*, const String& in_requestId, String* out_body, bool* out_base64Encoded) = 0;
        virtual void replayXHR(ErrorString*, const String& in_requestId) = 0;
        virtual void canClearBrowserCache(ErrorString*, bool* out_result) = 0;
        virtual void canClearBrowserCookies(ErrorString*, bool* out_result) = 0;
        virtual void emulateNetworkConditions(ErrorString*, bool in_offline, double in_latency, double in_downloadThroughput, double in_uploadThroughput) = 0;
        virtual void setCacheDisabled(ErrorString*, bool in_cacheDisabled) = 0;
        class LoadResourceForFrontendCallback : public CallbackBase {
        public:
            LoadResourceForFrontendCallback(PassRefPtr<InspectorBackendDispatcherImpl>, int id);
            void sendSuccess(double statusCode, PassRefPtr<JSONObject> responseHeaders, const String& content);
        };
        virtual void loadResourceForFrontend(ErrorString*, const String& in_frameId, const String& in_url, const RefPtr<JSONObject>* in_requestHeaders, PassRefPtr<LoadResourceForFrontendCallback> callback) = 0;

    protected:
        virtual ~NetworkCommandHandler() { }
    };

    class DatabaseCommandHandler {
    public:
        virtual void enable(ErrorString*) = 0;
        virtual void disable(ErrorString*) = 0;
        virtual void getDatabaseTableNames(ErrorString*, const String& in_databaseId, RefPtr<TypeBuilder::Array<String> >& out_tableNames) = 0;
        class ExecuteSQLCallback : public CallbackBase {
        public:
            ExecuteSQLCallback(PassRefPtr<InspectorBackendDispatcherImpl>, int id);
            void sendSuccess(PassRefPtr<TypeBuilder::Array<String> > columnNames, PassRefPtr<TypeBuilder::Array<JSONValue> > values, PassRefPtr<TypeBuilder::Database::Error> sqlError);
        };
        virtual void executeSQL(ErrorString*, const String& in_databaseId, const String& in_query, PassRefPtr<ExecuteSQLCallback> callback) = 0;

    protected:
        virtual ~DatabaseCommandHandler() { }
    };

    class IndexedDBCommandHandler {
    public:
        virtual void enable(ErrorString*) = 0;
        virtual void disable(ErrorString*) = 0;
        class RequestDatabaseNamesCallback : public CallbackBase {
        public:
            RequestDatabaseNamesCallback(PassRefPtr<InspectorBackendDispatcherImpl>, int id);
            void sendSuccess(PassRefPtr<TypeBuilder::Array<String> > databaseNames);
        };
        virtual void requestDatabaseNames(ErrorString*, const String& in_securityOrigin, PassRefPtr<RequestDatabaseNamesCallback> callback) = 0;
        class RequestDatabaseCallback : public CallbackBase {
        public:
            RequestDatabaseCallback(PassRefPtr<InspectorBackendDispatcherImpl>, int id);
            void sendSuccess(PassRefPtr<TypeBuilder::IndexedDB::DatabaseWithObjectStores> databaseWithObjectStores);
        };
        virtual void requestDatabase(ErrorString*, const String& in_securityOrigin, const String& in_databaseName, PassRefPtr<RequestDatabaseCallback> callback) = 0;
        class RequestDataCallback : public CallbackBase {
        public:
            RequestDataCallback(PassRefPtr<InspectorBackendDispatcherImpl>, int id);
            void sendSuccess(PassRefPtr<TypeBuilder::Array<TypeBuilder::IndexedDB::DataEntry> > objectStoreDataEntries, bool hasMore);
        };
        virtual void requestData(ErrorString*, const String& in_securityOrigin, const String& in_databaseName, const String& in_objectStoreName, const String& in_indexName, int in_skipCount, int in_pageSize, const RefPtr<JSONObject>* in_keyRange, PassRefPtr<RequestDataCallback> callback) = 0;
        class ClearObjectStoreCallback : public CallbackBase {
        public:
            ClearObjectStoreCallback(PassRefPtr<InspectorBackendDispatcherImpl>, int id);
            void sendSuccess();
        };
        virtual void clearObjectStore(ErrorString*, const String& in_securityOrigin, const String& in_databaseName, const String& in_objectStoreName, PassRefPtr<ClearObjectStoreCallback> callback) = 0;

    protected:
        virtual ~IndexedDBCommandHandler() { }
    };

    class DOMStorageCommandHandler {
    public:
        virtual void enable(ErrorString*) = 0;
        virtual void disable(ErrorString*) = 0;
        virtual void getDOMStorageItems(ErrorString*, const RefPtr<JSONObject>& in_storageId, RefPtr<TypeBuilder::Array<TypeBuilder::Array<String> > >& out_entries) = 0;
        virtual void setDOMStorageItem(ErrorString*, const RefPtr<JSONObject>& in_storageId, const String& in_key, const String& in_value) = 0;
        virtual void removeDOMStorageItem(ErrorString*, const RefPtr<JSONObject>& in_storageId, const String& in_key) = 0;

    protected:
        virtual ~DOMStorageCommandHandler() { }
    };

    class ApplicationCacheCommandHandler {
    public:
        virtual void getFramesWithManifests(ErrorString*, RefPtr<TypeBuilder::Array<TypeBuilder::ApplicationCache::FrameWithManifest> >& out_frameIds) = 0;
        virtual void enable(ErrorString*) = 0;
        virtual void getManifestForFrame(ErrorString*, const String& in_frameId, String* out_manifestURL) = 0;
        virtual void getApplicationCacheForFrame(ErrorString*, const String& in_frameId, RefPtr<TypeBuilder::ApplicationCache::ApplicationCache>& out_applicationCache) = 0;

    protected:
        virtual ~ApplicationCacheCommandHandler() { }
    };

    class FileSystemCommandHandler {
    public:
        virtual void enable(ErrorString*) = 0;
        virtual void disable(ErrorString*) = 0;
        class RequestFileSystemRootCallback : public CallbackBase {
        public:
            RequestFileSystemRootCallback(PassRefPtr<InspectorBackendDispatcherImpl>, int id);
            void sendSuccess(int errorCode, PassRefPtr<TypeBuilder::FileSystem::Entry> root);
        };
        virtual void requestFileSystemRoot(ErrorString*, const String& in_origin, const String& in_type, PassRefPtr<RequestFileSystemRootCallback> callback) = 0;
        class RequestDirectoryContentCallback : public CallbackBase {
        public:
            RequestDirectoryContentCallback(PassRefPtr<InspectorBackendDispatcherImpl>, int id);
            void sendSuccess(int errorCode, PassRefPtr<TypeBuilder::Array<TypeBuilder::FileSystem::Entry> > entries);
        };
        virtual void requestDirectoryContent(ErrorString*, const String& in_url, PassRefPtr<RequestDirectoryContentCallback> callback) = 0;
        class RequestMetadataCallback : public CallbackBase {
        public:
            RequestMetadataCallback(PassRefPtr<InspectorBackendDispatcherImpl>, int id);
            void sendSuccess(int errorCode, PassRefPtr<TypeBuilder::FileSystem::Metadata> metadata);
        };
        virtual void requestMetadata(ErrorString*, const String& in_url, PassRefPtr<RequestMetadataCallback> callback) = 0;
        class RequestFileContentCallback : public CallbackBase {
        public:
            RequestFileContentCallback(PassRefPtr<InspectorBackendDispatcherImpl>, int id);
            void sendSuccess(int errorCode, const String* const content, const String* const charset);
        };
        virtual void requestFileContent(ErrorString*, const String& in_url, bool in_readAsText, const int* in_start, const int* in_end, const String* in_charset, PassRefPtr<RequestFileContentCallback> callback) = 0;
        class DeleteEntryCallback : public CallbackBase {
        public:
            DeleteEntryCallback(PassRefPtr<InspectorBackendDispatcherImpl>, int id);
            void sendSuccess(int errorCode);
        };
        virtual void deleteEntry(ErrorString*, const String& in_url, PassRefPtr<DeleteEntryCallback> callback) = 0;

    protected:
        virtual ~FileSystemCommandHandler() { }
    };

    class DOMCommandHandler {
    public:
        virtual void enable(ErrorString*) = 0;
        virtual void disable(ErrorString*) = 0;
        virtual void getDocument(ErrorString*, RefPtr<TypeBuilder::DOM::Node>& out_root) = 0;
        virtual void requestChildNodes(ErrorString*, int in_nodeId, const int* in_depth) = 0;
        virtual void querySelector(ErrorString*, int in_nodeId, const String& in_selector, int* out_nodeId) = 0;
        virtual void querySelectorAll(ErrorString*, int in_nodeId, const String& in_selector, RefPtr<TypeBuilder::Array<int> >& out_nodeIds) = 0;
        virtual void setNodeName(ErrorString*, int in_nodeId, const String& in_name, int* out_nodeId) = 0;
        virtual void setNodeValue(ErrorString*, int in_nodeId, const String& in_value) = 0;
        virtual void removeNode(ErrorString*, int in_nodeId) = 0;
        virtual void setAttributeValue(ErrorString*, int in_nodeId, const String& in_name, const String& in_value) = 0;
        virtual void setAttributesAsText(ErrorString*, int in_nodeId, const String& in_text, const String* in_name) = 0;
        virtual void removeAttribute(ErrorString*, int in_nodeId, const String& in_name) = 0;
        virtual void getEventListenersForNode(ErrorString*, int in_nodeId, const String* in_objectGroup, RefPtr<TypeBuilder::Array<TypeBuilder::DOM::EventListener> >& out_listeners) = 0;
        virtual void getOuterHTML(ErrorString*, int in_nodeId, String* out_outerHTML) = 0;
        virtual void setOuterHTML(ErrorString*, int in_nodeId, const String& in_outerHTML) = 0;
        virtual void performSearch(ErrorString*, const String& in_query, String* out_searchId, int* out_resultCount) = 0;
        virtual void getSearchResults(ErrorString*, const String& in_searchId, int in_fromIndex, int in_toIndex, RefPtr<TypeBuilder::Array<int> >& out_nodeIds) = 0;
        virtual void discardSearchResults(ErrorString*, const String& in_searchId) = 0;
        virtual void requestNode(ErrorString*, const String& in_objectId, int* out_nodeId) = 0;
        virtual void setInspectModeEnabled(ErrorString*, bool in_enabled, const bool* in_inspectUAShadowDOM, const RefPtr<JSONObject>* in_highlightConfig) = 0;
        virtual void highlightRect(ErrorString*, int in_x, int in_y, int in_width, int in_height, const RefPtr<JSONObject>* in_color, const RefPtr<JSONObject>* in_outlineColor) = 0;
        virtual void highlightQuad(ErrorString*, const RefPtr<JSONArray>& in_quad, const RefPtr<JSONObject>* in_color, const RefPtr<JSONObject>* in_outlineColor) = 0;
        virtual void highlightNode(ErrorString*, const RefPtr<JSONObject>& in_highlightConfig, const int* in_nodeId, const String* in_objectId) = 0;
        virtual void hideHighlight(ErrorString*) = 0;
        virtual void highlightFrame(ErrorString*, const String& in_frameId, const RefPtr<JSONObject>* in_contentColor, const RefPtr<JSONObject>* in_contentOutlineColor) = 0;
        virtual void pushNodeByPathToFrontend(ErrorString*, const String& in_path, int* out_nodeId) = 0;
        virtual void pushNodesByBackendIdsToFrontend(ErrorString*, const RefPtr<JSONArray>& in_backendNodeIds, RefPtr<TypeBuilder::Array<int> >& out_nodeIds) = 0;
        virtual void resolveNode(ErrorString*, int in_nodeId, const String* in_objectGroup, RefPtr<TypeBuilder::Runtime::RemoteObject>& out_object) = 0;
        virtual void getAttributes(ErrorString*, int in_nodeId, RefPtr<TypeBuilder::Array<String> >& out_attributes) = 0;
        virtual void moveTo(ErrorString*, int in_nodeId, int in_targetNodeId, const int* in_insertBeforeNodeId, int* out_nodeId) = 0;
        virtual void undo(ErrorString*) = 0;
        virtual void redo(ErrorString*) = 0;
        virtual void markUndoableState(ErrorString*) = 0;
        virtual void focus(ErrorString*, int in_nodeId) = 0;
        virtual void setFileInputFiles(ErrorString*, int in_nodeId, const RefPtr<JSONArray>& in_files) = 0;
        virtual void getBoxModel(ErrorString*, int in_nodeId, RefPtr<TypeBuilder::DOM::BoxModel>& out_model) = 0;
        virtual void getNodeForLocation(ErrorString*, int in_x, int in_y, int* out_nodeId) = 0;
        virtual void getRelayoutBoundary(ErrorString*, int in_nodeId, int* out_nodeId) = 0;

    protected:
        virtual ~DOMCommandHandler() { }
    };

    class CSSCommandHandler {
    public:
        class EnableCallback : public CallbackBase {
        public:
            EnableCallback(PassRefPtr<InspectorBackendDispatcherImpl>, int id);
            void sendSuccess();
        };
        virtual void enable(ErrorString*, PassRefPtr<EnableCallback> callback) = 0;
        virtual void disable(ErrorString*) = 0;
        virtual void getMatchedStylesForNode(ErrorString*, int in_nodeId, const bool* in_includePseudo, const bool* in_includeInherited, RefPtr<TypeBuilder::Array<TypeBuilder::CSS::RuleMatch> >& opt_out_matchedCSSRules, RefPtr<TypeBuilder::Array<TypeBuilder::CSS::PseudoIdMatches> >& opt_out_pseudoElements, RefPtr<TypeBuilder::Array<TypeBuilder::CSS::InheritedStyleEntry> >& opt_out_inherited) = 0;
        virtual void getInlineStylesForNode(ErrorString*, int in_nodeId, RefPtr<TypeBuilder::CSS::CSSStyle>& opt_out_inlineStyle, RefPtr<TypeBuilder::CSS::CSSStyle>& opt_out_attributesStyle) = 0;
        virtual void getComputedStyleForNode(ErrorString*, int in_nodeId, RefPtr<TypeBuilder::Array<TypeBuilder::CSS::CSSComputedStyleProperty> >& out_computedStyle) = 0;
        virtual void getPlatformFontsForNode(ErrorString*, int in_nodeId, String* out_cssFamilyName, RefPtr<TypeBuilder::Array<TypeBuilder::CSS::PlatformFontUsage> >& out_fonts) = 0;
        virtual void getStyleSheetText(ErrorString*, const String& in_styleSheetId, String* out_text) = 0;
        virtual void setStyleSheetText(ErrorString*, const String& in_styleSheetId, const String& in_text) = 0;
        virtual void setPropertyText(ErrorString*, const String& in_styleSheetId, const RefPtr<JSONObject>& in_range, const String& in_text, RefPtr<TypeBuilder::CSS::CSSStyle>& out_style) = 0;
        virtual void setRuleSelector(ErrorString*, const String& in_styleSheetId, const RefPtr<JSONObject>& in_range, const String& in_selector, RefPtr<TypeBuilder::CSS::CSSRule>& out_rule) = 0;
        virtual void createStyleSheet(ErrorString*, const String& in_frameId, TypeBuilder::CSS::StyleSheetId* out_styleSheetId) = 0;
        virtual void addRule(ErrorString*, const String& in_styleSheetId, const String& in_selector, RefPtr<TypeBuilder::CSS::CSSRule>& out_rule) = 0;
        virtual void forcePseudoState(ErrorString*, int in_nodeId, const RefPtr<JSONArray>& in_forcedPseudoClasses) = 0;
        virtual void getMediaQueries(ErrorString*, RefPtr<TypeBuilder::Array<TypeBuilder::CSS::CSSMedia> >& out_medias) = 0;

    protected:
        virtual ~CSSCommandHandler() { }
    };

    class TimelineCommandHandler {
    public:
        virtual void enable(ErrorString*) = 0;
        virtual void disable(ErrorString*) = 0;
        virtual void start(ErrorString*, const int* in_maxCallStackDepth, const bool* in_bufferEvents, const String* in_liveEvents, const bool* in_includeCounters, const bool* in_includeGPUEvents) = 0;
        virtual void stop(ErrorString*, RefPtr<TypeBuilder::Array<TypeBuilder::Timeline::TimelineEvent> >& opt_out_events) = 0;

    protected:
        virtual ~TimelineCommandHandler() { }
    };

    class DebuggerCommandHandler {
    public:
        virtual void enable(ErrorString*) = 0;
        virtual void disable(ErrorString*) = 0;
        virtual void setBreakpointsActive(ErrorString*, bool in_active) = 0;
        virtual void setSkipAllPauses(ErrorString*, bool in_skipped, const bool* in_untilReload) = 0;
        virtual void setBreakpointByUrl(ErrorString*, int in_lineNumber, const String* in_url, const String* in_urlRegex, const int* in_columnNumber, const String* in_condition, const bool* in_isAntibreakpoint, TypeBuilder::Debugger::BreakpointId* out_breakpointId, RefPtr<TypeBuilder::Array<TypeBuilder::Debugger::Location> >& out_locations) = 0;
        virtual void setBreakpoint(ErrorString*, const RefPtr<JSONObject>& in_location, const String* in_condition, TypeBuilder::Debugger::BreakpointId* out_breakpointId, RefPtr<TypeBuilder::Debugger::Location>& out_actualLocation) = 0;
        virtual void removeBreakpoint(ErrorString*, const String& in_breakpointId) = 0;
        virtual void continueToLocation(ErrorString*, const RefPtr<JSONObject>& in_location, const bool* in_interstatementLocation) = 0;
        virtual void stepOver(ErrorString*) = 0;
        virtual void stepInto(ErrorString*) = 0;
        virtual void stepOut(ErrorString*) = 0;
        virtual void pause(ErrorString*) = 0;
        virtual void resume(ErrorString*) = 0;
        virtual void searchInContent(ErrorString*, const String& in_scriptId, const String& in_query, const bool* in_caseSensitive, const bool* in_isRegex, RefPtr<TypeBuilder::Array<TypeBuilder::Page::SearchMatch> >& out_result) = 0;
        virtual void canSetScriptSource(ErrorString*, bool* out_result) = 0;
        virtual void setScriptSource(ErrorString*, RefPtr<TypeBuilder::Debugger::SetScriptSourceError>& errorData, const String& in_scriptId, const String& in_scriptSource, const bool* in_preview, RefPtr<TypeBuilder::Array<TypeBuilder::Debugger::CallFrame> >& opt_out_callFrames, RefPtr<JSONObject>& opt_out_result, RefPtr<TypeBuilder::Debugger::StackTrace>& opt_out_asyncStackTrace) = 0;
        virtual void restartFrame(ErrorString*, const String& in_callFrameId, RefPtr<TypeBuilder::Array<TypeBuilder::Debugger::CallFrame> >& out_callFrames, RefPtr<JSONObject>& out_result, RefPtr<TypeBuilder::Debugger::StackTrace>& opt_out_asyncStackTrace) = 0;
        virtual void getScriptSource(ErrorString*, const String& in_scriptId, String* out_scriptSource) = 0;
        virtual void getFunctionDetails(ErrorString*, const String& in_functionId, RefPtr<TypeBuilder::Debugger::FunctionDetails>& out_details) = 0;
        virtual void setPauseOnExceptions(ErrorString*, const String& in_state) = 0;
        virtual void evaluateOnCallFrame(ErrorString*, const String& in_callFrameId, const String& in_expression, const String* in_objectGroup, const bool* in_includeCommandLineAPI, const bool* in_doNotPauseOnExceptionsAndMuteConsole, const bool* in_returnByValue, const bool* in_generatePreview, RefPtr<TypeBuilder::Runtime::RemoteObject>& out_result, TypeBuilder::OptOutput<bool>* opt_out_wasThrown) = 0;
        virtual void compileScript(ErrorString*, const String& in_expression, const String& in_sourceURL, const int* in_executionContextId, TypeBuilder::OptOutput<TypeBuilder::Debugger::ScriptId>* opt_out_scriptId, RefPtr<TypeBuilder::Debugger::ExceptionDetails>& opt_out_exceptionDetails) = 0;
        virtual void runScript(ErrorString*, const String& in_scriptId, const int* in_executionContextId, const String* in_objectGroup, const bool* in_doNotPauseOnExceptionsAndMuteConsole, RefPtr<TypeBuilder::Runtime::RemoteObject>& out_result, RefPtr<TypeBuilder::Debugger::ExceptionDetails>& opt_out_exceptionDetails) = 0;
        virtual void setOverlayMessage(ErrorString*, const String* in_message) = 0;
        virtual void setVariableValue(ErrorString*, int in_scopeNumber, const String& in_variableName, const RefPtr<JSONObject>& in_newValue, const String* in_callFrameId, const String* in_functionObjectId) = 0;
        virtual void getStepInPositions(ErrorString*, const String& in_callFrameId, RefPtr<TypeBuilder::Array<TypeBuilder::Debugger::Location> >& opt_out_stepInPositions) = 0;
        virtual void getBacktrace(ErrorString*, RefPtr<TypeBuilder::Array<TypeBuilder::Debugger::CallFrame> >& out_callFrames, RefPtr<TypeBuilder::Debugger::StackTrace>& opt_out_asyncStackTrace) = 0;
        virtual void skipStackFrames(ErrorString*, const String* in_script) = 0;
        virtual void setAsyncCallStackDepth(ErrorString*, int in_maxDepth) = 0;

    protected:
        virtual ~DebuggerCommandHandler() { }
    };

    class DOMDebuggerCommandHandler {
    public:
        virtual void setDOMBreakpoint(ErrorString*, int in_nodeId, const String& in_type) = 0;
        virtual void removeDOMBreakpoint(ErrorString*, int in_nodeId, const String& in_type) = 0;
        virtual void setEventListenerBreakpoint(ErrorString*, const String& in_eventName, const String* in_targetName) = 0;
        virtual void removeEventListenerBreakpoint(ErrorString*, const String& in_eventName, const String* in_targetName) = 0;
        virtual void setInstrumentationBreakpoint(ErrorString*, const String& in_eventName) = 0;
        virtual void removeInstrumentationBreakpoint(ErrorString*, const String& in_eventName) = 0;
        virtual void setXHRBreakpoint(ErrorString*, const String& in_url) = 0;
        virtual void removeXHRBreakpoint(ErrorString*, const String& in_url) = 0;

    protected:
        virtual ~DOMDebuggerCommandHandler() { }
    };

    class ProfilerCommandHandler {
    public:
        virtual void enable(ErrorString*) = 0;
        virtual void disable(ErrorString*) = 0;
        virtual void setSamplingInterval(ErrorString*, int in_interval) = 0;
        virtual void start(ErrorString*) = 0;
        virtual void stop(ErrorString*, RefPtr<TypeBuilder::Profiler::CPUProfile>& out_profile) = 0;

    protected:
        virtual ~ProfilerCommandHandler() { }
    };

    class HeapProfilerCommandHandler {
    public:
        virtual void enable(ErrorString*) = 0;
        virtual void disable(ErrorString*) = 0;
        virtual void startTrackingHeapObjects(ErrorString*, const bool* in_trackAllocations) = 0;
        virtual void stopTrackingHeapObjects(ErrorString*, const bool* in_reportProgress) = 0;
        virtual void takeHeapSnapshot(ErrorString*, const bool* in_reportProgress) = 0;
        virtual void collectGarbage(ErrorString*) = 0;
        virtual void getObjectByHeapObjectId(ErrorString*, const String& in_objectId, const String* in_objectGroup, RefPtr<TypeBuilder::Runtime::RemoteObject>& out_result) = 0;
        virtual void getHeapObjectId(ErrorString*, const String& in_objectId, TypeBuilder::HeapProfiler::HeapSnapshotObjectId* out_heapSnapshotObjectId) = 0;

    protected:
        virtual ~HeapProfilerCommandHandler() { }
    };

    class WorkerCommandHandler {
    public:
        virtual void enable(ErrorString*) = 0;
        virtual void disable(ErrorString*) = 0;
        virtual void sendMessageToWorker(ErrorString*, int in_workerId, const RefPtr<JSONObject>& in_message) = 0;
        virtual void canInspectWorkers(ErrorString*, bool* out_result) = 0;
        virtual void connectToWorker(ErrorString*, int in_workerId) = 0;
        virtual void disconnectFromWorker(ErrorString*, int in_workerId) = 0;
        virtual void setAutoconnectToWorkers(ErrorString*, bool in_value) = 0;

    protected:
        virtual ~WorkerCommandHandler() { }
    };

    class CanvasCommandHandler {
    public:
        virtual void enable(ErrorString*) = 0;
        virtual void disable(ErrorString*) = 0;
        virtual void dropTraceLog(ErrorString*, const String& in_traceLogId) = 0;
        virtual void hasUninstrumentedCanvases(ErrorString*, bool* out_result) = 0;
        virtual void captureFrame(ErrorString*, const String* in_frameId, TypeBuilder::Canvas::TraceLogId* out_traceLogId) = 0;
        virtual void startCapturing(ErrorString*, const String* in_frameId, TypeBuilder::Canvas::TraceLogId* out_traceLogId) = 0;
        virtual void stopCapturing(ErrorString*, const String& in_traceLogId) = 0;
        virtual void getTraceLog(ErrorString*, const String& in_traceLogId, const int* in_startOffset, const int* in_maxLength, RefPtr<TypeBuilder::Canvas::TraceLog>& out_traceLog) = 0;
        virtual void replayTraceLog(ErrorString*, const String& in_traceLogId, int in_stepNo, RefPtr<TypeBuilder::Canvas::ResourceState>& out_resourceState, double* out_replayTime) = 0;
        virtual void getResourceState(ErrorString*, const String& in_traceLogId, const String& in_resourceId, RefPtr<TypeBuilder::Canvas::ResourceState>& out_resourceState) = 0;
        virtual void evaluateTraceLogCallArgument(ErrorString*, const String& in_traceLogId, int in_callIndex, int in_argumentIndex, const String* in_objectGroup, RefPtr<TypeBuilder::Runtime::RemoteObject>& opt_out_result, RefPtr<TypeBuilder::Canvas::ResourceState>& opt_out_resourceState) = 0;

    protected:
        virtual ~CanvasCommandHandler() { }
    };

    class InputCommandHandler {
    public:
        virtual void dispatchKeyEvent(ErrorString*, const String& in_type, const int* in_modifiers, const double* in_timestamp, const String* in_text, const String* in_unmodifiedText, const String* in_keyIdentifier, const int* in_windowsVirtualKeyCode, const int* in_nativeVirtualKeyCode, const bool* in_autoRepeat, const bool* in_isKeypad, const bool* in_isSystemKey) = 0;
        virtual void dispatchMouseEvent(ErrorString*, const String& in_type, int in_x, int in_y, const int* in_modifiers, const double* in_timestamp, const String* in_button, const int* in_clickCount, const bool* in_deviceSpace) = 0;
        virtual void dispatchTouchEvent(ErrorString*, const String& in_type, const RefPtr<JSONArray>& in_touchPoints, const int* in_modifiers, const double* in_timestamp) = 0;

    protected:
        virtual ~InputCommandHandler() { }
    };

    class LayerTreeCommandHandler {
    public:
        virtual void enable(ErrorString*) = 0;
        virtual void disable(ErrorString*) = 0;
        virtual void compositingReasons(ErrorString*, const String& in_layerId, RefPtr<TypeBuilder::Array<String> >& out_compositingReasons) = 0;
        virtual void makeSnapshot(ErrorString*, const String& in_layerId, TypeBuilder::LayerTree::SnapshotId* out_snapshotId) = 0;
        virtual void loadSnapshot(ErrorString*, const String& in_data, TypeBuilder::LayerTree::SnapshotId* out_snapshotId) = 0;
        virtual void releaseSnapshot(ErrorString*, const String& in_snapshotId) = 0;
        virtual void profileSnapshot(ErrorString*, const String& in_snapshotId, const int* in_minRepeatCount, const double* in_minDuration, RefPtr<TypeBuilder::Array<TypeBuilder::Array<double> > >& out_timings) = 0;
        virtual void replaySnapshot(ErrorString*, const String& in_snapshotId, const int* in_fromStep, const int* in_toStep, String* out_dataURL) = 0;
        virtual void snapshotCommandLog(ErrorString*, const String& in_snapshotId, RefPtr<TypeBuilder::Array<JSONObject> >& out_commandLog) = 0;

    protected:
        virtual ~LayerTreeCommandHandler() { }
    };

    class GeolocationCommandHandler {
    public:
        virtual void setGeolocationOverride(ErrorString*, const double* in_latitude, const double* in_longitude, const double* in_accuracy) = 0;
        virtual void clearGeolocationOverride(ErrorString*) = 0;

    protected:
        virtual ~GeolocationCommandHandler() { }
    };

    class DeviceOrientationCommandHandler {
    public:
        virtual void setDeviceOrientationOverride(ErrorString*, double in_alpha, double in_beta, double in_gamma) = 0;
        virtual void clearDeviceOrientationOverride(ErrorString*) = 0;

    protected:
        virtual ~DeviceOrientationCommandHandler() { }
    };

    class TracingCommandHandler {
    public:
        virtual void start(ErrorString*, const String& in_categories, const String& in_options, const double* in_bufferUsageReportingInterval, String* out_sessionId) = 0;

    protected:
        virtual ~TracingCommandHandler() { }
    };

    class PowerCommandHandler {
    public:

    protected:
        virtual ~PowerCommandHandler() { }
    };


    virtual void registerAgent(InspectorCommandHandler* inspectorAgent) = 0;
    virtual void registerAgent(MemoryCommandHandler* memoryAgent) = 0;
    virtual void registerAgent(PageCommandHandler* pageAgent) = 0;
    virtual void registerAgent(RuntimeCommandHandler* runtimeAgent) = 0;
    virtual void registerAgent(ConsoleCommandHandler* consoleAgent) = 0;
    virtual void registerAgent(NetworkCommandHandler* networkAgent) = 0;
    virtual void registerAgent(DatabaseCommandHandler* databaseAgent) = 0;
    virtual void registerAgent(IndexedDBCommandHandler* indexedDBAgent) = 0;
    virtual void registerAgent(DOMStorageCommandHandler* domStorageAgent) = 0;
    virtual void registerAgent(ApplicationCacheCommandHandler* applicationCacheAgent) = 0;
    virtual void registerAgent(FileSystemCommandHandler* fileSystemAgent) = 0;
    virtual void registerAgent(DOMCommandHandler* domAgent) = 0;
    virtual void registerAgent(CSSCommandHandler* cssAgent) = 0;
    virtual void registerAgent(TimelineCommandHandler* timelineAgent) = 0;
    virtual void registerAgent(DebuggerCommandHandler* debuggerAgent) = 0;
    virtual void registerAgent(DOMDebuggerCommandHandler* domDebuggerAgent) = 0;
    virtual void registerAgent(ProfilerCommandHandler* profilerAgent) = 0;
    virtual void registerAgent(HeapProfilerCommandHandler* heapProfilerAgent) = 0;
    virtual void registerAgent(WorkerCommandHandler* workerAgent) = 0;
    virtual void registerAgent(CanvasCommandHandler* canvasAgent) = 0;
    virtual void registerAgent(InputCommandHandler* inputAgent) = 0;
    virtual void registerAgent(LayerTreeCommandHandler* layerTreeAgent) = 0;
    virtual void registerAgent(GeolocationCommandHandler* geolocationAgent) = 0;
    virtual void registerAgent(DeviceOrientationCommandHandler* deviceOrientationAgent) = 0;
    virtual void registerAgent(TracingCommandHandler* tracingAgent) = 0;
    virtual void registerAgent(PowerCommandHandler* powerAgent) = 0;

    virtual void clearFrontend() = 0;

    enum CommonErrorCode {
        ParseError = 0,
        InvalidRequest,
        MethodNotFound,
        InvalidParams,
        InternalError,
        ServerError,
        LastEntry,
    };

    void reportProtocolError(const long* const callId, CommonErrorCode, const String& errorMessage) const;
    virtual void reportProtocolError(const long* const callId, CommonErrorCode, const String& errorMessage, PassRefPtr<JSONValue> data) const = 0;
    virtual void dispatch(const String& message) = 0;
    static bool getCommandName(const String& message, String* result);

    enum MethodNames {
        kInspector_enableCmd,
        kInspector_disableCmd,
        kInspector_resetCmd,
        kMemory_getDOMCountersCmd,
        kPage_enableCmd,
        kPage_disableCmd,
        kPage_addScriptToEvaluateOnLoadCmd,
        kPage_removeScriptToEvaluateOnLoadCmd,
        kPage_reloadCmd,
        kPage_navigateCmd,
        kPage_getCookiesCmd,
        kPage_deleteCookieCmd,
        kPage_getResourceTreeCmd,
        kPage_getResourceContentCmd,
        kPage_searchInResourceCmd,
        kPage_setDocumentContentCmd,
        kPage_setDeviceMetricsOverrideCmd,
        kPage_clearDeviceMetricsOverrideCmd,
        kPage_setShowPaintRectsCmd,
        kPage_setShowDebugBordersCmd,
        kPage_setShowFPSCounterCmd,
        kPage_setContinuousPaintingEnabledCmd,
        kPage_setShowScrollBottleneckRectsCmd,
        kPage_getScriptExecutionStatusCmd,
        kPage_setScriptExecutionDisabledCmd,
        kPage_setGeolocationOverrideCmd,
        kPage_clearGeolocationOverrideCmd,
        kPage_setDeviceOrientationOverrideCmd,
        kPage_clearDeviceOrientationOverrideCmd,
        kPage_hasTouchInputsCmd,
        kPage_setTouchEmulationEnabledCmd,
        kPage_setEmulatedMediaCmd,
        kPage_setShowViewportSizeOnResizeCmd,
        kRuntime_evaluateCmd,
        kRuntime_callFunctionOnCmd,
        kRuntime_getPropertiesCmd,
        kRuntime_releaseObjectCmd,
        kRuntime_releaseObjectGroupCmd,
        kRuntime_runCmd,
        kRuntime_enableCmd,
        kRuntime_disableCmd,
        kRuntime_isRunRequiredCmd,
        kConsole_enableCmd,
        kConsole_disableCmd,
        kConsole_clearMessagesCmd,
        kConsole_setMonitoringXHREnabledCmd,
        kConsole_addInspectedNodeCmd,
        kConsole_addInspectedHeapObjectCmd,
        kNetwork_enableCmd,
        kNetwork_disableCmd,
        kNetwork_setUserAgentOverrideCmd,
        kNetwork_setExtraHTTPHeadersCmd,
        kNetwork_getResponseBodyCmd,
        kNetwork_replayXHRCmd,
        kNetwork_canClearBrowserCacheCmd,
        kNetwork_canClearBrowserCookiesCmd,
        kNetwork_emulateNetworkConditionsCmd,
        kNetwork_setCacheDisabledCmd,
        kNetwork_loadResourceForFrontendCmd,
        kDatabase_enableCmd,
        kDatabase_disableCmd,
        kDatabase_getDatabaseTableNamesCmd,
        kDatabase_executeSQLCmd,
        kIndexedDB_enableCmd,
        kIndexedDB_disableCmd,
        kIndexedDB_requestDatabaseNamesCmd,
        kIndexedDB_requestDatabaseCmd,
        kIndexedDB_requestDataCmd,
        kIndexedDB_clearObjectStoreCmd,
        kDOMStorage_enableCmd,
        kDOMStorage_disableCmd,
        kDOMStorage_getDOMStorageItemsCmd,
        kDOMStorage_setDOMStorageItemCmd,
        kDOMStorage_removeDOMStorageItemCmd,
        kApplicationCache_getFramesWithManifestsCmd,
        kApplicationCache_enableCmd,
        kApplicationCache_getManifestForFrameCmd,
        kApplicationCache_getApplicationCacheForFrameCmd,
        kFileSystem_enableCmd,
        kFileSystem_disableCmd,
        kFileSystem_requestFileSystemRootCmd,
        kFileSystem_requestDirectoryContentCmd,
        kFileSystem_requestMetadataCmd,
        kFileSystem_requestFileContentCmd,
        kFileSystem_deleteEntryCmd,
        kDOM_enableCmd,
        kDOM_disableCmd,
        kDOM_getDocumentCmd,
        kDOM_requestChildNodesCmd,
        kDOM_querySelectorCmd,
        kDOM_querySelectorAllCmd,
        kDOM_setNodeNameCmd,
        kDOM_setNodeValueCmd,
        kDOM_removeNodeCmd,
        kDOM_setAttributeValueCmd,
        kDOM_setAttributesAsTextCmd,
        kDOM_removeAttributeCmd,
        kDOM_getEventListenersForNodeCmd,
        kDOM_getOuterHTMLCmd,
        kDOM_setOuterHTMLCmd,
        kDOM_performSearchCmd,
        kDOM_getSearchResultsCmd,
        kDOM_discardSearchResultsCmd,
        kDOM_requestNodeCmd,
        kDOM_setInspectModeEnabledCmd,
        kDOM_highlightRectCmd,
        kDOM_highlightQuadCmd,
        kDOM_highlightNodeCmd,
        kDOM_hideHighlightCmd,
        kDOM_highlightFrameCmd,
        kDOM_pushNodeByPathToFrontendCmd,
        kDOM_pushNodesByBackendIdsToFrontendCmd,
        kDOM_resolveNodeCmd,
        kDOM_getAttributesCmd,
        kDOM_moveToCmd,
        kDOM_undoCmd,
        kDOM_redoCmd,
        kDOM_markUndoableStateCmd,
        kDOM_focusCmd,
        kDOM_setFileInputFilesCmd,
        kDOM_getBoxModelCmd,
        kDOM_getNodeForLocationCmd,
        kDOM_getRelayoutBoundaryCmd,
        kCSS_enableCmd,
        kCSS_disableCmd,
        kCSS_getMatchedStylesForNodeCmd,
        kCSS_getInlineStylesForNodeCmd,
        kCSS_getComputedStyleForNodeCmd,
        kCSS_getPlatformFontsForNodeCmd,
        kCSS_getStyleSheetTextCmd,
        kCSS_setStyleSheetTextCmd,
        kCSS_setPropertyTextCmd,
        kCSS_setRuleSelectorCmd,
        kCSS_createStyleSheetCmd,
        kCSS_addRuleCmd,
        kCSS_forcePseudoStateCmd,
        kCSS_getMediaQueriesCmd,
        kTimeline_enableCmd,
        kTimeline_disableCmd,
        kTimeline_startCmd,
        kTimeline_stopCmd,
        kDebugger_enableCmd,
        kDebugger_disableCmd,
        kDebugger_setBreakpointsActiveCmd,
        kDebugger_setSkipAllPausesCmd,
        kDebugger_setBreakpointByUrlCmd,
        kDebugger_setBreakpointCmd,
        kDebugger_removeBreakpointCmd,
        kDebugger_continueToLocationCmd,
        kDebugger_stepOverCmd,
        kDebugger_stepIntoCmd,
        kDebugger_stepOutCmd,
        kDebugger_pauseCmd,
        kDebugger_resumeCmd,
        kDebugger_searchInContentCmd,
        kDebugger_canSetScriptSourceCmd,
        kDebugger_setScriptSourceCmd,
        kDebugger_restartFrameCmd,
        kDebugger_getScriptSourceCmd,
        kDebugger_getFunctionDetailsCmd,
        kDebugger_setPauseOnExceptionsCmd,
        kDebugger_evaluateOnCallFrameCmd,
        kDebugger_compileScriptCmd,
        kDebugger_runScriptCmd,
        kDebugger_setOverlayMessageCmd,
        kDebugger_setVariableValueCmd,
        kDebugger_getStepInPositionsCmd,
        kDebugger_getBacktraceCmd,
        kDebugger_skipStackFramesCmd,
        kDebugger_setAsyncCallStackDepthCmd,
        kDOMDebugger_setDOMBreakpointCmd,
        kDOMDebugger_removeDOMBreakpointCmd,
        kDOMDebugger_setEventListenerBreakpointCmd,
        kDOMDebugger_removeEventListenerBreakpointCmd,
        kDOMDebugger_setInstrumentationBreakpointCmd,
        kDOMDebugger_removeInstrumentationBreakpointCmd,
        kDOMDebugger_setXHRBreakpointCmd,
        kDOMDebugger_removeXHRBreakpointCmd,
        kProfiler_enableCmd,
        kProfiler_disableCmd,
        kProfiler_setSamplingIntervalCmd,
        kProfiler_startCmd,
        kProfiler_stopCmd,
        kHeapProfiler_enableCmd,
        kHeapProfiler_disableCmd,
        kHeapProfiler_startTrackingHeapObjectsCmd,
        kHeapProfiler_stopTrackingHeapObjectsCmd,
        kHeapProfiler_takeHeapSnapshotCmd,
        kHeapProfiler_collectGarbageCmd,
        kHeapProfiler_getObjectByHeapObjectIdCmd,
        kHeapProfiler_getHeapObjectIdCmd,
        kWorker_enableCmd,
        kWorker_disableCmd,
        kWorker_sendMessageToWorkerCmd,
        kWorker_canInspectWorkersCmd,
        kWorker_connectToWorkerCmd,
        kWorker_disconnectFromWorkerCmd,
        kWorker_setAutoconnectToWorkersCmd,
        kCanvas_enableCmd,
        kCanvas_disableCmd,
        kCanvas_dropTraceLogCmd,
        kCanvas_hasUninstrumentedCanvasesCmd,
        kCanvas_captureFrameCmd,
        kCanvas_startCapturingCmd,
        kCanvas_stopCapturingCmd,
        kCanvas_getTraceLogCmd,
        kCanvas_replayTraceLogCmd,
        kCanvas_getResourceStateCmd,
        kCanvas_evaluateTraceLogCallArgumentCmd,
        kInput_dispatchKeyEventCmd,
        kInput_dispatchMouseEventCmd,
        kInput_dispatchTouchEventCmd,
        kLayerTree_enableCmd,
        kLayerTree_disableCmd,
        kLayerTree_compositingReasonsCmd,
        kLayerTree_makeSnapshotCmd,
        kLayerTree_loadSnapshotCmd,
        kLayerTree_releaseSnapshotCmd,
        kLayerTree_profileSnapshotCmd,
        kLayerTree_replaySnapshotCmd,
        kLayerTree_snapshotCommandLogCmd,
        kGeolocation_setGeolocationOverrideCmd,
        kGeolocation_clearGeolocationOverrideCmd,
        kDeviceOrientation_setDeviceOrientationOverrideCmd,
        kDeviceOrientation_clearDeviceOrientationOverrideCmd,
        kTracing_startCmd,

        kMethodNamesEnumSize
    };

    static const char* commandName(MethodNames);

private:
    static const char commandNames[];
    static const size_t commandNamesIndex[];
};

} // namespace WebCore
#endif // !defined(InspectorBackendDispatcher_h)


