
// Copyright (c) 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CSSValueKeywords_h
#define CSSValueKeywords_h

#include "core/css/CSSParserMode.h"
#include <string.h>

namespace WebCore {

enum CSSValueID {
    CSSValueInvalid = 0,
    CSSValueInherit = 1,
    CSSValueInitial = 2,
    CSSValueNone = 3,
    CSSValueHidden = 4,
    CSSValueInset = 5,
    CSSValueGroove = 6,
    CSSValueOutset = 7,
    CSSValueRidge = 8,
    CSSValueDotted = 9,
    CSSValueDashed = 10,
    CSSValueSolid = 11,
    CSSValueDouble = 12,
    CSSValueCaption = 13,
    CSSValueIcon = 14,
    CSSValueMenu = 15,
    CSSValueMessageBox = 16,
    CSSValueSmallCaption = 17,
    CSSValueWebkitMiniControl = 18,
    CSSValueWebkitSmallControl = 19,
    CSSValueWebkitControl = 20,
    CSSValueStatusBar = 21,
    CSSValueItalic = 22,
    CSSValueOblique = 23,
    CSSValueAll = 24,
    CSSValueSmallCaps = 25,
    CSSValueCommonLigatures = 26,
    CSSValueNoCommonLigatures = 27,
    CSSValueDiscretionaryLigatures = 28,
    CSSValueNoDiscretionaryLigatures = 29,
    CSSValueHistoricalLigatures = 30,
    CSSValueNoHistoricalLigatures = 31,
    CSSValueContextual = 32,
    CSSValueNoContextual = 33,
    CSSValueNormal = 34,
    CSSValueBold = 35,
    CSSValueBolder = 36,
    CSSValueLighter = 37,
    CSSValue100 = 38,
    CSSValue200 = 39,
    CSSValue300 = 40,
    CSSValue400 = 41,
    CSSValue500 = 42,
    CSSValue600 = 43,
    CSSValue700 = 44,
    CSSValue800 = 45,
    CSSValue900 = 46,
    CSSValueXxSmall = 47,
    CSSValueXSmall = 48,
    CSSValueSmall = 49,
    CSSValueMedium = 50,
    CSSValueLarge = 51,
    CSSValueXLarge = 52,
    CSSValueXxLarge = 53,
    CSSValueWebkitXxxLarge = 54,
    CSSValueSmaller = 55,
    CSSValueLarger = 56,
    CSSValueSerif = 57,
    CSSValueSansSerif = 58,
    CSSValueCursive = 59,
    CSSValueFantasy = 60,
    CSSValueMonospace = 61,
    CSSValueWebkitBody = 62,
    CSSValueWebkitPictograph = 63,
    CSSValueAqua = 64,
    CSSValueBlack = 65,
    CSSValueBlue = 66,
    CSSValueFuchsia = 67,
    CSSValueGray = 68,
    CSSValueGreen = 69,
    CSSValueLime = 70,
    CSSValueMaroon = 71,
    CSSValueNavy = 72,
    CSSValueOlive = 73,
    CSSValueOrange = 74,
    CSSValuePurple = 75,
    CSSValueRed = 76,
    CSSValueSilver = 77,
    CSSValueTeal = 78,
    CSSValueWhite = 79,
    CSSValueYellow = 80,
    CSSValueTransparent = 81,
    CSSValueWebkitLink = 82,
    CSSValueWebkitActivelink = 83,
    CSSValueActiveborder = 84,
    CSSValueActivecaption = 85,
    CSSValueAppworkspace = 86,
    CSSValueBackground = 87,
    CSSValueButtonface = 88,
    CSSValueButtonhighlight = 89,
    CSSValueButtonshadow = 90,
    CSSValueButtontext = 91,
    CSSValueCaptiontext = 92,
    CSSValueGraytext = 93,
    CSSValueHighlight = 94,
    CSSValueHighlighttext = 95,
    CSSValueInactiveborder = 96,
    CSSValueInactivecaption = 97,
    CSSValueInactivecaptiontext = 98,
    CSSValueInfobackground = 99,
    CSSValueInfotext = 100,
    CSSValueMenutext = 101,
    CSSValueScrollbar = 102,
    CSSValueThreeddarkshadow = 103,
    CSSValueThreedface = 104,
    CSSValueThreedhighlight = 105,
    CSSValueThreedlightshadow = 106,
    CSSValueThreedshadow = 107,
    CSSValueWindow = 108,
    CSSValueWindowframe = 109,
    CSSValueWindowtext = 110,
    CSSValueInternalActiveListBoxSelection = 111,
    CSSValueInternalActiveListBoxSelectionText = 112,
    CSSValueInternalInactiveListBoxSelection = 113,
    CSSValueInternalInactiveListBoxSelectionText = 114,
    CSSValueWebkitFocusRingColor = 115,
    CSSValueCurrentcolor = 116,
    CSSValueGrey = 117,
    CSSValueWebkitText = 118,
    CSSValueRepeat = 119,
    CSSValueRepeatX = 120,
    CSSValueRepeatY = 121,
    CSSValueNoRepeat = 122,
    CSSValueClear = 123,
    CSSValueCopy = 124,
    CSSValueSourceOver = 125,
    CSSValueSourceIn = 126,
    CSSValueSourceOut = 127,
    CSSValueSourceAtop = 128,
    CSSValueDestinationOver = 129,
    CSSValueDestinationIn = 130,
    CSSValueDestinationOut = 131,
    CSSValueDestinationAtop = 132,
    CSSValueXor = 133,
    CSSValuePlusDarker = 134,
    CSSValuePlusLighter = 135,
    CSSValueBaseline = 136,
    CSSValueMiddle = 137,
    CSSValueSub = 138,
    CSSValueSuper = 139,
    CSSValueTextTop = 140,
    CSSValueTextBottom = 141,
    CSSValueTop = 142,
    CSSValueBottom = 143,
    CSSValueWebkitBaselineMiddle = 144,
    CSSValueWebkitAuto = 145,
    CSSValueLeft = 146,
    CSSValueRight = 147,
    CSSValueCenter = 148,
    CSSValueJustify = 149,
    CSSValueWebkitLeft = 150,
    CSSValueWebkitRight = 151,
    CSSValueWebkitCenter = 152,
    CSSValueWebkitMatchParent = 153,
    CSSValueInterWord = 154,
    CSSValueDistribute = 155,
    CSSValueOutside = 156,
    CSSValueInside = 157,
    CSSValueDisc = 158,
    CSSValueCircle = 159,
    CSSValueSquare = 160,
    CSSValueDecimal = 161,
    CSSValueDecimalLeadingZero = 162,
    CSSValueArabicIndic = 163,
    CSSValueBinary = 164,
    CSSValueBengali = 165,
    CSSValueCambodian = 166,
    CSSValueKhmer = 167,
    CSSValueDevanagari = 168,
    CSSValueGujarati = 169,
    CSSValueGurmukhi = 170,
    CSSValueKannada = 171,
    CSSValueLowerHexadecimal = 172,
    CSSValueLao = 173,
    CSSValueMalayalam = 174,
    CSSValueMongolian = 175,
    CSSValueMyanmar = 176,
    CSSValueOctal = 177,
    CSSValueOriya = 178,
    CSSValuePersian = 179,
    CSSValueUrdu = 180,
    CSSValueTelugu = 181,
    CSSValueTibetan = 182,
    CSSValueThai = 183,
    CSSValueUpperHexadecimal = 184,
    CSSValueLowerRoman = 185,
    CSSValueUpperRoman = 186,
    CSSValueLowerGreek = 187,
    CSSValueLowerAlpha = 188,
    CSSValueLowerLatin = 189,
    CSSValueUpperAlpha = 190,
    CSSValueUpperLatin = 191,
    CSSValueAfar = 192,
    CSSValueEthiopicHalehameAaEt = 193,
    CSSValueEthiopicHalehameAaEr = 194,
    CSSValueAmharic = 195,
    CSSValueEthiopicHalehameAmEt = 196,
    CSSValueAmharicAbegede = 197,
    CSSValueEthiopicAbegedeAmEt = 198,
    CSSValueCjkEarthlyBranch = 199,
    CSSValueCjkHeavenlyStem = 200,
    CSSValueEthiopic = 201,
    CSSValueEthiopicHalehameGez = 202,
    CSSValueEthiopicAbegede = 203,
    CSSValueEthiopicAbegedeGez = 204,
    CSSValueHangulConsonant = 205,
    CSSValueHangul = 206,
    CSSValueLowerNorwegian = 207,
    CSSValueOromo = 208,
    CSSValueEthiopicHalehameOmEt = 209,
    CSSValueSidama = 210,
    CSSValueEthiopicHalehameSidEt = 211,
    CSSValueSomali = 212,
    CSSValueEthiopicHalehameSoEt = 213,
    CSSValueTigre = 214,
    CSSValueEthiopicHalehameTig = 215,
    CSSValueTigrinyaEr = 216,
    CSSValueEthiopicHalehameTiEr = 217,
    CSSValueTigrinyaErAbegede = 218,
    CSSValueEthiopicAbegedeTiEr = 219,
    CSSValueTigrinyaEt = 220,
    CSSValueEthiopicHalehameTiEt = 221,
    CSSValueTigrinyaEtAbegede = 222,
    CSSValueEthiopicAbegedeTiEt = 223,
    CSSValueUpperGreek = 224,
    CSSValueUpperNorwegian = 225,
    CSSValueAsterisks = 226,
    CSSValueFootnotes = 227,
    CSSValueHebrew = 228,
    CSSValueArmenian = 229,
    CSSValueLowerArmenian = 230,
    CSSValueUpperArmenian = 231,
    CSSValueGeorgian = 232,
    CSSValueCjkIdeographic = 233,
    CSSValueHiragana = 234,
    CSSValueKatakana = 235,
    CSSValueHiraganaIroha = 236,
    CSSValueKatakanaIroha = 237,
    CSSValueInline = 238,
    CSSValueBlock = 239,
    CSSValueListItem = 240,
    CSSValueInlineBlock = 241,
    CSSValueTable = 242,
    CSSValueInlineTable = 243,
    CSSValueTableRowGroup = 244,
    CSSValueTableHeaderGroup = 245,
    CSSValueTableFooterGroup = 246,
    CSSValueTableRow = 247,
    CSSValueTableColumnGroup = 248,
    CSSValueTableColumn = 249,
    CSSValueTableCell = 250,
    CSSValueTableCaption = 251,
    CSSValueWebkitBox = 252,
    CSSValueWebkitInlineBox = 253,
    CSSValueFlex = 254,
    CSSValueInlineFlex = 255,
    CSSValueGrid = 256,
    CSSValueInlineGrid = 257,
    CSSValueWebkitFlex = 258,
    CSSValueWebkitInlineFlex = 259,
    CSSValueAuto = 260,
    CSSValueCrosshair = 261,
    CSSValueDefault = 262,
    CSSValuePointer = 263,
    CSSValueMove = 264,
    CSSValueVerticalText = 265,
    CSSValueCell = 266,
    CSSValueContextMenu = 267,
    CSSValueAlias = 268,
    CSSValueProgress = 269,
    CSSValueNoDrop = 270,
    CSSValueNotAllowed = 271,
    CSSValueZoomIn = 272,
    CSSValueZoomOut = 273,
    CSSValueEResize = 274,
    CSSValueNeResize = 275,
    CSSValueNwResize = 276,
    CSSValueNResize = 277,
    CSSValueSeResize = 278,
    CSSValueSwResize = 279,
    CSSValueSResize = 280,
    CSSValueWResize = 281,
    CSSValueEwResize = 282,
    CSSValueNsResize = 283,
    CSSValueNeswResize = 284,
    CSSValueNwseResize = 285,
    CSSValueColResize = 286,
    CSSValueRowResize = 287,
    CSSValueText = 288,
    CSSValueWait = 289,
    CSSValueHelp = 290,
    CSSValueAllScroll = 291,
    CSSValueWebkitGrab = 292,
    CSSValueWebkitGrabbing = 293,
    CSSValueWebkitZoomIn = 294,
    CSSValueWebkitZoomOut = 295,
    CSSValueLtr = 296,
    CSSValueRtl = 297,
    CSSValueCapitalize = 298,
    CSSValueUppercase = 299,
    CSSValueLowercase = 300,
    CSSValueVisible = 301,
    CSSValueCollapse = 302,
    CSSValueA3 = 303,
    CSSValueA4 = 304,
    CSSValueA5 = 305,
    CSSValueAbove = 306,
    CSSValueAbsolute = 307,
    CSSValueAlways = 308,
    CSSValueAvoid = 309,
    CSSValueB4 = 310,
    CSSValueB5 = 311,
    CSSValueBelow = 312,
    CSSValueBidiOverride = 313,
    CSSValueBlink = 314,
    CSSValueBoth = 315,
    CSSValueCloseQuote = 316,
    CSSValueEmbed = 317,
    CSSValueFixed = 318,
    CSSValueHand = 319,
    CSSValueHide = 320,
    CSSValueInvert = 321,
    CSSValueWebkitIsolate = 322,
    CSSValueWebkitIsolateOverride = 323,
    CSSValueWebkitPlaintext = 324,
    CSSValueLandscape = 325,
    CSSValueLedger = 326,
    CSSValueLegal = 327,
    CSSValueLetter = 328,
    CSSValueLineThrough = 329,
    CSSValueLocal = 330,
    CSSValueNoCloseQuote = 331,
    CSSValueNoOpenQuote = 332,
    CSSValueNowrap = 333,
    CSSValueOpenQuote = 334,
    CSSValueOverlay = 335,
    CSSValueOverline = 336,
    CSSValuePortrait = 337,
    CSSValuePre = 338,
    CSSValuePreLine = 339,
    CSSValuePreWrap = 340,
    CSSValueInternalPresence = 341,
    CSSValueRelative = 342,
    CSSValueScroll = 343,
    CSSValueSeparate = 344,
    CSSValueShow = 345,
    CSSValueStatic = 346,
    CSSValueThick = 347,
    CSSValueThin = 348,
    CSSValueUnderline = 349,
    CSSValueWavy = 350,
    CSSValueWebkitNowrap = 351,
    CSSValueStretch = 352,
    CSSValueStart = 353,
    CSSValueEnd = 354,
    CSSValueClone = 355,
    CSSValueSlice = 356,
    CSSValueReverse = 357,
    CSSValueHorizontal = 358,
    CSSValueVertical = 359,
    CSSValueInlineAxis = 360,
    CSSValueBlockAxis = 361,
    CSSValueSingle = 362,
    CSSValueMultiple = 363,
    CSSValueFlexStart = 364,
    CSSValueFlexEnd = 365,
    CSSValueSpaceBetween = 366,
    CSSValueSpaceAround = 367,
    CSSValueRow = 368,
    CSSValueRowReverse = 369,
    CSSValueColumn = 370,
    CSSValueColumnReverse = 371,
    CSSValueWrapReverse = 372,
    CSSValueForwards = 373,
    CSSValueBackwards = 374,
    CSSValueAhead = 375,
    CSSValueUp = 376,
    CSSValueDown = 377,
    CSSValueSlow = 378,
    CSSValueFast = 379,
    CSSValueInfinite = 380,
    CSSValueSlide = 381,
    CSSValueAlternate = 382,
    CSSValueReadOnly = 383,
    CSSValueReadWrite = 384,
    CSSValueReadWritePlaintextOnly = 385,
    CSSValueElement = 386,
    CSSValueIntrinsic = 387,
    CSSValueMinIntrinsic = 388,
    CSSValueWebkitMinContent = 389,
    CSSValueWebkitMaxContent = 390,
    CSSValueWebkitFillAvailable = 391,
    CSSValueWebkitFitContent = 392,
    CSSValueMinContent = 393,
    CSSValueMaxContent = 394,
    CSSValueClip = 395,
    CSSValueEllipsis = 396,
    CSSValueDiscard = 397,
    CSSValueDotDash = 398,
    CSSValueDotDotDash = 399,
    CSSValueWave = 400,
    CSSValueContinuous = 401,
    CSSValueSkipWhiteSpace = 402,
    CSSValueBreakAll = 403,
    CSSValueBreakWord = 404,
    CSSValueSpace = 405,
    CSSValueLoose = 406,
    CSSValueStrict = 407,
    CSSValueAfterWhiteSpace = 408,
    CSSValueCheckbox = 409,
    CSSValueRadio = 410,
    CSSValuePushButton = 411,
    CSSValueSquareButton = 412,
    CSSValueButton = 413,
    CSSValueButtonBevel = 414,
    CSSValueInnerSpinButton = 415,
    CSSValueListbox = 416,
    CSSValueListitem = 417,
    CSSValueMediaEnterFullscreenButton = 418,
    CSSValueMediaExitFullscreenButton = 419,
    CSSValueMediaFullscreenVolumeSlider = 420,
    CSSValueMediaFullscreenVolumeSliderThumb = 421,
    CSSValueMediaMuteButton = 422,
    CSSValueMediaPlayButton = 423,
    CSSValueMediaOverlayPlayButton = 424,
    CSSValueMediaToggleClosedCaptionsButton = 425,
    CSSValueMediaSlider = 426,
    CSSValueMediaSliderthumb = 427,
    CSSValueMediaVolumeSliderContainer = 428,
    CSSValueMediaVolumeSlider = 429,
    CSSValueMediaVolumeSliderthumb = 430,
    CSSValueMediaControlsBackground = 431,
    CSSValueMediaControlsFullscreenBackground = 432,
    CSSValueMediaCurrentTimeDisplay = 433,
    CSSValueMediaTimeRemainingDisplay = 434,
    CSSValueMenulist = 435,
    CSSValueMenulistButton = 436,
    CSSValueMenulistText = 437,
    CSSValueMenulistTextfield = 438,
    CSSValueMeter = 439,
    CSSValueProgressBar = 440,
    CSSValueProgressBarValue = 441,
    CSSValueSliderHorizontal = 442,
    CSSValueSliderVertical = 443,
    CSSValueSliderthumbHorizontal = 444,
    CSSValueSliderthumbVertical = 445,
    CSSValueCaret = 446,
    CSSValueSearchfield = 447,
    CSSValueSearchfieldDecoration = 448,
    CSSValueSearchfieldResultsDecoration = 449,
    CSSValueSearchfieldCancelButton = 450,
    CSSValueTextfield = 451,
    CSSValueRelevancyLevelIndicator = 452,
    CSSValueContinuousCapacityLevelIndicator = 453,
    CSSValueDiscreteCapacityLevelIndicator = 454,
    CSSValueRatingLevelIndicator = 455,
    CSSValueTextarea = 456,
    CSSValueCapsLockIndicator = 457,
    CSSValueRound = 458,
    CSSValueBorder = 459,
    CSSValueBorderBox = 460,
    CSSValueContent = 461,
    CSSValueContentBox = 462,
    CSSValuePadding = 463,
    CSSValuePaddingBox = 464,
    CSSValueMarginBox = 465,
    CSSValueContain = 466,
    CSSValueCover = 467,
    CSSValueLogical = 468,
    CSSValueVisual = 469,
    CSSValueLines = 470,
    CSSValueAlternateReverse = 471,
    CSSValueRunning = 472,
    CSSValuePaused = 473,
    CSSValueFlat = 474,
    CSSValuePreserve3d = 475,
    CSSValueEase = 476,
    CSSValueLinear = 477,
    CSSValueEaseIn = 478,
    CSSValueEaseOut = 479,
    CSSValueEaseInOut = 480,
    CSSValueStepStart = 481,
    CSSValueStepMiddle = 482,
    CSSValueStepEnd = 483,
    CSSValueDocument = 484,
    CSSValueReset = 485,
    CSSValueZoom = 486,
    CSSValueVisiblepainted = 487,
    CSSValueVisiblefill = 488,
    CSSValueVisiblestroke = 489,
    CSSValuePainted = 490,
    CSSValueFill = 491,
    CSSValueStroke = 492,
    CSSValueBoundingBox = 493,
    CSSValueSpellOut = 494,
    CSSValueDigits = 495,
    CSSValueLiteralPunctuation = 496,
    CSSValueNoPunctuation = 497,
    CSSValueAntialiased = 498,
    CSSValueSubpixelAntialiased = 499,
    CSSValueOptimizespeed = 500,
    CSSValueOptimizelegibility = 501,
    CSSValueGeometricprecision = 502,
    CSSValueEconomy = 503,
    CSSValueExact = 504,
    CSSValueLr = 505,
    CSSValueRl = 506,
    CSSValueTb = 507,
    CSSValueLrTb = 508,
    CSSValueRlTb = 509,
    CSSValueTbRl = 510,
    CSSValueHorizontalTb = 511,
    CSSValueVerticalRl = 512,
    CSSValueVerticalLr = 513,
    CSSValueHorizontalBt = 514,
    CSSValueAfter = 515,
    CSSValueBefore = 516,
    CSSValueOver = 517,
    CSSValueUnder = 518,
    CSSValueFilled = 519,
    CSSValueOpen = 520,
    CSSValueDot = 521,
    CSSValueDoubleCircle = 522,
    CSSValueTriangle = 523,
    CSSValueSesame = 524,
    CSSValueEllipse = 525,
    CSSValueClosestSide = 526,
    CSSValueClosestCorner = 527,
    CSSValueFarthestSide = 528,
    CSSValueFarthestCorner = 529,
    CSSValueSideways = 530,
    CSSValueSidewaysRight = 531,
    CSSValueUpright = 532,
    CSSValueVerticalRight = 533,
    CSSValueFont = 534,
    CSSValueGlyphs = 535,
    CSSValueInlineBox = 536,
    CSSValueReplaced = 537,
    CSSValueOn = 538,
    CSSValueOff = 539,
    CSSValueOptimizequality = 540,
    CSSValueWebkitOptimizeContrast = 541,
    CSSValueNonzero = 542,
    CSSValueEvenodd = 543,
    CSSValueAt = 544,
    CSSValueMaximum = 545,
    CSSValueWrap = 546,
    CSSValueAlphabetic = 547,
    CSSValueSticky = 548,
    CSSValueCoarse = 549,
    CSSValueFine = 550,
    CSSValueMultiply = 551,
    CSSValueScreen = 552,
    CSSValueDarken = 553,
    CSSValueLighten = 554,
    CSSValueColorDodge = 555,
    CSSValueColorBurn = 556,
    CSSValueHardLight = 557,
    CSSValueSoftLight = 558,
    CSSValueDifference = 559,
    CSSValueExclusion = 560,
    CSSValueHue = 561,
    CSSValueSaturation = 562,
    CSSValueColor = 563,
    CSSValueLuminosity = 564,
    CSSValueScaleDown = 565,
    CSSValueBalance = 566,
    CSSValueWebkitPagedX = 567,
    CSSValueWebkitPagedY = 568,
    CSSValueDrag = 569,
    CSSValueNoDrag = 570,
    CSSValueSpan = 571,
    CSSValueEachLine = 572,
    CSSValueProgressive = 573,
    CSSValueInterlace = 574,
    CSSValueMarkers = 575,
    CSSValueInternalExtendToZoom = 576,
    CSSValueIsolate = 577,
    CSSValueScript = 578,
    CSSValuePanX = 579,
    CSSValuePanY = 580,
    CSSValueManipulation = 581,
    CSSValueSelfStart = 582,
    CSSValueSelfEnd = 583,
    CSSValueTrue = 584,
    CSSValueSafe = 585,
    CSSValueInstant = 586,
    CSSValueSmooth = 587,
    CSSValueContents = 588,
    CSSValueScrollPosition = 589,
    CSSValueUnset = 590,
    CSSValueAliceblue = 591,
    CSSValueAlpha = 592,
    CSSValueAntiquewhite = 593,
    CSSValueAquamarine = 594,
    CSSValueAzure = 595,
    CSSValueBeige = 596,
    CSSValueBisque = 597,
    CSSValueBlanchedalmond = 598,
    CSSValueBlueviolet = 599,
    CSSValueBrown = 600,
    CSSValueBurlywood = 601,
    CSSValueCadetblue = 602,
    CSSValueChartreuse = 603,
    CSSValueChocolate = 604,
    CSSValueCoral = 605,
    CSSValueCornflowerblue = 606,
    CSSValueCornsilk = 607,
    CSSValueCrimson = 608,
    CSSValueCyan = 609,
    CSSValueDarkblue = 610,
    CSSValueDarkcyan = 611,
    CSSValueDarkgoldenrod = 612,
    CSSValueDarkgray = 613,
    CSSValueDarkgreen = 614,
    CSSValueDarkgrey = 615,
    CSSValueDarkkhaki = 616,
    CSSValueDarkmagenta = 617,
    CSSValueDarkolivegreen = 618,
    CSSValueDarkorange = 619,
    CSSValueDarkorchid = 620,
    CSSValueDarkred = 621,
    CSSValueDarksalmon = 622,
    CSSValueDarkseagreen = 623,
    CSSValueDarkslateblue = 624,
    CSSValueDarkslategray = 625,
    CSSValueDarkslategrey = 626,
    CSSValueDarkturquoise = 627,
    CSSValueDarkviolet = 628,
    CSSValueDeeppink = 629,
    CSSValueDeepskyblue = 630,
    CSSValueDimgray = 631,
    CSSValueDimgrey = 632,
    CSSValueDodgerblue = 633,
    CSSValueFirebrick = 634,
    CSSValueFloralwhite = 635,
    CSSValueForestgreen = 636,
    CSSValueGainsboro = 637,
    CSSValueGhostwhite = 638,
    CSSValueGold = 639,
    CSSValueGoldenrod = 640,
    CSSValueGreenyellow = 641,
    CSSValueHoneydew = 642,
    CSSValueHotpink = 643,
    CSSValueIndianred = 644,
    CSSValueIndigo = 645,
    CSSValueIvory = 646,
    CSSValueKhaki = 647,
    CSSValueLavender = 648,
    CSSValueLavenderblush = 649,
    CSSValueLawngreen = 650,
    CSSValueLemonchiffon = 651,
    CSSValueLightblue = 652,
    CSSValueLightcoral = 653,
    CSSValueLightcyan = 654,
    CSSValueLightgoldenrodyellow = 655,
    CSSValueLightgray = 656,
    CSSValueLightgreen = 657,
    CSSValueLightgrey = 658,
    CSSValueLightpink = 659,
    CSSValueLightsalmon = 660,
    CSSValueLightseagreen = 661,
    CSSValueLightskyblue = 662,
    CSSValueLightslategray = 663,
    CSSValueLightslategrey = 664,
    CSSValueLightsteelblue = 665,
    CSSValueLightyellow = 666,
    CSSValueLimegreen = 667,
    CSSValueLinen = 668,
    CSSValueLuminance = 669,
    CSSValueMagenta = 670,
    CSSValueMediumaquamarine = 671,
    CSSValueMediumblue = 672,
    CSSValueMediumorchid = 673,
    CSSValueMediumpurple = 674,
    CSSValueMediumseagreen = 675,
    CSSValueMediumslateblue = 676,
    CSSValueMediumspringgreen = 677,
    CSSValueMediumturquoise = 678,
    CSSValueMediumvioletred = 679,
    CSSValueMidnightblue = 680,
    CSSValueMintcream = 681,
    CSSValueMistyrose = 682,
    CSSValueMoccasin = 683,
    CSSValueNavajowhite = 684,
    CSSValueOldlace = 685,
    CSSValueOlivedrab = 686,
    CSSValueOrangered = 687,
    CSSValueOrchid = 688,
    CSSValuePalegoldenrod = 689,
    CSSValuePalegreen = 690,
    CSSValuePaleturquoise = 691,
    CSSValuePalevioletred = 692,
    CSSValuePapayawhip = 693,
    CSSValuePeachpuff = 694,
    CSSValuePeru = 695,
    CSSValuePink = 696,
    CSSValuePlum = 697,
    CSSValuePowderblue = 698,
    CSSValueRosybrown = 699,
    CSSValueRoyalblue = 700,
    CSSValueSaddlebrown = 701,
    CSSValueSalmon = 702,
    CSSValueSandybrown = 703,
    CSSValueSeagreen = 704,
    CSSValueSeashell = 705,
    CSSValueSienna = 706,
    CSSValueSkyblue = 707,
    CSSValueSlateblue = 708,
    CSSValueSlategray = 709,
    CSSValueSlategrey = 710,
    CSSValueSnow = 711,
    CSSValueSpringgreen = 712,
    CSSValueSteelblue = 713,
    CSSValueTan = 714,
    CSSValueThistle = 715,
    CSSValueTomato = 716,
    CSSValueTurquoise = 717,
    CSSValueViolet = 718,
    CSSValueWheat = 719,
    CSSValueWhitesmoke = 720,
    CSSValueYellowgreen = 721,
    CSSValueAccumulate = 722,
    CSSValueNew = 723,
    CSSValueSrgb = 724,
    CSSValueLinearrgb = 725,
    CSSValueCrispedges = 726,
    CSSValueButt = 727,
    CSSValueMiter = 728,
    CSSValueBevel = 729,
    CSSValueBeforeEdge = 730,
    CSSValueAfterEdge = 731,
    CSSValueCentral = 732,
    CSSValueTextBeforeEdge = 733,
    CSSValueTextAfterEdge = 734,
    CSSValueIdeographic = 735,
    CSSValueHanging = 736,
    CSSValueMathematical = 737,
    CSSValueUseScript = 738,
    CSSValueNoChange = 739,
    CSSValueResetSize = 740,
    CSSValueDynamic = 741,
    CSSValueNonScalingStroke = 742,
};

const int numCSSValueKeywords = 743;
const size_t maxCSSValueKeywordLength = 42;

const char* getValueName(unsigned short id);
bool isValueAllowedInMode(unsigned short id, CSSParserMode mode);

} // namespace WebCore

#endif // CSSValueKeywords_h
