
// Copyright (c) 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CSSPropertyNames_h
#define CSSPropertyNames_h

#include "core/css/CSSParserMode.h"
#include "wtf/HashFunctions.h"
#include "wtf/HashTraits.h"
#include <string.h>

namespace WTF {
class AtomicString;
class String;
}

namespace WebCore {

enum CSSPropertyID {
    CSSPropertyInvalid = 0,
    CSSPropertyDisplay = 1,
    CSSPropertyWebkitAnimation = 2,
    CSSPropertyWebkitAnimationDelay = 3,
    CSSPropertyWebkitAnimationDirection = 4,
    CSSPropertyWebkitAnimationDuration = 5,
    CSSPropertyWebkitAnimationFillMode = 6,
    CSSPropertyWebkitAnimationIterationCount = 7,
    CSSPropertyWebkitAnimationName = 8,
    CSSPropertyWebkitAnimationPlayState = 9,
    CSSPropertyWebkitAnimationTimingFunction = 10,
    CSSPropertyAnimation = 11,
    CSSPropertyAnimationDelay = 12,
    CSSPropertyAnimationDirection = 13,
    CSSPropertyAnimationDuration = 14,
    CSSPropertyAnimationFillMode = 15,
    CSSPropertyAnimationIterationCount = 16,
    CSSPropertyAnimationName = 17,
    CSSPropertyAnimationPlayState = 18,
    CSSPropertyAnimationTimingFunction = 19,
    CSSPropertyWebkitTransition = 20,
    CSSPropertyWebkitTransitionDelay = 21,
    CSSPropertyWebkitTransitionDuration = 22,
    CSSPropertyWebkitTransitionProperty = 23,
    CSSPropertyWebkitTransitionTimingFunction = 24,
    CSSPropertyTransition = 25,
    CSSPropertyTransitionDelay = 26,
    CSSPropertyTransitionDuration = 27,
    CSSPropertyTransitionProperty = 28,
    CSSPropertyTransitionTimingFunction = 29,
    CSSPropertyColor = 30,
    CSSPropertyDirection = 31,
    CSSPropertyFont = 32,
    CSSPropertyFontFamily = 33,
    CSSPropertyFontKerning = 34,
    CSSPropertyFontSize = 35,
    CSSPropertyFontStyle = 36,
    CSSPropertyFontVariant = 37,
    CSSPropertyFontVariantLigatures = 38,
    CSSPropertyFontWeight = 39,
    CSSPropertyTextRendering = 40,
    CSSPropertyWebkitFontFeatureSettings = 41,
    CSSPropertyWebkitFontSmoothing = 42,
    CSSPropertyWebkitLocale = 43,
    CSSPropertyWebkitTextOrientation = 44,
    CSSPropertyWebkitWritingMode = 45,
    CSSPropertyZoom = 46,
    CSSPropertyLineHeight = 47,
    CSSPropertyBackground = 48,
    CSSPropertyBackgroundAttachment = 49,
    CSSPropertyBackgroundBlendMode = 50,
    CSSPropertyBackgroundClip = 51,
    CSSPropertyBackgroundColor = 52,
    CSSPropertyBackgroundImage = 53,
    CSSPropertyBackgroundOrigin = 54,
    CSSPropertyBackgroundPosition = 55,
    CSSPropertyBackgroundPositionX = 56,
    CSSPropertyBackgroundPositionY = 57,
    CSSPropertyBackgroundRepeat = 58,
    CSSPropertyBackgroundRepeatX = 59,
    CSSPropertyBackgroundRepeatY = 60,
    CSSPropertyBackgroundSize = 61,
    CSSPropertyBorder = 62,
    CSSPropertyBorderBottom = 63,
    CSSPropertyBorderBottomColor = 64,
    CSSPropertyBorderBottomLeftRadius = 65,
    CSSPropertyBorderBottomRightRadius = 66,
    CSSPropertyBorderBottomStyle = 67,
    CSSPropertyBorderBottomWidth = 68,
    CSSPropertyBorderCollapse = 69,
    CSSPropertyBorderColor = 70,
    CSSPropertyBorderImage = 71,
    CSSPropertyBorderImageOutset = 72,
    CSSPropertyBorderImageRepeat = 73,
    CSSPropertyBorderImageSlice = 74,
    CSSPropertyBorderImageSource = 75,
    CSSPropertyBorderImageWidth = 76,
    CSSPropertyBorderLeft = 77,
    CSSPropertyBorderLeftColor = 78,
    CSSPropertyBorderLeftStyle = 79,
    CSSPropertyBorderLeftWidth = 80,
    CSSPropertyBorderRadius = 81,
    CSSPropertyBorderRight = 82,
    CSSPropertyBorderRightColor = 83,
    CSSPropertyBorderRightStyle = 84,
    CSSPropertyBorderRightWidth = 85,
    CSSPropertyBorderSpacing = 86,
    CSSPropertyBorderStyle = 87,
    CSSPropertyBorderTop = 88,
    CSSPropertyBorderTopColor = 89,
    CSSPropertyBorderTopLeftRadius = 90,
    CSSPropertyBorderTopRightRadius = 91,
    CSSPropertyBorderTopStyle = 92,
    CSSPropertyBorderTopWidth = 93,
    CSSPropertyBorderWidth = 94,
    CSSPropertyBottom = 95,
    CSSPropertyBoxShadow = 96,
    CSSPropertyBoxSizing = 97,
    CSSPropertyCaptionSide = 98,
    CSSPropertyClear = 99,
    CSSPropertyClip = 100,
    CSSPropertyWebkitClipPath = 101,
    CSSPropertyContent = 102,
    CSSPropertyCounterIncrement = 103,
    CSSPropertyCounterReset = 104,
    CSSPropertyCursor = 105,
    CSSPropertyEmptyCells = 106,
    CSSPropertyFloat = 107,
    CSSPropertyFontStretch = 108,
    CSSPropertyHeight = 109,
    CSSPropertyImageRendering = 110,
    CSSPropertyIsolation = 111,
    CSSPropertyJustifySelf = 112,
    CSSPropertyLeft = 113,
    CSSPropertyLetterSpacing = 114,
    CSSPropertyListStyle = 115,
    CSSPropertyListStyleImage = 116,
    CSSPropertyListStylePosition = 117,
    CSSPropertyListStyleType = 118,
    CSSPropertyMargin = 119,
    CSSPropertyMarginBottom = 120,
    CSSPropertyMarginLeft = 121,
    CSSPropertyMarginRight = 122,
    CSSPropertyMarginTop = 123,
    CSSPropertyMaskSourceType = 124,
    CSSPropertyMaxHeight = 125,
    CSSPropertyMaxWidth = 126,
    CSSPropertyMinHeight = 127,
    CSSPropertyMinWidth = 128,
    CSSPropertyMixBlendMode = 129,
    CSSPropertyOpacity = 130,
    CSSPropertyOrphans = 131,
    CSSPropertyOutline = 132,
    CSSPropertyOutlineColor = 133,
    CSSPropertyOutlineOffset = 134,
    CSSPropertyOutlineStyle = 135,
    CSSPropertyOutlineWidth = 136,
    CSSPropertyObjectFit = 137,
    CSSPropertyObjectPosition = 138,
    CSSPropertyOverflow = 139,
    CSSPropertyOverflowWrap = 140,
    CSSPropertyOverflowX = 141,
    CSSPropertyOverflowY = 142,
    CSSPropertyPadding = 143,
    CSSPropertyPaddingBottom = 144,
    CSSPropertyPaddingLeft = 145,
    CSSPropertyPaddingRight = 146,
    CSSPropertyPaddingTop = 147,
    CSSPropertyPage = 148,
    CSSPropertyPageBreakAfter = 149,
    CSSPropertyPageBreakBefore = 150,
    CSSPropertyPageBreakInside = 151,
    CSSPropertyPointerEvents = 152,
    CSSPropertyPosition = 153,
    CSSPropertyQuotes = 154,
    CSSPropertyResize = 155,
    CSSPropertyRight = 156,
    CSSPropertyScrollBehavior = 157,
    CSSPropertySize = 158,
    CSSPropertySrc = 159,
    CSSPropertySpeak = 160,
    CSSPropertyTableLayout = 161,
    CSSPropertyTabSize = 162,
    CSSPropertyTextAlign = 163,
    CSSPropertyTextAlignLast = 164,
    CSSPropertyTextDecoration = 165,
    CSSPropertyTextDecorationLine = 166,
    CSSPropertyTextDecorationStyle = 167,
    CSSPropertyTextDecorationColor = 168,
    CSSPropertyTextIndent = 169,
    CSSPropertyTextJustify = 170,
    CSSPropertyTextLineThroughColor = 171,
    CSSPropertyTextLineThroughMode = 172,
    CSSPropertyTextLineThroughStyle = 173,
    CSSPropertyTextLineThroughWidth = 174,
    CSSPropertyTextOverflow = 175,
    CSSPropertyTextOverlineColor = 176,
    CSSPropertyTextOverlineMode = 177,
    CSSPropertyTextOverlineStyle = 178,
    CSSPropertyTextOverlineWidth = 179,
    CSSPropertyTextShadow = 180,
    CSSPropertyTextTransform = 181,
    CSSPropertyTextUnderlineColor = 182,
    CSSPropertyTextUnderlineMode = 183,
    CSSPropertyTextUnderlineStyle = 184,
    CSSPropertyTextUnderlineWidth = 185,
    CSSPropertyTextUnderlinePosition = 186,
    CSSPropertyTop = 187,
    CSSPropertyTouchAction = 188,
    CSSPropertyTouchActionDelay = 189,
    CSSPropertyUnicodeBidi = 190,
    CSSPropertyUnicodeRange = 191,
    CSSPropertyVerticalAlign = 192,
    CSSPropertyVisibility = 193,
    CSSPropertyWhiteSpace = 194,
    CSSPropertyWidows = 195,
    CSSPropertyWidth = 196,
    CSSPropertyWillChange = 197,
    CSSPropertyWordBreak = 198,
    CSSPropertyWordSpacing = 199,
    CSSPropertyWordWrap = 200,
    CSSPropertyZIndex = 201,
    CSSPropertyWebkitAppearance = 202,
    CSSPropertyWebkitAspectRatio = 203,
    CSSPropertyBackfaceVisibility = 204,
    CSSPropertyWebkitBackfaceVisibility = 205,
    CSSPropertyWebkitBackgroundClip = 206,
    CSSPropertyWebkitBackgroundComposite = 207,
    CSSPropertyWebkitBackgroundOrigin = 208,
    CSSPropertyWebkitBackgroundSize = 209,
    CSSPropertyWebkitBorderAfter = 210,
    CSSPropertyWebkitBorderAfterColor = 211,
    CSSPropertyWebkitBorderAfterStyle = 212,
    CSSPropertyWebkitBorderAfterWidth = 213,
    CSSPropertyWebkitBorderBefore = 214,
    CSSPropertyWebkitBorderBeforeColor = 215,
    CSSPropertyWebkitBorderBeforeStyle = 216,
    CSSPropertyWebkitBorderBeforeWidth = 217,
    CSSPropertyWebkitBorderEnd = 218,
    CSSPropertyWebkitBorderEndColor = 219,
    CSSPropertyWebkitBorderEndStyle = 220,
    CSSPropertyWebkitBorderEndWidth = 221,
    CSSPropertyWebkitBorderFit = 222,
    CSSPropertyWebkitBorderHorizontalSpacing = 223,
    CSSPropertyWebkitBorderImage = 224,
    CSSPropertyWebkitBorderRadius = 225,
    CSSPropertyWebkitBorderStart = 226,
    CSSPropertyWebkitBorderStartColor = 227,
    CSSPropertyWebkitBorderStartStyle = 228,
    CSSPropertyWebkitBorderStartWidth = 229,
    CSSPropertyWebkitBorderVerticalSpacing = 230,
    CSSPropertyWebkitBoxAlign = 231,
    CSSPropertyWebkitBoxDirection = 232,
    CSSPropertyWebkitBoxFlex = 233,
    CSSPropertyWebkitBoxFlexGroup = 234,
    CSSPropertyWebkitBoxLines = 235,
    CSSPropertyWebkitBoxOrdinalGroup = 236,
    CSSPropertyWebkitBoxOrient = 237,
    CSSPropertyWebkitBoxPack = 238,
    CSSPropertyWebkitBoxReflect = 239,
    CSSPropertyWebkitBoxShadow = 240,
    CSSPropertyInternalCallback = 241,
    CSSPropertyWebkitColumnBreakAfter = 242,
    CSSPropertyWebkitColumnBreakBefore = 243,
    CSSPropertyWebkitColumnBreakInside = 244,
    CSSPropertyWebkitColumnCount = 245,
    CSSPropertyColumnFill = 246,
    CSSPropertyWebkitColumnGap = 247,
    CSSPropertyWebkitColumnRule = 248,
    CSSPropertyWebkitColumnRuleColor = 249,
    CSSPropertyWebkitColumnRuleStyle = 250,
    CSSPropertyWebkitColumnRuleWidth = 251,
    CSSPropertyWebkitColumnSpan = 252,
    CSSPropertyWebkitColumnWidth = 253,
    CSSPropertyWebkitColumns = 254,
    CSSPropertyWebkitBoxDecorationBreak = 255,
    CSSPropertyWebkitFilter = 256,
    CSSPropertyAlignContent = 257,
    CSSPropertyAlignItems = 258,
    CSSPropertyAlignSelf = 259,
    CSSPropertyFlex = 260,
    CSSPropertyFlexBasis = 261,
    CSSPropertyFlexDirection = 262,
    CSSPropertyFlexFlow = 263,
    CSSPropertyFlexGrow = 264,
    CSSPropertyFlexShrink = 265,
    CSSPropertyFlexWrap = 266,
    CSSPropertyJustifyContent = 267,
    CSSPropertyWebkitFontSizeDelta = 268,
    CSSPropertyGridAutoColumns = 269,
    CSSPropertyGridAutoFlow = 270,
    CSSPropertyGridAutoRows = 271,
    CSSPropertyGridArea = 272,
    CSSPropertyGridColumn = 273,
    CSSPropertyGridColumnEnd = 274,
    CSSPropertyGridColumnStart = 275,
    CSSPropertyGrid = 276,
    CSSPropertyGridTemplate = 277,
    CSSPropertyGridTemplateColumns = 278,
    CSSPropertyGridTemplateRows = 279,
    CSSPropertyGridRow = 280,
    CSSPropertyGridRowEnd = 281,
    CSSPropertyGridRowStart = 282,
    CSSPropertyGridTemplateAreas = 283,
    CSSPropertyWebkitHighlight = 284,
    CSSPropertyWebkitHyphenateCharacter = 285,
    CSSPropertyWebkitLineBoxContain = 286,
    CSSPropertyWebkitLineBreak = 287,
    CSSPropertyWebkitLineClamp = 288,
    CSSPropertyWebkitLogicalWidth = 289,
    CSSPropertyWebkitLogicalHeight = 290,
    CSSPropertyWebkitMarginAfterCollapse = 291,
    CSSPropertyWebkitMarginBeforeCollapse = 292,
    CSSPropertyWebkitMarginBottomCollapse = 293,
    CSSPropertyWebkitMarginTopCollapse = 294,
    CSSPropertyWebkitMarginCollapse = 295,
    CSSPropertyWebkitMarginAfter = 296,
    CSSPropertyWebkitMarginBefore = 297,
    CSSPropertyWebkitMarginEnd = 298,
    CSSPropertyWebkitMarginStart = 299,
    CSSPropertyWebkitMask = 300,
    CSSPropertyWebkitMaskBoxImage = 301,
    CSSPropertyWebkitMaskBoxImageOutset = 302,
    CSSPropertyWebkitMaskBoxImageRepeat = 303,
    CSSPropertyWebkitMaskBoxImageSlice = 304,
    CSSPropertyWebkitMaskBoxImageSource = 305,
    CSSPropertyWebkitMaskBoxImageWidth = 306,
    CSSPropertyWebkitMaskClip = 307,
    CSSPropertyWebkitMaskComposite = 308,
    CSSPropertyWebkitMaskImage = 309,
    CSSPropertyWebkitMaskOrigin = 310,
    CSSPropertyWebkitMaskPosition = 311,
    CSSPropertyWebkitMaskPositionX = 312,
    CSSPropertyWebkitMaskPositionY = 313,
    CSSPropertyWebkitMaskRepeat = 314,
    CSSPropertyWebkitMaskRepeatX = 315,
    CSSPropertyWebkitMaskRepeatY = 316,
    CSSPropertyWebkitMaskSize = 317,
    CSSPropertyWebkitMaxLogicalWidth = 318,
    CSSPropertyWebkitMaxLogicalHeight = 319,
    CSSPropertyWebkitMinLogicalWidth = 320,
    CSSPropertyWebkitMinLogicalHeight = 321,
    CSSPropertyOrder = 322,
    CSSPropertyWebkitPaddingAfter = 323,
    CSSPropertyWebkitPaddingBefore = 324,
    CSSPropertyWebkitPaddingEnd = 325,
    CSSPropertyWebkitPaddingStart = 326,
    CSSPropertyPerspective = 327,
    CSSPropertyWebkitPerspective = 328,
    CSSPropertyPerspectiveOrigin = 329,
    CSSPropertyWebkitPerspectiveOrigin = 330,
    CSSPropertyWebkitPerspectiveOriginX = 331,
    CSSPropertyWebkitPerspectiveOriginY = 332,
    CSSPropertyWebkitPrintColorAdjust = 333,
    CSSPropertyWebkitRtlOrdering = 334,
    CSSPropertyWebkitRubyPosition = 335,
    CSSPropertyWebkitTextCombine = 336,
    CSSPropertyWebkitTextDecorationsInEffect = 337,
    CSSPropertyWebkitTextEmphasis = 338,
    CSSPropertyWebkitTextEmphasisColor = 339,
    CSSPropertyWebkitTextEmphasisPosition = 340,
    CSSPropertyWebkitTextEmphasisStyle = 341,
    CSSPropertyWebkitTextFillColor = 342,
    CSSPropertyWebkitTextSecurity = 343,
    CSSPropertyWebkitTextStroke = 344,
    CSSPropertyWebkitTextStrokeColor = 345,
    CSSPropertyWebkitTextStrokeWidth = 346,
    CSSPropertyTransform = 347,
    CSSPropertyWebkitTransform = 348,
    CSSPropertyTransformOrigin = 349,
    CSSPropertyWebkitTransformOrigin = 350,
    CSSPropertyWebkitTransformOriginX = 351,
    CSSPropertyWebkitTransformOriginY = 352,
    CSSPropertyWebkitTransformOriginZ = 353,
    CSSPropertyTransformStyle = 354,
    CSSPropertyWebkitTransformStyle = 355,
    CSSPropertyWebkitUserDrag = 356,
    CSSPropertyWebkitUserModify = 357,
    CSSPropertyWebkitUserSelect = 358,
    CSSPropertyShapeOutside = 359,
    CSSPropertyShapeMargin = 360,
    CSSPropertyShapeImageThreshold = 361,
    CSSPropertyWebkitWrapFlow = 362,
    CSSPropertyWebkitWrapThrough = 363,
    CSSPropertyMaxZoom = 364,
    CSSPropertyMinZoom = 365,
    CSSPropertyOrientation = 366,
    CSSPropertyUserZoom = 367,
    CSSPropertyWebkitTapHighlightColor = 368,
    CSSPropertyWebkitAppRegion = 369,
    CSSPropertyAll = 370,
    CSSPropertyInternalMarqueeDirection = 371,
    CSSPropertyInternalMarqueeIncrement = 372,
    CSSPropertyInternalMarqueeRepetition = 373,
    CSSPropertyInternalMarqueeSpeed = 374,
    CSSPropertyInternalMarqueeStyle = 375,
    CSSPropertyBufferedRendering = 376,
    CSSPropertyClipPath = 377,
    CSSPropertyClipRule = 378,
    CSSPropertyMask = 379,
    CSSPropertyEnableBackground = 380,
    CSSPropertyFilter = 381,
    CSSPropertyFloodColor = 382,
    CSSPropertyFloodOpacity = 383,
    CSSPropertyLightingColor = 384,
    CSSPropertyStopColor = 385,
    CSSPropertyStopOpacity = 386,
    CSSPropertyColorInterpolation = 387,
    CSSPropertyColorInterpolationFilters = 388,
    CSSPropertyColorRendering = 389,
    CSSPropertyFill = 390,
    CSSPropertyFillOpacity = 391,
    CSSPropertyFillRule = 392,
    CSSPropertyMarker = 393,
    CSSPropertyMarkerEnd = 394,
    CSSPropertyMarkerMid = 395,
    CSSPropertyMarkerStart = 396,
    CSSPropertyMaskType = 397,
    CSSPropertyShapeRendering = 398,
    CSSPropertyStroke = 399,
    CSSPropertyStrokeDasharray = 400,
    CSSPropertyStrokeDashoffset = 401,
    CSSPropertyStrokeLinecap = 402,
    CSSPropertyStrokeLinejoin = 403,
    CSSPropertyStrokeMiterlimit = 404,
    CSSPropertyStrokeOpacity = 405,
    CSSPropertyStrokeWidth = 406,
    CSSPropertyAlignmentBaseline = 407,
    CSSPropertyBaselineShift = 408,
    CSSPropertyDominantBaseline = 409,
    CSSPropertyGlyphOrientationHorizontal = 410,
    CSSPropertyGlyphOrientationVertical = 411,
    CSSPropertyTextAnchor = 412,
    CSSPropertyVectorEffect = 413,
    CSSPropertyWritingMode = 414,
    CSSPropertyPaintOrder = 415,
};

const int firstCSSProperty = 1;
const int numCSSProperties = 415;
const int lastCSSProperty = 415;
const size_t maxCSSPropertyNameLength = 34;

const char* getPropertyName(CSSPropertyID);
const WTF::AtomicString& getPropertyNameAtomicString(CSSPropertyID);
WTF::String getPropertyNameString(CSSPropertyID);
WTF::String getJSPropertyName(CSSPropertyID);
bool isInternalProperty(CSSPropertyID id);

inline CSSPropertyID convertToCSSPropertyID(int value)
{
    ASSERT((value >= firstCSSProperty && value <= lastCSSProperty) || value == CSSPropertyInvalid);
    return static_cast<CSSPropertyID>(value);
}

} // namespace WebCore

namespace WTF {
template<> struct DefaultHash<WebCore::CSSPropertyID> { typedef IntHash<unsigned> Hash; };
template<> struct HashTraits<WebCore::CSSPropertyID> : GenericHashTraits<WebCore::CSSPropertyID> {
    static const bool emptyValueIsZero = true;
    static const bool needsDestruction = false;
    static void constructDeletedValue(WebCore::CSSPropertyID& slot) { slot = static_cast<WebCore::CSSPropertyID>(WebCore::lastCSSProperty + 1); }
    static bool isDeletedValue(WebCore::CSSPropertyID value) { return value == (WebCore::lastCSSProperty + 1); }
};
}

#endif // CSSPropertyNames_h
