// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file has been auto-generated by code_generator_v8.py. DO NOT MODIFY!

#ifndef V8WebGLRenderingContext_h
#define V8WebGLRenderingContext_h

#include "bindings/v8/V8Binding.h"
#include "bindings/v8/V8DOMWrapper.h"
#include "bindings/v8/WrapperTypeInfo.h"
#include "core/html/canvas/WebGLRenderingContext.h"
#include "platform/heap/Handle.h"

namespace WebCore {

class V8WebGLRenderingContext {
public:
    static bool hasInstance(v8::Handle<v8::Value>, v8::Isolate*);
    static v8::Handle<v8::Object> findInstanceInPrototypeChain(v8::Handle<v8::Value>, v8::Isolate*);
    static v8::Handle<v8::FunctionTemplate> domTemplate(v8::Isolate*);
    static WebGLRenderingContext* toNative(v8::Handle<v8::Object> object)
    {
        return fromInternalPointer(object->GetAlignedPointerFromInternalField(v8DOMWrapperObjectIndex));
    }
    static WebGLRenderingContext* toNativeWithTypeCheck(v8::Isolate*, v8::Handle<v8::Value>);
    static const WrapperTypeInfo wrapperTypeInfo;
    static void derefObject(void*);
    static void getAttachedShadersMethodCustom(const v8::FunctionCallbackInfo<v8::Value>&);
    static void getBufferParameterMethodCustom(const v8::FunctionCallbackInfo<v8::Value>&);
    static void getExtensionMethodCustom(const v8::FunctionCallbackInfo<v8::Value>&);
    static void getFramebufferAttachmentParameterMethodCustom(const v8::FunctionCallbackInfo<v8::Value>&);
    static void getParameterMethodCustom(const v8::FunctionCallbackInfo<v8::Value>&);
    static void getProgramParameterMethodCustom(const v8::FunctionCallbackInfo<v8::Value>&);
    static void getRenderbufferParameterMethodCustom(const v8::FunctionCallbackInfo<v8::Value>&);
    static void getShaderParameterMethodCustom(const v8::FunctionCallbackInfo<v8::Value>&);
    static void getSupportedExtensionsMethodCustom(const v8::FunctionCallbackInfo<v8::Value>&);
    static void getTexParameterMethodCustom(const v8::FunctionCallbackInfo<v8::Value>&);
    static void getUniformMethodCustom(const v8::FunctionCallbackInfo<v8::Value>&);
    static void getVertexAttribMethodCustom(const v8::FunctionCallbackInfo<v8::Value>&);
    static void uniform1fvMethodCustom(const v8::FunctionCallbackInfo<v8::Value>&);
    static void uniform1ivMethodCustom(const v8::FunctionCallbackInfo<v8::Value>&);
    static void uniform2fvMethodCustom(const v8::FunctionCallbackInfo<v8::Value>&);
    static void uniform2ivMethodCustom(const v8::FunctionCallbackInfo<v8::Value>&);
    static void uniform3fvMethodCustom(const v8::FunctionCallbackInfo<v8::Value>&);
    static void uniform3ivMethodCustom(const v8::FunctionCallbackInfo<v8::Value>&);
    static void uniform4fvMethodCustom(const v8::FunctionCallbackInfo<v8::Value>&);
    static void uniform4ivMethodCustom(const v8::FunctionCallbackInfo<v8::Value>&);
    static void uniformMatrix2fvMethodCustom(const v8::FunctionCallbackInfo<v8::Value>&);
    static void uniformMatrix3fvMethodCustom(const v8::FunctionCallbackInfo<v8::Value>&);
    static void uniformMatrix4fvMethodCustom(const v8::FunctionCallbackInfo<v8::Value>&);
    static void vertexAttrib1fvMethodCustom(const v8::FunctionCallbackInfo<v8::Value>&);
    static void vertexAttrib2fvMethodCustom(const v8::FunctionCallbackInfo<v8::Value>&);
    static void vertexAttrib3fvMethodCustom(const v8::FunctionCallbackInfo<v8::Value>&);
    static void vertexAttrib4fvMethodCustom(const v8::FunctionCallbackInfo<v8::Value>&);
#if ENABLE(OILPAN)
    static const int persistentHandleIndex = v8DefaultWrapperInternalFieldCount + 0;
    static const int internalFieldCount = v8DefaultWrapperInternalFieldCount + 0 + 1;
#else
    static const int internalFieldCount = v8DefaultWrapperInternalFieldCount + 0;
#endif
    static inline void* toInternalPointer(WebGLRenderingContext* impl)
    {
        return impl;
    }

    static inline WebGLRenderingContext* fromInternalPointer(void* object)
    {
        return static_cast<WebGLRenderingContext*>(object);
    }
    static void installPerContextEnabledProperties(v8::Handle<v8::Object>, WebGLRenderingContext*, v8::Isolate*) { }
    static void installPerContextEnabledMethods(v8::Handle<v8::Object>, v8::Isolate*) { }

private:
    friend v8::Handle<v8::Object> wrap(WebGLRenderingContext*, v8::Handle<v8::Object> creationContext, v8::Isolate*);
    static v8::Handle<v8::Object> createWrapper(PassRefPtrWillBeRawPtr<WebGLRenderingContext>, v8::Handle<v8::Object> creationContext, v8::Isolate*);
};

v8::Handle<v8::Object> wrap(WebGLRenderingContext* impl, v8::Handle<v8::Object> creationContext, v8::Isolate*);

inline v8::Handle<v8::Value> toV8(WebGLRenderingContext* impl, v8::Handle<v8::Object> creationContext, v8::Isolate* isolate)
{
    if (UNLIKELY(!impl))
        return v8::Null(isolate);
    v8::Handle<v8::Value> wrapper = DOMDataStore::getWrapper<V8WebGLRenderingContext>(impl, isolate);
    if (!wrapper.IsEmpty())
        return wrapper;
    return wrap(impl, creationContext, isolate);
}

template<typename CallbackInfo>
inline void v8SetReturnValue(const CallbackInfo& callbackInfo, WebGLRenderingContext* impl)
{
    if (UNLIKELY(!impl)) {
        v8SetReturnValueNull(callbackInfo);
        return;
    }
    if (DOMDataStore::setReturnValueFromWrapper<V8WebGLRenderingContext>(callbackInfo.GetReturnValue(), impl))
        return;
    v8::Handle<v8::Object> wrapper = wrap(impl, callbackInfo.Holder(), callbackInfo.GetIsolate());
    v8SetReturnValue(callbackInfo, wrapper);
}

template<typename CallbackInfo>
inline void v8SetReturnValueForMainWorld(const CallbackInfo& callbackInfo, WebGLRenderingContext* impl)
{
    ASSERT(DOMWrapperWorld::current(callbackInfo.GetIsolate()).isMainWorld());
    if (UNLIKELY(!impl)) {
        v8SetReturnValueNull(callbackInfo);
        return;
    }
    if (DOMDataStore::setReturnValueFromWrapperForMainWorld<V8WebGLRenderingContext>(callbackInfo.GetReturnValue(), impl))
        return;
    v8::Handle<v8::Value> wrapper = wrap(impl, callbackInfo.Holder(), callbackInfo.GetIsolate());
    v8SetReturnValue(callbackInfo, wrapper);
}

template<class CallbackInfo, class Wrappable>
inline void v8SetReturnValueFast(const CallbackInfo& callbackInfo, WebGLRenderingContext* impl, Wrappable* wrappable)
{
    if (UNLIKELY(!impl)) {
        v8SetReturnValueNull(callbackInfo);
        return;
    }
    if (DOMDataStore::setReturnValueFromWrapperFast<V8WebGLRenderingContext>(callbackInfo.GetReturnValue(), impl, callbackInfo.Holder(), wrappable))
        return;
    v8::Handle<v8::Object> wrapper = wrap(impl, callbackInfo.Holder(), callbackInfo.GetIsolate());
    v8SetReturnValue(callbackInfo, wrapper);
}

inline v8::Handle<v8::Value> toV8(PassRefPtrWillBeRawPtr<WebGLRenderingContext> impl, v8::Handle<v8::Object> creationContext, v8::Isolate* isolate)
{
    return toV8(impl.get(), creationContext, isolate);
}

template<class CallbackInfo>
inline void v8SetReturnValue(const CallbackInfo& callbackInfo, PassRefPtrWillBeRawPtr<WebGLRenderingContext> impl)
{
    v8SetReturnValue(callbackInfo, impl.get());
}

template<class CallbackInfo>
inline void v8SetReturnValueForMainWorld(const CallbackInfo& callbackInfo, PassRefPtrWillBeRawPtr<WebGLRenderingContext> impl)
{
    v8SetReturnValueForMainWorld(callbackInfo, impl.get());
}

template<class CallbackInfo, class Wrappable>
inline void v8SetReturnValueFast(const CallbackInfo& callbackInfo, PassRefPtrWillBeRawPtr<WebGLRenderingContext> impl, Wrappable* wrappable)
{
    v8SetReturnValueFast(callbackInfo, impl.get(), wrappable);
}

}
#endif // V8WebGLRenderingContext_h
