// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_CAST_TEST_FAKE_RECEIVER_TIME_OFFSET_ESTIMATOR_H_
#define MEDIA_CAST_TEST_FAKE_RECEIVER_TIME_OFFSET_ESTIMATOR_H_

#include "base/time/time.h"
#include "base/threading/thread_checker.h"
#include "media/cast/logging/logging_defines.h"
#include "media/cast/logging/receiver_time_offset_estimator.h"

namespace media {
namespace cast {
namespace test {

// This class is used for testing. It will always return the |offset| value
// provided during construction as offset bounds.
class FakeReceiverTimeOffsetEstimator : public ReceiverTimeOffsetEstimator {
 public:
  FakeReceiverTimeOffsetEstimator(base::TimeDelta offset);

  virtual ~FakeReceiverTimeOffsetEstimator();

  // RawReventSubscriber implementations.
  virtual void OnReceiveFrameEvent(const FrameEvent& frame_event) OVERRIDE;
  virtual void OnReceivePacketEvent(const PacketEvent& packet_event) OVERRIDE;

  // ReceiverTimeOffsetEstimator
  virtual bool GetReceiverOffsetBounds(base::TimeDelta* lower_bound,
                                       base::TimeDelta* upper_bound) OVERRIDE;

 private:
  const base::TimeDelta offset_;
  DISALLOW_COPY_AND_ASSIGN(FakeReceiverTimeOffsetEstimator);
};

}  // namespace test
}  // namespace cast
}  // namespace media

#endif  // MEDIA_CAST_TEST_FAKE_RECEIVER_TIME_OFFSET_ESTIMATOR_H_
