// Copyright (c) 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_VIEWS_FRAME_BROWSER_DESKTOP_ROOT_WINDOW_HOST_OZONE_H_
#define CHROME_BROWSER_UI_VIEWS_FRAME_BROWSER_DESKTOP_ROOT_WINDOW_HOST_OZONE_H_

#include "ui/aura/window_tree_host.h"
#include "ui/views/widget/desktop_aura/desktop_window_tree_host.h"
#include "chrome/browser/ui/views/frame/browser_desktop_window_tree_host.h"

class BrowserFrame;
class BrowserView;

namespace views {
class DesktopNativeWidgetAura;
}

class BrowserDesktopWindowTreeHostOzone
    : public BrowserDesktopWindowTreeHost {
 public:
  BrowserDesktopWindowTreeHostOzone(
      views::internal::NativeWidgetDelegate* native_widget_delegate,
      views::DesktopNativeWidgetAura* desktop_native_widget_aura,
      BrowserView* browser_view);
  virtual ~BrowserDesktopWindowTreeHostOzone();

 private:
  // Overridden from BrowserDesktopWindowTreeHost:
  virtual views::DesktopWindowTreeHost* AsDesktopWindowTreeHost() OVERRIDE;
  virtual int GetMinimizeButtonOffset() const OVERRIDE;
  virtual bool UsesNativeSystemMenu() const OVERRIDE;

  BrowserView* browser_view_;

  // Ownership passed to RootWindow on Init.
  views::DesktopWindowTreeHost* desktop_root_window_host_;

  DISALLOW_COPY_AND_ASSIGN(BrowserDesktopWindowTreeHostOzone);
};

#endif  // CHROME_BROWSER_UI_VIEWS_FRAME_BROWSER_DESKTOP_ROOT_WINDOW_HOST_OZONE_H_
