// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_ANDROID_BANNERS_APP_BANNER_METRICS_ID_LIST_H_
#define CHROME_BROWSER_ANDROID_BANNERS_APP_BANNER_METRICS_ID_LIST_H_

// Keep in sync with the values defined in histograms.xml.

DEFINE_APP_BANNER_METRICS_ID_ENUM_START(DisplayEvent)
DEFINE_APP_BANNER_METRICS_ID(DISPLAY_MIN, 0)
DEFINE_APP_BANNER_METRICS_ID(DISPLAY_BANNER_REQUESTED, 1)
DEFINE_APP_BANNER_METRICS_ID(DISPLAY_BLOCKED_PREVIOUSLY, 2)
DEFINE_APP_BANNER_METRICS_ID(DISPLAY_BLOCKED_TOO_MANY_OTHERS, 3)
DEFINE_APP_BANNER_METRICS_ID(DISPLAY_CREATED, 4)
DEFINE_APP_BANNER_METRICS_ID(DISPLAY_MAX, 5)
DEFINE_APP_BANNER_METRICS_ID_ENUM_END()

DEFINE_APP_BANNER_METRICS_ID_ENUM_START(InstallEvent)
DEFINE_APP_BANNER_METRICS_ID(INSTALL_MIN, 20)
DEFINE_APP_BANNER_METRICS_ID(INSTALL_TRIGGERED, 21)
DEFINE_APP_BANNER_METRICS_ID(INSTALL_STARTED, 22)
DEFINE_APP_BANNER_METRICS_ID(INSTALL_COMPLETED, 23)
DEFINE_APP_BANNER_METRICS_ID(INSTALL_MAX, 24)
DEFINE_APP_BANNER_METRICS_ID_ENUM_END()

DEFINE_APP_BANNER_METRICS_ID_ENUM_START(DismissEvent)
DEFINE_APP_BANNER_METRICS_ID(DISMISS_MIN, 40)
DEFINE_APP_BANNER_METRICS_ID(DISMISS_ERROR, 41)
DEFINE_APP_BANNER_METRICS_ID(DISMISS_APP_OPEN, 42)
DEFINE_APP_BANNER_METRICS_ID(DISMISS_BANNER_CLICK, 43)
DEFINE_APP_BANNER_METRICS_ID(DISMISS_BANNER_SWIPE, 44)
DEFINE_APP_BANNER_METRICS_ID(DISMISS_CLOSE_BUTTON, 45)
DEFINE_APP_BANNER_METRICS_ID(DISMISS_INSTALL_TIMEOUT, 46)
DEFINE_APP_BANNER_METRICS_ID(DISMISS_NAVIGATE, 47)
DEFINE_APP_BANNER_METRICS_ID(DISMISS_MAX, 48)
DEFINE_APP_BANNER_METRICS_ID_ENUM_END()

#endif  // CHROME_BROWSER_ANDROID_BANNERS_APP_BANNER_METRICS_ID_LIST_H_
