// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is automatically generated.

#ifndef UI_GFX_GL_GL_BINDINGS_AUTOGEN_OSMESA_H_
#define UI_GFX_GL_GL_BINDINGS_AUTOGEN_OSMESA_H_

namespace gfx {

class GLContext;


typedef OSMesaContext (GL_BINDING_CALL *OSMesaCreateContextProc)(GLenum format, OSMesaContext sharelist);
typedef OSMesaContext (GL_BINDING_CALL *OSMesaCreateContextExtProc)(GLenum format, GLint depthBits, GLint stencilBits, GLint accumBits, OSMesaContext sharelist);
typedef void (GL_BINDING_CALL *OSMesaDestroyContextProc)(OSMesaContext ctx);
typedef GLboolean (GL_BINDING_CALL *OSMesaMakeCurrentProc)(OSMesaContext ctx, void* buffer, GLenum type, GLsizei width, GLsizei height);
typedef OSMesaContext (GL_BINDING_CALL *OSMesaGetCurrentContextProc)(void);
typedef void (GL_BINDING_CALL *OSMesaPixelStoreProc)(GLint pname, GLint value);
typedef void (GL_BINDING_CALL *OSMesaGetIntegervProc)(GLint pname, GLint* value);
typedef GLboolean (GL_BINDING_CALL *OSMesaGetDepthBufferProc)(OSMesaContext c, GLint* width, GLint* height, GLint* bytesPerValue, void** buffer);
typedef GLboolean (GL_BINDING_CALL *OSMesaGetColorBufferProc)(OSMesaContext c, GLint* width, GLint* height, GLint* format, void** buffer);
typedef OSMESAproc (GL_BINDING_CALL *OSMesaGetProcAddressProc)(const char* funcName);
typedef void (GL_BINDING_CALL *OSMesaColorClampProc)(GLboolean enable);

struct ExtensionsOSMESA {
};

struct ProcsOSMESA {
  OSMesaCreateContextProc OSMesaCreateContextFn;
  OSMesaCreateContextExtProc OSMesaCreateContextExtFn;
  OSMesaDestroyContextProc OSMesaDestroyContextFn;
  OSMesaMakeCurrentProc OSMesaMakeCurrentFn;
  OSMesaGetCurrentContextProc OSMesaGetCurrentContextFn;
  OSMesaPixelStoreProc OSMesaPixelStoreFn;
  OSMesaGetIntegervProc OSMesaGetIntegervFn;
  OSMesaGetDepthBufferProc OSMesaGetDepthBufferFn;
  OSMesaGetColorBufferProc OSMesaGetColorBufferFn;
  OSMesaGetProcAddressProc OSMesaGetProcAddressFn;
  OSMesaColorClampProc OSMesaColorClampFn;
};

class GL_EXPORT OSMESAApi {
 public:
  OSMESAApi();
  virtual ~OSMESAApi();

  virtual OSMesaContext OSMesaCreateContextFn(GLenum format, OSMesaContext sharelist) = 0;
  virtual OSMesaContext OSMesaCreateContextExtFn(GLenum format, GLint depthBits, GLint stencilBits, GLint accumBits, OSMesaContext sharelist) = 0;
  virtual void OSMesaDestroyContextFn(OSMesaContext ctx) = 0;
  virtual GLboolean OSMesaMakeCurrentFn(OSMesaContext ctx, void* buffer, GLenum type, GLsizei width, GLsizei height) = 0;
  virtual OSMesaContext OSMesaGetCurrentContextFn(void) = 0;
  virtual void OSMesaPixelStoreFn(GLint pname, GLint value) = 0;
  virtual void OSMesaGetIntegervFn(GLint pname, GLint* value) = 0;
  virtual GLboolean OSMesaGetDepthBufferFn(OSMesaContext c, GLint* width, GLint* height, GLint* bytesPerValue, void** buffer) = 0;
  virtual GLboolean OSMesaGetColorBufferFn(OSMesaContext c, GLint* width, GLint* height, GLint* format, void** buffer) = 0;
  virtual OSMESAproc OSMesaGetProcAddressFn(const char* funcName) = 0;
  virtual void OSMesaColorClampFn(GLboolean enable) = 0;
};

}  // namespace gfx

#define OSMesaCreateContext ::gfx::g_current_osmesa_context->OSMesaCreateContextFn
#define OSMesaCreateContextExt ::gfx::g_current_osmesa_context->OSMesaCreateContextExtFn
#define OSMesaDestroyContext ::gfx::g_current_osmesa_context->OSMesaDestroyContextFn
#define OSMesaMakeCurrent ::gfx::g_current_osmesa_context->OSMesaMakeCurrentFn
#define OSMesaGetCurrentContext ::gfx::g_current_osmesa_context->OSMesaGetCurrentContextFn
#define OSMesaPixelStore ::gfx::g_current_osmesa_context->OSMesaPixelStoreFn
#define OSMesaGetIntegerv ::gfx::g_current_osmesa_context->OSMesaGetIntegervFn
#define OSMesaGetDepthBuffer ::gfx::g_current_osmesa_context->OSMesaGetDepthBufferFn
#define OSMesaGetColorBuffer ::gfx::g_current_osmesa_context->OSMesaGetColorBufferFn
#define OSMesaGetProcAddress ::gfx::g_current_osmesa_context->OSMesaGetProcAddressFn
#define OSMesaColorClamp ::gfx::g_current_osmesa_context->OSMesaColorClampFn

#endif  //  UI_GFX_GL_GL_BINDINGS_AUTOGEN_OSMESA_H_
