// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_INTERFACES_SERVICE_PROVIDER_SERVICE_PROVIDER_MOJOM_H_
#define MOJO_PUBLIC_INTERFACES_SERVICE_PROVIDER_SERVICE_PROVIDER_MOJOM_H_

#include "mojo/public/cpp/bindings/array.h"
#include "mojo/public/cpp/bindings/callback.h"
#include "mojo/public/cpp/bindings/interface_impl.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/message_filter.h"
#include "mojo/public/cpp/bindings/no_interface.h"
#include "mojo/public/cpp/bindings/string.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/interfaces/service_provider/service_provider.mojom-internal.h"
namespace mojo {


class ServiceProvider;
typedef mojo::InterfacePtr<ServiceProvider> ServiceProviderPtr;




class ServiceProviderProxy;
class ServiceProviderStub;

class ServiceProviderRequestValidator;

class ServiceProvider;


class ServiceProvider {
 public:
  static const char* Name_;

  typedef ServiceProviderProxy Proxy_;
  typedef ServiceProviderStub Stub_;

  typedef ServiceProviderRequestValidator RequestValidator_;
  typedef mojo::PassThroughFilter ResponseValidator_;

  typedef ServiceProvider Client;

  virtual ~ServiceProvider() {}
  virtual void ConnectToService(const mojo::String& service_url, const mojo::String& service_name, mojo::ScopedMessagePipeHandle client_handle, const mojo::String& requestor_url) = 0;
};


class ServiceProviderProxy : public ServiceProvider {
 public:
  explicit ServiceProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  virtual void ConnectToService(
      const mojo::String& service_url, const mojo::String& service_name, mojo::ScopedMessagePipeHandle client_handle, const mojo::String& requestor_url
  ) MOJO_OVERRIDE;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};

class ServiceProviderStub : public mojo::MessageReceiverWithResponder {
 public:
  ServiceProviderStub();
  void set_sink(ServiceProvider* sink) { sink_ = sink; }
  ServiceProvider* sink() { return sink_; }

  virtual bool Accept(mojo::Message* message) MOJO_OVERRIDE;
  virtual bool AcceptWithResponder(mojo::Message* message,
                                   mojo::MessageReceiver* responder)
                                       MOJO_OVERRIDE;

 private:
  ServiceProvider* sink_;
};

class ServiceProviderRequestValidator : public mojo::MessageFilter {
 public:
  explicit ServiceProviderRequestValidator(mojo::MessageReceiver* sink = NULL);

  virtual bool Accept(mojo::Message* message) MOJO_OVERRIDE;
};

}  // namespace mojo

#endif  // MOJO_PUBLIC_INTERFACES_SERVICE_PROVIDER_SERVICE_PROVIDER_MOJOM_H_
