// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_WEB_UI_SETUP_MOJOM_H_
#define CONTENT_COMMON_WEB_UI_SETUP_MOJOM_H_

#include "mojo/public/cpp/bindings/array.h"
#include "mojo/public/cpp/bindings/callback.h"
#include "mojo/public/cpp/bindings/interface_impl.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/message_filter.h"
#include "mojo/public/cpp/bindings/no_interface.h"
#include "mojo/public/cpp/bindings/string.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "content/common/web_ui_setup.mojom-internal.h"
namespace content {


class WebUISetupClient;
typedef mojo::InterfacePtr<WebUISetupClient> WebUISetupClientPtr;

class WebUISetup;
typedef mojo::InterfacePtr<WebUISetup> WebUISetupPtr;




class WebUISetupClientProxy;
class WebUISetupClientStub;

class WebUISetupClientRequestValidator;


class WebUISetupClient {
 public:
  static const char* Name_;

  typedef WebUISetupClientProxy Proxy_;
  typedef WebUISetupClientStub Stub_;

  typedef WebUISetupClientRequestValidator RequestValidator_;
  typedef mojo::PassThroughFilter ResponseValidator_;

  typedef mojo::NoInterface Client;

  virtual ~WebUISetupClient() {}
};


class WebUISetupProxy;
class WebUISetupStub;

class WebUISetupRequestValidator;


class WebUISetup {
 public:
  static const char* Name_;

  typedef WebUISetupProxy Proxy_;
  typedef WebUISetupStub Stub_;

  typedef WebUISetupRequestValidator RequestValidator_;
  typedef mojo::PassThroughFilter ResponseValidator_;

  typedef mojo::NoInterface Client;

  virtual ~WebUISetup() {}
  virtual void SetWebUIHandle(int32_t view_routing_id, mojo::ScopedMessagePipeHandle web_ui_handle) = 0;
};


class WebUISetupClientProxy : public WebUISetupClient {
 public:
  explicit WebUISetupClientProxy(mojo::MessageReceiverWithResponder* receiver);

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};


class WebUISetupProxy : public WebUISetup {
 public:
  explicit WebUISetupProxy(mojo::MessageReceiverWithResponder* receiver);
  virtual void SetWebUIHandle(
      int32_t view_routing_id, mojo::ScopedMessagePipeHandle web_ui_handle
  ) MOJO_OVERRIDE;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};

class WebUISetupClientStub : public mojo::MessageReceiverWithResponder {
 public:
  WebUISetupClientStub();
  void set_sink(WebUISetupClient* sink) { sink_ = sink; }
  WebUISetupClient* sink() { return sink_; }

  virtual bool Accept(mojo::Message* message) MOJO_OVERRIDE;
  virtual bool AcceptWithResponder(mojo::Message* message,
                                   mojo::MessageReceiver* responder)
                                       MOJO_OVERRIDE;

 private:
  WebUISetupClient* sink_;
};

class WebUISetupStub : public mojo::MessageReceiverWithResponder {
 public:
  WebUISetupStub();
  void set_sink(WebUISetup* sink) { sink_ = sink; }
  WebUISetup* sink() { return sink_; }

  virtual bool Accept(mojo::Message* message) MOJO_OVERRIDE;
  virtual bool AcceptWithResponder(mojo::Message* message,
                                   mojo::MessageReceiver* responder)
                                       MOJO_OVERRIDE;

 private:
  WebUISetup* sink_;
};

class WebUISetupClientRequestValidator : public mojo::MessageFilter {
 public:
  explicit WebUISetupClientRequestValidator(mojo::MessageReceiver* sink = NULL);

  virtual bool Accept(mojo::Message* message) MOJO_OVERRIDE;
};

class WebUISetupRequestValidator : public mojo::MessageFilter {
 public:
  explicit WebUISetupRequestValidator(mojo::MessageReceiver* sink = NULL);

  virtual bool Accept(mojo::Message* message) MOJO_OVERRIDE;
};

}  // namespace content

#endif  // CONTENT_COMMON_WEB_UI_SETUP_MOJOM_H_
