// Copyright (c) 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MediaFeatureNames_h
#define MediaFeatureNames_h

#include "wtf/text/AtomicString.h"

namespace WebCore {
namespace MediaFeatureNames {

#ifndef MEDIA_FEATURE_NAMES_HIDE_GLOBALS

extern const WTF::AtomicString devicePixelRatioMediaFeature;
extern const WTF::AtomicString maxDevicePixelRatioMediaFeature;
extern const WTF::AtomicString minDevicePixelRatioMediaFeature;
extern const WTF::AtomicString transform3dMediaFeature;
extern const WTF::AtomicString aspectRatioMediaFeature;
extern const WTF::AtomicString colorMediaFeature;
extern const WTF::AtomicString colorIndexMediaFeature;
extern const WTF::AtomicString deviceAspectRatioMediaFeature;
extern const WTF::AtomicString deviceHeightMediaFeature;
extern const WTF::AtomicString deviceWidthMediaFeature;
extern const WTF::AtomicString gridMediaFeature;
extern const WTF::AtomicString heightMediaFeature;
extern const WTF::AtomicString hoverMediaFeature;
extern const WTF::AtomicString maxAspectRatioMediaFeature;
extern const WTF::AtomicString maxColorMediaFeature;
extern const WTF::AtomicString maxColorIndexMediaFeature;
extern const WTF::AtomicString maxDeviceAspectRatioMediaFeature;
extern const WTF::AtomicString maxDeviceHeightMediaFeature;
extern const WTF::AtomicString maxDeviceWidthMediaFeature;
extern const WTF::AtomicString maxHeightMediaFeature;
extern const WTF::AtomicString maxMonochromeMediaFeature;
extern const WTF::AtomicString maxResolutionMediaFeature;
extern const WTF::AtomicString maxWidthMediaFeature;
extern const WTF::AtomicString minAspectRatioMediaFeature;
extern const WTF::AtomicString minColorMediaFeature;
extern const WTF::AtomicString minColorIndexMediaFeature;
extern const WTF::AtomicString minDeviceAspectRatioMediaFeature;
extern const WTF::AtomicString minDeviceHeightMediaFeature;
extern const WTF::AtomicString minDeviceWidthMediaFeature;
extern const WTF::AtomicString minHeightMediaFeature;
extern const WTF::AtomicString minMonochromeMediaFeature;
extern const WTF::AtomicString minResolutionMediaFeature;
extern const WTF::AtomicString minWidthMediaFeature;
extern const WTF::AtomicString monochromeMediaFeature;
extern const WTF::AtomicString orientationMediaFeature;
extern const WTF::AtomicString pointerMediaFeature;
extern const WTF::AtomicString resolutionMediaFeature;
extern const WTF::AtomicString scanMediaFeature;
extern const WTF::AtomicString widthMediaFeature;

#endif // MEDIA_FEATURE_NAMES_HIDE_GLOBALS

 void init();

} // MediaFeatureNames
} // WebCore

#endif
