// File is generated by Source/core/inspector/CodeGeneratorInspector.py

// Copyright (c) 2011 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef InspectorTypeBuilder_h
#define InspectorTypeBuilder_h

#include "platform/JSONValues.h"
#include "wtf/Assertions.h"
#include "wtf/PassRefPtr.h"

namespace WebCore {

namespace TypeBuilder {

template<typename T>
class OptOutput {
public:
    OptOutput() : m_assigned(false) { }

    void operator=(T value)
    {
        m_value = value;
        m_assigned = true;
    }

    bool isAssigned() { return m_assigned; }

    T getValue()
    {
        ASSERT(isAssigned());
        return m_value;
    }

private:
    T m_value;
    bool m_assigned;

    WTF_MAKE_NONCOPYABLE(OptOutput);
};


// A small transient wrapper around int type, that can be used as a funciton parameter type
// cleverly disallowing C++ implicit casts from float or double.
class ExactlyInt {
public:
    template<typename T>
    ExactlyInt(T t) : m_value(cast_to_int<T>(t)) {}

    ExactlyInt() {}

    operator int() { return m_value; }
private:
    int m_value;

    template<typename T>
    static int cast_to_int(T) { return T::default_case_cast_is_not_supported(); }
};

template<>
inline int ExactlyInt::cast_to_int<int>(int i) { return i; }

template<>
inline int ExactlyInt::cast_to_int<unsigned int>(unsigned int i) { return i; }

class RuntimeCastHelper {
public:
#if ASSERT_ENABLED
    template<JSONValue::Type TYPE>
    static void assertType(JSONValue* value)
    {
        ASSERT(value->type() == TYPE);
    }
    static void assertAny(JSONValue*);
    static void assertInt(JSONValue* value);
#endif
};


// This class provides "Traits" type for the input type T. It is programmed using C++ template specialization
// technique. By default it simply takes "ItemTraits" type from T, but it doesn't work with the base types.
template<typename T>
struct ArrayItemHelper {
    typedef typename T::ItemTraits Traits;
};

template<typename T>
class Array : public JSONArrayBase {
private:
    Array() { }

    JSONArray* openAccessors() {
        COMPILE_ASSERT(sizeof(JSONArray) == sizeof(Array<T>), cannot_cast);
        return static_cast<JSONArray*>(static_cast<JSONArrayBase*>(this));
    }

public:
    void addItem(PassRefPtr<T> value)
    {
        ArrayItemHelper<T>::Traits::pushRefPtr(this->openAccessors(), value);
    }

    void addItem(T value)
    {
        ArrayItemHelper<T>::Traits::pushRaw(this->openAccessors(), value);
    }

    static PassRefPtr<Array<T> > create()
    {
        return adoptRef(new Array<T>());
    }

    static PassRefPtr<Array<T> > runtimeCast(PassRefPtr<JSONValue> value)
    {
        RefPtr<JSONArray> array;
        bool castRes = value->asArray(&array);
        ASSERT_UNUSED(castRes, castRes);
#if ASSERT_ENABLED
        assertCorrectValue(array.get());
#endif  // ASSERT_ENABLED
        COMPILE_ASSERT(sizeof(Array<T>) == sizeof(JSONArray), type_cast_problem);
        return static_cast<Array<T>*>(static_cast<JSONArrayBase*>(array.get()));
    }

    void concat(PassRefPtr<Array<T> > array)
    {
        return ArrayItemHelper<T>::Traits::concat(this->openAccessors(), array->openAccessors());
    }

#if ASSERT_ENABLED
    static void assertCorrectValue(JSONValue* value)
    {
        RefPtr<JSONArray> array;
        bool castRes = value->asArray(&array);
        ASSERT_UNUSED(castRes, castRes);
        for (unsigned i = 0; i < array->length(); i++)
            ArrayItemHelper<T>::Traits::template assertCorrectValue<T>(array->get(i).get());
    }

#endif // ASSERT_ENABLED
};

struct StructItemTraits {
    static void pushRefPtr(JSONArray* array, PassRefPtr<JSONValue> value)
    {
        array->pushValue(value);
    }

    static void concat(JSONArray* array, JSONArray* anotherArray)
    {
        for (JSONArray::iterator it = anotherArray->begin(); it != anotherArray->end(); ++it)
            array->pushValue(*it);
    }

#if ASSERT_ENABLED
    template<typename T>
    static void assertCorrectValue(JSONValue* value) {
        T::assertCorrectValue(value);
    }
#endif  // ASSERT_ENABLED
};

template<>
struct ArrayItemHelper<String> {
    struct Traits {
        static void pushRaw(JSONArray* array, const String& value)
        {
            array->pushString(value);
        }

#if ASSERT_ENABLED
        template<typename T>
        static void assertCorrectValue(JSONValue* value) {
            RuntimeCastHelper::assertType<JSONValue::TypeString>(value);
        }
#endif  // ASSERT_ENABLED
    };
};

template<>
struct ArrayItemHelper<int> {
    struct Traits {
        static void pushRaw(JSONArray* array, int value)
        {
            array->pushInt(value);
        }

#if ASSERT_ENABLED
        template<typename T>
        static void assertCorrectValue(JSONValue* value) {
            RuntimeCastHelper::assertInt(value);
        }
#endif  // ASSERT_ENABLED
    };
};

template<>
struct ArrayItemHelper<double> {
    struct Traits {
        static void pushRaw(JSONArray* array, double value)
        {
            array->pushNumber(value);
        }

#if ASSERT_ENABLED
        template<typename T>
        static void assertCorrectValue(JSONValue* value) {
            RuntimeCastHelper::assertType<JSONValue::TypeNumber>(value);
        }
#endif  // ASSERT_ENABLED
    };
};

template<>
struct ArrayItemHelper<bool> {
    struct Traits {
        static void pushRaw(JSONArray* array, bool value)
        {
            array->pushBoolean(value);
        }

#if ASSERT_ENABLED
        template<typename T>
        static void assertCorrectValue(JSONValue* value) {
            RuntimeCastHelper::assertType<JSONValue::TypeBoolean>(value);
        }
#endif  // ASSERT_ENABLED
    };
};

template<>
struct ArrayItemHelper<JSONValue> {
    struct Traits {
        static void pushRefPtr(JSONArray* array, PassRefPtr<JSONValue> value)
        {
            array->pushValue(value);
        }

#if ASSERT_ENABLED
        template<typename T>
        static void assertCorrectValue(JSONValue* value) {
            RuntimeCastHelper::assertAny(value);
        }
#endif  // ASSERT_ENABLED
    };
};

template<>
struct ArrayItemHelper<JSONObject> {
    struct Traits {
        static void pushRefPtr(JSONArray* array, PassRefPtr<JSONValue> value)
        {
            array->pushValue(value);
        }

#if ASSERT_ENABLED
        template<typename T>
        static void assertCorrectValue(JSONValue* value) {
            RuntimeCastHelper::assertType<JSONValue::TypeObject>(value);
        }
#endif  // ASSERT_ENABLED
    };
};

template<>
struct ArrayItemHelper<JSONArray> {
    struct Traits {
        static void pushRefPtr(JSONArray* array, PassRefPtr<JSONArray> value)
        {
            array->pushArray(value);
        }

#if ASSERT_ENABLED
        template<typename T>
        static void assertCorrectValue(JSONValue* value) {
            RuntimeCastHelper::assertType<JSONValue::TypeArray>(value);
        }
#endif  // ASSERT_ENABLED
    };
};

template<typename T>
struct ArrayItemHelper<TypeBuilder::Array<T> > {
    struct Traits {
        static void pushRefPtr(JSONArray* array, PassRefPtr<TypeBuilder::Array<T> > value)
        {
            array->pushValue(value);
        }

#if ASSERT_ENABLED
        template<typename S>
        static void assertCorrectValue(JSONValue* value) {
            S::assertCorrectValue(value);
        }
#endif  // ASSERT_ENABLED
    };
};

// Forward declarations.
namespace Page {
class UsageItem;
} // Page

namespace Runtime {
class ObjectPreview;
class PropertyPreview;
} // Runtime

namespace Console {
class CallFrame;
} // Console

namespace IndexedDB {
class ObjectStore;
class ObjectStoreIndex;
class KeyPath;
} // IndexedDB

namespace DOM {
class ShapeOutsideInfo;
class Rect;
} // DOM

namespace CSS {
class RuleMatch;
class CSSRule;
class SourceRange;
class CSSStyle;
class CSSProperty;
class CSSMedia;
class MediaQueryExpression;
} // CSS

namespace Debugger {
class Location;
class Scope;
} // Debugger

namespace Canvas {
class CallArgument;
} // Canvas

// End of forward declarations.

// Typedefs.
namespace Page {
/* Unique frame identifier. */
typedef String FrameId;

/* Unique script identifier. */
typedef String ScriptIdentifier;

} // Page

namespace Runtime {
/* Unique object identifier. */
typedef String RemoteObjectId;

} // Runtime

namespace Network {
/* Unique loader identifier. */
typedef String LoaderId;

/* Unique request identifier. */
typedef String RequestId;

} // Network

namespace Database {
/* Unique identifier of Database object. */
typedef String DatabaseId;

} // Database

namespace CSS {
typedef String StyleSheetId;

} // CSS

namespace Debugger {
/* Breakpoint identifier. */
typedef String BreakpointId;

/* Unique script identifier. */
typedef String ScriptId;

/* Call frame identifier. */
typedef String CallFrameId;

} // Debugger

namespace HeapProfiler {
/* Heap snapshot object id. */
typedef String HeapSnapshotObjectId;

} // HeapProfiler

namespace Canvas {
/* Unique resource identifier. */
typedef String ResourceId;

/* Unique trace log identifier. */
typedef String TraceLogId;

} // Canvas

namespace LayerTree {
/* Unique RenderLayer identifier. */
typedef String LayerId;

/* Unique snapshot identifier. */
typedef String SnapshotId;

} // LayerTree

// End of typedefs.



String getEnumConstantValue(int code);

namespace Page {
/* Resource type as it was perceived by the rendering engine. */
struct ResourceType {
    enum Enum {
        Document = 0,
        Stylesheet = 1,
        Image = 2,
        Media = 3,
        Font = 4,
        Script = 5,
        TextTrack = 6,
        XHR = 7,
        WebSocket = 8,
        Other = 9,
    };
}; // struct ResourceType

/* Information about the Frame on the page. */
class Frame : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        IdSet = 1 << 0,
        LoaderIdSet = 1 << 1,
        UrlSet = 1 << 2,
        SecurityOriginSet = 1 << 3,
        MimeTypeSet = 1 << 4,
        AllFieldsSet = (IdSet | LoaderIdSet | UrlSet | SecurityOriginSet | MimeTypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Frame*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Frame;
    public:

        Builder<STATE | IdSet>& setId(const String& value)
        {
            COMPILE_ASSERT(!(STATE & IdSet), property_id_already_set);
            m_result->setString("id", value);
            return castState<IdSet>();
        }

        Builder<STATE | LoaderIdSet>& setLoaderId(const TypeBuilder::Network::LoaderId& value)
        {
            COMPILE_ASSERT(!(STATE & LoaderIdSet), property_loaderId_already_set);
            m_result->setString("loaderId", value);
            return castState<LoaderIdSet>();
        }

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString("url", value);
            return castState<UrlSet>();
        }

        Builder<STATE | SecurityOriginSet>& setSecurityOrigin(const String& value)
        {
            COMPILE_ASSERT(!(STATE & SecurityOriginSet), property_securityOrigin_already_set);
            m_result->setString("securityOrigin", value);
            return castState<SecurityOriginSet>();
        }

        Builder<STATE | MimeTypeSet>& setMimeType(const String& value)
        {
            COMPILE_ASSERT(!(STATE & MimeTypeSet), property_mimeType_already_set);
            m_result->setString("mimeType", value);
            return castState<MimeTypeSet>();
        }

        operator RefPtr<Frame>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Frame) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Frame>*>(&m_result);
        }

        PassRefPtr<Frame> release()
        {
            return RefPtr<Frame>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Frame> result = Frame::create()
     *     .setId(...)
     *     .setLoaderId(...)
     *     .setUrl(...)
     *     .setSecurityOrigin(...)
     *     .setMimeType(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void id(String* value)
    {
        JSONObjectBase::getString("id", value);
    }

    void loaderId(TypeBuilder::Network::LoaderId* value)
    {
        JSONObjectBase::getString("loaderId", value);
    }

    void url(String* value)
    {
        JSONObjectBase::getString("url", value);
    }

    void securityOrigin(String* value)
    {
        JSONObjectBase::getString("securityOrigin", value);
    }

    void mimeType(String* value)
    {
        JSONObjectBase::getString("mimeType", value);
    }

    void setParentId(const String& value)
    {
        this->setString("parentId", value);
    }

    void setName(const String& value)
    {
        this->setString("name", value);
    }
};

/* Information about the Frame hierarchy along with their cached resources. */
class FrameResourceTree : public JSONObjectBase {
public:
    // Named after property name 'resources' while generating FrameResourceTree.
    class Resources : public JSONObjectBase {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 0,
            TypeSet = 1 << 1,
            MimeTypeSet = 1 << 2,
            AllFieldsSet = (UrlSet | TypeSet | MimeTypeSet)
        };

        template<int STATE>
        class Builder {
        private:
            RefPtr<JSONObject> m_result;

            template<int STEP> Builder<STATE | STEP>& castState()
            {
                return *reinterpret_cast<Builder<STATE | STEP>*>(this);
            }

            Builder(PassRefPtr</*Resources*/JSONObject> ptr)
            {
                COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
                m_result = ptr;
            }
            friend class Resources;
        public:
    
            Builder<STATE | UrlSet>& setUrl(const String& value)
            {
                COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
                m_result->setString("url", value);
                return castState<UrlSet>();
            }
    
            Builder<STATE | TypeSet>& setType(TypeBuilder::Page::ResourceType::Enum value)
            {
                COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
                m_result->setString("type", TypeBuilder::getEnumConstantValue(value));
                return castState<TypeSet>();
            }
    
            Builder<STATE | MimeTypeSet>& setMimeType(const String& value)
            {
                COMPILE_ASSERT(!(STATE & MimeTypeSet), property_mimeType_already_set);
                m_result->setString("mimeType", value);
                return castState<MimeTypeSet>();
            }
    
            operator RefPtr<Resources>& ()
            {
                COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
                COMPILE_ASSERT(sizeof(Resources) == sizeof(JSONObject), cannot_cast);
                return *reinterpret_cast<RefPtr<Resources>*>(&m_result);
            }

            PassRefPtr<Resources> release()
            {
                return RefPtr<Resources>(*this).release();
            }
        };

        /*
         * Synthetic constructor:
         * RefPtr<Resources> result = Resources::create()
         *     .setUrl(...)
         *     .setType(...)
         *     .setMimeType(...);
         */
        static Builder<NoFieldsSet> create()
        {
            return Builder<NoFieldsSet>(JSONObject::create());
        }
        typedef TypeBuilder::StructItemTraits ItemTraits;

        void url(String* value)
        {
            JSONObjectBase::getString("url", value);
        }

        void mimeType(String* value)
        {
            JSONObjectBase::getString("mimeType", value);
        }

        void setFailed(bool value)
        {
            this->setBoolean("failed", value);
        }

        void setCanceled(bool value)
        {
            this->setBoolean("canceled", value);
        }
    };

    enum {
        NoFieldsSet = 0,
        FrameSet = 1 << 0,
        ResourcesSet = 1 << 1,
        AllFieldsSet = (FrameSet | ResourcesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*FrameResourceTree*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class FrameResourceTree;
    public:

        Builder<STATE | FrameSet>& setFrame(PassRefPtr<TypeBuilder::Page::Frame> value)
        {
            COMPILE_ASSERT(!(STATE & FrameSet), property_frame_already_set);
            m_result->setValue("frame", value);
            return castState<FrameSet>();
        }

        Builder<STATE | ResourcesSet>& setResources(PassRefPtr<TypeBuilder::Array<Resources> > value)
        {
            COMPILE_ASSERT(!(STATE & ResourcesSet), property_resources_already_set);
            m_result->setValue("resources", value);
            return castState<ResourcesSet>();
        }

        operator RefPtr<FrameResourceTree>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(FrameResourceTree) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<FrameResourceTree>*>(&m_result);
        }

        PassRefPtr<FrameResourceTree> release()
        {
            return RefPtr<FrameResourceTree>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<FrameResourceTree> result = FrameResourceTree::create()
     *     .setFrame(...)
     *     .setResources(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setChildFrames(PassRefPtr<TypeBuilder::Array<TypeBuilder::Page::FrameResourceTree> > value)
    {
        this->setValue("childFrames", value);
    }
};

/* Search match for resource. */
class SearchMatch : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        LineNumberSet = 1 << 0,
        LineContentSet = 1 << 1,
        AllFieldsSet = (LineNumberSet | LineContentSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*SearchMatch*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class SearchMatch;
    public:

        Builder<STATE | LineNumberSet>& setLineNumber(double value)
        {
            COMPILE_ASSERT(!(STATE & LineNumberSet), property_lineNumber_already_set);
            m_result->setNumber("lineNumber", value);
            return castState<LineNumberSet>();
        }

        Builder<STATE | LineContentSet>& setLineContent(const String& value)
        {
            COMPILE_ASSERT(!(STATE & LineContentSet), property_lineContent_already_set);
            m_result->setString("lineContent", value);
            return castState<LineContentSet>();
        }

        operator RefPtr<SearchMatch>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(SearchMatch) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<SearchMatch>*>(&m_result);
        }

        PassRefPtr<SearchMatch> release()
        {
            return RefPtr<SearchMatch>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<SearchMatch> result = SearchMatch::create()
     *     .setLineNumber(...)
     *     .setLineContent(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void lineNumber(double* value)
    {
        JSONObjectBase::getNumber("lineNumber", value);
    }

    void lineContent(String* value)
    {
        JSONObjectBase::getString("lineContent", value);
    }
};

/* Cookie object */
class Cookie : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        ValueSet = 1 << 1,
        DomainSet = 1 << 2,
        PathSet = 1 << 3,
        ExpiresSet = 1 << 4,
        SizeSet = 1 << 5,
        HttpOnlySet = 1 << 6,
        SecureSet = 1 << 7,
        SessionSet = 1 << 8,
        AllFieldsSet = (NameSet | ValueSet | DomainSet | PathSet | ExpiresSet | SizeSet | HttpOnlySet | SecureSet | SessionSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Cookie*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Cookie;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name", value);
            return castState<NameSet>();
        }

        Builder<STATE | ValueSet>& setValue(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ValueSet), property_value_already_set);
            m_result->setString("value", value);
            return castState<ValueSet>();
        }

        Builder<STATE | DomainSet>& setDomain(const String& value)
        {
            COMPILE_ASSERT(!(STATE & DomainSet), property_domain_already_set);
            m_result->setString("domain", value);
            return castState<DomainSet>();
        }

        Builder<STATE | PathSet>& setPath(const String& value)
        {
            COMPILE_ASSERT(!(STATE & PathSet), property_path_already_set);
            m_result->setString("path", value);
            return castState<PathSet>();
        }

        Builder<STATE | ExpiresSet>& setExpires(double value)
        {
            COMPILE_ASSERT(!(STATE & ExpiresSet), property_expires_already_set);
            m_result->setNumber("expires", value);
            return castState<ExpiresSet>();
        }

        Builder<STATE | SizeSet>& setSize(int value)
        {
            COMPILE_ASSERT(!(STATE & SizeSet), property_size_already_set);
            m_result->setNumber("size", value);
            return castState<SizeSet>();
        }

        Builder<STATE | HttpOnlySet>& setHttpOnly(bool value)
        {
            COMPILE_ASSERT(!(STATE & HttpOnlySet), property_httpOnly_already_set);
            m_result->setBoolean("httpOnly", value);
            return castState<HttpOnlySet>();
        }

        Builder<STATE | SecureSet>& setSecure(bool value)
        {
            COMPILE_ASSERT(!(STATE & SecureSet), property_secure_already_set);
            m_result->setBoolean("secure", value);
            return castState<SecureSet>();
        }

        Builder<STATE | SessionSet>& setSession(bool value)
        {
            COMPILE_ASSERT(!(STATE & SessionSet), property_session_already_set);
            m_result->setBoolean("session", value);
            return castState<SessionSet>();
        }

        operator RefPtr<Cookie>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Cookie) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Cookie>*>(&m_result);
        }

        PassRefPtr<Cookie> release()
        {
            return RefPtr<Cookie>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Cookie> result = Cookie::create()
     *     .setName(...)
     *     .setValue(...)
     *     .setDomain(...)
     *     .setPath(...)
     *     .setExpires(...)
     *     .setSize(...)
     *     .setHttpOnly(...)
     *     .setSecure(...)
     *     .setSession(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void name(String* value)
    {
        JSONObjectBase::getString("name", value);
    }

    void value(String* value)
    {
        JSONObjectBase::getString("value", value);
    }

    void domain(String* value)
    {
        JSONObjectBase::getString("domain", value);
    }

    void path(String* value)
    {
        JSONObjectBase::getString("path", value);
    }

    void expires(double* value)
    {
        JSONObjectBase::getNumber("expires", value);
    }

    void size(int* value)
    {
        JSONObjectBase::getNumber("size", value);
    }

    void httpOnly(bool* value)
    {
        JSONObjectBase::getBoolean("httpOnly", value);
    }

    void secure(bool* value)
    {
        JSONObjectBase::getBoolean("secure", value);
    }

    void session(bool* value)
    {
        JSONObjectBase::getBoolean("session", value);
    }
};

/* Navigation history entry. */
class NavigationEntry : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        IdSet = 1 << 0,
        UrlSet = 1 << 1,
        TitleSet = 1 << 2,
        AllFieldsSet = (IdSet | UrlSet | TitleSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*NavigationEntry*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class NavigationEntry;
    public:

        Builder<STATE | IdSet>& setId(int value)
        {
            COMPILE_ASSERT(!(STATE & IdSet), property_id_already_set);
            m_result->setNumber("id", value);
            return castState<IdSet>();
        }

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString("url", value);
            return castState<UrlSet>();
        }

        Builder<STATE | TitleSet>& setTitle(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TitleSet), property_title_already_set);
            m_result->setString("title", value);
            return castState<TitleSet>();
        }

        operator RefPtr<NavigationEntry>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(NavigationEntry) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<NavigationEntry>*>(&m_result);
        }

        PassRefPtr<NavigationEntry> release()
        {
            return RefPtr<NavigationEntry>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<NavigationEntry> result = NavigationEntry::create()
     *     .setId(...)
     *     .setUrl(...)
     *     .setTitle(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void id(int* value)
    {
        JSONObjectBase::getNumber("id", value);
    }

    void url(String* value)
    {
        JSONObjectBase::getString("url", value);
    }

    void title(String* value)
    {
        JSONObjectBase::getString("title", value);
    }
};

/* Quota information */
class Quota : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        TemporarySet = 1 << 0,
        PersistentSet = 1 << 1,
        AllFieldsSet = (TemporarySet | PersistentSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Quota*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Quota;
    public:

        Builder<STATE | TemporarySet>& setTemporary(double value)
        {
            COMPILE_ASSERT(!(STATE & TemporarySet), property_temporary_already_set);
            m_result->setNumber("temporary", value);
            return castState<TemporarySet>();
        }

        Builder<STATE | PersistentSet>& setPersistent(double value)
        {
            COMPILE_ASSERT(!(STATE & PersistentSet), property_persistent_already_set);
            m_result->setNumber("persistent", value);
            return castState<PersistentSet>();
        }

        operator RefPtr<Quota>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Quota) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Quota>*>(&m_result);
        }

        PassRefPtr<Quota> release()
        {
            return RefPtr<Quota>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Quota> result = Quota::create()
     *     .setTemporary(...)
     *     .setPersistent(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void temporary(double* value)
    {
        JSONObjectBase::getNumber("temporary", value);
    }

    void persistent(double* value)
    {
        JSONObjectBase::getNumber("persistent", value);
    }
};

/* Usage information */
class Usage : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        TemporarySet = 1 << 0,
        PersistentSet = 1 << 1,
        SyncableSet = 1 << 2,
        AllFieldsSet = (TemporarySet | PersistentSet | SyncableSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Usage*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Usage;
    public:

        Builder<STATE | TemporarySet>& setTemporary(PassRefPtr<TypeBuilder::Array<TypeBuilder::Page::UsageItem> > value)
        {
            COMPILE_ASSERT(!(STATE & TemporarySet), property_temporary_already_set);
            m_result->setValue("temporary", value);
            return castState<TemporarySet>();
        }

        Builder<STATE | PersistentSet>& setPersistent(PassRefPtr<TypeBuilder::Array<TypeBuilder::Page::UsageItem> > value)
        {
            COMPILE_ASSERT(!(STATE & PersistentSet), property_persistent_already_set);
            m_result->setValue("persistent", value);
            return castState<PersistentSet>();
        }

        Builder<STATE | SyncableSet>& setSyncable(PassRefPtr<TypeBuilder::Array<TypeBuilder::Page::UsageItem> > value)
        {
            COMPILE_ASSERT(!(STATE & SyncableSet), property_syncable_already_set);
            m_result->setValue("syncable", value);
            return castState<SyncableSet>();
        }

        operator RefPtr<Usage>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Usage) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Usage>*>(&m_result);
        }

        PassRefPtr<Usage> release()
        {
            return RefPtr<Usage>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Usage> result = Usage::create()
     *     .setTemporary(...)
     *     .setPersistent(...)
     *     .setSyncable(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

/* Usage information for a client and storage type */
class UsageItem : public JSONObjectBase {
public:
    // Named after property name 'id' while generating UsageItem.
    struct Id {
        enum Enum {
            Filesystem = 10,
            Database = 11,
            Appcache = 12,
            Indexeddatabase = 13,
        };
    }; // struct Id

    enum {
        NoFieldsSet = 0,
        IdSet = 1 << 0,
        ValueSet = 1 << 1,
        AllFieldsSet = (IdSet | ValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*UsageItem*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class UsageItem;
    public:

        Builder<STATE | IdSet>& setId(Id::Enum value)
        {
            COMPILE_ASSERT(!(STATE & IdSet), property_id_already_set);
            m_result->setString("id", TypeBuilder::getEnumConstantValue(value));
            return castState<IdSet>();
        }

        Builder<STATE | ValueSet>& setValue(double value)
        {
            COMPILE_ASSERT(!(STATE & ValueSet), property_value_already_set);
            m_result->setNumber("value", value);
            return castState<ValueSet>();
        }

        operator RefPtr<UsageItem>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(UsageItem) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<UsageItem>*>(&m_result);
        }

        PassRefPtr<UsageItem> release()
        {
            return RefPtr<UsageItem>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<UsageItem> result = UsageItem::create()
     *     .setId(...)
     *     .setValue(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void value(double* value)
    {
        JSONObjectBase::getNumber("value", value);
    }
};

/* Screencast frame metadata */
class ScreencastFrameMetadata : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        DeviceScaleFactorSet = 1 << 0,
        ViewportSet = 1 << 1,
        PageScaleFactorSet = 1 << 2,
        PageScaleFactorMinSet = 1 << 3,
        PageScaleFactorMaxSet = 1 << 4,
        AllFieldsSet = (DeviceScaleFactorSet | ViewportSet | PageScaleFactorSet | PageScaleFactorMinSet | PageScaleFactorMaxSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*ScreencastFrameMetadata*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class ScreencastFrameMetadata;
    public:

        Builder<STATE | DeviceScaleFactorSet>& setDeviceScaleFactor(double value)
        {
            COMPILE_ASSERT(!(STATE & DeviceScaleFactorSet), property_deviceScaleFactor_already_set);
            m_result->setNumber("deviceScaleFactor", value);
            return castState<DeviceScaleFactorSet>();
        }

        Builder<STATE | ViewportSet>& setViewport(PassRefPtr<TypeBuilder::DOM::Rect> value)
        {
            COMPILE_ASSERT(!(STATE & ViewportSet), property_viewport_already_set);
            m_result->setValue("viewport", value);
            return castState<ViewportSet>();
        }

        Builder<STATE | PageScaleFactorSet>& setPageScaleFactor(double value)
        {
            COMPILE_ASSERT(!(STATE & PageScaleFactorSet), property_pageScaleFactor_already_set);
            m_result->setNumber("pageScaleFactor", value);
            return castState<PageScaleFactorSet>();
        }

        Builder<STATE | PageScaleFactorMinSet>& setPageScaleFactorMin(double value)
        {
            COMPILE_ASSERT(!(STATE & PageScaleFactorMinSet), property_pageScaleFactorMin_already_set);
            m_result->setNumber("pageScaleFactorMin", value);
            return castState<PageScaleFactorMinSet>();
        }

        Builder<STATE | PageScaleFactorMaxSet>& setPageScaleFactorMax(double value)
        {
            COMPILE_ASSERT(!(STATE & PageScaleFactorMaxSet), property_pageScaleFactorMax_already_set);
            m_result->setNumber("pageScaleFactorMax", value);
            return castState<PageScaleFactorMaxSet>();
        }

        operator RefPtr<ScreencastFrameMetadata>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ScreencastFrameMetadata) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<ScreencastFrameMetadata>*>(&m_result);
        }

        PassRefPtr<ScreencastFrameMetadata> release()
        {
            return RefPtr<ScreencastFrameMetadata>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<ScreencastFrameMetadata> result = ScreencastFrameMetadata::create()
     *     .setDeviceScaleFactor(...)
     *     .setViewport(...)
     *     .setPageScaleFactor(...)
     *     .setPageScaleFactorMin(...)
     *     .setPageScaleFactorMax(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void deviceScaleFactor(double* value)
    {
        JSONObjectBase::getNumber("deviceScaleFactor", value);
    }

    void pageScaleFactor(double* value)
    {
        JSONObjectBase::getNumber("pageScaleFactor", value);
    }

    void pageScaleFactorMin(double* value)
    {
        JSONObjectBase::getNumber("pageScaleFactorMin", value);
    }

    void pageScaleFactorMax(double* value)
    {
        JSONObjectBase::getNumber("pageScaleFactorMax", value);
    }

    void setOffsetTop(double value)
    {
        this->setNumber("offsetTop", value);
    }

    void setOffsetBottom(double value)
    {
        this->setNumber("offsetBottom", value);
    }
};

} // Page

namespace Runtime {
/* Mirror object referencing original JavaScript object. */
class RemoteObject : public JSONObjectBase {
public:
    // Named after property name 'type' while generating RemoteObject.
    struct Type {
        enum Enum {
            Object = 14,
            Function = 15,
            Undefined = 16,
            String = 17,
            Number = 18,
            Boolean = 19,
            Symbol = 20,
        };
#if ASSERT_ENABLED
        static void assertCorrectValue(JSONValue* value);
#endif  // ASSERT_ENABLED
    }; // struct Type

    // Named after property name 'subtype' while generating RemoteObject.
    struct Subtype {
        enum Enum {
            Array = 21,
            Null = 22,
            Node = 23,
            Regexp = 24,
            Date = 25,
        };
#if ASSERT_ENABLED
        static void assertCorrectValue(JSONValue* value);
#endif  // ASSERT_ENABLED
    }; // struct Subtype

    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        AllFieldsSet = (TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*RemoteObject*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class RemoteObject;
    public:

        Builder<STATE | TypeSet>& setType(Type::Enum value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type", TypeBuilder::getEnumConstantValue(value));
            return castState<TypeSet>();
        }

        operator RefPtr<RemoteObject>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(RemoteObject) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<RemoteObject>*>(&m_result);
        }

        PassRefPtr<RemoteObject> release()
        {
            return RefPtr<RemoteObject>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<RemoteObject> result = RemoteObject::create()
     *     .setType(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setSubtype(Subtype::Enum value)
    {
        this->setString("subtype", TypeBuilder::getEnumConstantValue(value));
    }

    void setClassName(const String& value)
    {
        this->setString("className", value);
    }

    void setValue(PassRefPtr<JSONValue> value)
    {
        this->setValue("value", value);
    }
    using JSONObjectBase::setValue;


    void setDescription(const String& value)
    {
        this->setString("description", value);
    }

    void setObjectId(const TypeBuilder::Runtime::RemoteObjectId& value)
    {
        this->setString("objectId", value);
    }

    void setPreview(PassRefPtr<TypeBuilder::Runtime::ObjectPreview> value)
    {
        this->setValue("preview", value);
    }
    static PassRefPtr<RemoteObject> runtimeCast(PassRefPtr<JSONValue> value)
    {
        RefPtr<JSONObject> object;
        bool castRes = value->asObject(&object);
        ASSERT_UNUSED(castRes, castRes);
#if ASSERT_ENABLED
        assertCorrectValue(object.get());
#endif  // ASSERT_ENABLED
        COMPILE_ASSERT(sizeof(RemoteObject) == sizeof(JSONObjectBase), type_cast_problem);
        return static_cast<RemoteObject*>(static_cast<JSONObjectBase*>(object.get()));
    }

#if ASSERT_ENABLED
    static void assertCorrectValue(JSONValue* value);
#endif  // ASSERT_ENABLED
};

/* Object containing abbreviated remote object value. */
class ObjectPreview : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        LosslessSet = 1 << 0,
        OverflowSet = 1 << 1,
        PropertiesSet = 1 << 2,
        AllFieldsSet = (LosslessSet | OverflowSet | PropertiesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*ObjectPreview*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class ObjectPreview;
    public:

        Builder<STATE | LosslessSet>& setLossless(bool value)
        {
            COMPILE_ASSERT(!(STATE & LosslessSet), property_lossless_already_set);
            m_result->setBoolean("lossless", value);
            return castState<LosslessSet>();
        }

        Builder<STATE | OverflowSet>& setOverflow(bool value)
        {
            COMPILE_ASSERT(!(STATE & OverflowSet), property_overflow_already_set);
            m_result->setBoolean("overflow", value);
            return castState<OverflowSet>();
        }

        Builder<STATE | PropertiesSet>& setProperties(PassRefPtr<TypeBuilder::Array<TypeBuilder::Runtime::PropertyPreview> > value)
        {
            COMPILE_ASSERT(!(STATE & PropertiesSet), property_properties_already_set);
            m_result->setValue("properties", value);
            return castState<PropertiesSet>();
        }

        operator RefPtr<ObjectPreview>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ObjectPreview) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<ObjectPreview>*>(&m_result);
        }

        PassRefPtr<ObjectPreview> release()
        {
            return RefPtr<ObjectPreview>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<ObjectPreview> result = ObjectPreview::create()
     *     .setLossless(...)
     *     .setOverflow(...)
     *     .setProperties(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void lossless(bool* value)
    {
        JSONObjectBase::getBoolean("lossless", value);
    }

    void overflow(bool* value)
    {
        JSONObjectBase::getBoolean("overflow", value);
    }
#if ASSERT_ENABLED
    static void assertCorrectValue(JSONValue* value);
#endif  // ASSERT_ENABLED
};

class PropertyPreview : public JSONObjectBase {
public:
    // Named after property name 'type' while generating PropertyPreview.
    struct Type {
        enum Enum {
            Object = 14,
            Function = 15,
            Undefined = 16,
            String = 17,
            Number = 18,
            Boolean = 19,
            Symbol = 20,
            Accessor = 26,
        };
#if ASSERT_ENABLED
        static void assertCorrectValue(JSONValue* value);
#endif  // ASSERT_ENABLED
    }; // struct Type

    // Named after property name 'subtype' while generating PropertyPreview.
    struct Subtype {
        enum Enum {
            Array = 21,
            Null = 22,
            Node = 23,
            Regexp = 24,
            Date = 25,
        };
#if ASSERT_ENABLED
        static void assertCorrectValue(JSONValue* value);
#endif  // ASSERT_ENABLED
    }; // struct Subtype

    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        TypeSet = 1 << 1,
        AllFieldsSet = (NameSet | TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*PropertyPreview*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class PropertyPreview;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name", value);
            return castState<NameSet>();
        }

        Builder<STATE | TypeSet>& setType(Type::Enum value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type", TypeBuilder::getEnumConstantValue(value));
            return castState<TypeSet>();
        }

        operator RefPtr<PropertyPreview>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(PropertyPreview) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<PropertyPreview>*>(&m_result);
        }

        PassRefPtr<PropertyPreview> release()
        {
            return RefPtr<PropertyPreview>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<PropertyPreview> result = PropertyPreview::create()
     *     .setName(...)
     *     .setType(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void name(String* value)
    {
        JSONObjectBase::getString("name", value);
    }

    void setValue(const String& value)
    {
        this->setString("value", value);
    }
    using JSONObjectBase::setValue;


    void setValuePreview(PassRefPtr<TypeBuilder::Runtime::ObjectPreview> value)
    {
        this->setValue("valuePreview", value);
    }

    void setSubtype(Subtype::Enum value)
    {
        this->setString("subtype", TypeBuilder::getEnumConstantValue(value));
    }
#if ASSERT_ENABLED
    static void assertCorrectValue(JSONValue* value);
#endif  // ASSERT_ENABLED
};

/* Object property descriptor. */
class PropertyDescriptor : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        ConfigurableSet = 1 << 1,
        EnumerableSet = 1 << 2,
        AllFieldsSet = (NameSet | ConfigurableSet | EnumerableSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*PropertyDescriptor*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class PropertyDescriptor;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name", value);
            return castState<NameSet>();
        }

        Builder<STATE | ConfigurableSet>& setConfigurable(bool value)
        {
            COMPILE_ASSERT(!(STATE & ConfigurableSet), property_configurable_already_set);
            m_result->setBoolean("configurable", value);
            return castState<ConfigurableSet>();
        }

        Builder<STATE | EnumerableSet>& setEnumerable(bool value)
        {
            COMPILE_ASSERT(!(STATE & EnumerableSet), property_enumerable_already_set);
            m_result->setBoolean("enumerable", value);
            return castState<EnumerableSet>();
        }

        operator RefPtr<PropertyDescriptor>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(PropertyDescriptor) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<PropertyDescriptor>*>(&m_result);
        }

        PassRefPtr<PropertyDescriptor> release()
        {
            return RefPtr<PropertyDescriptor>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<PropertyDescriptor> result = PropertyDescriptor::create()
     *     .setName(...)
     *     .setConfigurable(...)
     *     .setEnumerable(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void name(String* value)
    {
        JSONObjectBase::getString("name", value);
    }

    void configurable(bool* value)
    {
        JSONObjectBase::getBoolean("configurable", value);
    }

    void enumerable(bool* value)
    {
        JSONObjectBase::getBoolean("enumerable", value);
    }

    void setValue(PassRefPtr<TypeBuilder::Runtime::RemoteObject> value)
    {
        this->setValue("value", value);
    }
    using JSONObjectBase::setValue;


    void setWritable(bool value)
    {
        this->setBoolean("writable", value);
    }

    void setGet(PassRefPtr<TypeBuilder::Runtime::RemoteObject> value)
    {
        this->setValue("get", value);
    }

    void setSet(PassRefPtr<TypeBuilder::Runtime::RemoteObject> value)
    {
        this->setValue("set", value);
    }

    void setWasThrown(bool value)
    {
        this->setBoolean("wasThrown", value);
    }

    void setIsOwn(bool value)
    {
        this->setBoolean("isOwn", value);
    }

    void setSymbol(PassRefPtr<TypeBuilder::Runtime::RemoteObject> value)
    {
        this->setValue("symbol", value);
    }
    static PassRefPtr<PropertyDescriptor> runtimeCast(PassRefPtr<JSONValue> value)
    {
        RefPtr<JSONObject> object;
        bool castRes = value->asObject(&object);
        ASSERT_UNUSED(castRes, castRes);
#if ASSERT_ENABLED
        assertCorrectValue(object.get());
#endif  // ASSERT_ENABLED
        COMPILE_ASSERT(sizeof(PropertyDescriptor) == sizeof(JSONObjectBase), type_cast_problem);
        return static_cast<PropertyDescriptor*>(static_cast<JSONObjectBase*>(object.get()));
    }

#if ASSERT_ENABLED
    static void assertCorrectValue(JSONValue* value);
#endif  // ASSERT_ENABLED
};

/* Object internal property descriptor. This property isn't normally visible in JavaScript code. */
class InternalPropertyDescriptor : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        AllFieldsSet = (NameSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*InternalPropertyDescriptor*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class InternalPropertyDescriptor;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name", value);
            return castState<NameSet>();
        }

        operator RefPtr<InternalPropertyDescriptor>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(InternalPropertyDescriptor) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<InternalPropertyDescriptor>*>(&m_result);
        }

        PassRefPtr<InternalPropertyDescriptor> release()
        {
            return RefPtr<InternalPropertyDescriptor>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<InternalPropertyDescriptor> result = InternalPropertyDescriptor::create()
     *     .setName(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void name(String* value)
    {
        JSONObjectBase::getString("name", value);
    }

    void setValue(PassRefPtr<TypeBuilder::Runtime::RemoteObject> value)
    {
        this->setValue("value", value);
    }
    using JSONObjectBase::setValue;

    static PassRefPtr<InternalPropertyDescriptor> runtimeCast(PassRefPtr<JSONValue> value)
    {
        RefPtr<JSONObject> object;
        bool castRes = value->asObject(&object);
        ASSERT_UNUSED(castRes, castRes);
#if ASSERT_ENABLED
        assertCorrectValue(object.get());
#endif  // ASSERT_ENABLED
        COMPILE_ASSERT(sizeof(InternalPropertyDescriptor) == sizeof(JSONObjectBase), type_cast_problem);
        return static_cast<InternalPropertyDescriptor*>(static_cast<JSONObjectBase*>(object.get()));
    }

#if ASSERT_ENABLED
    static void assertCorrectValue(JSONValue* value);
#endif  // ASSERT_ENABLED
};

/* Represents function call argument. Either remote object id <code>objectId</code> or primitive <code>value</code> or neither of (for undefined) them should be specified. */
class CallArgument : public JSONObjectBase {
public:
    // Named after property name 'type' while generating CallArgument.
    struct Type {
        enum Enum {
            Object = 14,
            Function = 15,
            Undefined = 16,
            String = 17,
            Number = 18,
            Boolean = 19,
            Symbol = 20,
        };
    }; // struct Type

    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*CallArgument*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class CallArgument;
    public:

        operator RefPtr<CallArgument>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CallArgument) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<CallArgument>*>(&m_result);
        }

        PassRefPtr<CallArgument> release()
        {
            return RefPtr<CallArgument>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<CallArgument> result = CallArgument::create();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setValue(PassRefPtr<JSONValue> value)
    {
        this->setValue("value", value);
    }
    using JSONObjectBase::setValue;


    void setObjectId(const TypeBuilder::Runtime::RemoteObjectId& value)
    {
        this->setString("objectId", value);
    }

    void setType(Type::Enum value)
    {
        this->setString("type", TypeBuilder::getEnumConstantValue(value));
    }
};

/* Description of an isolated world. */
class ExecutionContextDescription : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        IdSet = 1 << 0,
        IsPageContextSet = 1 << 1,
        NameSet = 1 << 2,
        FrameIdSet = 1 << 3,
        AllFieldsSet = (IdSet | IsPageContextSet | NameSet | FrameIdSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*ExecutionContextDescription*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class ExecutionContextDescription;
    public:

        Builder<STATE | IdSet>& setId(int value)
        {
            COMPILE_ASSERT(!(STATE & IdSet), property_id_already_set);
            m_result->setNumber("id", value);
            return castState<IdSet>();
        }

        Builder<STATE | IsPageContextSet>& setIsPageContext(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsPageContextSet), property_isPageContext_already_set);
            m_result->setBoolean("isPageContext", value);
            return castState<IsPageContextSet>();
        }

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name", value);
            return castState<NameSet>();
        }

        Builder<STATE | FrameIdSet>& setFrameId(const TypeBuilder::Page::FrameId& value)
        {
            COMPILE_ASSERT(!(STATE & FrameIdSet), property_frameId_already_set);
            m_result->setString("frameId", value);
            return castState<FrameIdSet>();
        }

        operator RefPtr<ExecutionContextDescription>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ExecutionContextDescription) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<ExecutionContextDescription>*>(&m_result);
        }

        PassRefPtr<ExecutionContextDescription> release()
        {
            return RefPtr<ExecutionContextDescription>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<ExecutionContextDescription> result = ExecutionContextDescription::create()
     *     .setId(...)
     *     .setIsPageContext(...)
     *     .setName(...)
     *     .setFrameId(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void id(int* value)
    {
        JSONObjectBase::getNumber("id", value);
    }

    void isPageContext(bool* value)
    {
        JSONObjectBase::getBoolean("isPageContext", value);
    }

    void name(String* value)
    {
        JSONObjectBase::getString("name", value);
    }

    void frameId(TypeBuilder::Page::FrameId* value)
    {
        JSONObjectBase::getString("frameId", value);
    }
};

} // Runtime

namespace Console {
/* Console message. */
class ConsoleMessage : public JSONObjectBase {
public:
    // Named after property name 'source' while generating ConsoleMessage.
    struct Source {
        enum Enum {
            Xml = 27,
            Javascript = 28,
            Network = 29,
            Console_api = 30,
            Storage = 31,
            Appcache = 12,
            Rendering = 32,
            Css = 33,
            Security = 34,
            Other = 35,
            Deprecation = 36,
        };
    }; // struct Source

    // Named after property name 'level' while generating ConsoleMessage.
    struct Level {
        enum Enum {
            Log = 37,
            Warning = 38,
            Error = 39,
            Debug = 40,
            Info = 41,
        };
    }; // struct Level

    // Named after property name 'type' while generating ConsoleMessage.
    struct Type {
        enum Enum {
            Log = 37,
            Dir = 42,
            Dirxml = 43,
            Table = 44,
            Trace = 45,
            Clear = 46,
            StartGroup = 47,
            StartGroupCollapsed = 48,
            EndGroup = 49,
            Assert = 50,
            Profile = 51,
            ProfileEnd = 52,
        };
    }; // struct Type

    enum {
        NoFieldsSet = 0,
        SourceSet = 1 << 0,
        LevelSet = 1 << 1,
        TextSet = 1 << 2,
        TimestampSet = 1 << 3,
        AllFieldsSet = (SourceSet | LevelSet | TextSet | TimestampSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*ConsoleMessage*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class ConsoleMessage;
    public:

        Builder<STATE | SourceSet>& setSource(Source::Enum value)
        {
            COMPILE_ASSERT(!(STATE & SourceSet), property_source_already_set);
            m_result->setString("source", TypeBuilder::getEnumConstantValue(value));
            return castState<SourceSet>();
        }

        Builder<STATE | LevelSet>& setLevel(Level::Enum value)
        {
            COMPILE_ASSERT(!(STATE & LevelSet), property_level_already_set);
            m_result->setString("level", TypeBuilder::getEnumConstantValue(value));
            return castState<LevelSet>();
        }

        Builder<STATE | TextSet>& setText(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TextSet), property_text_already_set);
            m_result->setString("text", value);
            return castState<TextSet>();
        }

        Builder<STATE | TimestampSet>& setTimestamp(double value)
        {
            COMPILE_ASSERT(!(STATE & TimestampSet), property_timestamp_already_set);
            m_result->setNumber("timestamp", value);
            return castState<TimestampSet>();
        }

        operator RefPtr<ConsoleMessage>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ConsoleMessage) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<ConsoleMessage>*>(&m_result);
        }

        PassRefPtr<ConsoleMessage> release()
        {
            return RefPtr<ConsoleMessage>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<ConsoleMessage> result = ConsoleMessage::create()
     *     .setSource(...)
     *     .setLevel(...)
     *     .setText(...)
     *     .setTimestamp(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void text(String* value)
    {
        JSONObjectBase::getString("text", value);
    }

    void timestamp(double* value)
    {
        JSONObjectBase::getNumber("timestamp", value);
    }

    void setType(Type::Enum value)
    {
        this->setString("type", TypeBuilder::getEnumConstantValue(value));
    }

    void setUrl(const String& value)
    {
        this->setString("url", value);
    }

    void setLine(int value)
    {
        this->setNumber("line", value);
    }

    void setColumn(int value)
    {
        this->setNumber("column", value);
    }

    void setRepeatCount(int value)
    {
        this->setNumber("repeatCount", value);
    }

    void setParameters(PassRefPtr<TypeBuilder::Array<TypeBuilder::Runtime::RemoteObject> > value)
    {
        this->setValue("parameters", value);
    }

    void setStackTrace(PassRefPtr<TypeBuilder::Array<TypeBuilder::Console::CallFrame> > value)
    {
        this->setValue("stackTrace", value);
    }

    void setNetworkRequestId(const TypeBuilder::Network::RequestId& value)
    {
        this->setString("networkRequestId", value);
    }

    void setExecutionContextId(int value)
    {
        this->setNumber("executionContextId", value);
    }
};

/* Stack entry for console errors and assertions. */
class CallFrame : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        FunctionNameSet = 1 << 0,
        ScriptIdSet = 1 << 1,
        UrlSet = 1 << 2,
        LineNumberSet = 1 << 3,
        ColumnNumberSet = 1 << 4,
        AllFieldsSet = (FunctionNameSet | ScriptIdSet | UrlSet | LineNumberSet | ColumnNumberSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*CallFrame*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class CallFrame;
    public:

        Builder<STATE | FunctionNameSet>& setFunctionName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & FunctionNameSet), property_functionName_already_set);
            m_result->setString("functionName", value);
            return castState<FunctionNameSet>();
        }

        Builder<STATE | ScriptIdSet>& setScriptId(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ScriptIdSet), property_scriptId_already_set);
            m_result->setString("scriptId", value);
            return castState<ScriptIdSet>();
        }

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString("url", value);
            return castState<UrlSet>();
        }

        Builder<STATE | LineNumberSet>& setLineNumber(int value)
        {
            COMPILE_ASSERT(!(STATE & LineNumberSet), property_lineNumber_already_set);
            m_result->setNumber("lineNumber", value);
            return castState<LineNumberSet>();
        }

        Builder<STATE | ColumnNumberSet>& setColumnNumber(int value)
        {
            COMPILE_ASSERT(!(STATE & ColumnNumberSet), property_columnNumber_already_set);
            m_result->setNumber("columnNumber", value);
            return castState<ColumnNumberSet>();
        }

        operator RefPtr<CallFrame>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CallFrame) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<CallFrame>*>(&m_result);
        }

        PassRefPtr<CallFrame> release()
        {
            return RefPtr<CallFrame>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<CallFrame> result = CallFrame::create()
     *     .setFunctionName(...)
     *     .setScriptId(...)
     *     .setUrl(...)
     *     .setLineNumber(...)
     *     .setColumnNumber(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void functionName(String* value)
    {
        JSONObjectBase::getString("functionName", value);
    }

    void scriptId(String* value)
    {
        JSONObjectBase::getString("scriptId", value);
    }

    void url(String* value)
    {
        JSONObjectBase::getString("url", value);
    }

    void lineNumber(int* value)
    {
        JSONObjectBase::getNumber("lineNumber", value);
    }

    void columnNumber(int* value)
    {
        JSONObjectBase::getNumber("columnNumber", value);
    }
};

} // Console

namespace Network {
/* Timing information for the request. */
class ResourceTiming : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        RequestTimeSet = 1 << 0,
        ProxyStartSet = 1 << 1,
        ProxyEndSet = 1 << 2,
        DnsStartSet = 1 << 3,
        DnsEndSet = 1 << 4,
        ConnectStartSet = 1 << 5,
        ConnectEndSet = 1 << 6,
        SslStartSet = 1 << 7,
        SslEndSet = 1 << 8,
        SendStartSet = 1 << 9,
        SendEndSet = 1 << 10,
        ReceiveHeadersEndSet = 1 << 11,
        AllFieldsSet = (RequestTimeSet | ProxyStartSet | ProxyEndSet | DnsStartSet | DnsEndSet | ConnectStartSet | ConnectEndSet | SslStartSet | SslEndSet | SendStartSet | SendEndSet | ReceiveHeadersEndSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*ResourceTiming*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class ResourceTiming;
    public:

        Builder<STATE | RequestTimeSet>& setRequestTime(double value)
        {
            COMPILE_ASSERT(!(STATE & RequestTimeSet), property_requestTime_already_set);
            m_result->setNumber("requestTime", value);
            return castState<RequestTimeSet>();
        }

        Builder<STATE | ProxyStartSet>& setProxyStart(double value)
        {
            COMPILE_ASSERT(!(STATE & ProxyStartSet), property_proxyStart_already_set);
            m_result->setNumber("proxyStart", value);
            return castState<ProxyStartSet>();
        }

        Builder<STATE | ProxyEndSet>& setProxyEnd(double value)
        {
            COMPILE_ASSERT(!(STATE & ProxyEndSet), property_proxyEnd_already_set);
            m_result->setNumber("proxyEnd", value);
            return castState<ProxyEndSet>();
        }

        Builder<STATE | DnsStartSet>& setDnsStart(double value)
        {
            COMPILE_ASSERT(!(STATE & DnsStartSet), property_dnsStart_already_set);
            m_result->setNumber("dnsStart", value);
            return castState<DnsStartSet>();
        }

        Builder<STATE | DnsEndSet>& setDnsEnd(double value)
        {
            COMPILE_ASSERT(!(STATE & DnsEndSet), property_dnsEnd_already_set);
            m_result->setNumber("dnsEnd", value);
            return castState<DnsEndSet>();
        }

        Builder<STATE | ConnectStartSet>& setConnectStart(double value)
        {
            COMPILE_ASSERT(!(STATE & ConnectStartSet), property_connectStart_already_set);
            m_result->setNumber("connectStart", value);
            return castState<ConnectStartSet>();
        }

        Builder<STATE | ConnectEndSet>& setConnectEnd(double value)
        {
            COMPILE_ASSERT(!(STATE & ConnectEndSet), property_connectEnd_already_set);
            m_result->setNumber("connectEnd", value);
            return castState<ConnectEndSet>();
        }

        Builder<STATE | SslStartSet>& setSslStart(double value)
        {
            COMPILE_ASSERT(!(STATE & SslStartSet), property_sslStart_already_set);
            m_result->setNumber("sslStart", value);
            return castState<SslStartSet>();
        }

        Builder<STATE | SslEndSet>& setSslEnd(double value)
        {
            COMPILE_ASSERT(!(STATE & SslEndSet), property_sslEnd_already_set);
            m_result->setNumber("sslEnd", value);
            return castState<SslEndSet>();
        }

        Builder<STATE | SendStartSet>& setSendStart(double value)
        {
            COMPILE_ASSERT(!(STATE & SendStartSet), property_sendStart_already_set);
            m_result->setNumber("sendStart", value);
            return castState<SendStartSet>();
        }

        Builder<STATE | SendEndSet>& setSendEnd(double value)
        {
            COMPILE_ASSERT(!(STATE & SendEndSet), property_sendEnd_already_set);
            m_result->setNumber("sendEnd", value);
            return castState<SendEndSet>();
        }

        Builder<STATE | ReceiveHeadersEndSet>& setReceiveHeadersEnd(double value)
        {
            COMPILE_ASSERT(!(STATE & ReceiveHeadersEndSet), property_receiveHeadersEnd_already_set);
            m_result->setNumber("receiveHeadersEnd", value);
            return castState<ReceiveHeadersEndSet>();
        }

        operator RefPtr<ResourceTiming>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ResourceTiming) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<ResourceTiming>*>(&m_result);
        }

        PassRefPtr<ResourceTiming> release()
        {
            return RefPtr<ResourceTiming>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<ResourceTiming> result = ResourceTiming::create()
     *     .setRequestTime(...)
     *     .setProxyStart(...)
     *     .setProxyEnd(...)
     *     .setDnsStart(...)
     *     .setDnsEnd(...)
     *     .setConnectStart(...)
     *     .setConnectEnd(...)
     *     .setSslStart(...)
     *     .setSslEnd(...)
     *     .setSendStart(...)
     *     .setSendEnd(...)
     *     .setReceiveHeadersEnd(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void requestTime(double* value)
    {
        JSONObjectBase::getNumber("requestTime", value);
    }

    void proxyStart(double* value)
    {
        JSONObjectBase::getNumber("proxyStart", value);
    }

    void proxyEnd(double* value)
    {
        JSONObjectBase::getNumber("proxyEnd", value);
    }

    void dnsStart(double* value)
    {
        JSONObjectBase::getNumber("dnsStart", value);
    }

    void dnsEnd(double* value)
    {
        JSONObjectBase::getNumber("dnsEnd", value);
    }

    void connectStart(double* value)
    {
        JSONObjectBase::getNumber("connectStart", value);
    }

    void connectEnd(double* value)
    {
        JSONObjectBase::getNumber("connectEnd", value);
    }

    void sslStart(double* value)
    {
        JSONObjectBase::getNumber("sslStart", value);
    }

    void sslEnd(double* value)
    {
        JSONObjectBase::getNumber("sslEnd", value);
    }

    void sendStart(double* value)
    {
        JSONObjectBase::getNumber("sendStart", value);
    }

    void sendEnd(double* value)
    {
        JSONObjectBase::getNumber("sendEnd", value);
    }

    void receiveHeadersEnd(double* value)
    {
        JSONObjectBase::getNumber("receiveHeadersEnd", value);
    }
};

/* HTTP request data. */
class Request : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        UrlSet = 1 << 0,
        MethodSet = 1 << 1,
        HeadersSet = 1 << 2,
        AllFieldsSet = (UrlSet | MethodSet | HeadersSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Request*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Request;
    public:

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString("url", value);
            return castState<UrlSet>();
        }

        Builder<STATE | MethodSet>& setMethod(const String& value)
        {
            COMPILE_ASSERT(!(STATE & MethodSet), property_method_already_set);
            m_result->setString("method", value);
            return castState<MethodSet>();
        }

        Builder<STATE | HeadersSet>& setHeaders(PassRefPtr<JSONObject> value)
        {
            COMPILE_ASSERT(!(STATE & HeadersSet), property_headers_already_set);
            m_result->setValue("headers", value);
            return castState<HeadersSet>();
        }

        operator RefPtr<Request>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Request) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Request>*>(&m_result);
        }

        PassRefPtr<Request> release()
        {
            return RefPtr<Request>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Request> result = Request::create()
     *     .setUrl(...)
     *     .setMethod(...)
     *     .setHeaders(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void url(String* value)
    {
        JSONObjectBase::getString("url", value);
    }

    void method(String* value)
    {
        JSONObjectBase::getString("method", value);
    }

    void setPostData(const String& value)
    {
        this->setString("postData", value);
    }
};

/* HTTP response data. */
class Response : public JSONObject {
public:
    enum {
        NoFieldsSet = 0,
        UrlSet = 1 << 0,
        StatusSet = 1 << 1,
        StatusTextSet = 1 << 2,
        HeadersSet = 1 << 3,
        MimeTypeSet = 1 << 4,
        ConnectionReusedSet = 1 << 5,
        ConnectionIdSet = 1 << 6,
        EncodedDataLengthSet = 1 << 7,
        AllFieldsSet = (UrlSet | StatusSet | StatusTextSet | HeadersSet | MimeTypeSet | ConnectionReusedSet | ConnectionIdSet | EncodedDataLengthSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Response*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Response;
    public:

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString("url", value);
            return castState<UrlSet>();
        }

        Builder<STATE | StatusSet>& setStatus(double value)
        {
            COMPILE_ASSERT(!(STATE & StatusSet), property_status_already_set);
            m_result->setNumber("status", value);
            return castState<StatusSet>();
        }

        Builder<STATE | StatusTextSet>& setStatusText(const String& value)
        {
            COMPILE_ASSERT(!(STATE & StatusTextSet), property_statusText_already_set);
            m_result->setString("statusText", value);
            return castState<StatusTextSet>();
        }

        Builder<STATE | HeadersSet>& setHeaders(PassRefPtr<JSONObject> value)
        {
            COMPILE_ASSERT(!(STATE & HeadersSet), property_headers_already_set);
            m_result->setValue("headers", value);
            return castState<HeadersSet>();
        }

        Builder<STATE | MimeTypeSet>& setMimeType(const String& value)
        {
            COMPILE_ASSERT(!(STATE & MimeTypeSet), property_mimeType_already_set);
            m_result->setString("mimeType", value);
            return castState<MimeTypeSet>();
        }

        Builder<STATE | ConnectionReusedSet>& setConnectionReused(bool value)
        {
            COMPILE_ASSERT(!(STATE & ConnectionReusedSet), property_connectionReused_already_set);
            m_result->setBoolean("connectionReused", value);
            return castState<ConnectionReusedSet>();
        }

        Builder<STATE | ConnectionIdSet>& setConnectionId(double value)
        {
            COMPILE_ASSERT(!(STATE & ConnectionIdSet), property_connectionId_already_set);
            m_result->setNumber("connectionId", value);
            return castState<ConnectionIdSet>();
        }

        Builder<STATE | EncodedDataLengthSet>& setEncodedDataLength(double value)
        {
            COMPILE_ASSERT(!(STATE & EncodedDataLengthSet), property_encodedDataLength_already_set);
            m_result->setNumber("encodedDataLength", value);
            return castState<EncodedDataLengthSet>();
        }

        operator RefPtr<Response>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Response) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Response>*>(&m_result);
        }

        PassRefPtr<Response> release()
        {
            return RefPtr<Response>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Response> result = Response::create()
     *     .setUrl(...)
     *     .setStatus(...)
     *     .setStatusText(...)
     *     .setHeaders(...)
     *     .setMimeType(...)
     *     .setConnectionReused(...)
     *     .setConnectionId(...)
     *     .setEncodedDataLength(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void url(String* value)
    {
        JSONObjectBase::getString("url", value);
    }

    void status(double* value)
    {
        JSONObjectBase::getNumber("status", value);
    }

    void statusText(String* value)
    {
        JSONObjectBase::getString("statusText", value);
    }

    void mimeType(String* value)
    {
        JSONObjectBase::getString("mimeType", value);
    }

    void connectionReused(bool* value)
    {
        JSONObjectBase::getBoolean("connectionReused", value);
    }

    void connectionId(double* value)
    {
        JSONObjectBase::getNumber("connectionId", value);
    }

    void encodedDataLength(double* value)
    {
        JSONObjectBase::getNumber("encodedDataLength", value);
    }

    void setHeadersText(const String& value)
    {
        this->setString("headersText", value);
    }

    void setRequestHeaders(PassRefPtr<JSONObject> value)
    {
        this->setValue("requestHeaders", value);
    }

    void setRequestHeadersText(const String& value)
    {
        this->setString("requestHeadersText", value);
    }

    void setRemoteIPAddress(const String& value)
    {
        this->setString("remoteIPAddress", value);
    }

    void setRemotePort(int value)
    {
        this->setNumber("remotePort", value);
    }

    void setFromDiskCache(bool value)
    {
        this->setBoolean("fromDiskCache", value);
    }

    void setTiming(PassRefPtr<TypeBuilder::Network::ResourceTiming> value)
    {
        this->setValue("timing", value);
    }

    // Property names for type generated as open.
    static const char Url[];
    static const char Status[];
    static const char StatusText[];
    static const char Headers[];
    static const char MimeType[];
    static const char ConnectionReused[];
    static const char ConnectionId[];
    static const char EncodedDataLength[];
    static const char HeadersText[];
    static const char RequestHeaders[];
    static const char RequestHeadersText[];
    static const char RemoteIPAddress[];
    static const char RemotePort[];
    static const char FromDiskCache[];
    static const char Timing[];
};

/* WebSocket request data. */
class WebSocketRequest : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        HeadersSet = 1 << 0,
        AllFieldsSet = (HeadersSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*WebSocketRequest*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class WebSocketRequest;
    public:

        Builder<STATE | HeadersSet>& setHeaders(PassRefPtr<JSONObject> value)
        {
            COMPILE_ASSERT(!(STATE & HeadersSet), property_headers_already_set);
            m_result->setValue("headers", value);
            return castState<HeadersSet>();
        }

        operator RefPtr<WebSocketRequest>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(WebSocketRequest) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<WebSocketRequest>*>(&m_result);
        }

        PassRefPtr<WebSocketRequest> release()
        {
            return RefPtr<WebSocketRequest>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<WebSocketRequest> result = WebSocketRequest::create()
     *     .setHeaders(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

/* WebSocket response data. */
class WebSocketResponse : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StatusSet = 1 << 0,
        StatusTextSet = 1 << 1,
        HeadersSet = 1 << 2,
        AllFieldsSet = (StatusSet | StatusTextSet | HeadersSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*WebSocketResponse*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class WebSocketResponse;
    public:

        Builder<STATE | StatusSet>& setStatus(double value)
        {
            COMPILE_ASSERT(!(STATE & StatusSet), property_status_already_set);
            m_result->setNumber("status", value);
            return castState<StatusSet>();
        }

        Builder<STATE | StatusTextSet>& setStatusText(const String& value)
        {
            COMPILE_ASSERT(!(STATE & StatusTextSet), property_statusText_already_set);
            m_result->setString("statusText", value);
            return castState<StatusTextSet>();
        }

        Builder<STATE | HeadersSet>& setHeaders(PassRefPtr<JSONObject> value)
        {
            COMPILE_ASSERT(!(STATE & HeadersSet), property_headers_already_set);
            m_result->setValue("headers", value);
            return castState<HeadersSet>();
        }

        operator RefPtr<WebSocketResponse>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(WebSocketResponse) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<WebSocketResponse>*>(&m_result);
        }

        PassRefPtr<WebSocketResponse> release()
        {
            return RefPtr<WebSocketResponse>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<WebSocketResponse> result = WebSocketResponse::create()
     *     .setStatus(...)
     *     .setStatusText(...)
     *     .setHeaders(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void status(double* value)
    {
        JSONObjectBase::getNumber("status", value);
    }

    void statusText(String* value)
    {
        JSONObjectBase::getString("statusText", value);
    }

    void setHeadersText(const String& value)
    {
        this->setString("headersText", value);
    }

    void setRequestHeaders(PassRefPtr<JSONObject> value)
    {
        this->setValue("requestHeaders", value);
    }

    void setRequestHeadersText(const String& value)
    {
        this->setString("requestHeadersText", value);
    }
};

/* WebSocket frame data. */
class WebSocketFrame : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        OpcodeSet = 1 << 0,
        MaskSet = 1 << 1,
        PayloadDataSet = 1 << 2,
        AllFieldsSet = (OpcodeSet | MaskSet | PayloadDataSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*WebSocketFrame*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class WebSocketFrame;
    public:

        Builder<STATE | OpcodeSet>& setOpcode(double value)
        {
            COMPILE_ASSERT(!(STATE & OpcodeSet), property_opcode_already_set);
            m_result->setNumber("opcode", value);
            return castState<OpcodeSet>();
        }

        Builder<STATE | MaskSet>& setMask(bool value)
        {
            COMPILE_ASSERT(!(STATE & MaskSet), property_mask_already_set);
            m_result->setBoolean("mask", value);
            return castState<MaskSet>();
        }

        Builder<STATE | PayloadDataSet>& setPayloadData(const String& value)
        {
            COMPILE_ASSERT(!(STATE & PayloadDataSet), property_payloadData_already_set);
            m_result->setString("payloadData", value);
            return castState<PayloadDataSet>();
        }

        operator RefPtr<WebSocketFrame>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(WebSocketFrame) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<WebSocketFrame>*>(&m_result);
        }

        PassRefPtr<WebSocketFrame> release()
        {
            return RefPtr<WebSocketFrame>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<WebSocketFrame> result = WebSocketFrame::create()
     *     .setOpcode(...)
     *     .setMask(...)
     *     .setPayloadData(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void opcode(double* value)
    {
        JSONObjectBase::getNumber("opcode", value);
    }

    void mask(bool* value)
    {
        JSONObjectBase::getBoolean("mask", value);
    }

    void payloadData(String* value)
    {
        JSONObjectBase::getString("payloadData", value);
    }
};

/* Information about the cached resource. */
class CachedResource : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        UrlSet = 1 << 0,
        TypeSet = 1 << 1,
        BodySizeSet = 1 << 2,
        AllFieldsSet = (UrlSet | TypeSet | BodySizeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*CachedResource*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class CachedResource;
    public:

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString("url", value);
            return castState<UrlSet>();
        }

        Builder<STATE | TypeSet>& setType(TypeBuilder::Page::ResourceType::Enum value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type", TypeBuilder::getEnumConstantValue(value));
            return castState<TypeSet>();
        }

        Builder<STATE | BodySizeSet>& setBodySize(double value)
        {
            COMPILE_ASSERT(!(STATE & BodySizeSet), property_bodySize_already_set);
            m_result->setNumber("bodySize", value);
            return castState<BodySizeSet>();
        }

        operator RefPtr<CachedResource>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CachedResource) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<CachedResource>*>(&m_result);
        }

        PassRefPtr<CachedResource> release()
        {
            return RefPtr<CachedResource>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<CachedResource> result = CachedResource::create()
     *     .setUrl(...)
     *     .setType(...)
     *     .setBodySize(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void url(String* value)
    {
        JSONObjectBase::getString("url", value);
    }

    void bodySize(double* value)
    {
        JSONObjectBase::getNumber("bodySize", value);
    }

    void setResponse(PassRefPtr<TypeBuilder::Network::Response> value)
    {
        this->setValue("response", value);
    }
};

/* Information about the request initiator. */
class Initiator : public JSONObjectBase {
public:
    // Named after property name 'type' while generating Initiator.
    struct Type {
        enum Enum {
            Parser = 53,
            Script = 54,
            Other = 35,
        };
    }; // struct Type

    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        AllFieldsSet = (TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Initiator*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Initiator;
    public:

        Builder<STATE | TypeSet>& setType(Type::Enum value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type", TypeBuilder::getEnumConstantValue(value));
            return castState<TypeSet>();
        }

        operator RefPtr<Initiator>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Initiator) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Initiator>*>(&m_result);
        }

        PassRefPtr<Initiator> release()
        {
            return RefPtr<Initiator>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Initiator> result = Initiator::create()
     *     .setType(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setStackTrace(PassRefPtr<TypeBuilder::Array<TypeBuilder::Console::CallFrame> > value)
    {
        this->setValue("stackTrace", value);
    }

    void setUrl(const String& value)
    {
        this->setString("url", value);
    }

    void setLineNumber(double value)
    {
        this->setNumber("lineNumber", value);
    }
};

} // Network

namespace Database {
/* Database object. */
class Database : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        IdSet = 1 << 0,
        DomainSet = 1 << 1,
        NameSet = 1 << 2,
        VersionSet = 1 << 3,
        AllFieldsSet = (IdSet | DomainSet | NameSet | VersionSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Database*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Database;
    public:

        Builder<STATE | IdSet>& setId(const TypeBuilder::Database::DatabaseId& value)
        {
            COMPILE_ASSERT(!(STATE & IdSet), property_id_already_set);
            m_result->setString("id", value);
            return castState<IdSet>();
        }

        Builder<STATE | DomainSet>& setDomain(const String& value)
        {
            COMPILE_ASSERT(!(STATE & DomainSet), property_domain_already_set);
            m_result->setString("domain", value);
            return castState<DomainSet>();
        }

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name", value);
            return castState<NameSet>();
        }

        Builder<STATE | VersionSet>& setVersion(const String& value)
        {
            COMPILE_ASSERT(!(STATE & VersionSet), property_version_already_set);
            m_result->setString("version", value);
            return castState<VersionSet>();
        }

        operator RefPtr<Database>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Database) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Database>*>(&m_result);
        }

        PassRefPtr<Database> release()
        {
            return RefPtr<Database>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Database> result = Database::create()
     *     .setId(...)
     *     .setDomain(...)
     *     .setName(...)
     *     .setVersion(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void id(TypeBuilder::Database::DatabaseId* value)
    {
        JSONObjectBase::getString("id", value);
    }

    void domain(String* value)
    {
        JSONObjectBase::getString("domain", value);
    }

    void name(String* value)
    {
        JSONObjectBase::getString("name", value);
    }

    void version(String* value)
    {
        JSONObjectBase::getString("version", value);
    }
};

/* Database error. */
class Error : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        MessageSet = 1 << 0,
        CodeSet = 1 << 1,
        AllFieldsSet = (MessageSet | CodeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Error*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Error;
    public:

        Builder<STATE | MessageSet>& setMessage(const String& value)
        {
            COMPILE_ASSERT(!(STATE & MessageSet), property_message_already_set);
            m_result->setString("message", value);
            return castState<MessageSet>();
        }

        Builder<STATE | CodeSet>& setCode(int value)
        {
            COMPILE_ASSERT(!(STATE & CodeSet), property_code_already_set);
            m_result->setNumber("code", value);
            return castState<CodeSet>();
        }

        operator RefPtr<Error>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Error) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Error>*>(&m_result);
        }

        PassRefPtr<Error> release()
        {
            return RefPtr<Error>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Error> result = Error::create()
     *     .setMessage(...)
     *     .setCode(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void message(String* value)
    {
        JSONObjectBase::getString("message", value);
    }

    void code(int* value)
    {
        JSONObjectBase::getNumber("code", value);
    }
};

} // Database

namespace IndexedDB {
/* Database with an array of object stores. */
class DatabaseWithObjectStores : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        VersionSet = 1 << 1,
        IntVersionSet = 1 << 2,
        ObjectStoresSet = 1 << 3,
        AllFieldsSet = (NameSet | VersionSet | IntVersionSet | ObjectStoresSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*DatabaseWithObjectStores*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class DatabaseWithObjectStores;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name", value);
            return castState<NameSet>();
        }

        Builder<STATE | VersionSet>& setVersion(const String& value)
        {
            COMPILE_ASSERT(!(STATE & VersionSet), property_version_already_set);
            m_result->setString("version", value);
            return castState<VersionSet>();
        }

        Builder<STATE | IntVersionSet>& setIntVersion(int value)
        {
            COMPILE_ASSERT(!(STATE & IntVersionSet), property_intVersion_already_set);
            m_result->setNumber("intVersion", value);
            return castState<IntVersionSet>();
        }

        Builder<STATE | ObjectStoresSet>& setObjectStores(PassRefPtr<TypeBuilder::Array<TypeBuilder::IndexedDB::ObjectStore> > value)
        {
            COMPILE_ASSERT(!(STATE & ObjectStoresSet), property_objectStores_already_set);
            m_result->setValue("objectStores", value);
            return castState<ObjectStoresSet>();
        }

        operator RefPtr<DatabaseWithObjectStores>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(DatabaseWithObjectStores) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<DatabaseWithObjectStores>*>(&m_result);
        }

        PassRefPtr<DatabaseWithObjectStores> release()
        {
            return RefPtr<DatabaseWithObjectStores>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<DatabaseWithObjectStores> result = DatabaseWithObjectStores::create()
     *     .setName(...)
     *     .setVersion(...)
     *     .setIntVersion(...)
     *     .setObjectStores(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void name(String* value)
    {
        JSONObjectBase::getString("name", value);
    }

    void version(String* value)
    {
        JSONObjectBase::getString("version", value);
    }

    void intVersion(int* value)
    {
        JSONObjectBase::getNumber("intVersion", value);
    }
};

/* Object store. */
class ObjectStore : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        KeyPathSet = 1 << 1,
        AutoIncrementSet = 1 << 2,
        IndexesSet = 1 << 3,
        AllFieldsSet = (NameSet | KeyPathSet | AutoIncrementSet | IndexesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*ObjectStore*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class ObjectStore;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name", value);
            return castState<NameSet>();
        }

        Builder<STATE | KeyPathSet>& setKeyPath(PassRefPtr<TypeBuilder::IndexedDB::KeyPath> value)
        {
            COMPILE_ASSERT(!(STATE & KeyPathSet), property_keyPath_already_set);
            m_result->setValue("keyPath", value);
            return castState<KeyPathSet>();
        }

        Builder<STATE | AutoIncrementSet>& setAutoIncrement(bool value)
        {
            COMPILE_ASSERT(!(STATE & AutoIncrementSet), property_autoIncrement_already_set);
            m_result->setBoolean("autoIncrement", value);
            return castState<AutoIncrementSet>();
        }

        Builder<STATE | IndexesSet>& setIndexes(PassRefPtr<TypeBuilder::Array<TypeBuilder::IndexedDB::ObjectStoreIndex> > value)
        {
            COMPILE_ASSERT(!(STATE & IndexesSet), property_indexes_already_set);
            m_result->setValue("indexes", value);
            return castState<IndexesSet>();
        }

        operator RefPtr<ObjectStore>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ObjectStore) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<ObjectStore>*>(&m_result);
        }

        PassRefPtr<ObjectStore> release()
        {
            return RefPtr<ObjectStore>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<ObjectStore> result = ObjectStore::create()
     *     .setName(...)
     *     .setKeyPath(...)
     *     .setAutoIncrement(...)
     *     .setIndexes(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void name(String* value)
    {
        JSONObjectBase::getString("name", value);
    }

    void autoIncrement(bool* value)
    {
        JSONObjectBase::getBoolean("autoIncrement", value);
    }
};

/* Object store index. */
class ObjectStoreIndex : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        KeyPathSet = 1 << 1,
        UniqueSet = 1 << 2,
        MultiEntrySet = 1 << 3,
        AllFieldsSet = (NameSet | KeyPathSet | UniqueSet | MultiEntrySet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*ObjectStoreIndex*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class ObjectStoreIndex;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name", value);
            return castState<NameSet>();
        }

        Builder<STATE | KeyPathSet>& setKeyPath(PassRefPtr<TypeBuilder::IndexedDB::KeyPath> value)
        {
            COMPILE_ASSERT(!(STATE & KeyPathSet), property_keyPath_already_set);
            m_result->setValue("keyPath", value);
            return castState<KeyPathSet>();
        }

        Builder<STATE | UniqueSet>& setUnique(bool value)
        {
            COMPILE_ASSERT(!(STATE & UniqueSet), property_unique_already_set);
            m_result->setBoolean("unique", value);
            return castState<UniqueSet>();
        }

        Builder<STATE | MultiEntrySet>& setMultiEntry(bool value)
        {
            COMPILE_ASSERT(!(STATE & MultiEntrySet), property_multiEntry_already_set);
            m_result->setBoolean("multiEntry", value);
            return castState<MultiEntrySet>();
        }

        operator RefPtr<ObjectStoreIndex>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ObjectStoreIndex) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<ObjectStoreIndex>*>(&m_result);
        }

        PassRefPtr<ObjectStoreIndex> release()
        {
            return RefPtr<ObjectStoreIndex>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<ObjectStoreIndex> result = ObjectStoreIndex::create()
     *     .setName(...)
     *     .setKeyPath(...)
     *     .setUnique(...)
     *     .setMultiEntry(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void name(String* value)
    {
        JSONObjectBase::getString("name", value);
    }

    void unique(bool* value)
    {
        JSONObjectBase::getBoolean("unique", value);
    }

    void multiEntry(bool* value)
    {
        JSONObjectBase::getBoolean("multiEntry", value);
    }
};

/* Key. */
class Key : public JSONObjectBase {
public:
    // Named after property name 'type' while generating Key.
    struct Type {
        enum Enum {
            Number = 18,
            String = 17,
            Date = 25,
            Array = 21,
        };
    }; // struct Type

    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        AllFieldsSet = (TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Key*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Key;
    public:

        Builder<STATE | TypeSet>& setType(Type::Enum value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type", TypeBuilder::getEnumConstantValue(value));
            return castState<TypeSet>();
        }

        operator RefPtr<Key>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Key) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Key>*>(&m_result);
        }

        PassRefPtr<Key> release()
        {
            return RefPtr<Key>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Key> result = Key::create()
     *     .setType(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setNumber(double value)
    {
        this->setNumber("number", value);
    }
    using JSONObjectBase::setNumber;


    void setString(const String& value)
    {
        this->setString("string", value);
    }
    using JSONObjectBase::setString;


    void setDate(double value)
    {
        this->setNumber("date", value);
    }

    void setArray(PassRefPtr<TypeBuilder::Array<TypeBuilder::IndexedDB::Key> > value)
    {
        this->setValue("array", value);
    }
    using JSONObjectBase::setArray;

};

/* Key range. */
class KeyRange : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        LowerOpenSet = 1 << 0,
        UpperOpenSet = 1 << 1,
        AllFieldsSet = (LowerOpenSet | UpperOpenSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*KeyRange*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class KeyRange;
    public:

        Builder<STATE | LowerOpenSet>& setLowerOpen(bool value)
        {
            COMPILE_ASSERT(!(STATE & LowerOpenSet), property_lowerOpen_already_set);
            m_result->setBoolean("lowerOpen", value);
            return castState<LowerOpenSet>();
        }

        Builder<STATE | UpperOpenSet>& setUpperOpen(bool value)
        {
            COMPILE_ASSERT(!(STATE & UpperOpenSet), property_upperOpen_already_set);
            m_result->setBoolean("upperOpen", value);
            return castState<UpperOpenSet>();
        }

        operator RefPtr<KeyRange>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(KeyRange) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<KeyRange>*>(&m_result);
        }

        PassRefPtr<KeyRange> release()
        {
            return RefPtr<KeyRange>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<KeyRange> result = KeyRange::create()
     *     .setLowerOpen(...)
     *     .setUpperOpen(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void lowerOpen(bool* value)
    {
        JSONObjectBase::getBoolean("lowerOpen", value);
    }

    void upperOpen(bool* value)
    {
        JSONObjectBase::getBoolean("upperOpen", value);
    }

    void setLower(PassRefPtr<TypeBuilder::IndexedDB::Key> value)
    {
        this->setValue("lower", value);
    }

    void setUpper(PassRefPtr<TypeBuilder::IndexedDB::Key> value)
    {
        this->setValue("upper", value);
    }
};

/* Data entry. */
class DataEntry : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        KeySet = 1 << 0,
        PrimaryKeySet = 1 << 1,
        ValueSet = 1 << 2,
        AllFieldsSet = (KeySet | PrimaryKeySet | ValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*DataEntry*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class DataEntry;
    public:

        Builder<STATE | KeySet>& setKey(const String& value)
        {
            COMPILE_ASSERT(!(STATE & KeySet), property_key_already_set);
            m_result->setString("key", value);
            return castState<KeySet>();
        }

        Builder<STATE | PrimaryKeySet>& setPrimaryKey(const String& value)
        {
            COMPILE_ASSERT(!(STATE & PrimaryKeySet), property_primaryKey_already_set);
            m_result->setString("primaryKey", value);
            return castState<PrimaryKeySet>();
        }

        Builder<STATE | ValueSet>& setValue(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ValueSet), property_value_already_set);
            m_result->setString("value", value);
            return castState<ValueSet>();
        }

        operator RefPtr<DataEntry>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(DataEntry) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<DataEntry>*>(&m_result);
        }

        PassRefPtr<DataEntry> release()
        {
            return RefPtr<DataEntry>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<DataEntry> result = DataEntry::create()
     *     .setKey(...)
     *     .setPrimaryKey(...)
     *     .setValue(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void key(String* value)
    {
        JSONObjectBase::getString("key", value);
    }

    void primaryKey(String* value)
    {
        JSONObjectBase::getString("primaryKey", value);
    }

    void value(String* value)
    {
        JSONObjectBase::getString("value", value);
    }
};

/* Key path. */
class KeyPath : public JSONObjectBase {
public:
    // Named after property name 'type' while generating KeyPath.
    struct Type {
        enum Enum {
            Null = 22,
            String = 17,
            Array = 21,
        };
    }; // struct Type

    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        AllFieldsSet = (TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*KeyPath*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class KeyPath;
    public:

        Builder<STATE | TypeSet>& setType(Type::Enum value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type", TypeBuilder::getEnumConstantValue(value));
            return castState<TypeSet>();
        }

        operator RefPtr<KeyPath>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(KeyPath) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<KeyPath>*>(&m_result);
        }

        PassRefPtr<KeyPath> release()
        {
            return RefPtr<KeyPath>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<KeyPath> result = KeyPath::create()
     *     .setType(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setString(const String& value)
    {
        this->setString("string", value);
    }
    using JSONObjectBase::setString;


    void setArray(PassRefPtr<TypeBuilder::Array<String> > value)
    {
        this->setValue("array", value);
    }
    using JSONObjectBase::setArray;

};

} // IndexedDB

namespace DOMStorage {
/* DOM Storage identifier. */
class StorageId : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        SecurityOriginSet = 1 << 0,
        IsLocalStorageSet = 1 << 1,
        AllFieldsSet = (SecurityOriginSet | IsLocalStorageSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*StorageId*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class StorageId;
    public:

        Builder<STATE | SecurityOriginSet>& setSecurityOrigin(const String& value)
        {
            COMPILE_ASSERT(!(STATE & SecurityOriginSet), property_securityOrigin_already_set);
            m_result->setString("securityOrigin", value);
            return castState<SecurityOriginSet>();
        }

        Builder<STATE | IsLocalStorageSet>& setIsLocalStorage(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsLocalStorageSet), property_isLocalStorage_already_set);
            m_result->setBoolean("isLocalStorage", value);
            return castState<IsLocalStorageSet>();
        }

        operator RefPtr<StorageId>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(StorageId) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<StorageId>*>(&m_result);
        }

        PassRefPtr<StorageId> release()
        {
            return RefPtr<StorageId>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<StorageId> result = StorageId::create()
     *     .setSecurityOrigin(...)
     *     .setIsLocalStorage(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void securityOrigin(String* value)
    {
        JSONObjectBase::getString("securityOrigin", value);
    }

    void isLocalStorage(bool* value)
    {
        JSONObjectBase::getBoolean("isLocalStorage", value);
    }
};

} // DOMStorage

namespace ApplicationCache {
/* Detailed application cache resource information. */
class ApplicationCacheResource : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        UrlSet = 1 << 0,
        SizeSet = 1 << 1,
        TypeSet = 1 << 2,
        AllFieldsSet = (UrlSet | SizeSet | TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*ApplicationCacheResource*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class ApplicationCacheResource;
    public:

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString("url", value);
            return castState<UrlSet>();
        }

        Builder<STATE | SizeSet>& setSize(int value)
        {
            COMPILE_ASSERT(!(STATE & SizeSet), property_size_already_set);
            m_result->setNumber("size", value);
            return castState<SizeSet>();
        }

        Builder<STATE | TypeSet>& setType(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type", value);
            return castState<TypeSet>();
        }

        operator RefPtr<ApplicationCacheResource>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ApplicationCacheResource) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<ApplicationCacheResource>*>(&m_result);
        }

        PassRefPtr<ApplicationCacheResource> release()
        {
            return RefPtr<ApplicationCacheResource>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<ApplicationCacheResource> result = ApplicationCacheResource::create()
     *     .setUrl(...)
     *     .setSize(...)
     *     .setType(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void url(String* value)
    {
        JSONObjectBase::getString("url", value);
    }

    void size(int* value)
    {
        JSONObjectBase::getNumber("size", value);
    }

    void type(String* value)
    {
        JSONObjectBase::getString("type", value);
    }
};

/* Detailed application cache information. */
class ApplicationCache : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ManifestURLSet = 1 << 0,
        SizeSet = 1 << 1,
        CreationTimeSet = 1 << 2,
        UpdateTimeSet = 1 << 3,
        ResourcesSet = 1 << 4,
        AllFieldsSet = (ManifestURLSet | SizeSet | CreationTimeSet | UpdateTimeSet | ResourcesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*ApplicationCache*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class ApplicationCache;
    public:

        Builder<STATE | ManifestURLSet>& setManifestURL(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ManifestURLSet), property_manifestURL_already_set);
            m_result->setString("manifestURL", value);
            return castState<ManifestURLSet>();
        }

        Builder<STATE | SizeSet>& setSize(double value)
        {
            COMPILE_ASSERT(!(STATE & SizeSet), property_size_already_set);
            m_result->setNumber("size", value);
            return castState<SizeSet>();
        }

        Builder<STATE | CreationTimeSet>& setCreationTime(double value)
        {
            COMPILE_ASSERT(!(STATE & CreationTimeSet), property_creationTime_already_set);
            m_result->setNumber("creationTime", value);
            return castState<CreationTimeSet>();
        }

        Builder<STATE | UpdateTimeSet>& setUpdateTime(double value)
        {
            COMPILE_ASSERT(!(STATE & UpdateTimeSet), property_updateTime_already_set);
            m_result->setNumber("updateTime", value);
            return castState<UpdateTimeSet>();
        }

        Builder<STATE | ResourcesSet>& setResources(PassRefPtr<TypeBuilder::Array<TypeBuilder::ApplicationCache::ApplicationCacheResource> > value)
        {
            COMPILE_ASSERT(!(STATE & ResourcesSet), property_resources_already_set);
            m_result->setValue("resources", value);
            return castState<ResourcesSet>();
        }

        operator RefPtr<ApplicationCache>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ApplicationCache) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<ApplicationCache>*>(&m_result);
        }

        PassRefPtr<ApplicationCache> release()
        {
            return RefPtr<ApplicationCache>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<ApplicationCache> result = ApplicationCache::create()
     *     .setManifestURL(...)
     *     .setSize(...)
     *     .setCreationTime(...)
     *     .setUpdateTime(...)
     *     .setResources(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void manifestURL(String* value)
    {
        JSONObjectBase::getString("manifestURL", value);
    }

    void size(double* value)
    {
        JSONObjectBase::getNumber("size", value);
    }

    void creationTime(double* value)
    {
        JSONObjectBase::getNumber("creationTime", value);
    }

    void updateTime(double* value)
    {
        JSONObjectBase::getNumber("updateTime", value);
    }
};

/* Frame identifier - manifest URL pair. */
class FrameWithManifest : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        FrameIdSet = 1 << 0,
        ManifestURLSet = 1 << 1,
        StatusSet = 1 << 2,
        AllFieldsSet = (FrameIdSet | ManifestURLSet | StatusSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*FrameWithManifest*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class FrameWithManifest;
    public:

        Builder<STATE | FrameIdSet>& setFrameId(const TypeBuilder::Page::FrameId& value)
        {
            COMPILE_ASSERT(!(STATE & FrameIdSet), property_frameId_already_set);
            m_result->setString("frameId", value);
            return castState<FrameIdSet>();
        }

        Builder<STATE | ManifestURLSet>& setManifestURL(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ManifestURLSet), property_manifestURL_already_set);
            m_result->setString("manifestURL", value);
            return castState<ManifestURLSet>();
        }

        Builder<STATE | StatusSet>& setStatus(int value)
        {
            COMPILE_ASSERT(!(STATE & StatusSet), property_status_already_set);
            m_result->setNumber("status", value);
            return castState<StatusSet>();
        }

        operator RefPtr<FrameWithManifest>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(FrameWithManifest) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<FrameWithManifest>*>(&m_result);
        }

        PassRefPtr<FrameWithManifest> release()
        {
            return RefPtr<FrameWithManifest>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<FrameWithManifest> result = FrameWithManifest::create()
     *     .setFrameId(...)
     *     .setManifestURL(...)
     *     .setStatus(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void frameId(TypeBuilder::Page::FrameId* value)
    {
        JSONObjectBase::getString("frameId", value);
    }

    void manifestURL(String* value)
    {
        JSONObjectBase::getString("manifestURL", value);
    }

    void status(int* value)
    {
        JSONObjectBase::getNumber("status", value);
    }
};

} // ApplicationCache

namespace FileSystem {
/* Represents a browser side file or directory. */
class Entry : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        UrlSet = 1 << 0,
        NameSet = 1 << 1,
        IsDirectorySet = 1 << 2,
        AllFieldsSet = (UrlSet | NameSet | IsDirectorySet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Entry*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Entry;
    public:

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString("url", value);
            return castState<UrlSet>();
        }

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name", value);
            return castState<NameSet>();
        }

        Builder<STATE | IsDirectorySet>& setIsDirectory(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsDirectorySet), property_isDirectory_already_set);
            m_result->setBoolean("isDirectory", value);
            return castState<IsDirectorySet>();
        }

        operator RefPtr<Entry>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Entry) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Entry>*>(&m_result);
        }

        PassRefPtr<Entry> release()
        {
            return RefPtr<Entry>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Entry> result = Entry::create()
     *     .setUrl(...)
     *     .setName(...)
     *     .setIsDirectory(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void url(String* value)
    {
        JSONObjectBase::getString("url", value);
    }

    void name(String* value)
    {
        JSONObjectBase::getString("name", value);
    }

    void isDirectory(bool* value)
    {
        JSONObjectBase::getBoolean("isDirectory", value);
    }

    void setMimeType(const String& value)
    {
        this->setString("mimeType", value);
    }

    void setResourceType(TypeBuilder::Page::ResourceType::Enum value)
    {
        this->setString("resourceType", TypeBuilder::getEnumConstantValue(value));
    }

    void setIsTextFile(bool value)
    {
        this->setBoolean("isTextFile", value);
    }
};

/* Represents metadata of a file or entry. */
class Metadata : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ModificationTimeSet = 1 << 0,
        SizeSet = 1 << 1,
        AllFieldsSet = (ModificationTimeSet | SizeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Metadata*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Metadata;
    public:

        Builder<STATE | ModificationTimeSet>& setModificationTime(double value)
        {
            COMPILE_ASSERT(!(STATE & ModificationTimeSet), property_modificationTime_already_set);
            m_result->setNumber("modificationTime", value);
            return castState<ModificationTimeSet>();
        }

        Builder<STATE | SizeSet>& setSize(double value)
        {
            COMPILE_ASSERT(!(STATE & SizeSet), property_size_already_set);
            m_result->setNumber("size", value);
            return castState<SizeSet>();
        }

        operator RefPtr<Metadata>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Metadata) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Metadata>*>(&m_result);
        }

        PassRefPtr<Metadata> release()
        {
            return RefPtr<Metadata>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Metadata> result = Metadata::create()
     *     .setModificationTime(...)
     *     .setSize(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void modificationTime(double* value)
    {
        JSONObjectBase::getNumber("modificationTime", value);
    }

    void size(double* value)
    {
        JSONObjectBase::getNumber("size", value);
    }
};

} // FileSystem

namespace DOM {
/* Pseudo element type. */
struct PseudoType {
    enum Enum {
        Before = 55,
        After = 56,
    };
}; // struct PseudoType

/* Shadow root type. */
struct ShadowRootType {
    enum Enum {
        User_agent = 57,
        Author = 58,
    };
}; // struct ShadowRootType

/* DOM interaction is implemented in terms of mirror objects that represent the actual DOM nodes. DOMNode is a base node mirror type. */
class Node : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NodeIdSet = 1 << 0,
        NodeTypeSet = 1 << 1,
        NodeNameSet = 1 << 2,
        LocalNameSet = 1 << 3,
        NodeValueSet = 1 << 4,
        AllFieldsSet = (NodeIdSet | NodeTypeSet | NodeNameSet | LocalNameSet | NodeValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Node*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Node;
    public:

        Builder<STATE | NodeIdSet>& setNodeId(int value)
        {
            COMPILE_ASSERT(!(STATE & NodeIdSet), property_nodeId_already_set);
            m_result->setNumber("nodeId", value);
            return castState<NodeIdSet>();
        }

        Builder<STATE | NodeTypeSet>& setNodeType(int value)
        {
            COMPILE_ASSERT(!(STATE & NodeTypeSet), property_nodeType_already_set);
            m_result->setNumber("nodeType", value);
            return castState<NodeTypeSet>();
        }

        Builder<STATE | NodeNameSet>& setNodeName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NodeNameSet), property_nodeName_already_set);
            m_result->setString("nodeName", value);
            return castState<NodeNameSet>();
        }

        Builder<STATE | LocalNameSet>& setLocalName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & LocalNameSet), property_localName_already_set);
            m_result->setString("localName", value);
            return castState<LocalNameSet>();
        }

        Builder<STATE | NodeValueSet>& setNodeValue(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NodeValueSet), property_nodeValue_already_set);
            m_result->setString("nodeValue", value);
            return castState<NodeValueSet>();
        }

        operator RefPtr<Node>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Node) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Node>*>(&m_result);
        }

        PassRefPtr<Node> release()
        {
            return RefPtr<Node>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Node> result = Node::create()
     *     .setNodeId(...)
     *     .setNodeType(...)
     *     .setNodeName(...)
     *     .setLocalName(...)
     *     .setNodeValue(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void nodeId(int* value)
    {
        JSONObjectBase::getNumber("nodeId", value);
    }

    void nodeType(int* value)
    {
        JSONObjectBase::getNumber("nodeType", value);
    }

    void nodeName(String* value)
    {
        JSONObjectBase::getString("nodeName", value);
    }

    void localName(String* value)
    {
        JSONObjectBase::getString("localName", value);
    }

    void nodeValue(String* value)
    {
        JSONObjectBase::getString("nodeValue", value);
    }

    void setChildNodeCount(int value)
    {
        this->setNumber("childNodeCount", value);
    }

    void setChildren(PassRefPtr<TypeBuilder::Array<TypeBuilder::DOM::Node> > value)
    {
        this->setValue("children", value);
    }

    void setAttributes(PassRefPtr<TypeBuilder::Array<String> > value)
    {
        this->setValue("attributes", value);
    }

    void setDocumentURL(const String& value)
    {
        this->setString("documentURL", value);
    }

    void setBaseURL(const String& value)
    {
        this->setString("baseURL", value);
    }

    void setPublicId(const String& value)
    {
        this->setString("publicId", value);
    }

    void setSystemId(const String& value)
    {
        this->setString("systemId", value);
    }

    void setInternalSubset(const String& value)
    {
        this->setString("internalSubset", value);
    }

    void setXmlVersion(const String& value)
    {
        this->setString("xmlVersion", value);
    }

    void setName(const String& value)
    {
        this->setString("name", value);
    }

    void setValue(const String& value)
    {
        this->setString("value", value);
    }
    using JSONObjectBase::setValue;


    void setPseudoType(TypeBuilder::DOM::PseudoType::Enum value)
    {
        this->setString("pseudoType", TypeBuilder::getEnumConstantValue(value));
    }

    void setShadowRootType(TypeBuilder::DOM::ShadowRootType::Enum value)
    {
        this->setString("shadowRootType", TypeBuilder::getEnumConstantValue(value));
    }

    void setFrameId(const TypeBuilder::Page::FrameId& value)
    {
        this->setString("frameId", value);
    }

    void setContentDocument(PassRefPtr<TypeBuilder::DOM::Node> value)
    {
        this->setValue("contentDocument", value);
    }

    void setShadowRoots(PassRefPtr<TypeBuilder::Array<TypeBuilder::DOM::Node> > value)
    {
        this->setValue("shadowRoots", value);
    }

    void setTemplateContent(PassRefPtr<TypeBuilder::DOM::Node> value)
    {
        this->setValue("templateContent", value);
    }

    void setPseudoElements(PassRefPtr<TypeBuilder::Array<TypeBuilder::DOM::Node> > value)
    {
        this->setValue("pseudoElements", value);
    }

    void setImportedDocument(PassRefPtr<TypeBuilder::DOM::Node> value)
    {
        this->setValue("importedDocument", value);
    }
};

/* DOM interaction is implemented in terms of mirror objects that represent the actual DOM nodes. DOMNode is a base node mirror type. */
class EventListener : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        UseCaptureSet = 1 << 1,
        IsAttributeSet = 1 << 2,
        NodeIdSet = 1 << 3,
        HandlerBodySet = 1 << 4,
        LocationSet = 1 << 5,
        AllFieldsSet = (TypeSet | UseCaptureSet | IsAttributeSet | NodeIdSet | HandlerBodySet | LocationSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*EventListener*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class EventListener;
    public:

        Builder<STATE | TypeSet>& setType(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type", value);
            return castState<TypeSet>();
        }

        Builder<STATE | UseCaptureSet>& setUseCapture(bool value)
        {
            COMPILE_ASSERT(!(STATE & UseCaptureSet), property_useCapture_already_set);
            m_result->setBoolean("useCapture", value);
            return castState<UseCaptureSet>();
        }

        Builder<STATE | IsAttributeSet>& setIsAttribute(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsAttributeSet), property_isAttribute_already_set);
            m_result->setBoolean("isAttribute", value);
            return castState<IsAttributeSet>();
        }

        Builder<STATE | NodeIdSet>& setNodeId(int value)
        {
            COMPILE_ASSERT(!(STATE & NodeIdSet), property_nodeId_already_set);
            m_result->setNumber("nodeId", value);
            return castState<NodeIdSet>();
        }

        Builder<STATE | HandlerBodySet>& setHandlerBody(const String& value)
        {
            COMPILE_ASSERT(!(STATE & HandlerBodySet), property_handlerBody_already_set);
            m_result->setString("handlerBody", value);
            return castState<HandlerBodySet>();
        }

        Builder<STATE | LocationSet>& setLocation(PassRefPtr<TypeBuilder::Debugger::Location> value)
        {
            COMPILE_ASSERT(!(STATE & LocationSet), property_location_already_set);
            m_result->setValue("location", value);
            return castState<LocationSet>();
        }

        operator RefPtr<EventListener>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(EventListener) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<EventListener>*>(&m_result);
        }

        PassRefPtr<EventListener> release()
        {
            return RefPtr<EventListener>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<EventListener> result = EventListener::create()
     *     .setType(...)
     *     .setUseCapture(...)
     *     .setIsAttribute(...)
     *     .setNodeId(...)
     *     .setHandlerBody(...)
     *     .setLocation(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void type(String* value)
    {
        JSONObjectBase::getString("type", value);
    }

    void useCapture(bool* value)
    {
        JSONObjectBase::getBoolean("useCapture", value);
    }

    void isAttribute(bool* value)
    {
        JSONObjectBase::getBoolean("isAttribute", value);
    }

    void nodeId(int* value)
    {
        JSONObjectBase::getNumber("nodeId", value);
    }

    void handlerBody(String* value)
    {
        JSONObjectBase::getString("handlerBody", value);
    }

    void setSourceName(const String& value)
    {
        this->setString("sourceName", value);
    }

    void setHandler(PassRefPtr<TypeBuilder::Runtime::RemoteObject> value)
    {
        this->setValue("handler", value);
    }
};

/* A structure holding an RGBA color. */
// Type originally was named 'RGBA'.
class Rgba : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        RSet = 1 << 0,
        GSet = 1 << 1,
        BSet = 1 << 2,
        AllFieldsSet = (RSet | GSet | BSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Rgba*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Rgba;
    public:

        Builder<STATE | RSet>& setR(int value)
        {
            COMPILE_ASSERT(!(STATE & RSet), property_r_already_set);
            m_result->setNumber("r", value);
            return castState<RSet>();
        }

        Builder<STATE | GSet>& setG(int value)
        {
            COMPILE_ASSERT(!(STATE & GSet), property_g_already_set);
            m_result->setNumber("g", value);
            return castState<GSet>();
        }

        Builder<STATE | BSet>& setB(int value)
        {
            COMPILE_ASSERT(!(STATE & BSet), property_b_already_set);
            m_result->setNumber("b", value);
            return castState<BSet>();
        }

        operator RefPtr<Rgba>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Rgba) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Rgba>*>(&m_result);
        }

        PassRefPtr<Rgba> release()
        {
            return RefPtr<Rgba>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Rgba> result = Rgba::create()
     *     .setR(...)
     *     .setG(...)
     *     .setB(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void r(int* value)
    {
        JSONObjectBase::getNumber("r", value);
    }

    void g(int* value)
    {
        JSONObjectBase::getNumber("g", value);
    }

    void b(int* value)
    {
        JSONObjectBase::getNumber("b", value);
    }

    void setA(double value)
    {
        this->setNumber("a", value);
    }
};

/* Box model. */
class BoxModel : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ContentSet = 1 << 0,
        PaddingSet = 1 << 1,
        BorderSet = 1 << 2,
        MarginSet = 1 << 3,
        WidthSet = 1 << 4,
        HeightSet = 1 << 5,
        AllFieldsSet = (ContentSet | PaddingSet | BorderSet | MarginSet | WidthSet | HeightSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*BoxModel*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class BoxModel;
    public:

        Builder<STATE | ContentSet>& setContent(PassRefPtr<TypeBuilder::Array<double> > value)
        {
            COMPILE_ASSERT(!(STATE & ContentSet), property_content_already_set);
            m_result->setValue("content", value);
            return castState<ContentSet>();
        }

        Builder<STATE | PaddingSet>& setPadding(PassRefPtr<TypeBuilder::Array<double> > value)
        {
            COMPILE_ASSERT(!(STATE & PaddingSet), property_padding_already_set);
            m_result->setValue("padding", value);
            return castState<PaddingSet>();
        }

        Builder<STATE | BorderSet>& setBorder(PassRefPtr<TypeBuilder::Array<double> > value)
        {
            COMPILE_ASSERT(!(STATE & BorderSet), property_border_already_set);
            m_result->setValue("border", value);
            return castState<BorderSet>();
        }

        Builder<STATE | MarginSet>& setMargin(PassRefPtr<TypeBuilder::Array<double> > value)
        {
            COMPILE_ASSERT(!(STATE & MarginSet), property_margin_already_set);
            m_result->setValue("margin", value);
            return castState<MarginSet>();
        }

        Builder<STATE | WidthSet>& setWidth(int value)
        {
            COMPILE_ASSERT(!(STATE & WidthSet), property_width_already_set);
            m_result->setNumber("width", value);
            return castState<WidthSet>();
        }

        Builder<STATE | HeightSet>& setHeight(int value)
        {
            COMPILE_ASSERT(!(STATE & HeightSet), property_height_already_set);
            m_result->setNumber("height", value);
            return castState<HeightSet>();
        }

        operator RefPtr<BoxModel>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(BoxModel) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<BoxModel>*>(&m_result);
        }

        PassRefPtr<BoxModel> release()
        {
            return RefPtr<BoxModel>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<BoxModel> result = BoxModel::create()
     *     .setContent(...)
     *     .setPadding(...)
     *     .setBorder(...)
     *     .setMargin(...)
     *     .setWidth(...)
     *     .setHeight(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void width(int* value)
    {
        JSONObjectBase::getNumber("width", value);
    }

    void height(int* value)
    {
        JSONObjectBase::getNumber("height", value);
    }

    void setShapeOutside(PassRefPtr<TypeBuilder::DOM::ShapeOutsideInfo> value)
    {
        this->setValue("shapeOutside", value);
    }
};

/* CSS Shape Outside details. */
class ShapeOutsideInfo : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        BoundsSet = 1 << 0,
        ShapeSet = 1 << 1,
        MarginShapeSet = 1 << 2,
        AllFieldsSet = (BoundsSet | ShapeSet | MarginShapeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*ShapeOutsideInfo*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class ShapeOutsideInfo;
    public:

        Builder<STATE | BoundsSet>& setBounds(PassRefPtr<TypeBuilder::Array<double> > value)
        {
            COMPILE_ASSERT(!(STATE & BoundsSet), property_bounds_already_set);
            m_result->setValue("bounds", value);
            return castState<BoundsSet>();
        }

        Builder<STATE | ShapeSet>& setShape(PassRefPtr<TypeBuilder::Array<JSONValue> > value)
        {
            COMPILE_ASSERT(!(STATE & ShapeSet), property_shape_already_set);
            m_result->setValue("shape", value);
            return castState<ShapeSet>();
        }

        Builder<STATE | MarginShapeSet>& setMarginShape(PassRefPtr<TypeBuilder::Array<JSONValue> > value)
        {
            COMPILE_ASSERT(!(STATE & MarginShapeSet), property_marginShape_already_set);
            m_result->setValue("marginShape", value);
            return castState<MarginShapeSet>();
        }

        operator RefPtr<ShapeOutsideInfo>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ShapeOutsideInfo) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<ShapeOutsideInfo>*>(&m_result);
        }

        PassRefPtr<ShapeOutsideInfo> release()
        {
            return RefPtr<ShapeOutsideInfo>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<ShapeOutsideInfo> result = ShapeOutsideInfo::create()
     *     .setBounds(...)
     *     .setShape(...)
     *     .setMarginShape(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

/* Rectangle. */
class Rect : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        XSet = 1 << 0,
        YSet = 1 << 1,
        WidthSet = 1 << 2,
        HeightSet = 1 << 3,
        AllFieldsSet = (XSet | YSet | WidthSet | HeightSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Rect*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Rect;
    public:

        Builder<STATE | XSet>& setX(double value)
        {
            COMPILE_ASSERT(!(STATE & XSet), property_x_already_set);
            m_result->setNumber("x", value);
            return castState<XSet>();
        }

        Builder<STATE | YSet>& setY(double value)
        {
            COMPILE_ASSERT(!(STATE & YSet), property_y_already_set);
            m_result->setNumber("y", value);
            return castState<YSet>();
        }

        Builder<STATE | WidthSet>& setWidth(double value)
        {
            COMPILE_ASSERT(!(STATE & WidthSet), property_width_already_set);
            m_result->setNumber("width", value);
            return castState<WidthSet>();
        }

        Builder<STATE | HeightSet>& setHeight(double value)
        {
            COMPILE_ASSERT(!(STATE & HeightSet), property_height_already_set);
            m_result->setNumber("height", value);
            return castState<HeightSet>();
        }

        operator RefPtr<Rect>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Rect) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Rect>*>(&m_result);
        }

        PassRefPtr<Rect> release()
        {
            return RefPtr<Rect>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Rect> result = Rect::create()
     *     .setX(...)
     *     .setY(...)
     *     .setWidth(...)
     *     .setHeight(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void x(double* value)
    {
        JSONObjectBase::getNumber("x", value);
    }

    void y(double* value)
    {
        JSONObjectBase::getNumber("y", value);
    }

    void width(double* value)
    {
        JSONObjectBase::getNumber("width", value);
    }

    void height(double* value)
    {
        JSONObjectBase::getNumber("height", value);
    }
};

/* Configuration data for the highlighting of page elements. */
class HighlightConfig : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*HighlightConfig*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class HighlightConfig;
    public:

        operator RefPtr<HighlightConfig>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(HighlightConfig) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<HighlightConfig>*>(&m_result);
        }

        PassRefPtr<HighlightConfig> release()
        {
            return RefPtr<HighlightConfig>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<HighlightConfig> result = HighlightConfig::create();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setShowInfo(bool value)
    {
        this->setBoolean("showInfo", value);
    }

    void setShowRulers(bool value)
    {
        this->setBoolean("showRulers", value);
    }

    void setShowExtensionLines(bool value)
    {
        this->setBoolean("showExtensionLines", value);
    }

    void setContentColor(PassRefPtr<TypeBuilder::DOM::Rgba> value)
    {
        this->setValue("contentColor", value);
    }

    void setPaddingColor(PassRefPtr<TypeBuilder::DOM::Rgba> value)
    {
        this->setValue("paddingColor", value);
    }

    void setBorderColor(PassRefPtr<TypeBuilder::DOM::Rgba> value)
    {
        this->setValue("borderColor", value);
    }

    void setMarginColor(PassRefPtr<TypeBuilder::DOM::Rgba> value)
    {
        this->setValue("marginColor", value);
    }

    void setEventTargetColor(PassRefPtr<TypeBuilder::DOM::Rgba> value)
    {
        this->setValue("eventTargetColor", value);
    }
};

} // DOM

namespace CSS {
/* Stylesheet type: "user" for user stylesheets, "user-agent" for user-agent stylesheets, "inspector" for stylesheets created by the inspector (i.e. those holding the "via inspector" rules), "regular" for regular stylesheets. */
struct StyleSheetOrigin {
    enum Enum {
        User = 59,
        User_agent = 57,
        Inspector = 60,
        Regular = 61,
    };
}; // struct StyleSheetOrigin

/* CSS rule collection for a single pseudo style. */
class PseudoIdMatches : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        PseudoIdSet = 1 << 0,
        MatchesSet = 1 << 1,
        AllFieldsSet = (PseudoIdSet | MatchesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*PseudoIdMatches*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class PseudoIdMatches;
    public:

        Builder<STATE | PseudoIdSet>& setPseudoId(int value)
        {
            COMPILE_ASSERT(!(STATE & PseudoIdSet), property_pseudoId_already_set);
            m_result->setNumber("pseudoId", value);
            return castState<PseudoIdSet>();
        }

        Builder<STATE | MatchesSet>& setMatches(PassRefPtr<TypeBuilder::Array<TypeBuilder::CSS::RuleMatch> > value)
        {
            COMPILE_ASSERT(!(STATE & MatchesSet), property_matches_already_set);
            m_result->setValue("matches", value);
            return castState<MatchesSet>();
        }

        operator RefPtr<PseudoIdMatches>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(PseudoIdMatches) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<PseudoIdMatches>*>(&m_result);
        }

        PassRefPtr<PseudoIdMatches> release()
        {
            return RefPtr<PseudoIdMatches>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<PseudoIdMatches> result = PseudoIdMatches::create()
     *     .setPseudoId(...)
     *     .setMatches(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void pseudoId(int* value)
    {
        JSONObjectBase::getNumber("pseudoId", value);
    }
};

/* Inherited CSS rule collection from ancestor node. */
class InheritedStyleEntry : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        MatchedCSSRulesSet = 1 << 0,
        AllFieldsSet = (MatchedCSSRulesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*InheritedStyleEntry*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class InheritedStyleEntry;
    public:

        Builder<STATE | MatchedCSSRulesSet>& setMatchedCSSRules(PassRefPtr<TypeBuilder::Array<TypeBuilder::CSS::RuleMatch> > value)
        {
            COMPILE_ASSERT(!(STATE & MatchedCSSRulesSet), property_matchedCSSRules_already_set);
            m_result->setValue("matchedCSSRules", value);
            return castState<MatchedCSSRulesSet>();
        }

        operator RefPtr<InheritedStyleEntry>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(InheritedStyleEntry) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<InheritedStyleEntry>*>(&m_result);
        }

        PassRefPtr<InheritedStyleEntry> release()
        {
            return RefPtr<InheritedStyleEntry>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<InheritedStyleEntry> result = InheritedStyleEntry::create()
     *     .setMatchedCSSRules(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setInlineStyle(PassRefPtr<TypeBuilder::CSS::CSSStyle> value)
    {
        this->setValue("inlineStyle", value);
    }
};

/* Match data for a CSS rule. */
class RuleMatch : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        RuleSet = 1 << 0,
        MatchingSelectorsSet = 1 << 1,
        AllFieldsSet = (RuleSet | MatchingSelectorsSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*RuleMatch*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class RuleMatch;
    public:

        Builder<STATE | RuleSet>& setRule(PassRefPtr<TypeBuilder::CSS::CSSRule> value)
        {
            COMPILE_ASSERT(!(STATE & RuleSet), property_rule_already_set);
            m_result->setValue("rule", value);
            return castState<RuleSet>();
        }

        Builder<STATE | MatchingSelectorsSet>& setMatchingSelectors(PassRefPtr<TypeBuilder::Array<int> > value)
        {
            COMPILE_ASSERT(!(STATE & MatchingSelectorsSet), property_matchingSelectors_already_set);
            m_result->setValue("matchingSelectors", value);
            return castState<MatchingSelectorsSet>();
        }

        operator RefPtr<RuleMatch>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(RuleMatch) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<RuleMatch>*>(&m_result);
        }

        PassRefPtr<RuleMatch> release()
        {
            return RefPtr<RuleMatch>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<RuleMatch> result = RuleMatch::create()
     *     .setRule(...)
     *     .setMatchingSelectors(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

/* Data for a simple selector (these are delimited by commas in a selector list). */
class Selector : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ValueSet = 1 << 0,
        AllFieldsSet = (ValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Selector*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Selector;
    public:

        Builder<STATE | ValueSet>& setValue(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ValueSet), property_value_already_set);
            m_result->setString("value", value);
            return castState<ValueSet>();
        }

        operator RefPtr<Selector>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Selector) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Selector>*>(&m_result);
        }

        PassRefPtr<Selector> release()
        {
            return RefPtr<Selector>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Selector> result = Selector::create()
     *     .setValue(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void value(String* value)
    {
        JSONObjectBase::getString("value", value);
    }

    void setRange(PassRefPtr<TypeBuilder::CSS::SourceRange> value)
    {
        this->setValue("range", value);
    }
};

/* Selector list data. */
class SelectorList : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        SelectorsSet = 1 << 0,
        TextSet = 1 << 1,
        AllFieldsSet = (SelectorsSet | TextSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*SelectorList*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class SelectorList;
    public:

        Builder<STATE | SelectorsSet>& setSelectors(PassRefPtr<TypeBuilder::Array<TypeBuilder::CSS::Selector> > value)
        {
            COMPILE_ASSERT(!(STATE & SelectorsSet), property_selectors_already_set);
            m_result->setValue("selectors", value);
            return castState<SelectorsSet>();
        }

        Builder<STATE | TextSet>& setText(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TextSet), property_text_already_set);
            m_result->setString("text", value);
            return castState<TextSet>();
        }

        operator RefPtr<SelectorList>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(SelectorList) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<SelectorList>*>(&m_result);
        }

        PassRefPtr<SelectorList> release()
        {
            return RefPtr<SelectorList>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<SelectorList> result = SelectorList::create()
     *     .setSelectors(...)
     *     .setText(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void text(String* value)
    {
        JSONObjectBase::getString("text", value);
    }
};

/* CSS stylesheet metainformation. */
class CSSStyleSheetHeader : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StyleSheetIdSet = 1 << 0,
        FrameIdSet = 1 << 1,
        SourceURLSet = 1 << 2,
        OriginSet = 1 << 3,
        TitleSet = 1 << 4,
        DisabledSet = 1 << 5,
        IsInlineSet = 1 << 6,
        StartLineSet = 1 << 7,
        StartColumnSet = 1 << 8,
        AllFieldsSet = (StyleSheetIdSet | FrameIdSet | SourceURLSet | OriginSet | TitleSet | DisabledSet | IsInlineSet | StartLineSet | StartColumnSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*CSSStyleSheetHeader*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class CSSStyleSheetHeader;
    public:

        Builder<STATE | StyleSheetIdSet>& setStyleSheetId(const TypeBuilder::CSS::StyleSheetId& value)
        {
            COMPILE_ASSERT(!(STATE & StyleSheetIdSet), property_styleSheetId_already_set);
            m_result->setString("styleSheetId", value);
            return castState<StyleSheetIdSet>();
        }

        Builder<STATE | FrameIdSet>& setFrameId(const TypeBuilder::Page::FrameId& value)
        {
            COMPILE_ASSERT(!(STATE & FrameIdSet), property_frameId_already_set);
            m_result->setString("frameId", value);
            return castState<FrameIdSet>();
        }

        Builder<STATE | SourceURLSet>& setSourceURL(const String& value)
        {
            COMPILE_ASSERT(!(STATE & SourceURLSet), property_sourceURL_already_set);
            m_result->setString("sourceURL", value);
            return castState<SourceURLSet>();
        }

        Builder<STATE | OriginSet>& setOrigin(TypeBuilder::CSS::StyleSheetOrigin::Enum value)
        {
            COMPILE_ASSERT(!(STATE & OriginSet), property_origin_already_set);
            m_result->setString("origin", TypeBuilder::getEnumConstantValue(value));
            return castState<OriginSet>();
        }

        Builder<STATE | TitleSet>& setTitle(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TitleSet), property_title_already_set);
            m_result->setString("title", value);
            return castState<TitleSet>();
        }

        Builder<STATE | DisabledSet>& setDisabled(bool value)
        {
            COMPILE_ASSERT(!(STATE & DisabledSet), property_disabled_already_set);
            m_result->setBoolean("disabled", value);
            return castState<DisabledSet>();
        }

        Builder<STATE | IsInlineSet>& setIsInline(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsInlineSet), property_isInline_already_set);
            m_result->setBoolean("isInline", value);
            return castState<IsInlineSet>();
        }

        Builder<STATE | StartLineSet>& setStartLine(double value)
        {
            COMPILE_ASSERT(!(STATE & StartLineSet), property_startLine_already_set);
            m_result->setNumber("startLine", value);
            return castState<StartLineSet>();
        }

        Builder<STATE | StartColumnSet>& setStartColumn(double value)
        {
            COMPILE_ASSERT(!(STATE & StartColumnSet), property_startColumn_already_set);
            m_result->setNumber("startColumn", value);
            return castState<StartColumnSet>();
        }

        operator RefPtr<CSSStyleSheetHeader>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSStyleSheetHeader) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<CSSStyleSheetHeader>*>(&m_result);
        }

        PassRefPtr<CSSStyleSheetHeader> release()
        {
            return RefPtr<CSSStyleSheetHeader>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<CSSStyleSheetHeader> result = CSSStyleSheetHeader::create()
     *     .setStyleSheetId(...)
     *     .setFrameId(...)
     *     .setSourceURL(...)
     *     .setOrigin(...)
     *     .setTitle(...)
     *     .setDisabled(...)
     *     .setIsInline(...)
     *     .setStartLine(...)
     *     .setStartColumn(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void styleSheetId(TypeBuilder::CSS::StyleSheetId* value)
    {
        JSONObjectBase::getString("styleSheetId", value);
    }

    void frameId(TypeBuilder::Page::FrameId* value)
    {
        JSONObjectBase::getString("frameId", value);
    }

    void sourceURL(String* value)
    {
        JSONObjectBase::getString("sourceURL", value);
    }

    void title(String* value)
    {
        JSONObjectBase::getString("title", value);
    }

    void disabled(bool* value)
    {
        JSONObjectBase::getBoolean("disabled", value);
    }

    void isInline(bool* value)
    {
        JSONObjectBase::getBoolean("isInline", value);
    }

    void startLine(double* value)
    {
        JSONObjectBase::getNumber("startLine", value);
    }

    void startColumn(double* value)
    {
        JSONObjectBase::getNumber("startColumn", value);
    }

    void setSourceMapURL(const String& value)
    {
        this->setString("sourceMapURL", value);
    }

    void setHasSourceURL(bool value)
    {
        this->setBoolean("hasSourceURL", value);
    }
};

/* CSS rule representation. */
class CSSRule : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        SelectorListSet = 1 << 0,
        OriginSet = 1 << 1,
        StyleSet = 1 << 2,
        AllFieldsSet = (SelectorListSet | OriginSet | StyleSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*CSSRule*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class CSSRule;
    public:

        Builder<STATE | SelectorListSet>& setSelectorList(PassRefPtr<TypeBuilder::CSS::SelectorList> value)
        {
            COMPILE_ASSERT(!(STATE & SelectorListSet), property_selectorList_already_set);
            m_result->setValue("selectorList", value);
            return castState<SelectorListSet>();
        }

        Builder<STATE | OriginSet>& setOrigin(TypeBuilder::CSS::StyleSheetOrigin::Enum value)
        {
            COMPILE_ASSERT(!(STATE & OriginSet), property_origin_already_set);
            m_result->setString("origin", TypeBuilder::getEnumConstantValue(value));
            return castState<OriginSet>();
        }

        Builder<STATE | StyleSet>& setStyle(PassRefPtr<TypeBuilder::CSS::CSSStyle> value)
        {
            COMPILE_ASSERT(!(STATE & StyleSet), property_style_already_set);
            m_result->setValue("style", value);
            return castState<StyleSet>();
        }

        operator RefPtr<CSSRule>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSRule) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<CSSRule>*>(&m_result);
        }

        PassRefPtr<CSSRule> release()
        {
            return RefPtr<CSSRule>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<CSSRule> result = CSSRule::create()
     *     .setSelectorList(...)
     *     .setOrigin(...)
     *     .setStyle(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setStyleSheetId(const TypeBuilder::CSS::StyleSheetId& value)
    {
        this->setString("styleSheetId", value);
    }

    void setMedia(PassRefPtr<TypeBuilder::Array<TypeBuilder::CSS::CSSMedia> > value)
    {
        this->setValue("media", value);
    }
};

/* Text range within a resource. All numbers are zero-based. */
class SourceRange : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StartLineSet = 1 << 0,
        StartColumnSet = 1 << 1,
        EndLineSet = 1 << 2,
        EndColumnSet = 1 << 3,
        AllFieldsSet = (StartLineSet | StartColumnSet | EndLineSet | EndColumnSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*SourceRange*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class SourceRange;
    public:

        Builder<STATE | StartLineSet>& setStartLine(int value)
        {
            COMPILE_ASSERT(!(STATE & StartLineSet), property_startLine_already_set);
            m_result->setNumber("startLine", value);
            return castState<StartLineSet>();
        }

        Builder<STATE | StartColumnSet>& setStartColumn(int value)
        {
            COMPILE_ASSERT(!(STATE & StartColumnSet), property_startColumn_already_set);
            m_result->setNumber("startColumn", value);
            return castState<StartColumnSet>();
        }

        Builder<STATE | EndLineSet>& setEndLine(int value)
        {
            COMPILE_ASSERT(!(STATE & EndLineSet), property_endLine_already_set);
            m_result->setNumber("endLine", value);
            return castState<EndLineSet>();
        }

        Builder<STATE | EndColumnSet>& setEndColumn(int value)
        {
            COMPILE_ASSERT(!(STATE & EndColumnSet), property_endColumn_already_set);
            m_result->setNumber("endColumn", value);
            return castState<EndColumnSet>();
        }

        operator RefPtr<SourceRange>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(SourceRange) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<SourceRange>*>(&m_result);
        }

        PassRefPtr<SourceRange> release()
        {
            return RefPtr<SourceRange>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<SourceRange> result = SourceRange::create()
     *     .setStartLine(...)
     *     .setStartColumn(...)
     *     .setEndLine(...)
     *     .setEndColumn(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void startLine(int* value)
    {
        JSONObjectBase::getNumber("startLine", value);
    }

    void startColumn(int* value)
    {
        JSONObjectBase::getNumber("startColumn", value);
    }

    void endLine(int* value)
    {
        JSONObjectBase::getNumber("endLine", value);
    }

    void endColumn(int* value)
    {
        JSONObjectBase::getNumber("endColumn", value);
    }
};

class ShorthandEntry : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        ValueSet = 1 << 1,
        AllFieldsSet = (NameSet | ValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*ShorthandEntry*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class ShorthandEntry;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name", value);
            return castState<NameSet>();
        }

        Builder<STATE | ValueSet>& setValue(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ValueSet), property_value_already_set);
            m_result->setString("value", value);
            return castState<ValueSet>();
        }

        operator RefPtr<ShorthandEntry>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ShorthandEntry) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<ShorthandEntry>*>(&m_result);
        }

        PassRefPtr<ShorthandEntry> release()
        {
            return RefPtr<ShorthandEntry>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<ShorthandEntry> result = ShorthandEntry::create()
     *     .setName(...)
     *     .setValue(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void name(String* value)
    {
        JSONObjectBase::getString("name", value);
    }

    void value(String* value)
    {
        JSONObjectBase::getString("value", value);
    }
};

class CSSComputedStyleProperty : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        ValueSet = 1 << 1,
        AllFieldsSet = (NameSet | ValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*CSSComputedStyleProperty*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class CSSComputedStyleProperty;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name", value);
            return castState<NameSet>();
        }

        Builder<STATE | ValueSet>& setValue(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ValueSet), property_value_already_set);
            m_result->setString("value", value);
            return castState<ValueSet>();
        }

        operator RefPtr<CSSComputedStyleProperty>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSComputedStyleProperty) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<CSSComputedStyleProperty>*>(&m_result);
        }

        PassRefPtr<CSSComputedStyleProperty> release()
        {
            return RefPtr<CSSComputedStyleProperty>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<CSSComputedStyleProperty> result = CSSComputedStyleProperty::create()
     *     .setName(...)
     *     .setValue(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void name(String* value)
    {
        JSONObjectBase::getString("name", value);
    }

    void value(String* value)
    {
        JSONObjectBase::getString("value", value);
    }
};

/* CSS style representation. */
class CSSStyle : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        CssPropertiesSet = 1 << 0,
        ShorthandEntriesSet = 1 << 1,
        AllFieldsSet = (CssPropertiesSet | ShorthandEntriesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*CSSStyle*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class CSSStyle;
    public:

        Builder<STATE | CssPropertiesSet>& setCssProperties(PassRefPtr<TypeBuilder::Array<TypeBuilder::CSS::CSSProperty> > value)
        {
            COMPILE_ASSERT(!(STATE & CssPropertiesSet), property_cssProperties_already_set);
            m_result->setValue("cssProperties", value);
            return castState<CssPropertiesSet>();
        }

        Builder<STATE | ShorthandEntriesSet>& setShorthandEntries(PassRefPtr<TypeBuilder::Array<TypeBuilder::CSS::ShorthandEntry> > value)
        {
            COMPILE_ASSERT(!(STATE & ShorthandEntriesSet), property_shorthandEntries_already_set);
            m_result->setValue("shorthandEntries", value);
            return castState<ShorthandEntriesSet>();
        }

        operator RefPtr<CSSStyle>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSStyle) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<CSSStyle>*>(&m_result);
        }

        PassRefPtr<CSSStyle> release()
        {
            return RefPtr<CSSStyle>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<CSSStyle> result = CSSStyle::create()
     *     .setCssProperties(...)
     *     .setShorthandEntries(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setStyleSheetId(const TypeBuilder::CSS::StyleSheetId& value)
    {
        this->setString("styleSheetId", value);
    }

    void setCssText(const String& value)
    {
        this->setString("cssText", value);
    }

    void setRange(PassRefPtr<TypeBuilder::CSS::SourceRange> value)
    {
        this->setValue("range", value);
    }
};

/* CSS property declaration data. */
class CSSProperty : public JSONObject {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        ValueSet = 1 << 1,
        AllFieldsSet = (NameSet | ValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*CSSProperty*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class CSSProperty;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name", value);
            return castState<NameSet>();
        }

        Builder<STATE | ValueSet>& setValue(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ValueSet), property_value_already_set);
            m_result->setString("value", value);
            return castState<ValueSet>();
        }

        operator RefPtr<CSSProperty>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSProperty) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<CSSProperty>*>(&m_result);
        }

        PassRefPtr<CSSProperty> release()
        {
            return RefPtr<CSSProperty>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<CSSProperty> result = CSSProperty::create()
     *     .setName(...)
     *     .setValue(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void name(String* value)
    {
        JSONObjectBase::getString("name", value);
    }

    void value(String* value)
    {
        JSONObjectBase::getString("value", value);
    }

    void setImportant(bool value)
    {
        this->setBoolean("important", value);
    }

    void setImplicit(bool value)
    {
        this->setBoolean("implicit", value);
    }

    void setText(const String& value)
    {
        this->setString("text", value);
    }

    void setParsedOk(bool value)
    {
        this->setBoolean("parsedOk", value);
    }

    void setDisabled(bool value)
    {
        this->setBoolean("disabled", value);
    }

    void setRange(PassRefPtr<TypeBuilder::CSS::SourceRange> value)
    {
        this->setValue("range", value);
    }

    // Property names for type generated as open.
    static const char Name[];
    static const char Value[];
    static const char Important[];
    static const char Implicit[];
    static const char Text[];
    static const char ParsedOk[];
    static const char Disabled[];
    static const char Range[];
};

/* CSS media query descriptor. */
class CSSMedia : public JSONObjectBase {
public:
    // Named after property name 'source' while generating CSSMedia.
    struct Source {
        enum Enum {
            MediaRule = 62,
            ImportRule = 63,
            LinkedSheet = 64,
            InlineSheet = 65,
        };
    }; // struct Source

    enum {
        NoFieldsSet = 0,
        TextSet = 1 << 0,
        SourceSet = 1 << 1,
        AllFieldsSet = (TextSet | SourceSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*CSSMedia*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class CSSMedia;
    public:

        Builder<STATE | TextSet>& setText(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TextSet), property_text_already_set);
            m_result->setString("text", value);
            return castState<TextSet>();
        }

        Builder<STATE | SourceSet>& setSource(Source::Enum value)
        {
            COMPILE_ASSERT(!(STATE & SourceSet), property_source_already_set);
            m_result->setString("source", TypeBuilder::getEnumConstantValue(value));
            return castState<SourceSet>();
        }

        operator RefPtr<CSSMedia>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSMedia) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<CSSMedia>*>(&m_result);
        }

        PassRefPtr<CSSMedia> release()
        {
            return RefPtr<CSSMedia>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<CSSMedia> result = CSSMedia::create()
     *     .setText(...)
     *     .setSource(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void text(String* value)
    {
        JSONObjectBase::getString("text", value);
    }

    void setSourceURL(const String& value)
    {
        this->setString("sourceURL", value);
    }

    void setRange(PassRefPtr<TypeBuilder::CSS::SourceRange> value)
    {
        this->setValue("range", value);
    }

    void setParentStyleSheetId(const TypeBuilder::CSS::StyleSheetId& value)
    {
        this->setString("parentStyleSheetId", value);
    }

    void setMediaList(PassRefPtr<TypeBuilder::Array<TypeBuilder::Array<TypeBuilder::CSS::MediaQueryExpression> > > value)
    {
        this->setValue("mediaList", value);
    }
};

/* Media query expression data. */
class MediaQueryExpression : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ValueSet = 1 << 0,
        UnitSet = 1 << 1,
        FeatureSet = 1 << 2,
        AllFieldsSet = (ValueSet | UnitSet | FeatureSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*MediaQueryExpression*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class MediaQueryExpression;
    public:

        Builder<STATE | ValueSet>& setValue(double value)
        {
            COMPILE_ASSERT(!(STATE & ValueSet), property_value_already_set);
            m_result->setNumber("value", value);
            return castState<ValueSet>();
        }

        Builder<STATE | UnitSet>& setUnit(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UnitSet), property_unit_already_set);
            m_result->setString("unit", value);
            return castState<UnitSet>();
        }

        Builder<STATE | FeatureSet>& setFeature(const String& value)
        {
            COMPILE_ASSERT(!(STATE & FeatureSet), property_feature_already_set);
            m_result->setString("feature", value);
            return castState<FeatureSet>();
        }

        operator RefPtr<MediaQueryExpression>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(MediaQueryExpression) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<MediaQueryExpression>*>(&m_result);
        }

        PassRefPtr<MediaQueryExpression> release()
        {
            return RefPtr<MediaQueryExpression>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<MediaQueryExpression> result = MediaQueryExpression::create()
     *     .setValue(...)
     *     .setUnit(...)
     *     .setFeature(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void value(double* value)
    {
        JSONObjectBase::getNumber("value", value);
    }

    void unit(String* value)
    {
        JSONObjectBase::getString("unit", value);
    }

    void feature(String* value)
    {
        JSONObjectBase::getString("feature", value);
    }

    void setComputedLength(double value)
    {
        this->setNumber("computedLength", value);
    }
};

/* Information about amount of glyphs that were rendered with given font. */
class PlatformFontUsage : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        FamilyNameSet = 1 << 0,
        GlyphCountSet = 1 << 1,
        AllFieldsSet = (FamilyNameSet | GlyphCountSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*PlatformFontUsage*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class PlatformFontUsage;
    public:

        Builder<STATE | FamilyNameSet>& setFamilyName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & FamilyNameSet), property_familyName_already_set);
            m_result->setString("familyName", value);
            return castState<FamilyNameSet>();
        }

        Builder<STATE | GlyphCountSet>& setGlyphCount(double value)
        {
            COMPILE_ASSERT(!(STATE & GlyphCountSet), property_glyphCount_already_set);
            m_result->setNumber("glyphCount", value);
            return castState<GlyphCountSet>();
        }

        operator RefPtr<PlatformFontUsage>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(PlatformFontUsage) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<PlatformFontUsage>*>(&m_result);
        }

        PassRefPtr<PlatformFontUsage> release()
        {
            return RefPtr<PlatformFontUsage>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<PlatformFontUsage> result = PlatformFontUsage::create()
     *     .setFamilyName(...)
     *     .setGlyphCount(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void familyName(String* value)
    {
        JSONObjectBase::getString("familyName", value);
    }

    void glyphCount(double* value)
    {
        JSONObjectBase::getNumber("glyphCount", value);
    }
};

} // CSS

namespace Timeline {
/* Current values of counters. */
class Counters : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Counters*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Counters;
    public:

        operator RefPtr<Counters>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Counters) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Counters>*>(&m_result);
        }

        PassRefPtr<Counters> release()
        {
            return RefPtr<Counters>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Counters> result = Counters::create();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setDocuments(int value)
    {
        this->setNumber("documents", value);
    }

    void setNodes(int value)
    {
        this->setNumber("nodes", value);
    }

    void setJsEventListeners(int value)
    {
        this->setNumber("jsEventListeners", value);
    }

    void setJsHeapSizeUsed(double value)
    {
        this->setNumber("jsHeapSizeUsed", value);
    }

    void setGpuMemoryUsedKB(double value)
    {
        this->setNumber("gpuMemoryUsedKB", value);
    }

    void setGpuMemoryLimitKB(double value)
    {
        this->setNumber("gpuMemoryLimitKB", value);
    }
};

/* Timeline record contains information about the recorded activity. */
class TimelineEvent : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        DataSet = 1 << 1,
        StartTimeSet = 1 << 2,
        AllFieldsSet = (TypeSet | DataSet | StartTimeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*TimelineEvent*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class TimelineEvent;
    public:

        Builder<STATE | TypeSet>& setType(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type", value);
            return castState<TypeSet>();
        }

        Builder<STATE | DataSet>& setData(PassRefPtr<JSONObject> value)
        {
            COMPILE_ASSERT(!(STATE & DataSet), property_data_already_set);
            m_result->setValue("data", value);
            return castState<DataSet>();
        }

        Builder<STATE | StartTimeSet>& setStartTime(double value)
        {
            COMPILE_ASSERT(!(STATE & StartTimeSet), property_startTime_already_set);
            m_result->setNumber("startTime", value);
            return castState<StartTimeSet>();
        }

        operator RefPtr<TimelineEvent>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(TimelineEvent) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<TimelineEvent>*>(&m_result);
        }

        PassRefPtr<TimelineEvent> release()
        {
            return RefPtr<TimelineEvent>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<TimelineEvent> result = TimelineEvent::create()
     *     .setType(...)
     *     .setData(...)
     *     .setStartTime(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void type(String* value)
    {
        JSONObjectBase::getString("type", value);
    }

    void startTime(double* value)
    {
        JSONObjectBase::getNumber("startTime", value);
    }

    void setEndTime(double value)
    {
        this->setNumber("endTime", value);
    }

    void setChildren(PassRefPtr<TypeBuilder::Array<TypeBuilder::Timeline::TimelineEvent> > value)
    {
        this->setValue("children", value);
    }

    void setThread(const String& value)
    {
        this->setString("thread", value);
    }

    void setStackTrace(PassRefPtr<TypeBuilder::Array<TypeBuilder::Console::CallFrame> > value)
    {
        this->setValue("stackTrace", value);
    }

    void setFrameId(const String& value)
    {
        this->setString("frameId", value);
    }
};

} // Timeline

namespace Debugger {
/* Location in the source code. */
class Location : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ScriptIdSet = 1 << 0,
        LineNumberSet = 1 << 1,
        AllFieldsSet = (ScriptIdSet | LineNumberSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Location*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Location;
    public:

        Builder<STATE | ScriptIdSet>& setScriptId(const TypeBuilder::Debugger::ScriptId& value)
        {
            COMPILE_ASSERT(!(STATE & ScriptIdSet), property_scriptId_already_set);
            m_result->setString("scriptId", value);
            return castState<ScriptIdSet>();
        }

        Builder<STATE | LineNumberSet>& setLineNumber(int value)
        {
            COMPILE_ASSERT(!(STATE & LineNumberSet), property_lineNumber_already_set);
            m_result->setNumber("lineNumber", value);
            return castState<LineNumberSet>();
        }

        operator RefPtr<Location>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Location) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Location>*>(&m_result);
        }

        PassRefPtr<Location> release()
        {
            return RefPtr<Location>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Location> result = Location::create()
     *     .setScriptId(...)
     *     .setLineNumber(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void scriptId(TypeBuilder::Debugger::ScriptId* value)
    {
        JSONObjectBase::getString("scriptId", value);
    }

    void lineNumber(int* value)
    {
        JSONObjectBase::getNumber("lineNumber", value);
    }

    void setColumnNumber(int value)
    {
        this->setNumber("columnNumber", value);
    }
    static PassRefPtr<Location> runtimeCast(PassRefPtr<JSONValue> value)
    {
        RefPtr<JSONObject> object;
        bool castRes = value->asObject(&object);
        ASSERT_UNUSED(castRes, castRes);
#if ASSERT_ENABLED
        assertCorrectValue(object.get());
#endif  // ASSERT_ENABLED
        COMPILE_ASSERT(sizeof(Location) == sizeof(JSONObjectBase), type_cast_problem);
        return static_cast<Location*>(static_cast<JSONObjectBase*>(object.get()));
    }

#if ASSERT_ENABLED
    static void assertCorrectValue(JSONValue* value);
#endif  // ASSERT_ENABLED
};

/* Information about the function. */
class FunctionDetails : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        LocationSet = 1 << 0,
        FunctionNameSet = 1 << 1,
        AllFieldsSet = (LocationSet | FunctionNameSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*FunctionDetails*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class FunctionDetails;
    public:

        Builder<STATE | LocationSet>& setLocation(PassRefPtr<TypeBuilder::Debugger::Location> value)
        {
            COMPILE_ASSERT(!(STATE & LocationSet), property_location_already_set);
            m_result->setValue("location", value);
            return castState<LocationSet>();
        }

        Builder<STATE | FunctionNameSet>& setFunctionName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & FunctionNameSet), property_functionName_already_set);
            m_result->setString("functionName", value);
            return castState<FunctionNameSet>();
        }

        operator RefPtr<FunctionDetails>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(FunctionDetails) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<FunctionDetails>*>(&m_result);
        }

        PassRefPtr<FunctionDetails> release()
        {
            return RefPtr<FunctionDetails>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<FunctionDetails> result = FunctionDetails::create()
     *     .setLocation(...)
     *     .setFunctionName(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void functionName(String* value)
    {
        JSONObjectBase::getString("functionName", value);
    }

    void setScopeChain(PassRefPtr<TypeBuilder::Array<TypeBuilder::Debugger::Scope> > value)
    {
        this->setValue("scopeChain", value);
    }
    static PassRefPtr<FunctionDetails> runtimeCast(PassRefPtr<JSONValue> value)
    {
        RefPtr<JSONObject> object;
        bool castRes = value->asObject(&object);
        ASSERT_UNUSED(castRes, castRes);
#if ASSERT_ENABLED
        assertCorrectValue(object.get());
#endif  // ASSERT_ENABLED
        COMPILE_ASSERT(sizeof(FunctionDetails) == sizeof(JSONObjectBase), type_cast_problem);
        return static_cast<FunctionDetails*>(static_cast<JSONObjectBase*>(object.get()));
    }

#if ASSERT_ENABLED
    static void assertCorrectValue(JSONValue* value);
#endif  // ASSERT_ENABLED
};

/* JavaScript call frame. Array of call frames form the call stack. */
class CallFrame : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        CallFrameIdSet = 1 << 0,
        FunctionNameSet = 1 << 1,
        LocationSet = 1 << 2,
        ScopeChainSet = 1 << 3,
        ThisSet = 1 << 4,
        AllFieldsSet = (CallFrameIdSet | FunctionNameSet | LocationSet | ScopeChainSet | ThisSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*CallFrame*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class CallFrame;
    public:

        Builder<STATE | CallFrameIdSet>& setCallFrameId(const TypeBuilder::Debugger::CallFrameId& value)
        {
            COMPILE_ASSERT(!(STATE & CallFrameIdSet), property_callFrameId_already_set);
            m_result->setString("callFrameId", value);
            return castState<CallFrameIdSet>();
        }

        Builder<STATE | FunctionNameSet>& setFunctionName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & FunctionNameSet), property_functionName_already_set);
            m_result->setString("functionName", value);
            return castState<FunctionNameSet>();
        }

        Builder<STATE | LocationSet>& setLocation(PassRefPtr<TypeBuilder::Debugger::Location> value)
        {
            COMPILE_ASSERT(!(STATE & LocationSet), property_location_already_set);
            m_result->setValue("location", value);
            return castState<LocationSet>();
        }

        Builder<STATE | ScopeChainSet>& setScopeChain(PassRefPtr<TypeBuilder::Array<TypeBuilder::Debugger::Scope> > value)
        {
            COMPILE_ASSERT(!(STATE & ScopeChainSet), property_scopeChain_already_set);
            m_result->setValue("scopeChain", value);
            return castState<ScopeChainSet>();
        }

        Builder<STATE | ThisSet>& setThis(PassRefPtr<TypeBuilder::Runtime::RemoteObject> value)
        {
            COMPILE_ASSERT(!(STATE & ThisSet), property_this_already_set);
            m_result->setValue("this", value);
            return castState<ThisSet>();
        }

        operator RefPtr<CallFrame>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CallFrame) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<CallFrame>*>(&m_result);
        }

        PassRefPtr<CallFrame> release()
        {
            return RefPtr<CallFrame>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<CallFrame> result = CallFrame::create()
     *     .setCallFrameId(...)
     *     .setFunctionName(...)
     *     .setLocation(...)
     *     .setScopeChain(...)
     *     .setThis(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void callFrameId(TypeBuilder::Debugger::CallFrameId* value)
    {
        JSONObjectBase::getString("callFrameId", value);
    }

    void functionName(String* value)
    {
        JSONObjectBase::getString("functionName", value);
    }

    void setReturnValue(PassRefPtr<TypeBuilder::Runtime::RemoteObject> value)
    {
        this->setValue("returnValue", value);
    }
    static PassRefPtr<CallFrame> runtimeCast(PassRefPtr<JSONValue> value)
    {
        RefPtr<JSONObject> object;
        bool castRes = value->asObject(&object);
        ASSERT_UNUSED(castRes, castRes);
#if ASSERT_ENABLED
        assertCorrectValue(object.get());
#endif  // ASSERT_ENABLED
        COMPILE_ASSERT(sizeof(CallFrame) == sizeof(JSONObjectBase), type_cast_problem);
        return static_cast<CallFrame*>(static_cast<JSONObjectBase*>(object.get()));
    }

#if ASSERT_ENABLED
    static void assertCorrectValue(JSONValue* value);
#endif  // ASSERT_ENABLED
};

/* JavaScript call stack, including async stack traces. */
class StackTrace : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        CallFramesSet = 1 << 0,
        AllFieldsSet = (CallFramesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*StackTrace*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class StackTrace;
    public:

        Builder<STATE | CallFramesSet>& setCallFrames(PassRefPtr<TypeBuilder::Array<TypeBuilder::Debugger::CallFrame> > value)
        {
            COMPILE_ASSERT(!(STATE & CallFramesSet), property_callFrames_already_set);
            m_result->setValue("callFrames", value);
            return castState<CallFramesSet>();
        }

        operator RefPtr<StackTrace>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(StackTrace) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<StackTrace>*>(&m_result);
        }

        PassRefPtr<StackTrace> release()
        {
            return RefPtr<StackTrace>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<StackTrace> result = StackTrace::create()
     *     .setCallFrames(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setDescription(const String& value)
    {
        this->setString("description", value);
    }

    void setAsyncStackTrace(PassRefPtr<TypeBuilder::Debugger::StackTrace> value)
    {
        this->setValue("asyncStackTrace", value);
    }
};

/* Scope description. */
class Scope : public JSONObjectBase {
public:
    // Named after property name 'type' while generating Scope.
    struct Type {
        enum Enum {
            Global = 66,
            Local = 67,
            With = 68,
            Closure = 69,
            Catch = 70,
        };
#if ASSERT_ENABLED
        static void assertCorrectValue(JSONValue* value);
#endif  // ASSERT_ENABLED
    }; // struct Type

    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        ObjectSet = 1 << 1,
        AllFieldsSet = (TypeSet | ObjectSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Scope*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Scope;
    public:

        Builder<STATE | TypeSet>& setType(Type::Enum value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type", TypeBuilder::getEnumConstantValue(value));
            return castState<TypeSet>();
        }

        Builder<STATE | ObjectSet>& setObject(PassRefPtr<TypeBuilder::Runtime::RemoteObject> value)
        {
            COMPILE_ASSERT(!(STATE & ObjectSet), property_object_already_set);
            m_result->setValue("object", value);
            return castState<ObjectSet>();
        }

        operator RefPtr<Scope>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Scope) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Scope>*>(&m_result);
        }

        PassRefPtr<Scope> release()
        {
            return RefPtr<Scope>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Scope> result = Scope::create()
     *     .setType(...)
     *     .setObject(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
#if ASSERT_ENABLED
    static void assertCorrectValue(JSONValue* value);
#endif  // ASSERT_ENABLED
};

/* Detailed information on exception (or error) that was thrown during script compilation or execution. */
class ExceptionDetails : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        TextSet = 1 << 0,
        AllFieldsSet = (TextSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*ExceptionDetails*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class ExceptionDetails;
    public:

        Builder<STATE | TextSet>& setText(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TextSet), property_text_already_set);
            m_result->setString("text", value);
            return castState<TextSet>();
        }

        operator RefPtr<ExceptionDetails>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ExceptionDetails) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<ExceptionDetails>*>(&m_result);
        }

        PassRefPtr<ExceptionDetails> release()
        {
            return RefPtr<ExceptionDetails>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<ExceptionDetails> result = ExceptionDetails::create()
     *     .setText(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void text(String* value)
    {
        JSONObjectBase::getString("text", value);
    }

    void setUrl(const String& value)
    {
        this->setString("url", value);
    }

    void setLine(int value)
    {
        this->setNumber("line", value);
    }

    void setColumn(int value)
    {
        this->setNumber("column", value);
    }

    void setStackTrace(PassRefPtr<TypeBuilder::Array<TypeBuilder::Console::CallFrame> > value)
    {
        this->setValue("stackTrace", value);
    }
};

/* Error data for setScriptSource command. compileError is a case type for uncompilable script source error. */
class SetScriptSourceError : public JSONObjectBase {
public:
    // Named after property name 'compileError' while generating SetScriptSourceError.
    class CompileError : public JSONObjectBase {
    public:
        enum {
            NoFieldsSet = 0,
            MessageSet = 1 << 0,
            LineNumberSet = 1 << 1,
            ColumnNumberSet = 1 << 2,
            AllFieldsSet = (MessageSet | LineNumberSet | ColumnNumberSet)
        };

        template<int STATE>
        class Builder {
        private:
            RefPtr<JSONObject> m_result;

            template<int STEP> Builder<STATE | STEP>& castState()
            {
                return *reinterpret_cast<Builder<STATE | STEP>*>(this);
            }

            Builder(PassRefPtr</*CompileError*/JSONObject> ptr)
            {
                COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
                m_result = ptr;
            }
            friend class CompileError;
        public:
    
            Builder<STATE | MessageSet>& setMessage(const String& value)
            {
                COMPILE_ASSERT(!(STATE & MessageSet), property_message_already_set);
                m_result->setString("message", value);
                return castState<MessageSet>();
            }
    
            Builder<STATE | LineNumberSet>& setLineNumber(int value)
            {
                COMPILE_ASSERT(!(STATE & LineNumberSet), property_lineNumber_already_set);
                m_result->setNumber("lineNumber", value);
                return castState<LineNumberSet>();
            }
    
            Builder<STATE | ColumnNumberSet>& setColumnNumber(int value)
            {
                COMPILE_ASSERT(!(STATE & ColumnNumberSet), property_columnNumber_already_set);
                m_result->setNumber("columnNumber", value);
                return castState<ColumnNumberSet>();
            }
    
            operator RefPtr<CompileError>& ()
            {
                COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
                COMPILE_ASSERT(sizeof(CompileError) == sizeof(JSONObject), cannot_cast);
                return *reinterpret_cast<RefPtr<CompileError>*>(&m_result);
            }

            PassRefPtr<CompileError> release()
            {
                return RefPtr<CompileError>(*this).release();
            }
        };

        /*
         * Synthetic constructor:
         * RefPtr<CompileError> result = CompileError::create()
         *     .setMessage(...)
         *     .setLineNumber(...)
         *     .setColumnNumber(...);
         */
        static Builder<NoFieldsSet> create()
        {
            return Builder<NoFieldsSet>(JSONObject::create());
        }
        typedef TypeBuilder::StructItemTraits ItemTraits;

        void message(String* value)
        {
            JSONObjectBase::getString("message", value);
        }

        void lineNumber(int* value)
        {
            JSONObjectBase::getNumber("lineNumber", value);
        }

        void columnNumber(int* value)
        {
            JSONObjectBase::getNumber("columnNumber", value);
        }
    };

    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*SetScriptSourceError*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class SetScriptSourceError;
    public:

        operator RefPtr<SetScriptSourceError>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(SetScriptSourceError) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<SetScriptSourceError>*>(&m_result);
        }

        PassRefPtr<SetScriptSourceError> release()
        {
            return RefPtr<SetScriptSourceError>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<SetScriptSourceError> result = SetScriptSourceError::create();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setCompileError(PassRefPtr<CompileError> value)
    {
        this->setValue("compileError", value);
    }
};

} // Debugger

namespace DOMDebugger {
/* DOM breakpoint type. */
struct DOMBreakpointType {
    enum Enum {
        Subtree_modified = 71,
        Attribute_modified = 72,
        Node_removed = 73,
    };
}; // struct DOMBreakpointType

} // DOMDebugger

namespace Profiler {
/* CPU Profile node. Holds callsite information, execution statistics and child nodes. */
class CPUProfileNode : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        FunctionNameSet = 1 << 0,
        ScriptIdSet = 1 << 1,
        UrlSet = 1 << 2,
        LineNumberSet = 1 << 3,
        ColumnNumberSet = 1 << 4,
        HitCountSet = 1 << 5,
        CallUIDSet = 1 << 6,
        ChildrenSet = 1 << 7,
        DeoptReasonSet = 1 << 8,
        IdSet = 1 << 9,
        AllFieldsSet = (FunctionNameSet | ScriptIdSet | UrlSet | LineNumberSet | ColumnNumberSet | HitCountSet | CallUIDSet | ChildrenSet | DeoptReasonSet | IdSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*CPUProfileNode*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class CPUProfileNode;
    public:

        Builder<STATE | FunctionNameSet>& setFunctionName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & FunctionNameSet), property_functionName_already_set);
            m_result->setString("functionName", value);
            return castState<FunctionNameSet>();
        }

        Builder<STATE | ScriptIdSet>& setScriptId(const TypeBuilder::Debugger::ScriptId& value)
        {
            COMPILE_ASSERT(!(STATE & ScriptIdSet), property_scriptId_already_set);
            m_result->setString("scriptId", value);
            return castState<ScriptIdSet>();
        }

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString("url", value);
            return castState<UrlSet>();
        }

        Builder<STATE | LineNumberSet>& setLineNumber(int value)
        {
            COMPILE_ASSERT(!(STATE & LineNumberSet), property_lineNumber_already_set);
            m_result->setNumber("lineNumber", value);
            return castState<LineNumberSet>();
        }

        Builder<STATE | ColumnNumberSet>& setColumnNumber(int value)
        {
            COMPILE_ASSERT(!(STATE & ColumnNumberSet), property_columnNumber_already_set);
            m_result->setNumber("columnNumber", value);
            return castState<ColumnNumberSet>();
        }

        Builder<STATE | HitCountSet>& setHitCount(int value)
        {
            COMPILE_ASSERT(!(STATE & HitCountSet), property_hitCount_already_set);
            m_result->setNumber("hitCount", value);
            return castState<HitCountSet>();
        }

        Builder<STATE | CallUIDSet>& setCallUID(double value)
        {
            COMPILE_ASSERT(!(STATE & CallUIDSet), property_callUID_already_set);
            m_result->setNumber("callUID", value);
            return castState<CallUIDSet>();
        }

        Builder<STATE | ChildrenSet>& setChildren(PassRefPtr<TypeBuilder::Array<TypeBuilder::Profiler::CPUProfileNode> > value)
        {
            COMPILE_ASSERT(!(STATE & ChildrenSet), property_children_already_set);
            m_result->setValue("children", value);
            return castState<ChildrenSet>();
        }

        Builder<STATE | DeoptReasonSet>& setDeoptReason(const String& value)
        {
            COMPILE_ASSERT(!(STATE & DeoptReasonSet), property_deoptReason_already_set);
            m_result->setString("deoptReason", value);
            return castState<DeoptReasonSet>();
        }

        Builder<STATE | IdSet>& setId(int value)
        {
            COMPILE_ASSERT(!(STATE & IdSet), property_id_already_set);
            m_result->setNumber("id", value);
            return castState<IdSet>();
        }

        operator RefPtr<CPUProfileNode>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CPUProfileNode) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<CPUProfileNode>*>(&m_result);
        }

        PassRefPtr<CPUProfileNode> release()
        {
            return RefPtr<CPUProfileNode>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<CPUProfileNode> result = CPUProfileNode::create()
     *     .setFunctionName(...)
     *     .setScriptId(...)
     *     .setUrl(...)
     *     .setLineNumber(...)
     *     .setColumnNumber(...)
     *     .setHitCount(...)
     *     .setCallUID(...)
     *     .setChildren(...)
     *     .setDeoptReason(...)
     *     .setId(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void functionName(String* value)
    {
        JSONObjectBase::getString("functionName", value);
    }

    void scriptId(TypeBuilder::Debugger::ScriptId* value)
    {
        JSONObjectBase::getString("scriptId", value);
    }

    void url(String* value)
    {
        JSONObjectBase::getString("url", value);
    }

    void lineNumber(int* value)
    {
        JSONObjectBase::getNumber("lineNumber", value);
    }

    void columnNumber(int* value)
    {
        JSONObjectBase::getNumber("columnNumber", value);
    }

    void hitCount(int* value)
    {
        JSONObjectBase::getNumber("hitCount", value);
    }

    void callUID(double* value)
    {
        JSONObjectBase::getNumber("callUID", value);
    }

    void deoptReason(String* value)
    {
        JSONObjectBase::getString("deoptReason", value);
    }

    void id(int* value)
    {
        JSONObjectBase::getNumber("id", value);
    }
};

/* Profile. */
class CPUProfile : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        HeadSet = 1 << 0,
        StartTimeSet = 1 << 1,
        EndTimeSet = 1 << 2,
        AllFieldsSet = (HeadSet | StartTimeSet | EndTimeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*CPUProfile*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class CPUProfile;
    public:

        Builder<STATE | HeadSet>& setHead(PassRefPtr<TypeBuilder::Profiler::CPUProfileNode> value)
        {
            COMPILE_ASSERT(!(STATE & HeadSet), property_head_already_set);
            m_result->setValue("head", value);
            return castState<HeadSet>();
        }

        Builder<STATE | StartTimeSet>& setStartTime(double value)
        {
            COMPILE_ASSERT(!(STATE & StartTimeSet), property_startTime_already_set);
            m_result->setNumber("startTime", value);
            return castState<StartTimeSet>();
        }

        Builder<STATE | EndTimeSet>& setEndTime(double value)
        {
            COMPILE_ASSERT(!(STATE & EndTimeSet), property_endTime_already_set);
            m_result->setNumber("endTime", value);
            return castState<EndTimeSet>();
        }

        operator RefPtr<CPUProfile>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CPUProfile) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<CPUProfile>*>(&m_result);
        }

        PassRefPtr<CPUProfile> release()
        {
            return RefPtr<CPUProfile>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<CPUProfile> result = CPUProfile::create()
     *     .setHead(...)
     *     .setStartTime(...)
     *     .setEndTime(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void startTime(double* value)
    {
        JSONObjectBase::getNumber("startTime", value);
    }

    void endTime(double* value)
    {
        JSONObjectBase::getNumber("endTime", value);
    }

    void setSamples(PassRefPtr<TypeBuilder::Array<int> > value)
    {
        this->setValue("samples", value);
    }

    void setTimestamps(PassRefPtr<TypeBuilder::Array<double> > value)
    {
        this->setValue("timestamps", value);
    }
};

} // Profiler

namespace Canvas {
/* Resource state descriptor. */
class ResourceStateDescriptor : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        AllFieldsSet = (NameSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*ResourceStateDescriptor*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class ResourceStateDescriptor;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name", value);
            return castState<NameSet>();
        }

        operator RefPtr<ResourceStateDescriptor>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ResourceStateDescriptor) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<ResourceStateDescriptor>*>(&m_result);
        }

        PassRefPtr<ResourceStateDescriptor> release()
        {
            return RefPtr<ResourceStateDescriptor>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<ResourceStateDescriptor> result = ResourceStateDescriptor::create()
     *     .setName(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void name(String* value)
    {
        JSONObjectBase::getString("name", value);
    }

    void setEnumValueForName(const String& value)
    {
        this->setString("enumValueForName", value);
    }

    void setValue(PassRefPtr<TypeBuilder::Canvas::CallArgument> value)
    {
        this->setValue("value", value);
    }
    using JSONObjectBase::setValue;


    void setValues(PassRefPtr<TypeBuilder::Array<TypeBuilder::Canvas::ResourceStateDescriptor> > value)
    {
        this->setValue("values", value);
    }

    void setIsArray(bool value)
    {
        this->setBoolean("isArray", value);
    }
#if ASSERT_ENABLED
    static void assertCorrectValue(JSONValue* value);
#endif  // ASSERT_ENABLED
};

/* Resource state. */
class ResourceState : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        IdSet = 1 << 0,
        TraceLogIdSet = 1 << 1,
        AllFieldsSet = (IdSet | TraceLogIdSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*ResourceState*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class ResourceState;
    public:

        Builder<STATE | IdSet>& setId(const TypeBuilder::Canvas::ResourceId& value)
        {
            COMPILE_ASSERT(!(STATE & IdSet), property_id_already_set);
            m_result->setString("id", value);
            return castState<IdSet>();
        }

        Builder<STATE | TraceLogIdSet>& setTraceLogId(const TypeBuilder::Canvas::TraceLogId& value)
        {
            COMPILE_ASSERT(!(STATE & TraceLogIdSet), property_traceLogId_already_set);
            m_result->setString("traceLogId", value);
            return castState<TraceLogIdSet>();
        }

        operator RefPtr<ResourceState>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ResourceState) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<ResourceState>*>(&m_result);
        }

        PassRefPtr<ResourceState> release()
        {
            return RefPtr<ResourceState>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<ResourceState> result = ResourceState::create()
     *     .setId(...)
     *     .setTraceLogId(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void id(TypeBuilder::Canvas::ResourceId* value)
    {
        JSONObjectBase::getString("id", value);
    }

    void traceLogId(TypeBuilder::Canvas::TraceLogId* value)
    {
        JSONObjectBase::getString("traceLogId", value);
    }

    void setDescriptors(PassRefPtr<TypeBuilder::Array<TypeBuilder::Canvas::ResourceStateDescriptor> > value)
    {
        this->setValue("descriptors", value);
    }

    void setImageURL(const String& value)
    {
        this->setString("imageURL", value);
    }
    static PassRefPtr<ResourceState> runtimeCast(PassRefPtr<JSONValue> value)
    {
        RefPtr<JSONObject> object;
        bool castRes = value->asObject(&object);
        ASSERT_UNUSED(castRes, castRes);
#if ASSERT_ENABLED
        assertCorrectValue(object.get());
#endif  // ASSERT_ENABLED
        COMPILE_ASSERT(sizeof(ResourceState) == sizeof(JSONObjectBase), type_cast_problem);
        return static_cast<ResourceState*>(static_cast<JSONObjectBase*>(object.get()));
    }

#if ASSERT_ENABLED
    static void assertCorrectValue(JSONValue* value);
#endif  // ASSERT_ENABLED
};

class CallArgument : public JSONObjectBase {
public:
    // Named after property name 'type' while generating CallArgument.
    struct Type {
        enum Enum {
            Object = 14,
            Function = 15,
            Undefined = 16,
            String = 17,
            Number = 18,
            Boolean = 19,
        };
#if ASSERT_ENABLED
        static void assertCorrectValue(JSONValue* value);
#endif  // ASSERT_ENABLED
    }; // struct Type

    // Named after property name 'subtype' while generating CallArgument.
    struct Subtype {
        enum Enum {
            Array = 21,
            Null = 22,
            Node = 23,
            Regexp = 24,
            Date = 25,
        };
#if ASSERT_ENABLED
        static void assertCorrectValue(JSONValue* value);
#endif  // ASSERT_ENABLED
    }; // struct Subtype

    enum {
        NoFieldsSet = 0,
        DescriptionSet = 1 << 0,
        AllFieldsSet = (DescriptionSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*CallArgument*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class CallArgument;
    public:

        Builder<STATE | DescriptionSet>& setDescription(const String& value)
        {
            COMPILE_ASSERT(!(STATE & DescriptionSet), property_description_already_set);
            m_result->setString("description", value);
            return castState<DescriptionSet>();
        }

        operator RefPtr<CallArgument>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CallArgument) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<CallArgument>*>(&m_result);
        }

        PassRefPtr<CallArgument> release()
        {
            return RefPtr<CallArgument>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<CallArgument> result = CallArgument::create()
     *     .setDescription(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void description(String* value)
    {
        JSONObjectBase::getString("description", value);
    }

    void setEnumName(const String& value)
    {
        this->setString("enumName", value);
    }

    void setResourceId(const TypeBuilder::Canvas::ResourceId& value)
    {
        this->setString("resourceId", value);
    }

    void setType(Type::Enum value)
    {
        this->setString("type", TypeBuilder::getEnumConstantValue(value));
    }

    void setSubtype(Subtype::Enum value)
    {
        this->setString("subtype", TypeBuilder::getEnumConstantValue(value));
    }

    void setRemoteObject(PassRefPtr<TypeBuilder::Runtime::RemoteObject> value)
    {
        this->setValue("remoteObject", value);
    }
#if ASSERT_ENABLED
    static void assertCorrectValue(JSONValue* value);
#endif  // ASSERT_ENABLED
};

class Call : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ContextIdSet = 1 << 0,
        AllFieldsSet = (ContextIdSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Call*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Call;
    public:

        Builder<STATE | ContextIdSet>& setContextId(const TypeBuilder::Canvas::ResourceId& value)
        {
            COMPILE_ASSERT(!(STATE & ContextIdSet), property_contextId_already_set);
            m_result->setString("contextId", value);
            return castState<ContextIdSet>();
        }

        operator RefPtr<Call>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Call) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Call>*>(&m_result);
        }

        PassRefPtr<Call> release()
        {
            return RefPtr<Call>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Call> result = Call::create()
     *     .setContextId(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void contextId(TypeBuilder::Canvas::ResourceId* value)
    {
        JSONObjectBase::getString("contextId", value);
    }

    void setFunctionName(const String& value)
    {
        this->setString("functionName", value);
    }

    void setArguments(PassRefPtr<TypeBuilder::Array<TypeBuilder::Canvas::CallArgument> > value)
    {
        this->setValue("arguments", value);
    }

    void setResult(PassRefPtr<TypeBuilder::Canvas::CallArgument> value)
    {
        this->setValue("result", value);
    }

    void setIsDrawingCall(bool value)
    {
        this->setBoolean("isDrawingCall", value);
    }

    void setIsFrameEndCall(bool value)
    {
        this->setBoolean("isFrameEndCall", value);
    }

    void setProperty(const String& value)
    {
        this->setString("property", value);
    }

    void setValue(PassRefPtr<TypeBuilder::Canvas::CallArgument> value)
    {
        this->setValue("value", value);
    }
    using JSONObjectBase::setValue;


    void setSourceURL(const String& value)
    {
        this->setString("sourceURL", value);
    }

    void setLineNumber(int value)
    {
        this->setNumber("lineNumber", value);
    }

    void setColumnNumber(int value)
    {
        this->setNumber("columnNumber", value);
    }
#if ASSERT_ENABLED
    static void assertCorrectValue(JSONValue* value);
#endif  // ASSERT_ENABLED
};

class TraceLog : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        IdSet = 1 << 0,
        CallsSet = 1 << 1,
        ContextsSet = 1 << 2,
        StartOffsetSet = 1 << 3,
        AliveSet = 1 << 4,
        TotalAvailableCallsSet = 1 << 5,
        AllFieldsSet = (IdSet | CallsSet | ContextsSet | StartOffsetSet | AliveSet | TotalAvailableCallsSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*TraceLog*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class TraceLog;
    public:

        Builder<STATE | IdSet>& setId(const TypeBuilder::Canvas::TraceLogId& value)
        {
            COMPILE_ASSERT(!(STATE & IdSet), property_id_already_set);
            m_result->setString("id", value);
            return castState<IdSet>();
        }

        Builder<STATE | CallsSet>& setCalls(PassRefPtr<TypeBuilder::Array<TypeBuilder::Canvas::Call> > value)
        {
            COMPILE_ASSERT(!(STATE & CallsSet), property_calls_already_set);
            m_result->setValue("calls", value);
            return castState<CallsSet>();
        }

        Builder<STATE | ContextsSet>& setContexts(PassRefPtr<TypeBuilder::Array<TypeBuilder::Canvas::CallArgument> > value)
        {
            COMPILE_ASSERT(!(STATE & ContextsSet), property_contexts_already_set);
            m_result->setValue("contexts", value);
            return castState<ContextsSet>();
        }

        Builder<STATE | StartOffsetSet>& setStartOffset(int value)
        {
            COMPILE_ASSERT(!(STATE & StartOffsetSet), property_startOffset_already_set);
            m_result->setNumber("startOffset", value);
            return castState<StartOffsetSet>();
        }

        Builder<STATE | AliveSet>& setAlive(bool value)
        {
            COMPILE_ASSERT(!(STATE & AliveSet), property_alive_already_set);
            m_result->setBoolean("alive", value);
            return castState<AliveSet>();
        }

        Builder<STATE | TotalAvailableCallsSet>& setTotalAvailableCalls(double value)
        {
            COMPILE_ASSERT(!(STATE & TotalAvailableCallsSet), property_totalAvailableCalls_already_set);
            m_result->setNumber("totalAvailableCalls", value);
            return castState<TotalAvailableCallsSet>();
        }

        operator RefPtr<TraceLog>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(TraceLog) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<TraceLog>*>(&m_result);
        }

        PassRefPtr<TraceLog> release()
        {
            return RefPtr<TraceLog>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<TraceLog> result = TraceLog::create()
     *     .setId(...)
     *     .setCalls(...)
     *     .setContexts(...)
     *     .setStartOffset(...)
     *     .setAlive(...)
     *     .setTotalAvailableCalls(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void id(TypeBuilder::Canvas::TraceLogId* value)
    {
        JSONObjectBase::getString("id", value);
    }

    void startOffset(int* value)
    {
        JSONObjectBase::getNumber("startOffset", value);
    }

    void alive(bool* value)
    {
        JSONObjectBase::getBoolean("alive", value);
    }

    void totalAvailableCalls(double* value)
    {
        JSONObjectBase::getNumber("totalAvailableCalls", value);
    }
    static PassRefPtr<TraceLog> runtimeCast(PassRefPtr<JSONValue> value)
    {
        RefPtr<JSONObject> object;
        bool castRes = value->asObject(&object);
        ASSERT_UNUSED(castRes, castRes);
#if ASSERT_ENABLED
        assertCorrectValue(object.get());
#endif  // ASSERT_ENABLED
        COMPILE_ASSERT(sizeof(TraceLog) == sizeof(JSONObjectBase), type_cast_problem);
        return static_cast<TraceLog*>(static_cast<JSONObjectBase*>(object.get()));
    }

#if ASSERT_ENABLED
    static void assertCorrectValue(JSONValue* value);
#endif  // ASSERT_ENABLED
};

} // Canvas

namespace Input {
class TouchPoint : public JSONObjectBase {
public:
    // Named after property name 'state' while generating TouchPoint.
    struct State {
        enum Enum {
            TouchPressed = 74,
            TouchReleased = 75,
            TouchMoved = 76,
            TouchStationary = 77,
            TouchCancelled = 78,
        };
    }; // struct State

    enum {
        NoFieldsSet = 0,
        StateSet = 1 << 0,
        XSet = 1 << 1,
        YSet = 1 << 2,
        AllFieldsSet = (StateSet | XSet | YSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*TouchPoint*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class TouchPoint;
    public:

        Builder<STATE | StateSet>& setState(State::Enum value)
        {
            COMPILE_ASSERT(!(STATE & StateSet), property_state_already_set);
            m_result->setString("state", TypeBuilder::getEnumConstantValue(value));
            return castState<StateSet>();
        }

        Builder<STATE | XSet>& setX(int value)
        {
            COMPILE_ASSERT(!(STATE & XSet), property_x_already_set);
            m_result->setNumber("x", value);
            return castState<XSet>();
        }

        Builder<STATE | YSet>& setY(int value)
        {
            COMPILE_ASSERT(!(STATE & YSet), property_y_already_set);
            m_result->setNumber("y", value);
            return castState<YSet>();
        }

        operator RefPtr<TouchPoint>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(TouchPoint) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<TouchPoint>*>(&m_result);
        }

        PassRefPtr<TouchPoint> release()
        {
            return RefPtr<TouchPoint>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<TouchPoint> result = TouchPoint::create()
     *     .setState(...)
     *     .setX(...)
     *     .setY(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void x(int* value)
    {
        JSONObjectBase::getNumber("x", value);
    }

    void y(int* value)
    {
        JSONObjectBase::getNumber("y", value);
    }

    void setRadiusX(int value)
    {
        this->setNumber("radiusX", value);
    }

    void setRadiusY(int value)
    {
        this->setNumber("radiusY", value);
    }

    void setRotationAngle(double value)
    {
        this->setNumber("rotationAngle", value);
    }

    void setForce(double value)
    {
        this->setNumber("force", value);
    }

    void setId(double value)
    {
        this->setNumber("id", value);
    }
};

} // Input

namespace LayerTree {
/* Rectangle where scrolling happens on the main thread. */
class ScrollRect : public JSONObjectBase {
public:
    // Named after property name 'type' while generating ScrollRect.
    struct Type {
        enum Enum {
            RepaintsOnScroll = 79,
            TouchEventHandler = 80,
            WheelEventHandler = 81,
        };
    }; // struct Type

    enum {
        NoFieldsSet = 0,
        RectSet = 1 << 0,
        TypeSet = 1 << 1,
        AllFieldsSet = (RectSet | TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*ScrollRect*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class ScrollRect;
    public:

        Builder<STATE | RectSet>& setRect(PassRefPtr<TypeBuilder::DOM::Rect> value)
        {
            COMPILE_ASSERT(!(STATE & RectSet), property_rect_already_set);
            m_result->setValue("rect", value);
            return castState<RectSet>();
        }

        Builder<STATE | TypeSet>& setType(Type::Enum value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type", TypeBuilder::getEnumConstantValue(value));
            return castState<TypeSet>();
        }

        operator RefPtr<ScrollRect>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ScrollRect) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<ScrollRect>*>(&m_result);
        }

        PassRefPtr<ScrollRect> release()
        {
            return RefPtr<ScrollRect>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<ScrollRect> result = ScrollRect::create()
     *     .setRect(...)
     *     .setType(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

/* Information about a compositing layer. */
class Layer : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        LayerIdSet = 1 << 0,
        OffsetXSet = 1 << 1,
        OffsetYSet = 1 << 2,
        WidthSet = 1 << 3,
        HeightSet = 1 << 4,
        PaintCountSet = 1 << 5,
        AllFieldsSet = (LayerIdSet | OffsetXSet | OffsetYSet | WidthSet | HeightSet | PaintCountSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Layer*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Layer;
    public:

        Builder<STATE | LayerIdSet>& setLayerId(const TypeBuilder::LayerTree::LayerId& value)
        {
            COMPILE_ASSERT(!(STATE & LayerIdSet), property_layerId_already_set);
            m_result->setString("layerId", value);
            return castState<LayerIdSet>();
        }

        Builder<STATE | OffsetXSet>& setOffsetX(double value)
        {
            COMPILE_ASSERT(!(STATE & OffsetXSet), property_offsetX_already_set);
            m_result->setNumber("offsetX", value);
            return castState<OffsetXSet>();
        }

        Builder<STATE | OffsetYSet>& setOffsetY(double value)
        {
            COMPILE_ASSERT(!(STATE & OffsetYSet), property_offsetY_already_set);
            m_result->setNumber("offsetY", value);
            return castState<OffsetYSet>();
        }

        Builder<STATE | WidthSet>& setWidth(double value)
        {
            COMPILE_ASSERT(!(STATE & WidthSet), property_width_already_set);
            m_result->setNumber("width", value);
            return castState<WidthSet>();
        }

        Builder<STATE | HeightSet>& setHeight(double value)
        {
            COMPILE_ASSERT(!(STATE & HeightSet), property_height_already_set);
            m_result->setNumber("height", value);
            return castState<HeightSet>();
        }

        Builder<STATE | PaintCountSet>& setPaintCount(int value)
        {
            COMPILE_ASSERT(!(STATE & PaintCountSet), property_paintCount_already_set);
            m_result->setNumber("paintCount", value);
            return castState<PaintCountSet>();
        }

        operator RefPtr<Layer>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Layer) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Layer>*>(&m_result);
        }

        PassRefPtr<Layer> release()
        {
            return RefPtr<Layer>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Layer> result = Layer::create()
     *     .setLayerId(...)
     *     .setOffsetX(...)
     *     .setOffsetY(...)
     *     .setWidth(...)
     *     .setHeight(...)
     *     .setPaintCount(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void layerId(TypeBuilder::LayerTree::LayerId* value)
    {
        JSONObjectBase::getString("layerId", value);
    }

    void offsetX(double* value)
    {
        JSONObjectBase::getNumber("offsetX", value);
    }

    void offsetY(double* value)
    {
        JSONObjectBase::getNumber("offsetY", value);
    }

    void width(double* value)
    {
        JSONObjectBase::getNumber("width", value);
    }

    void height(double* value)
    {
        JSONObjectBase::getNumber("height", value);
    }

    void paintCount(int* value)
    {
        JSONObjectBase::getNumber("paintCount", value);
    }

    void setParentLayerId(const TypeBuilder::LayerTree::LayerId& value)
    {
        this->setString("parentLayerId", value);
    }

    void setBackendNodeId(int value)
    {
        this->setNumber("backendNodeId", value);
    }

    void setTransform(PassRefPtr<TypeBuilder::Array<double> > value)
    {
        this->setValue("transform", value);
    }

    void setAnchorX(double value)
    {
        this->setNumber("anchorX", value);
    }

    void setAnchorY(double value)
    {
        this->setNumber("anchorY", value);
    }

    void setAnchorZ(double value)
    {
        this->setNumber("anchorZ", value);
    }

    void setInvisible(bool value)
    {
        this->setBoolean("invisible", value);
    }

    void setScrollRects(PassRefPtr<TypeBuilder::Array<TypeBuilder::LayerTree::ScrollRect> > value)
    {
        this->setValue("scrollRects", value);
    }
};

} // LayerTree

namespace Power {
/* PowerEvent item */
class PowerEvent : public JSONObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        TimestampSet = 1 << 1,
        ValueSet = 1 << 2,
        AllFieldsSet = (TypeSet | TimestampSet | ValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSONObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*PowerEvent*/JSONObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class PowerEvent;
    public:

        Builder<STATE | TypeSet>& setType(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type", value);
            return castState<TypeSet>();
        }

        Builder<STATE | TimestampSet>& setTimestamp(double value)
        {
            COMPILE_ASSERT(!(STATE & TimestampSet), property_timestamp_already_set);
            m_result->setNumber("timestamp", value);
            return castState<TimestampSet>();
        }

        Builder<STATE | ValueSet>& setValue(double value)
        {
            COMPILE_ASSERT(!(STATE & ValueSet), property_value_already_set);
            m_result->setNumber("value", value);
            return castState<ValueSet>();
        }

        operator RefPtr<PowerEvent>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(PowerEvent) == sizeof(JSONObject), cannot_cast);
            return *reinterpret_cast<RefPtr<PowerEvent>*>(&m_result);
        }

        PassRefPtr<PowerEvent> release()
        {
            return RefPtr<PowerEvent>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<PowerEvent> result = PowerEvent::create()
     *     .setType(...)
     *     .setTimestamp(...)
     *     .setValue(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSONObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void type(String* value)
    {
        JSONObjectBase::getString("type", value);
    }

    void timestamp(double* value)
    {
        JSONObjectBase::getNumber("timestamp", value);
    }

    void value(double* value)
    {
        JSONObjectBase::getNumber("value", value);
    }
};

} // Power


} // namespace TypeBuilder


} // namespace WebCore

#endif // !defined(InspectorTypeBuilder_h)

