//  (C)2014 Tarnyko <tarnyko@tarnyko.net>
// compile with : g++ -std=c++11 -fno-rtti ...  in_process_context_factory.cc test_shared_bitmap_manager.cc -I/usr/include/chromium -I/usr/include/chromium/skia/config -I/usr/include/chromium/third_party/skia/include/core -I/usr/include/chromium/out/Debug/gen
// -DUSE_AURA -DUSE_OZONE /usr/lib/chromium/lib/libbase.so /usr/lib/chromium/lib/libgfx.so /usr/lib/chromium/lib/libgfx_geometry.so /usr/lib/chromium/lib/libskia.so /usr/lib/chromium/lib/libviews.so /usr/lib/chromium/lib/libaura.so /usr/lib/chromium/lib/libui_base.so /usr/lib/chromium/lib/libevents.so /usr/lib/chromium/lib/libgl_wrapper.so /usr/lib/chromium/lib/libwebkit_gpu.so /usr/lib/chromium/lib/libcc.so /usr/lib/chromium/lib/libblink_common.so /usr/lib/chromium/lib//libbase_i18n.so
// ("-fno-rtti" is activated by default in the Chromium build, and fixes a typeinfo problem with subclassing "aura::WindowObserver")

#include "base/logging.h"			// for LOG()
#include "base/at_exit.h"			// for AtExit
#include "base/command_line.h"			// for CommandLine
#include "base/message_loop/message_loop.h"	// for MessageLoop
#include "base/run_loop.h"			// for RunLoop

#include "ui/gl/gl_implementation.h"		// for SetGLImplementation()
#include "ui/gfx/screen.h"			// for Screen
#include "ui/gfx/display.h"			// for Display
#include "ui/aura/env.h"			// for Env
#include "ui/views/widget/widget.h"		// for Widget
#include "ui/views/widget/widget_observer.h"	// for WidgetObserver
#include "ui/views/widget/desktop_aura/desktop_screen.h" // for CreateDesktopScreen()
#include "ui/views/widget/desktop_aura/desktop_native_widget_aura.h" // for DesktopNativeWidgetAura

#include "ui/compositor/test/in_process_context_factory.h"

#include "base/files/file_path.h"		// for FilePath
#include "ui/base/resource/resource_bundle.h"	// for InitSharedInstance()
#include "base/i18n/icu_util.h"			// for InitializeICU()


struct widget_observer : public views::WidgetObserver {
	void OnWidgetClosing (views::Widget *widget) {
		LOG(INFO) << "Closing widget...";
	};
	void OnWidgetCreated (views::Widget *widget) {
		LOG(INFO) << "Created widget...";
	};
	void OnWidgetDestroying (views::Widget *widget) {
		LOG(INFO) << "Destroying widget...";
	};
	void OnWidgetDestroyed (views::Widget *widget) {
		LOG(INFO) << "Destroyed widget...";
	};
	void OnWidgetBoundsChanged (views::Widget *widget,
	                            const gfx::Rect &new_bounds) {
		LOG(INFO) << "Widget size changed :" << new_bounds.width()
		                                     << "*"
		                                     << new_bounds.height();
	};
};


int main (int argc, char *argv[])
{
	base::CommandLine::Init (argc, argv);	// required for Env
	base::AtExitManager exit_manager;	// required for MessageLoop
	base::MessageLoopForUI message_loop;

	 // initialize EGL and Aura
	gfx::SetGLImplementation (gfx::GLImplementation::kGLImplementationEGLGLES2);
 	// gfx::InitializeStaticGLBindings (gfx::GLImplementation::kGLImplementationEGLGLES2);
	scoped_ptr<ui::InProcessContextFactory> context_factory (new ui::InProcessContextFactory());
	aura::Env::CreateInstance (true);
	aura::Env::GetInstance()->set_context_factory (context_factory.get());

	 // create the screen and display
	auto screen = views::CreateDesktopScreen();
	gfx::Screen::SetScreenInstance (gfx::SCREEN_TYPE_NATIVE, screen);
	auto display = screen->GetPrimaryDisplay();

	 // required before we initialize a widget
	ui::ResourceBundle::InitSharedInstanceWithPakPath (base::FilePath ("/usr/lib/chromium/content_shell.pak"));
	base::i18n::InitializeICU ();

	 // create the views widget
	auto widget = new views::Widget;
	auto w_observer = new widget_observer;
	 //
	views::Widget::InitParams params;
	params.type = views::Widget::InitParams::TYPE_WINDOW/*_FRAMELSS*/;
	params.bounds = gfx::Rect (0, 0, 400, 300);    // or display.work_area()
	params.show_state = ui::SHOW_STATE_DEFAULT;
	//params.parent = other_window; // not needed if root widget, but then need to define a native_widget
	params.native_widget = new views::DesktopNativeWidgetAura (widget);
	 //
	widget->Init (params);
	widget->AddObserver (w_observer);


	widget->Show();

	base::RunLoop run_loop;
	run_loop.Run ();


	widget->RemoveObserver (w_observer);
	delete w_observer;
	delete widget;

	return 0;
}
