/* Cairo demo for Android, draws PNG & text on screen */
 /* by Tarnyko <tarnyko@tarnyko.net> */

using Cairo;


public static void drawCairo (AndroidBitmapInfo *info, void *pixels)
{
   string filename = "/data/data/com.android.CairoPNG/image.png";
   string text     = "Test Cairo-Vala";

    /* ANDROID SCREEN HERE */
   ImageSurface android_surface = new ImageSurface.for_data ((uchar[]) pixels, Format.RGB16_565, (int) info->width, (int) info->height, (int) info->stride);
   Context android_context = new Context (android_surface);

   /* we are using relative values here ; so we must ABSOLUTELY
      avoid scaling ! Punition : blank screen... */
   //android_context.scale (info->width, info->height);

    /* PNG image here */ 
   ImageSurface surface = new ImageSurface.from_png (filename);
    /* position it */
   int width = surface.get_width ();
   int height = surface.get_height ();
   int pos_x = ((int) info->width - width)/2;
   int pos_y = ((int) info->height - height)/2 - 20; /* for the top bar */
   android_context.set_source_surface (surface, pos_x, pos_y);
    /* draw it */
   android_context.paint ();

    /* text here */
   android_context.set_source_rgba (1.0, 0.0, 0.0, 1.0);
   android_context.select_font_face ("serif", FontSlant.ITALIC, FontWeight.BOLD);
   android_context.set_font_size (24);
   android_context.move_to (((info->width)/2)-90, pos_y+height+25);
    /* show it */
   android_context.show_text (text);

    /* clean everything */
   surface.finish ();
   android_surface.finish ();
}