/* Cairo demo for Android, draws lines & text on the screen */
 /* by Tarnyko <tarnyko@tarnyko.net> */

using Cairo;


public static void drawCairo (AndroidBitmapInfo *info, void *pixels)
{
    /* ANDROID SCREEN HERE */
   ImageSurface android_surface = new ImageSurface.for_data ((uchar[]) pixels, Format.RGB16_565, (int) info->width, (int) info->height, (int) info->stride);
   Context android_context = new Context (android_surface);
   android_context.scale (info->width, info->height);

    /* Red horizontal round line */
   android_context.set_source_rgba (1.0, 0.0, 0.0, 1.0);
   android_context.move_to (0.2, 0.2);
   android_context.line_to (0.8, 0.2);
   android_context.set_line_width (0.2);
   android_context.set_line_cap (LineCap.ROUND);
    /* draw it */
   android_context.stroke ();

    /* Green vertical square line */
   android_context.set_source_rgba (0.0, 1.0, 0.0, 1.0);
   android_context.move_to (0.5, 0.4);
   android_context.line_to (0.5, 0.7);
   android_context.set_line_width (0.2);
   android_context.set_line_cap (LineCap.SQUARE);
    /* draw it */
   android_context.stroke ();

   /* Blue text here */
   android_context.set_source_rgba (0.0, 0.0, 1.0, 1.0);
   android_context.select_font_face ("serif", FontSlant.NORMAL, FontWeight.BOLD);
   android_context.set_font_size (0.2);
   android_context.move_to (0.25, 0.5);
    /* show it */ 
   android_context.show_text ("Salut !");

    /* clean everything */
   android_surface.finish ();
}