package com.android.Cairo;

import android.app.Activity;
import android.os.Bundle;

 /* required libraries */
import android.view.View;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;


public class Cairo extends Activity
{
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
         /* define the current View as "CairoView" below */
        setContentView(new CairoView(this));
    }

     /* load "libcairo-android.so" */
    static { System.loadLibrary("cairo-android"); }
}

class CairoView extends View
{
     /* declare native Vala "drawCairo" method used later */
    private static native void drawCairo(Bitmap bitmap);

    private Bitmap bmp;

     /* constructor, automatically executed method */
    public CairoView(Context context)
    {
        super(context);
         /* initialize the Bitmap, size 1x1 pixels */
        bmp = Bitmap.createBitmap(1, 1, Bitmap.Config.RGB_565);
    }

     /* we override the default "onDraw" display method */
     /* here, to update and display the Bitmap */ 
    @Override protected void onDraw(Canvas canvas)
    {
         /* resize Bitmap to Android window size if different */
        if (canvas.getWidth()!=bmp.getWidth() || canvas.getHeight()!=bmp.getHeight()) 
         bmp = Bitmap.createBitmap(canvas.getWidth(), canvas.getHeight(), Bitmap.Config.RGB_565);

         /* native Vala method, update the Bitmap from Cairo */
        drawCairo(bmp);
         /* display the Bitmap in an Android window (canvas) */
        canvas.drawBitmap(bmp, 0, 0, null);
         /* force refresh */
        invalidate();
    }
}
